// Wall´n´Ball
// for the LEDmePlay
//
// www.mithotronic.de
//
// Version: 1.1.1
// Author: Thomas Laubach (2017)
// 
// Many thanks to Michael Rosskopf
// 
// Release Notes:
// V1.1.1: Support for LEDmePI (2021)
// V1.1.0: Support for LEDmePlay Joypad and LEDmePlayBoy (2018)
// V1.0.0: First release

#define RELAX_START_ARENA 0 // 0 - 25
#define EASY_START_ARENA 26 // 26 - 37
#define WORK_START_ARENA 38 // 38 - 48
boolean showWelcomeScreen = true;

// Include libraries for adafruit matrix
#include <Adafruit_GFX.h>   // Core graphics library
#include <RGBmatrixPanel.h> // Hardware-specific library
#include <avr/pgmspace.h> // Necessary in order to maintain the arenaData data in program memory
#include <Timer.h> // Enables timed events

#define PI_FRACTION 0.01745329 // = PI/180


// Setup adafruit matrix
#define CLK 50
#define OE  51
#define LAT 10
#define A   A0
#define B   A1
#define C   A2
#define D   A3

RGBmatrixPanel matrix(A, B, C, D, CLK, LAT, OE, false);

// Scroll text in the interlude section
// Similar to F(), but for PROGMEM string pointers rather than literals
//#define F2(progmem_ptr) (const __FlashStringHelper *)progmem_ptr
//const char str[] PROGMEM = "Arena 2 - Lives 5";


// Audio out
const int audio = 2;
boolean audioIsProduced; // True if an arbitrary sound is being produced, false otherwise
int *melodyPointer; // Pointer to an array that holds musical notes (frequencies) of a melody
int melodyPosition;
int melodyLength;
long audioTimer;
boolean playMelodyInLoop = false;

#define STOP 0
#define NEXT_ARENA_MELODY 1
#define BONUS_APPEAR 2

// Sounds
#define REBOUND 0
#define DEMOLISH 1
#define THROWBONUS 2
#define BAT_REBOUND 3
#define OUTOFARENA 4
#define GAMEOVER 5
#define SHOT 6
#define BADDIE_REBOUND 7
#define BADDIE_EXPLODE 8
#define BADDIE_APPEAR 9

#define D -1 // Drum
#define NOTE_B0  31
#define NOTE_C1  33
#define NOTE_CS1 35
#define NOTE_D1  37
#define NOTE_DS1 39
#define NOTE_E1  41
#define NOTE_F1  44
#define NOTE_FS1 46
#define NOTE_G1  49
#define NOTE_GS1 52
#define NOTE_A1  55
#define NOTE_AS1 58
#define NOTE_B1  62
#define NOTE_C2  65
#define NOTE_CS2 69
#define NOTE_D2  73
#define NOTE_DS2 78
#define NOTE_E2  82
#define NOTE_F2  87
#define NOTE_FS2 93
#define NOTE_G2  98
#define NOTE_GS2 104
#define NOTE_A2  110
#define NOTE_AS2 117
#define NOTE_B2  123
#define NOTE_C3  131
#define NOTE_CS3 139
#define NOTE_D3  147
#define NOTE_DS3 156
#define NOTE_E3  165
#define NOTE_F3  175
#define NOTE_FS3 185
#define NOTE_G3  196
#define NOTE_GS3 208
#define NOTE_A3  220
#define NOTE_AS3 233
#define NOTE_B3  247
#define NOTE_C4  262
#define NOTE_CS4 277
#define NOTE_D4  294
#define NOTE_DS4 311
#define NOTE_E4  330
#define NOTE_F4  349
#define NOTE_FS4 370
#define NOTE_G4  392
#define NOTE_GS4 415
#define NOTE_A4  440
#define NOTE_AS4 466
#define NOTE_B4  494
#define NOTE_C5  523
#define NOTE_CS5 554
#define NOTE_D5  587
#define NOTE_DS5 622
#define NOTE_E5  659
#define NOTE_F5  698
#define NOTE_FS5 740
#define NOTE_G5  784
#define NOTE_GS5 831
#define NOTE_A5  880
#define NOTE_AS5 932
#define NOTE_B5  988
#define NOTE_C6  1047
#define NOTE_CS6 1109
#define NOTE_D6  1175
#define NOTE_DS6 1245
#define NOTE_E6  1319
#define NOTE_F6  1397
#define NOTE_FS6 1480
#define NOTE_G6  1568
#define NOTE_GS6 1661
#define NOTE_A6  1760
#define NOTE_AS6 1865
#define NOTE_B6  1976
#define NOTE_C7  2093
#define NOTE_CS7 2217
#define NOTE_D7  2349
#define NOTE_DS7 2489
#define NOTE_E7  2637
#define NOTE_F7  2794
#define NOTE_FS7 2960
#define NOTE_G7  3136
#define NOTE_GS7 3322
#define NOTE_A7  3520
#define NOTE_AS7 3729
#define NOTE_B7  3951
#define NOTE_C8  4186
#define NOTE_CS8 4435
#define NOTE_D8  4699
#define NOTE_DS8 4978

#define ACCENT 0
#define STACCATO 1
#define NORMAL 2

int nextArenaMelody[] = { NOTE_C2, NOTE_C3, D, NOTE_C3, NOTE_C2, NOTE_C3, D, NOTE_C3, NOTE_C2, NOTE_C3, D, NOTE_C3, NOTE_C2, NOTE_C3, D, NOTE_B2, NOTE_A1, NOTE_A2, D, NOTE_A2, NOTE_A1, NOTE_A2, D, NOTE_A2, NOTE_A1, NOTE_A2, D, NOTE_A2, NOTE_A1, NOTE_A2, D, NOTE_A2, NOTE_F1, NOTE_F2, D, NOTE_F2, NOTE_F1, NOTE_F2, D, NOTE_F2, NOTE_F1, NOTE_F2, D, NOTE_F2, NOTE_F1, NOTE_F2, D, NOTE_FS2, NOTE_G1, NOTE_G2, D, NOTE_G2, NOTE_G1, NOTE_G2, D, NOTE_G2, NOTE_G1, NOTE_G2, D, NOTE_G2, NOTE_G1, NOTE_G2, D, NOTE_G2 };
int bonusAppearJingle[] = { NOTE_C5, 0, NOTE_C5, 0, 0, NOTE_C5, 0, NOTE_F5, 0, 0, NOTE_A5, 0, 0, 0};

// Initialize Timer object
Timer timer;

// Joystick directions
#define STILL 0
#define UP 1
#define RIGHT 2
#define DOWN 3
#define LEFT 4

// Joystick 1
int buttonU1 = 30;
int buttonD1 = 32;
int buttonL1 = 34;
int buttonR1 = 36;
int buttonFire1 = 38;
int analogX1 = 8;
int analogY1 = 9;

// Joystick 2
int buttonU2 = 31;
int buttonD2 = 33;
int buttonL2 = 35;
int buttonR2 = 37;
int buttonFire2 = 39;
int analogX2 = 10;
int analogY2 = 11;

// Sensitivity of analog thumb joysticks (of the LEDmePlay Joypad) in case of "digital usage" (detects movement if deviates from center position value of 512 by sensitivity value)
const int sensitivity = 192;

// Other buttons
int buttonReset = 42;
int buttonPause = 43;

// Title image
const uint8_t titleImg[] PROGMEM =
{
  0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 6, 6, 6, 6, 6, 6, 6, 0, 3, 3, 3, 3, 3, 3, 3, 0, 4, 4, 4, 4, 4, 4, 4, 0, 9, 9, 9, 9, 9, 9, 9,
  0, 6, 0, 6, 6, 6, 0, 6, 0, 3, 0, 0, 0, 0, 0, 3, 0, 4, 0, 4, 4, 4, 4, 4, 0, 9, 0, 9, 9, 9, 9, 9,
  0, 6, 0, 6, 6, 6, 0, 6, 0, 3, 0, 3, 3, 3, 0, 3, 0, 4, 0, 4, 4, 4, 4, 4, 0, 9, 0, 9, 9, 9, 9, 9,
  0, 6, 0, 6, 6, 6, 0, 6, 0, 3, 0, 0, 0, 0, 0, 3, 0, 4, 0, 4, 4, 4, 4, 4, 0, 9, 0, 9, 9, 9, 9, 9,
  0, 6, 0, 6, 0, 6, 0, 6, 0, 3, 0, 3, 3, 3, 0, 3, 0, 4, 0, 4, 4, 4, 4, 4, 0, 9, 0, 9, 9, 9, 9, 9,
  0, 6, 0, 0, 0, 0, 0, 6, 0, 3, 0, 3, 3, 3, 0, 3, 0, 4, 0, 0, 0, 0, 0, 4, 0, 9, 0, 0, 0, 0, 0, 9,
  0, 6, 6, 6, 6, 6, 6, 6, 0, 3, 3, 3, 3, 3, 3, 3, 0, 4, 4, 4, 4, 4, 4, 4, 0, 9, 9, 9, 9, 9, 9, 9,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

// Game over image
// Image data
const uint8_t gameOverImg[] PROGMEM =
{
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 4, 4, 4,
  2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 6, 3, 3, 3, 6, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0, 2, 4, 4, 4, 4,
  2, 2, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 6, 6, 3, 6, 6, 3, 0, 3, 6, 6, 6, 6, 6, 3, 0, 4, 4, 4, 4, 4,
  2, 2, 0, 3, 6, 6, 6, 6, 6, 3, 0, 3, 6, 3, 6, 3, 6, 3, 0, 3, 6, 3, 3, 3, 3, 3, 0, 4, 4, 4, 4, 4,
  2, 2, 0, 3, 6, 8, 8, 8, 6, 3, 0, 3, 6, 3, 3, 3, 6, 3, 0, 3, 6, 6, 6, 3, 3, 7, 0, 4, 4, 4, 4, 4,
  2, 2, 0, 3, 6, 6, 6, 6, 6, 3, 0, 3, 6, 3, 3, 3, 6, 3, 0, 3, 6, 3, 3, 3, 7, 7, 0, 4, 4, 4, 4, 4,
  2, 2, 0, 3, 6, 3, 3, 3, 6, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 6, 6, 6, 6, 6, 7, 0, 4, 4, 4, 4, 4,
  2, 2, 0, 3, 6, 3, 3, 3, 6, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 7, 7, 7, 7, 0, 4, 4, 4, 4, 4,
  2, 2, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 7, 7, 7, 7, 7, 7, 7, 0, 4, 4, 4,
  0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 0, 7, 5, 5, 5, 5, 5, 7, 0, 4, 4, 4,
  0, 3, 6, 6, 6, 6, 6, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 7, 7, 0, 7, 5, 7, 7, 7, 5, 7, 0, 4, 4, 4,
  0, 3, 6, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 7, 7, 7, 0, 7, 5, 5, 5, 5, 5, 7, 0, 4, 4, 4,
  0, 3, 6, 3, 3, 6, 6, 3, 0, 3, 3, 3, 3, 3, 3, 7, 7, 7, 7, 7, 0, 7, 5, 7, 7, 5, 7, 7, 0, 4, 4, 4,
  0, 3, 6, 3, 3, 3, 6, 3, 0, 3, 3, 3, 3, 3, 7, 7, 7, 7, 7, 7, 0, 7, 5, 7, 7, 7, 1, 7, 0, 4, 4, 4,
  0, 3, 6, 6, 6, 6, 6, 3, 0, 3, 3, 3, 3, 7, 7, 7, 7, 7, 7, 7, 0, 7, 7, 7, 7, 7, 7, 7, 0, 4, 4, 4,
  0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 7, 7, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 7, 7, 7, 7, 0, 7, 7, 7, 7, 7, 7, 7, 0, 4, 4, 4, 4, 4,
  3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0, 7, 7, 7, 7, 7, 7, 7, 0, 7, 5, 5, 5, 5, 5, 7, 0, 4, 4, 4, 4, 4,
  3, 3, 0, 3, 5, 5, 5, 5, 5, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 5, 7, 7, 7, 7, 7, 0, 4, 4, 4, 4, 4,
  3, 3, 0, 3, 5, 3, 3, 3, 5, 7, 0, 7, 7, 7, 7, 7, 7, 7, 0, 7, 5, 5, 5, 7, 7, 7, 0, 4, 4, 4, 4, 4,
  3, 3, 0, 3, 5, 3, 3, 7, 5, 7, 0, 7, 5, 7, 7, 7, 5, 7, 0, 7, 5, 7, 7, 7, 7, 7, 0, 4, 4, 4, 4, 4,
  3, 3, 0, 3, 5, 3, 7, 7, 5, 7, 0, 7, 5, 7, 7, 7, 5, 7, 0, 7, 5, 5, 5, 5, 5, 7, 0, 4, 4, 4, 4, 4,
  3, 3, 0, 3, 5, 5, 5, 5, 5, 7, 0, 7, 7, 5, 7, 5, 7, 7, 0, 7, 7, 7, 7, 7, 7, 7, 0, 4, 4, 4, 4, 4,
  3, 3, 0, 3, 7, 7, 7, 7, 7, 7, 0, 7, 7, 5, 7, 5, 7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4,
  3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 5, 7, 7, 7, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 0, 7, 7, 7, 7, 7, 7, 7, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4
};

// Relax/Work Image data
const uint8_t relaxImg[] PROGMEM =
{
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 
  1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 
  1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 
  1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 
  1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 
};

// Image data
const uint8_t easyImg[] PROGMEM =
{
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1,
  1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1,
  1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1,
  1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1,
  1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};


const uint8_t workImg[] PROGMEM =
{
  
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1,
  1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1,
  1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1,
  1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 
  1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};

// "Player" in player selection screen
const uint8_t playerImg[] PROGMEM =
{
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0,
  3, 0, 0, 0, 3, 3, 0, 3, 3, 3, 3, 0, 0, 0, 3, 3, 0, 3, 0, 3, 3, 0, 0, 0, 3, 3, 0, 0, 0, 3, 0, 0,
  3, 0, 3, 0, 3, 3, 0, 3, 3, 3, 3, 0, 3, 0, 3, 3, 0, 3, 0, 3, 3, 0, 3, 3, 3, 3, 0, 3, 0, 3, 0, 0,
  3, 0, 0, 0, 3, 3, 0, 3, 3, 3, 3, 0, 0, 0, 3, 3, 3, 0, 3, 3, 3, 0, 0, 3, 3, 3, 0, 0, 3, 3, 0, 0,
  3, 0, 3, 3, 3, 3, 0, 3, 3, 3, 3, 0, 3, 0, 3, 3, 3, 0, 3, 3, 3, 0, 3, 3, 3, 3, 0, 3, 0, 3, 0, 0,
  3, 0, 3, 3, 3, 3, 0, 0, 0, 3, 3, 0, 3, 0, 3, 3, 3, 0, 3, 3, 3, 0, 0, 0, 3, 3, 0, 3, 0, 3, 0, 0,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0
};

// "versus" in player selection screen
const uint8_t versusImg[] PROGMEM =
{
  1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1,
  2, 2, 0, 0, 2, 2, 0, 2, 2, 0, 0,
  4, 4, 0, 0, 4, 4, 0, 0, 4, 4, 0,
  0, 5, 0, 0, 5, 0, 0, 0, 0, 5, 5,
  0, 0, 3, 3, 0, 0, 0, 3, 3, 3, 0
};

// "with" in player selection screen
const uint8_t withImg[] PROGMEM =
{
  0, 0, 0, 0, 0, 0, 7, 7, 0, 7, 0, 0, 7, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0,
  1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1,
  4, 0, 4, 0, 4, 0, 4, 4, 0, 4, 4, 0, 4, 4, 4,
  5, 5, 5, 5, 5, 0, 5, 5, 0, 5, 0, 0, 5, 0, 5,
  6, 6, 6, 6, 6, 0, 6, 6, 0, 6, 0, 0, 6, 0, 6
};

// "CPU" in player selection screen
const uint8_t CPUImg[] PROGMEM =
{
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 0, 0, 0, 3, 3, 0, 0, 0, 3, 3, 0, 3, 0, 3,
  3, 0, 3, 3, 3, 3, 0, 3, 0, 3, 3, 0, 3, 0, 3,
  3, 0, 3, 3, 3, 3, 0, 0, 0, 3, 3, 0, 3, 0, 3,
  3, 0, 3, 3, 3, 3, 0, 3, 3, 3, 3, 0, 3, 0, 3,
  3, 0, 0, 0, 3, 3, 0, 3, 3, 3, 3, 0, 0, 0, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3
};

// OneUp (additional life) image
const uint8_t oneUpImg[] PROGMEM =
{
  0, 3, 3, 0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0,
  5, 5, 5, 0, 2, 2, 0, 0, 2, 2, 0, 2, 0, 0, 2, 2,
  0, 6, 6, 0, 8, 8, 0, 0, 8, 8, 0, 8, 8, 8, 8, 0,
  0, 7, 7, 0, 9, 9, 0, 0, 9, 9, 0, 9, 9, 0, 0, 0,
  0, 4, 4, 0, 0, 10, 10, 10, 10, 0, 0, 10, 10, 0, 0, 0
};

// Joystick reversed image
const uint8_t joyRevImg[] PROGMEM =
{
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  4, 11,  0, 0, 0,  0,
  0,  8,  8,  0,  0,  0,  0,  0, 10,  4, 11,  3, 3, 3,  0,
  0,  8,  8,  0,  0,  0,  0,  0,  0,  4, 11,  0, 0, 0,  3,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 11,  0, 0, 0,  9,
  12, 12, 12, 12, 12, 12, 12, 12,  0,  0,  0,  0, 0, 0,  9,
  12, 12, 12, 12, 12, 12, 12, 12,  0, 10,  4, 11, 9, 9,  0
};

// Playfield encoding
#define EMPTY 0
#define UNUSED_BRICK 1 // currently unused 
#define RED_BRICK 2
#define GREEN_BRICK 3
#define BLUE_BRICK 4
#define VIOLET_BRICK 5
#define YELLOW_BRICK 6
#define SOLID_BRICK 7
#define ORANGE_BRICK 8
#define HORIZ_WALL_HIGH 9
#define VERT_WALL 10
#define CORNER_NW 11
#define CORNER_NE 12
#define CORNER_SW 13
#define CORNER_SE 14
#define HORIZ_WALL_LOW 15


const uint8_t arenaData[] PROGMEM  =
{


  // ------------- EASY ARENAS -------------------

  
  // 0  RELAX 1 - Classic
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 2, 2, 2, 2, 2, 2, 2, 2, 0,
  0, 3, 3, 3, 3, 3, 3, 3, 3, 0,
  0, 4, 4, 4, 4, 4, 4, 4, 4, 0,
  0, 5, 5, 5, 5, 5, 5, 5, 5, 0,
  0, 6, 6, 6, 6, 6, 6, 6, 6, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0, // Upper, lower, left, right border is 0-closed/1-open

  // 1  RELAX 2 - Apple
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 11, 0, 0, 0, 0, 0, 9, 12, 0,
  0, 10, 0, 0, 0, 0, 3, 0, 10, 0,
  0, 10, 0, 0, 0, 3, 0, 0, 10, 0,
  0, 10, 0, 0, 8, 2, 2, 0, 0, 0,
  0, 10, 0, 8, 2, 2, 2, 2, 0, 0,
  0, 10, 0, 2, 2, 2, 2, 2, 0, 0,
  0, 10, 0, 2, 2, 2, 2, 2, 0, 0,
  0, 10, 0, 2, 2, 2, 2, 2, 0, 0,
  0, 10, 0, 0, 2, 2, 2, 0, 10, 0,
  0, 10, 0, 0, 0, 0, 0, 0, 10, 0,
  0, 14, 0, 0, 0, 0, 0, 15, 13, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0, // Upper, lower, left, right border is 0-closed/1-open

  // 2  RELAX 3 - Diagonal classic
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 2, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 3, 2, 0, 0, 0, 0, 0, 0, 0,
  0, 4, 3, 2, 0, 0, 0, 0, 0, 0,
  0, 5, 4, 3, 2, 0, 0, 0, 0, 0,
  0, 6, 5, 4, 3, 2, 0, 0, 0, 0,
  0, 8, 6, 5, 4, 3, 0, 0, 0, 0,
  0, 7, 8, 6, 5, 4, 0, 0, 0, 0,
  0, 0, 7, 8, 6, 5, 0, 0, 0, 0,
  0, 0, 0, 7, 8, 6, 0, 0, 0, 0,
  0, 0, 0, 0, 7, 8, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 7, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 0, 1, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0, // Upper, lower, left, right border is 0-closed/1-open

  // 3  RELAX 4 - Spider
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 7, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 12, 8, 6, 11, 0, 0, 0,
  0, 0, 15, 10, 8, 8, 10, 15, 0, 0,
  0, 11, 0, 2, 2, 2, 2, 0, 12, 0,
  0, 0, 11, 2, 2, 2, 2, 12, 0, 0,
  0, 0, 10, 0, 2, 2, 0, 10, 0, 0,
  0, 0, 0, 11, 2, 2, 12, 0, 0, 0,
  0, 0, 0, 10, 0, 0, 10, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 7, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 7, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 4  RELAX 5 - Noah's room
  2, 2, 0, 0, 10, 0, 0, 0, 0, 0, 
  2, 2, 0, 11, 4, 12, 0, 0, 0, 0, 
  2, 2, 0, 0, 0, 0, 0, 0, 12, 0, 
  2, 2, 0, 0, 0, 0, 0, 0, 7, 0, 
  2, 7, 0, 0, 0, 0, 0, 0, 7, 0, 
  2, 2, 0, 0, 0, 0, 3, 3, 3, 3, 
  2, 2, 0, 0, 0, 0, 4, 0, 0, 4, 
  2, 2, 0, 0, 0, 0, 4, 0, 0, 4, 
  2, 2, 0, 0, 0, 0, 4, 0, 0, 4, 
  9, 9, 9, 0, 0, 9, 9, 9, 9, 9, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  3, 0, 0, 0, 0, 0, 0, 2, 2, 2, 
  3, 0, 0, 0, 0, 0, 0, 6, 0, 6, 
  3, 3, 3, 0, 0, 0, 0, 6, 0, 6, 
  3, 0, 3, 0, 0, 0, 0, 6, 0, 6, 
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 5  RELAX 6 - Cave
  7, 7, 7, 7, 0, 0, 0, 0, 7, 7,
  7, 7, 7, 3, 0, 0, 0, 0, 0, 8,
  7, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  5, 0, 0, 0, 0, 0, 7, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 7, 7, 5, 4,
  0, 0, 0, 0, 0, 0, 0, 7, 7, 7,
  0, 0, 0, 0, 0, 0, 0, 0, 7, 7,
  6, 4, 7, 7, 0, 0, 0, 0, 0, 7,
  7, 7, 7, 7, 7, 0, 0, 0, 0, 0,
  7, 7, 7, 0, 0, 0, 0, 0, 0, 0,
  7, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  7, 3, 0, 0, 0, 0, 0, 0, 0, 0,
  7, 7, 0, 0, 0, 0, 0, 0, 0, 0,
  7, 7, 0, 0, 0, 0, 0, 0, 0, 0,
  7, 7, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open


  // 6  RELAX 9 - Robot
0, 0, 0, 4, 4, 4, 0, 0, 0, 0, 
0, 0, 0, 5, 4, 5, 0, 0, 0, 0, 
7, 0, 0, 4, 4, 4, 0, 0, 0, 7, 
0, 0, 0, 4, 4, 4, 0, 0, 0, 0, 
0, 0, 0, 14, 0, 13, 0, 0, 0, 0, 
0, 0, 0, 4, 4, 4, 0, 2, 0, 0, 
0, 2, 15, 4, 4, 4, 13, 2, 0, 0, 
0, 2, 0, 4, 4, 4, 0, 0, 0, 0, 
0, 2, 0, 4, 4, 4, 0, 0, 0, 0, 
0, 0, 0, 10, 0, 10, 0, 0, 0, 0, 
0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 
7, 0, 0, 2, 0, 2, 0, 0, 0, 7, 
0, 0, 14, 0, 13, 0, 13, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 1, 1,  // Upper, lower, left, right bat is 1-active/0 - inactive
0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

// 7  EASY - Umbrella
  0, 0, 4, 0, 0, 0, 0, 0, 4, 0,
  0, 0, 0, 0, 0, 4, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 4, 0, 0, 3, 0, 0, 0, 0, 4,
  0, 0, 0, 3, 3, 3, 0, 0, 0, 0,
  0, 0, 3, 3, 3, 3, 3, 0, 0, 0,
  0, 0, 0, 0, 10, 0, 0, 0, 0, 0,
  4, 0, 0, 0, 10, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 10, 0, 0, 0, 4, 0,
  0, 0, 0, 0, 14, 0, 0, 0, 0, 4,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  4, 0, 0, 0, 0, 0, 0, 0, 4, 0,
  7, 7, 7, 8, 8, 8, 8, 7, 7, 7,
  0, 0, 0, 7, 0, 0, 0, 7, 0, 0,
  0, 0, 0, 7, 0, 0, 0, 7, 0, 0,
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0, // Upper, lower, left, right border is 0-closed/1-open 
  
  // 8  RELAX 10 - Arrow
  0, 0, 0, 0, 6, 0, 0, 0, 0, 0,
  0, 0, 0, 4, 6, 7, 0, 11, 12, 0,
  0, 0, 0, 4, 6, 4, 0, 14, 13, 0,
  0, 0, 0, 7, 6, 4, 0, 0, 0, 0,
  0, 0, 0, 4, 6, 7, 0, 0, 0, 0,
  0, 0, 0, 4, 6, 4, 0, 0, 0, 0,
  0, 0, 6, 6, 6, 6, 6, 0, 0, 0,
  0, 0, 7, 6, 6, 6, 7, 0, 0, 0,
  0, 0, 0, 7, 6, 7, 0, 0, 0, 0,
  0, 0, 0, 0, 7, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 11, 12, 0,
  0, 11, 12, 0, 0, 0, 0, 14, 13, 0,
  0, 14, 13, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 1,  // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 9  RELAX 7 - Noah's Laundry
  7, 0, 0, 0, 0, 0, 0, 0, 0, 7, 
  8, 0, 0, 0, 15, 15, 15, 0, 0, 8, 
  0, 0, 0, 3, 0, 4, 0, 3, 0, 0, 
  0, 0, 0, 10, 4, 4, 4, 10, 0, 0, 
  0, 0, 0, 10, 4, 4, 4, 10, 0, 0, 
  0, 0, 0, 10, 4, 0, 4, 10, 0, 0, 
  0, 0, 0, 10, 4, 0, 4, 10, 0, 0, 
  0, 0, 0, 10, 4, 4, 4, 10, 0, 0, 
  0, 0, 0, 10, 4, 4, 4, 10, 0, 0, 
  0, 0, 0, 10, 0, 0, 0, 10, 0, 0, 
  0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 
  0, 0, 0, 0, 3, 3, 3, 0, 0, 0, 
  0, 0, 0, 0, 9, 9, 9, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 3, 7, 0, 0, 0, 0, 7, 8, 0, 
  1, 1, 1, 1, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open
  
  // 10 RELAX 11 - Plant1
  0, 0, 0, 0, 0, 2, 0, 0, 0, 0,
  0, 0, 0, 0, 2, 2, 2, 0, 15, 15,
  0, 0, 0, 0, 10, 2, 8, 0, 0, 0,
  0, 11, 9, 0, 10, 3, 0, 3, 3, 0,
  0, 10, 3, 0, 10, 3, 3, 0, 0, 0,
  0, 10, 0, 3, 3, 10, 0, 0, 15, 15,
  0, 14, 15, 0, 3, 10, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 3, 10, 0, 0, 0,
  0, 0, 0, 0, 0, 3, 10, 0, 0, 0,
  0, 0, 0, 0, 0, 3, 0, 0, 0, 0,
  0, 0, 0, 10, 8, 8, 8, 10, 0, 0,
  0, 0, 0, 10, 8, 8, 8, 10, 0, 0,
  0, 0, 0, 14, 15, 15, 15, 13, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 11 RELAX 12 - Heart
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 15, 15, 0, 15, 15, 0, 0, 0,
  0, 0, 2, 2, 0, 2, 2, 0, 0, 0,
  0, 2, 2, 2, 15, 2, 2, 2, 0, 0,
  0, 2, 2, 2, 2, 2, 2, 2, 0, 0,
  0, 2, 2, 2, 2, 2, 2, 2, 0, 0,
  0, 10, 2, 2, 2, 2, 2, 10, 0, 0,
  0, 10, 2, 2, 2, 2, 2, 10, 0, 0,
  0, 0, 0, 2, 2, 2, 0, 0, 0, 0,
  0, 0, 0, 10, 2, 10, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 6, 0, 0, 0, 0, 6, 0, 0,
  0, 8, 0, 0, 0, 0, 0, 0, 8, 0,
  8, 0, 0, 0, 0, 0, 0, 0, 0, 8,
  0, 1, 1, 1,  // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 12 RELAX 13 - Helicopter
  6, 6, 6, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 6, 6, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 6, 0, 0, 0, 0,
  0, 0, 15, 15, 15, 15, 15, 15, 15, 0,
  0, 0, 0, 0, 0, 10, 0, 0, 0, 0,
  11, 0, 0, 0, 4, 4, 4, 0, 0, 0,
  4, 4, 4, 4, 4, 4, 4, 8, 0, 0,
  13, 4, 4, 4, 4, 4, 4, 8, 4, 0,
  0, 0, 4, 4, 4, 4, 4, 4, 4, 0,
  0, 0, 0, 4, 4, 4, 4, 4, 0, 0,
  0, 0, 0, 0, 7, 0, 7, 0, 0, 0,
  0, 0, 0, 7, 7, 7, 7, 7, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 3, 3,
  0, 0, 0, 0, 0, 0, 3, 3, 0, 0,
  0, 1, 0, 0,  // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 13 RELAX 14 - Diagonal caverns
  0, 0, 0, 0, 0, 0, 0, 0, 0, 7,
  0, 0, 0, 0, 0, 0, 0, 5, 7, 0,
  0, 0, 0, 0, 0, 0, 8, 7, 0, 0,
  0, 0, 0, 0, 0, 6, 7, 0, 0, 0,
  0, 0, 0, 0, 4, 7, 0, 0, 0, 0,
  0, 0, 0, 2, 7, 0, 0, 0, 5, 7,
  0, 0, 0, 7, 0, 0, 0, 8, 7, 0,
  0, 0, 0, 0, 0, 0, 6, 7, 0, 0,
  0, 0, 0, 0, 0, 4, 7, 0, 0, 0,
  0, 0, 0, 0, 2, 7, 0, 0, 0, 0,
  0, 0, 0, 3, 7, 0, 0, 0, 0, 0,
  0, 0, 0, 7, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 14 RELAX 15 - Unnamed10
  0, 0, 0, 10, 0, 0, 10, 0, 0, 0,
  0, 4, 4, 10, 0, 0, 10, 3, 3, 0,
  0, 4, 4, 10, 0, 0, 10, 3, 3, 0,
  0, 0, 0, 10, 0, 0, 10, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  15, 15, 0, 0, 0, 0, 0, 0, 15, 15,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  8, 8, 0, 0, 0, 0, 0, 0, 6, 6,
  8, 8, 0, 0, 0, 0, 0, 0, 6, 6,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  9, 9, 0, 0, 0, 0, 0, 0, 9, 9,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  5, 5, 0, 0, 0, 0, 0, 0, 2, 2,
  5, 5, 10, 0, 0, 0, 0, 10, 2, 2,
  0, 0, 10, 0, 0, 0, 0, 10, 0, 0,
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 15 RELAX 16 - Unnamed5
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 2, 0, 0, 3, 0, 0, 6, 0,
  0, 0, 0, 0, 0, 7, 0, 0, 7, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  4, 0, 0, 5, 0, 0, 8, 0, 0, 0,
  7, 0, 0, 7, 0, 0, 7, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 2, 0, 0, 0, 7,
  0, 0, 0, 0, 0, 7, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 3, 0, 0, 0, 0, 0, 5, 0,
  0, 0, 7, 0, 0, 0, 0, 0, 7, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 1, 1,  // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 16 RELAX 17 - Scissors
  0, 3, 3, 3, 0, 3, 3, 3, 0, 2,
  0, 3, 0, 3, 0, 3, 0, 3, 10, 2,
  0, 3, 3, 3, 0, 3, 3, 3, 10, 0,
  0, 0, 3, 3, 0, 3, 3, 0, 10, 0,
  0, 0, 0, 3, 0, 3, 0, 0, 7, 0,
  0, 0, 0, 3, 3, 3, 0, 0, 10, 0,
  0, 0, 0, 4, 3, 4, 0, 0, 10, 0,
  0, 0, 0, 0, 7, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 4, 0, 0, 0, 0, 0,
  0, 0, 0, 4, 0, 4, 0, 0, 0, 0,
  0, 0, 0, 4, 0, 4, 0, 0, 0, 0,
  0, 0, 4, 0, 0, 0, 4, 0, 0, 0,
  0, 0, 4, 10, 0, 10, 4, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 0, 0,  // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 17 RELAX 18 - Gieskanne
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 15, 15, 15, 0, 0,
  0, 0, 0, 0, 11, 0, 0, 0, 12, 0,
  0, 0, 0, 0, 10, 0, 0, 0, 10, 0,
  7, 3, 0, 0, 10, 3, 3, 0, 10, 0,
  0, 3, 3, 0, 3, 3, 0, 3, 10, 0,
  0, 0, 3, 3, 3, 3, 3, 3, 13, 0,
  4, 0, 0, 3, 3, 3, 3, 3, 0, 0,
  0, 0, 0, 3, 3, 3, 3, 3, 0, 0,
  0, 4, 0, 0, 3, 3, 3, 3, 0, 0,
  0, 0, 0, 0, 3, 3, 3, 3, 0, 0,
  4, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  1, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 18 RELAX 19 - Balloon
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  0, 4, 0, 0, 0, 0, 0, 4, 4, 4,
  0, 0, 0, 0, 8, 8, 0, 0, 4, 0,
  0, 0, 0, 6, 6, 6, 6, 0, 0, 0,
  0, 0, 3, 3, 3, 3, 3, 3, 0, 0,
  0, 0, 5, 5, 5, 5, 5, 5, 0, 0,
  0, 0, 3, 3, 3, 3, 3, 3, 0, 0,
  0, 0, 0, 6, 6, 6, 6, 0, 0, 0,
  0, 0, 0, 10, 8, 8, 10, 0, 0, 0,
  0, 0, 0, 10, 0, 0, 10, 0, 0, 0,
  0, 0, 0, 10, 0, 0, 10, 0, 0, 0,
  0, 0, 0, 14, 2, 2, 13, 0, 0, 0,
  0, 0, 0, 0, 2, 2, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 19 RELAX 20 - Pac Man
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 7, 7,
  0, 0, 0, 6, 6, 6, 0, 0, 4, 4,
  0, 0, 6, 6, 6, 6, 6, 0, 4, 4,
  0, 6, 6, 6, 0, 6, 6, 0, 7, 7,
  0, 6, 6, 6, 6, 6, 0, 0, 0, 0,
  0, 6, 6, 6, 6, 0, 0, 0, 0, 0,
  0, 6, 6, 6, 6, 0, 0, 0, 7, 7,
  0, 6, 6, 6, 6, 6, 0, 0, 2, 2,
  0, 0, 6, 6, 6, 6, 6, 0, 2, 2,
  0, 0, 0, 6, 6, 6, 0, 0, 7, 2,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  3, 3, 7, 0, 0, 0, 0, 0, 0, 0,
  3, 3, 7, 0, 0, 0, 0, 0, 0, 0,
  3, 3, 7, 0, 0, 0, 0, 0, 0, 0,
  1, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open


  // 20 RELAX 21 - Tree
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 7, 7, 7, 7, 0,
  0, 7, 0, 0, 3, 0, 0, 0, 7, 7,
  7, 0, 0, 3, 3, 3, 0, 0, 0, 7,
  7, 0, 3, 3, 8, 3, 3, 0, 0, 0,
  0, 0, 0, 3, 8, 8, 8, 0, 0, 0,
  0, 3, 3, 3, 8, 3, 3, 3, 0, 7,
  0, 8, 3, 3, 8, 8, 8, 0, 0, 0,
  7, 0, 8, 8, 8, 3, 0, 0, 3, 0,
  0, 7, 3, 3, 8, 3, 8, 3, 0, 0,
  3, 0, 0, 3, 8, 8, 3, 0, 7, 0,
  0, 3, 3, 3, 8, 0, 3, 3, 0, 7,
  0, 0, 0, 0, 8, 0, 0, 0, 3, 0,
  0, 0, 0, 0, 8, 0, 0, 0, 0, 0,
  0, 0, 0, 7, 7, 7, 0, 0, 0, 0,
  1, 0, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open


  // 21 RELAX 22 - Fish
  0, 0, 0, 3, 0, 0, 0, 7, 7, 7,
  0, 4, 0, 0
  , 0, 0, 0, 0, 7, 0,
  0, 4, 4, 0, 0, 4, 4, 0, 0, 3,
  0, 4, 5, 0, 5, 5, 5, 5, 0, 0,
  0, 4, 4, 5, 5, 5, 5, 0, 5, 0,
  0, 0, 4, 5, 5, 5, 5, 5, 5, 0,
  0, 4, 4, 5, 5, 5, 5, 5, 5, 0,
  0, 4, 5, 0, 5, 5, 5, 5, 0, 0,
  0, 4, 4, 0, 0, 4, 4, 0, 0, 0,
  0, 4, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 7, 0, 0, 0, 0, 0, 0, 3, 0,
  7, 7, 0, 3, 0, 0, 0, 3, 0, 7,
  7, 7, 7, 0, 0, 0, 0, 3, 0, 7,
  7, 7, 7, 0, 0, 0, 0, 7, 7, 7,
  1, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 22 EASY 23 - Abyss
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  7, 0, 0, 0, 0, 0, 0, 0, 0, 7,
  0, 7, 0, 0, 0, 0, 0, 0, 7, 0,
  0, 0, 7, 0, 0, 0, 0, 7, 0, 0,
  0, 0, 0, 7, 0, 0, 7, 0, 0, 0,
  8, 8, 8, 8, 0, 0, 8, 8, 8, 8,
  4, 4, 4, 4, 0, 0, 4, 4, 4, 4,
  5, 5, 5, 5, 0, 0, 5, 5, 5, 5,
  3, 3, 3, 3, 0, 0, 3, 3, 3, 3,
  1, 0, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0, // Upper, lower, left, right border is 0-closed/1-open

  // 23 RELAX 24 - Flower2
  7, 7, 7, 0, 0, 0, 0, 0, 7, 7,
  7, 7, 0, 0, 6, 0, 0, 0, 0, 7,
  7, 0, 0, 6, 6, 6, 0, 12, 0, 0,
  7, 0, 6, 6, 8, 6, 6, 0, 0, 0,
  0, 0, 6, 6, 8, 6, 6, 0, 0, 0,
  0, 14, 0, 6, 6, 6, 0, 0, 0, 0,
  0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 3, 0, 0, 0, 0, 0,
  0, 0, 0, 3, 3, 3, 0, 0, 0, 0,
  0, 0, 3, 3, 3, 0, 3, 0, 0, 0,
  7, 3, 3, 0, 3, 0, 0, 13, 0, 0,
  7, 3, 0, 0, 3, 0, 0, 0, 0, 0,
  7, 0, 0, 7, 3, 0, 0, 0, 0, 0,
  7, 7, 7, 7, 3, 0, 0, 0, 0, 7,
  7, 7, 7, 7, 3, 0, 7, 0, 0, 7,
  0, 0, 1, 1,  // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 24 RELAX 25 - Himbeere
  0, 0, 0, 0, 0, 0, 0, 7, 7, 7,
  0, 0, 0, 0, 0, 0, 0, 0, 7, 7,
  0, 0, 0, 0, 0, 3, 0, 0, 0, 7,
  0, 0, 0, 0, 3, 3, 3, 0, 0, 7,
  0, 0, 0, 5, 5, 3, 5, 0, 0, 7,
  0, 0, 5, 5, 5, 5, 5, 5, 0, 7,
  0, 0, 5, 5, 4, 5, 5, 5, 0, 7,
  0, 0, 5, 4, 5, 5, 4, 5, 0, 7,
  0, 0, 5, 5, 5, 5, 5, 5, 0, 7,
  0, 0, 5, 5, 5, 5, 5, 5, 0, 7,
  0, 0, 0, 5, 4, 5, 5, 0, 7, 7,
  0, 0, 0, 5, 5, 5, 5, 0, 7, 7,
  0, 0, 0, 0, 5, 5, 0, 0, 7, 7,
  0, 0, 0, 0, 0, 0, 0, 7, 7, 7,
  0, 0, 0, 0, 0, 0, 7, 7, 7, 0,
  0, 0, 1, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 25 RELAX 26 - Mithotronic  
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 
15, 15, 15, 15, 15, 15, 0, 0, 7, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 
0, 4, 4, 4, 4, 4, 0, 7, 7, 7, 
0, 4, 0, 4, 0, 4, 0, 0, 7, 0, 
0, 4, 0, 4, 0, 4, 0, 0, 7, 0, 
0, 4, 0, 4, 0, 4, 0, 0, 7, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
9, 9, 9, 9, 9, 9, 0, 9, 9, 9, 
0, 5, 2, 0, 0, 0, 0, 0, 0, 0, 
0, 3, 4, 0, 0, 0, 0, 0, 0, 0, 
0, 6, 8, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
1, 0, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open


// ---------- EASY ARENAS ----------------


  // 26 EASY 1 - Classic Open
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 2, 2, 2, 2, 2, 2, 2, 2, 0, 
0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 
0, 4, 4, 4, 4, 4, 4, 4, 4, 0, 
0, 5, 5, 5, 5, 5, 5, 5, 5, 0, 
0, 6, 6, 6, 6, 6, 6, 6, 6, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 15, 7, 0, 0, 0, 0, 7, 15, 0, 
7, 7, 7, 0, 0, 0, 0, 7, 7, 7, 
0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
0, 1, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

 // 27  EASY 2 - Nearly Done
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  7, 6, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 
  7, 6, 0, 5, 0, 0, 0, 0, 0, 0, 
  0, 0, 3, 0, 4, 0, 0, 0, 0, 0, 
  7, 6, 0, 5, 0, 0, 0, 0, 0, 0, 
  0, 0, 3, 0, 4, 0, 0, 0, 0, 0, 
  7, 6, 0, 5, 0, 0, 0, 0, 0, 0, 
  0, 0, 3, 0, 4, 0, 0, 0, 0, 0, 
  7, 6, 0, 5, 0, 0, 0, 0, 0, 0, 
  0, 0, 3, 0, 4, 0, 0, 0, 0, 0, 
  7, 6, 0, 5, 0, 0, 0, 0, 0, 0, 
  0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 
  7, 6, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 1,  // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 1, // Upper, lower, left, right border is 0-closed/1-open

  // 28 EASY 3 - Umbrella
  0, 0, 4, 0, 0, 0, 0, 0, 4, 0,
  0, 0, 0, 0, 0, 4, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 4, 0, 0, 3, 0, 0, 0, 0, 4,
  0, 0, 0, 3, 3, 3, 0, 0, 0, 0,
  0, 0, 3, 3, 3, 3, 3, 0, 0, 0,
  0, 0, 0, 0, 10, 0, 0, 0, 0, 0,
  4, 0, 0, 0, 10, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 10, 0, 0, 0, 4, 0,
  0, 0, 0, 0, 10, 0, 0, 0, 0, 4,
  0, 0, 0, 0, 13, 0, 0, 0, 0, 0,
  4, 0, 0, 0, 0, 0, 0, 0, 4, 0,
  7, 7, 7, 0, 0, 0, 0, 7, 7, 7,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 1, 0, 0, // Upper, lower, left, right border is 0-closed/1-open 
  
  // 29 EASY 4 - Open all day
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  11, 9, 9, 9, 0, 0, 9, 9, 9, 12,
  10, 0, 0, 0, 0, 0, 0, 0, 0, 10,
  10, 0, 0, 0, 2, 0, 0, 0, 0, 10,
  10, 0, 0, 0, 3, 0, 0, 0, 0, 10,
  10, 0, 0, 4, 4, 4, 0, 0, 0, 10,
  0, 0, 5, 6, 6, 6, 5, 0, 0, 0,
  0, 0, 5, 6, 6, 6, 5, 0, 0, 0,
  0, 0, 0, 4, 4, 4, 0, 0, 0, 0,
  10, 0, 0, 0, 3, 0, 0, 0, 0, 10,
  10, 0, 0, 0, 2, 0, 0, 0, 0, 10,
  10, 0, 0, 0, 0, 0, 0, 0, 0, 10,
  10, 0, 0, 0, 0, 0, 0, 0, 0, 10,
  14, 15, 15, 15, 0, 0, 15, 15, 15, 13,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  1, 1, 1, 1,  // Upper, lower, left, right bat is 1-active/0 - inactive
  1, 1, 1, 1, // Upper, lower, left, right border is 0-closed/1-open

  // 30 EASY 5 - Rocket
  0, 0, 0, 13, 0, 0, 0, 0, 0, 7, 
  0, 0, 13, 8, 14, 0, 0, 0, 0, 7, 
  0, 0, 6, 8, 2, 0, 0, 0, 0, 7, 
  0, 0, 6, 8, 2, 0, 0, 0, 0, 0, 
  0, 0, 6, 8, 2, 0, 0, 0, 0, 0, 
  0, 0, 6, 8, 2, 0, 0, 0, 0, 0, 
  0, 0, 6, 8, 2, 0, 0, 0, 0, 0, 
  0, 0, 6, 8, 2, 0, 0, 0, 0, 0, 
  0, 10, 6, 8, 2, 10, 0, 0, 0, 0, 
  0, 7, 6, 8, 2, 7, 0, 0, 0, 0, 
  0, 0, 6, 8, 2, 0, 0, 0, 0, 0, 
  0, 0, 6, 8, 2, 0, 0, 0, 0, 7, 
  0, 0, 0, 7, 0, 0, 0, 0, 0, 7, 
  0, 0, 7, 9, 7, 0, 0, 0, 0, 7, 
  0, 15, 15, 15, 15, 15, 0, 0, 0, 7, 
  0, 0, 0, 1,  // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 1,  // Upper, lower, left, right border is 0-closed/1-open

  // 31 WORK 6 - Open1
  8, 0, 0, 0, 0, 0, 0, 0, 0, 2,
  8, 0, 0, 0, 0, 0, 0, 0, 0, 2,
  15, 0, 0, 0, 0, 0, 0, 0, 0, 15,
  0, 5, 0, 0, 0, 0, 0, 0, 3, 0,
  0, 5, 0, 0, 0, 0, 0, 0, 3, 0,
  0, 5, 0, 0, 0, 0, 0, 0, 3, 0,
  15, 0, 0, 0, 0, 0, 0, 0, 0, 15,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  15, 0, 0, 0, 0, 0, 0, 0, 0, 15,
  6, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  6, 0, 0, 0, 0, 0, 0, 0, 0, 4,
  6, 0, 0, 0, 0, 0, 0, 0, 0, 4,
  9, 9, 12, 0, 0, 0, 0, 11, 9, 9,
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 1, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open
  
// 32 EASY 7 - Open2
  4, 0, 0, 0, 0, 0, 0, 2, 10, 10,
  4, 3, 0, 0, 0, 0, 0, 2, 10, 10,
  4, 3, 6, 0, 0, 0, 0, 2, 10, 10,
  4, 3, 6, 0, 0, 0, 0, 15, 7, 7,
  4, 3, 6, 0, 0, 0, 0, 0, 0, 0,
  4, 3, 6, 0, 0, 0, 0, 0, 0, 0,
  4, 3, 6, 0, 0, 0, 0, 0, 0, 0,
  4, 3, 6, 0, 0, 0, 0, 0, 0, 0,
  4, 3, 6, 0, 0, 0, 0, 0, 0, 0,
  4, 3, 6, 0, 0, 0, 0, 0, 0, 0,
  4, 3, 6, 0, 0, 0, 0, 0, 0, 0,
  4, 3, 6, 0, 0, 0, 0, 9, 7, 7,
  4, 3, 6, 0, 0, 0, 0, 2, 10, 10,
  4, 3, 0, 0, 0, 0, 0, 2, 10, 10,
  4, 0, 0, 0, 0, 0, 0, 2, 10, 10,
  0, 0, 0, 1,  // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 1, // Upper, lower, left, right border is 0-closed/1-open

  // 33 EASY 8 - Open5
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 8, 5, 4, 3, 2, 6, 0, 0,
  0, 0, 8, 5, 4, 3, 2, 6, 0, 0,
  0, 0, 8, 5, 4, 3, 2, 6, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  7, 0, 0, 0, 0, 0, 0, 0, 0, 7,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 7, 7, 0, 0, 0, 0, 7, 7, 0,
  7, 0, 0, 0, 0, 0, 0, 0, 0, 7,
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 1, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 34 EASY 9 - Open3
  7, 7, 7, 0, 0, 0, 0, 0, 0, 0,
  7, 7, 0, 0, 0, 2, 0, 12, 0, 0,
  7, 0, 0, 0, 2, 2, 2, 10, 0, 0,
  0, 0, 0, 0, 2, 2, 2, 10, 0, 0,
  0, 0, 0, 0, 0, 2, 0, 10, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 6, 0, 0, 0, 0,
  0, 0, 0, 0, 6, 6, 6, 10, 0, 0,
  0, 0, 0, 0, 6, 6, 6, 10, 0, 0,
  10, 0, 0, 0, 0, 6, 0, 10, 0, 0,
  10, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  10, 0, 0, 0, 0, 3, 0, 0, 0, 0,
  10, 0, 0, 0, 3, 3, 3, 10, 0, 0,
  10, 0, 0, 0, 3, 3, 3, 10, 0, 0,
  10, 0, 0, 0, 0, 3, 0, 10, 0, 0,
  0, 0, 1, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 1, 0,  // Upper, lower, left, right border is 0-closed/1-open
  
   // 35  EASY 10 - Spikey
  7, 8, 8, 8, 0, 0, 7, 7, 7, 7, 
  5, 5, 5, 0, 0, 0, 0, 0, 0, 10, 
  3, 3, 0, 0, 0, 0, 0, 0, 0, 10, 
  4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 7, 7, 0, 0, 0, 
  0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 
  0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 
  0, 7, 7, 0, 0, 0, 0, 0, 0, 0, 
  0, 7, 7, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 
  2, 0, 0, 0, 0, 7, 7, 0, 0, 0, 
  8, 8, 0, 0, 0, 0, 0, 0, 0, 10, 
  6, 6, 6, 0, 0, 0, 0, 0, 0, 10, 
  7, 3, 3, 3, 0, 0, 7, 7, 7, 7, 
  0, 0, 1, 1, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 1, // Upper, lower, left, right border is 0-closed/1-open
  
  // 36 EASY 11 - Concentration!
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 6, 6, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 4, 4, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 5, 5, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  1, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  1, 1, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 37 EASY 12 - Key
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 7, 7, 0, 0, 0, 0,
  0, 0, 0, 7, 7, 7, 7, 0, 0, 0,
  0, 0, 0, 0, 4, 4, 7, 0, 0, 0,
  0, 0, 0, 7, 7, 7, 7, 0, 0, 0,
  0, 0, 0, 0, 7, 7, 0, 0, 0, 0,
  0, 0, 0, 0, 7, 7, 0, 0, 0, 0,
  0, 0, 0, 0, 7, 7, 0, 0, 0, 0,
  0, 0, 0, 0, 7, 7, 0, 0, 0, 0,
  0, 0, 0, 0, 7, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 7, 7, 0, 0, 0, 0,
  0, 0, 0, 0, 7, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 7, 7, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  1, 1, 1, 1,  // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open
  

// ---------- HARD ARENAS ----------------


  // 38 WORK 1 - Duck
  0, 8, 0, 0, 0, 6, 6, 0, 0, 0,
  8, 8, 0, 0, 0, 6, 7, 6, 0, 0,
  0, 6, 6, 0, 0, 6, 6, 6, 0, 0,
  0, 6, 6, 6, 6, 6, 6, 8, 8, 8,
  0, 6, 6, 6, 6, 6, 6, 8, 8, 0,
  0, 0, 6, 6, 6, 6, 6, 6, 0, 0,
  0, 0, 4, 6, 6, 6, 6, 6, 4, 0,
  0, 4, 4, 4, 6, 6, 6, 4, 4, 4,
  0, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  0, 0, 4, 4, 4, 4, 4, 4, 4, 0,
  0, 0, 0, 0, 0, 4, 4, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  15, 15, 0, 0, 15, 15, 15, 15, 15, 15,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 1, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

 
  // 39 WORK 2 - Garbage truck
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 15, 15, 15, 15, 15, 15, 0, 0, 
  0, 0, 8, 8, 8, 8, 8, 8, 8, 8, 
  6, 6, 8, 8, 8, 8, 8, 8, 8, 8, 
  4, 6, 8, 8, 8, 8, 8, 8, 8, 8, 
  4, 6, 8, 8, 8, 8, 8, 8, 8, 8, 
  6, 6, 6, 8, 8, 8, 8, 8, 8, 8, 
  11, 9, 12, 6, 6, 6, 6, 11, 9, 12, 
  10, 7, 10, 6, 6, 6, 6, 10, 7, 10, 
  14, 15, 13, 0, 0, 0, 0, 14, 15, 13, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  15, 15, 15, 0, 0, 0, 15, 15, 15, 15, 
  1, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 1, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 40 WORK 3 - Open4
  0, 0, 0, 0, 0, 10, 2, 2, 2, 2,
  0, 0, 0, 0, 0, 10, 5, 5, 5, 0,
  0, 0, 0, 0, 0, 10, 8, 0, 0, 0,
  0, 0, 0, 0, 0, 10, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 10, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 10, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 10, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 10, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 10, 8, 0, 0, 0,
  0, 0, 0, 0, 0, 10, 5, 5, 0, 0,
  0, 0, 0, 0, 0, 10, 2, 2, 2, 2,
  0, 0, 1, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 1, 0,  // Upper, lower, left, right border is 0-closed/1-open
  

  // 41 WORK 4 - Not Overly Nice
  10, 0, 0, 0, 0, 0, 0, 0, 0, 10, 
  10, 0, 0, 0, 0, 0, 0, 0, 0, 10, 
  10, 0, 0, 0, 0, 0, 0, 0, 0, 10, 
  0, 0, 0, 7, 7, 7, 7, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 7, 5, 3, 7, 0, 0, 0, 
  0, 0, 0, 7, 2, 6, 7, 0, 0, 0, 
  0, 0, 0, 7, 8, 4, 7, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 7, 7, 7, 7, 0, 0, 0, 
  10, 0, 0, 0, 0, 0, 0, 0, 0, 10, 
  10, 0, 0, 0, 0, 0, 0, 0, 0, 10, 
  10, 0, 0, 0, 0, 0, 0, 0, 0, 10, 
  1, 1, 1, 1,  // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 1, 1, // Upper, lower, left, right border is 0-closed/1-open


  // 42 WORK 5 - Tunnel
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 5, 5, 7, 7, 7, 7, 5, 5, 0, 
0, 2, 2, 7, 0, 0, 7, 2, 2, 0, 
0, 3, 3, 7, 0, 0, 7, 3, 3, 0, 
0, 4, 4, 7, 0, 0, 7, 4, 4, 0, 
0, 8, 8, 7, 0, 0, 7, 8, 8, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
9, 12, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 14, 15, 15, 13, 0, 0, 0, 11, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 14, 15, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
0, 1, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 43 WORK 6 - Knob
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 6, 7, 0, 0, 0, 
  0, 0, 0, 0, 6, 8, 6, 7, 0, 0, 
  0, 0, 0, 6, 8, 8, 8, 6, 7, 0, 
  0, 0, 0, 8, 0, 8, 0, 8, 7, 0, 
  0, 0, 6, 8, 8, 8, 8, 8, 6, 7, 
  0, 0, 0, 8, 0, 8, 0, 8, 0, 0, 
  0, 0, 0, 6, 8, 8, 8, 6, 0, 0, 
  0, 0, 0, 0, 6, 8, 6, 7, 0, 0, 
  0, 0, 0, 0, 0, 6, 7, 0, 0, 0, 
  0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1, 1, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 1, 0,  // Upper, lower, left, right border is 0-closed/1-open

 // 44  WORK 7 - Tough
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
0, 7, 7, 0, 0, 0, 0, 7, 7, 0, 
0, 7, 8, 0, 0, 0, 0, 8, 7, 0, 
0, 7, 0, 0, 0, 0, 0, 0, 7, 0, 
7, 7, 0, 0, 10, 0, 0, 0, 7, 7, 
0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 
0, 0, 15, 4, 5, 3, 15, 0, 0, 0, 
0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
7, 7, 0, 0, 10, 0, 0, 0, 7, 0, 
0, 7, 0, 0, 0, 0, 0, 0, 7, 7, 
0, 7, 0, 0, 0, 0, 0, 0, 7, 0, 
0, 7, 8, 0, 0, 0, 0, 8, 7, 0, 
0, 7, 7, 0, 0, 0, 7, 7, 7, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
1, 1, 1, 1,  // Upper, lower, left, right bat is 1-active/0 - inactive
1, 1, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open


  // 45 WORK 8 - Space War!
  0, 2, 0, 0, 0, 0, 2, 0, 0, 7, 
  0, 0, 2, 0, 0, 2, 0, 0, 0, 7, 
  0, 2, 2, 2, 2, 2, 2, 0, 0, 7, 
  2, 2, 0, 2, 2, 0, 2, 2, 0, 7, 
  2, 2, 2, 2, 2, 2, 2, 2, 0, 7, 
  0, 2, 2, 2, 2, 2, 2, 0, 0, 7, 
  0, 2, 2, 2, 2, 2, 2, 0, 0, 0, 
  0, 2, 2, 2, 2, 2, 2, 0, 0, 0, 
  0, 2, 0, 0, 0, 0, 2, 0, 0, 0, 
  0, 0, 2, 0, 0, 2, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 
  0, 1, 0, 1,  // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 1, 0, 1, // Upper, lower, left, right border is 0-closed/1-open

  // 46 WORK 9 - Crown
  7, 7, 7, 0, 0, 0, 7, 7, 7, 7, 
7, 0, 0, 0, 0, 0, 7, 7, 7, 7, 
7, 0, 0, 0, 0, 0, 0, 7, 7, 7, 
7, 0, 0, 0, 0, 0, 0, 0, 7, 7, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 
0, 0, 0, 6, 0, 6, 0, 6, 0, 0, 
0, 0, 0, 5, 6, 6, 6, 5, 0, 0, 
0, 0, 0, 6, 2, 2, 2, 6, 0, 0, 
0, 0, 0, 5, 6, 6, 6, 5, 0, 0, 
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
7, 7, 0, 0, 0, 0, 0, 0, 0, 0, 
7, 7, 7, 0, 0, 0, 0, 0, 0, 7, 
7, 7, 7, 7, 0, 0, 0, 0, 0, 7, 
7, 7, 7, 7, 0, 0, 0, 7, 7, 7, 
1, 1, 1, 1, // Upper, lower, left, right bat is 1-active/0 - inactive
1, 1, 1, 1,  // Upper, lower, left, right border is 0-closed/1-open



  // 47 WORK 10 - Homing In
  5, 6, 3, 2, 8, 4, 5, 6, 3, 2, 
  5, 6, 3, 2, 8, 4, 5, 6, 3, 2, 
  5, 0, 3, 0, 8, 0, 5, 0, 3, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 7, 7, 0, 0, 0, 7, 7, 7, 0, 
  0, 7, 7, 0, 0, 0, 7, 7, 7, 0, 
  0, 7, 7, 0, 0, 0, 7, 7, 7, 0, 
  0, 7, 7, 0, 0, 0, 7, 7, 0, 0, 
  0, 7, 7, 0, 0, 0, 7, 7, 0, 0, 
  0, 0, 7, 0, 0, 0, 7, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 1, 0, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 1, 0, 0,  // Upper, lower, left, right border is 0-closed/1-open

  // 48 WORK 11 - Wicked
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 9, 9, 9, 9, 12, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 
  0, 0, 0, 11, 9, 9, 9, 0, 5, 0, 
  0, 0, 0, 10, 5, 0, 0, 0, 0, 0, 
  0, 0, 11, 9, 9, 0, 0, 0, 0, 3, 
  0, 0, 10, 6, 2, 0, 0, 0, 0, 8, 
  0, 0, 14, 15, 15, 0, 0, 0, 0, 2, 
  0, 0, 0, 10, 4, 0, 0, 0, 0, 0, 
  0, 0, 0, 14, 15, 15, 15, 0, 8, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 
  0, 0, 0, 0, 0, 15, 15, 15, 13, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  1, 1, 1, 0, // Upper, lower, left, right bat is 1-active/0 - inactive
  0, 0, 1, 0  // Upper, lower, left, right border is 0-closed/1-open

};

// Ball reflection
#define IS_BORDER 0
#define IS_BAT 1
#define IS_BRICK 2
#define IS_BADDIE 3

// The arena = playing field is surrounded by a border
byte levelData[150]; // 15 rows a 10 bricks

// Playfield
byte playfield[32][32]; // Holds the objects in the playfield
boolean upperBorderOpen;
boolean lowerBorderOpen;
boolean leftBorderOpen;
boolean rightBorderOpen;
boolean borderTemporarilyOpen;
boolean borderOpen;
long borderOpenTimer;
int animCounter;
boolean animToggle;

// Frame buffer
int framebuffer[32][32]; // Contains the pixel colors of the screen

// stage settings
const byte NUM_LIVES = 7;
const byte NUM_ARENAS = (sizeof(arenaData) / sizeof(arenaData[0])) / 154; // Number of arenas
byte lives = NUM_LIVES;   // Number of remaining lives
byte difficulty = 0;      // Difficulty of current game
int score = 0;            // Current score
int numBricks;           // Number of bricks in current arena
byte numStagesFinished = 0;  // Counts the number of stages the player has finished
int arena; // = START_ARENA; // Game begins at arena 0

boolean reset;
boolean pause;       // if true, halt the game until the joystick is moved
boolean skipStage;
boolean nextArena;
boolean gameOver;
boolean lostLife;
boolean waitingForUserStart;
boolean onePlayerMode;
boolean joystick1Reversed;
boolean joystick2Reversed;
boolean ballTurnedHavoc;
boolean gameGoing = false;
boolean ongoingBonusAction = false;
byte gameMode;
#define RELAXED 0
#define EASY 1
#define WORK 2

double getInkrement_x(double);
double getInkrement_y(double);
double ball_moveAngle[5];
double ball_x[5] = { 34, 34, 34, 34, 34 };
double ball_y[5] = { 34, 34, 34, 34, 34 };
double ball_old_x[5] = { ball_x[0], ball_x[1], ball_x[2], ball_x[3], ball_x[4] };
double ball_old_y[5] = { ball_y[0], ball_y[1], ball_y[2], ball_y[3], ball_y[4] };
double ball_vector_x[5];
double ball_vector_y[5];
boolean ball_active[5] = { true, false, false, false, false };
boolean ballReflected[5] = { false, false, false, false, false }; // True, if a collision between ball i and an object or the walls occurred
boolean multipleBallsActive = false;
long bonusActionTimer;
byte numActiveBalls;

// Bats
#define UPPER_BAT 0
#define LOWER_BAT 1
#define LEFT_BAT 2
#define RIGHT_BAT 3
#define NONE 4
#define LEFT_BAT_HEIGHT 1 // Lower bat is on position y=31-1, upper bat is on y=0+1, left bat is on x=0+1, right bat is on x=31-1
#define RIGHT_BAT_HEIGHT 30
#define UPPER_BAT_HEIGHT 1
#define LOWER_BAT_HEIGHT 30
byte bat_pos[4]; // For the two horizontal bats, this is their current x position. For the two vertical bats, this is the their current y position
byte bat_pos_old[4];
boolean bat_active[4]; // = { false, false, false, false }; // Upper, lower, left, right bat
byte collidedBat = NONE; // ID of the bat that collided with a bonus item
boolean bat_hasBall[5] = { false, false, false, false };
boolean bat_hasGun[5] = { false, false, false, false };
boolean bat_isEnlarged[5] = { false, false, false, false };
byte bat_direction[5] = { STILL, STILL, STILL, STILL, STILL };
boolean batCanShoot = false;
boolean enlargedBat;

int shotsRemaining;
boolean shotInArena;
byte shot_x;
byte shot_y;

// Baddies
byte numBaddies = 4; // Maximum number of active baddies on-screen
boolean baddie_active[4] = { false, false, false, false };
int baddie_x[4] = { 0, 0, 0, 0 };
int baddie_y[4] = { 0, 0, 0, 0 };
int baddie_old_x[4] = { 0, 0, 0, 0 };
int baddie_old_y[4] = { 0, 0, 0, 0 };
byte baddie_type[4] = { 0, 0, 0, 0 };
byte baddie_appearance[4] = { 0, 0, 0, 0 };
byte baddieDir[4] = {0, 0, 0, 0 };
boolean baddieAppear[4] = { false, false, false, false};
boolean baddieDisappear[4] = { false, false, false, false};
boolean baddieExplode[4] = { false, false, false, false};
byte baddieAnimFrame[4] = { 0, 0, 0, 0 };
byte disturberAnimFrame[4] = { 0, 0, 0, 0 };
byte baddieAppearAnimFrame[4] = { 0, 0, 0, 0 };
byte baddieExplodeAnimFrame[4] = { 0, 0, 0, 0 };
boolean baddieHasCollided[4] = { false, false, false, false };
long baddieTimer[4] = { 0, 0, 0, 0 };
byte baddie_nextWaypointX[4] = { 0, 0, 0, 0 };
byte baddie_nextWaypointY[4] = { 0, 0, 0, 0 };
byte baddieTimeInkrement = 0;
boolean baddieCouldMoveX;
boolean baddieCouldMoveY;
byte lastBaddieTypeMade;
boolean baddieType2InGame;

#define KAMIKAZE 0
#define RANDOM_WALK 1
#define DISTURBER 2

// Bat impeded by a baddie
#define NOT_NEARBY 0
#define IS_RIGHT 1
#define IS_LEFT 2
#define IS_OVER 3
#define IS_UNDER 4

// Colors
const int bat_color = matrix.Color333(2, 1, 1);
const int bat_color2 = matrix.Color333(13, 7, 1);
const int wall_color = matrix.Color333(1, 1, 2);
const int ball_color = matrix.Color333(3, 3, 2); // was 5, 5, 3
const int backgroundColor = matrix.Color333(0, 0, 0);
const int baddie_color = matrix.Color333(1, 0, 2);
const int baddie_color2 = matrix.Color333(1, 0, 2);

// Helper (used for different things)
int i, j, k;
double x, y, z;


// ------ The next section is for controlling the bonus items --------

// The border the bonus item on-screen is going to move towards
#define GO_LEFT 0
#define GO_RIGHT 1
#define GO_UP 2
#define GO_DOWN 3

#define BONUS_MOVING_LEFT 0
#define BONUS_MOVING_RIGHT 1
#define BONUS_MOVING_UP 2
#define BONUS_MOVING_DOWN 3
#define BONUS_MOVING_TO_MIDDLE 4
#define BONUS_MOVING_NE 5
#define BONUS_MOVING_NW 6
#define BONUS_MOVING_SE 7
#define BONUS_MOVING_SW 8
#define BONUS_FRESH 9
#define BONUS_EMERGE 10
#define BONUS_LEAVE_SE 11
#define BONUS_LEAVE_SW 12

int bonus_x; // The bonus item's starting position
int bonus_y;
byte bonus_pathIndex = 0;
byte bonus_lastIndex = 0;
byte bonus_leftBoundary = 0;
byte bonus_rightBoundary = 30;
byte bonus_upperBoundary = 0;
byte bonus_lowerBoundary = 30;
byte bonus_mode = BONUS_FRESH;
int bonus_currentBorder = -1; // 0 - left border, 1 - right border, 2 - upper border, 3 - lower border
int bonus_nextBorder = bonus_currentBorder;
int *bonus_trajectory_x; // Points to an array of integers (x-vector)
int *bonus_trajectory_y; // Points to an array of integers (y-vector)
boolean bonusObjectFlying = false;
boolean bonusDisappear;
byte bonusAppearance = 0;
long bonusTimer;
byte bonusAnimFrame;
byte formerAction = 1000; // 1000 is suitably high to be an unlikely value

#define GRAPE 0
#define CHERRY 1
#define BANANA 2
#define APPLE 3

int next_move_x;
int next_move_y;

int spiral1_x[] = { -1, -1, -1, -1,  0,  1,  1, 1, 1, 1, 1, 1, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
int spiral1_y[] = { 0,  0, -1, -1, -1, -1, -1, 0, 0, 1, 1, 1, 1, 1,  1,  1,  1,  0,  0,  0, -1, -1, -1,  0};
int spiral2_x[] = { -1, -1, -1,  0,  1,  1, 1, 1, 1, 0, 0, -1, -1, -1, -1, -1, -1,  0,  0,  1,  1, 1, 1, 1, 1, 1, 1, 1};
int spiral2_y[] = { 1,  0, -1, -1, -1, -1, 0, 1, 1, 1, 1,  1,  1,  0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 1, 1, 1, 1, 0};

int sineL2_x[] = { -1, -1, -1, -1, -1, -1, -1};
int sineL2_y[] = {  0,  1,  0, -1, -1,  0,  1};
int sineL3_x[] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
int sineL3_y[] = {  0,  1,  0,  1,  0, -1,  0, -1,  0, -1,  0, -1,  0, -1,  0,  1,  0,  1,  0,  1};

int sineR1_x[] = { 1, 1,  1,  1, 1, 1, 1, 1, 1, 1,  1,  1, 1};
int sineR1_y[] = { 0, 0, -1, -1, 0, 1, 1, 1, 1, 0, -1, -1, 0};
int sineR4_x[] = { 1,  1, 1,  1, 1,  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,  1, 1,  1};
int sineR4_y[] = { 0, -1, 0, -1, 0, -1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, -1, 0, -1};
int sineR2_x[] = { 1,  1, 1,  1, 1, 1, 1,  1, 1,  1, 1,  1};
int sineR2_y[] = { 0, -1, 0, -1, 0, 1, 0, -1, 0, -1, 0, -1};
int sineR3_x[] = { 1,  1, 1,  1, 1,  1};
int sineR3_y[] = { 0, -1, 0, -1, 0, -1};

int sineU1_x[] = {  0,  0,  1,  1,  0, -1, -1,  0,  1 };
int sineU1_y[] = { -1, -1, -1, -1, -1, -1, -1, -1, -1 };

int sineD1_x[] = { 0, 1, 1, 0, -1, -1, -1, 0};
int sineD1_y[] = { 1, 1, 1, 1,  1,  1,  1, 1};

int sineNE_x[] = {  1,  0,  1,  1,  0,  0,  1, 1, 1, 1,  1,  0,  1};
int sineNE_y[] = { -1, -1, -1, -1, -1, -1, -1, 0, 1, 0, -1, -1, -1};
int sineSW_x[] = { 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1};
int sineSW_y[] = { 1, 1, 1,  1,  1,  0,  0,  0,  0,  1, 1, 1, 1,  0};
int sineSE_x[] = { 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0};
int sineSE_y[] = { 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1};
int sineNW_x[] = { -1,  0, -1,  0, -1,  0, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0};
int sineNW_y[] = { -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  1,  0, -1, -1, -1, -1};

int bonusOneUp_x[] = {  0 };
int bonusOneUp_y[] = { -1 };
int bonusOneDown_x[] = { 0 };
int bonusOneDown_y[] = { 1 };
int bonusOneLeft_x[] = { -1 };
int bonusOneLeft_y[] = {  0 };
int bonusOneRight_x[] = { 1 };
int bonusOneRight_y[] = { 0 };


// Function declarations
void setup();
boolean joy1Up();
boolean joy1Down();
boolean joy1Left();
boolean joy1Right();
float joy1XValue();
float joy1YValue();
boolean joy1Fire();
boolean joy1FireA();
boolean joy1FireB();
boolean joy1IsLEDmePlayJoypad();
boolean joy2Up();
boolean joy2Down();
boolean joy2Left();
boolean joy2Right();
float joy2XValue();
float joy2YValue();
boolean joy2Fire();
boolean joy2FireA();
boolean joy2FireB();
boolean joy2IsLEDmePlayJoypad();
void drawM(int x, int y);
void drawT(int x, int y);
void mithotronic();
void setLEDMePlayColor(int i);
void ledMePlay();
void setTimers();
void initBalls();
void clearBalls();
void initBats();
void closeOpenBorders(boolean closeThem);
void blinkOpenBorders();
void initVars();
void initializePlayfield();
void clearFramebuffer();
void drawPlayfield();
void setPlayfieldElement(byte i, byte j, byte element);
void drawPlayfieldElement(byte i, byte j);
void consumeJoystickEvents();
double calcMoveAngle_x(double angle);
double calcMoveAngle_y(double angle);
double getInkrement_x(double angle);
double getInkrement_y(double angle);
byte baddieImpedesBat(byte which);
void moveBat();
boolean reflectAtUpperSurface(byte b, byte surface);
boolean reflectAtLowerSurface(byte b, byte surface);
boolean reflectAtLeftSurface(byte b, byte surface);
boolean reflectAtRightSurface(byte b, byte surface);
boolean reflectDiagonally(byte b, byte surface);
void checkBallReflectedAtBat(byte i, double ball_x, double ball_y);
void checkBallReflectedAtBrick(byte i, double ball_x, double ball_y);
void checkBallOutsidePlayingArea(byte i);
void checkShotCollidedWithBrick();
void checkShotCollidedWithBaddie();
void deleteBrick(byte ex, byte ey);
void setNextHavocBallPosition(byte i, double x, double y);
void deleteObjAndThrowBonus(byte o1, byte o2, int x1, int y1, int x2, int y2);
void moveBalls();
void assignBallToBat();
boolean bothInMooreNeighborhood(double x, double y, double vx, double vy);
void animateShot();
void drawBats();
void clearBats();
void showTitleScreen();
static inline int8_t sgn(int val);
void debug(byte i);
boolean checkBaddieCollision(byte i, byte type);
boolean checkBaddie0CollidedWithBat(byte i);
boolean checkBaddieCollidedWithBat(byte i);
void drawBaddie(byte i);
void clearBaddie(byte i);
void setBaddieType0DirAndPos(byte i);
void setAlternatePosition();
boolean isBrick(int x, int y);
void makeBaddie(byte i);
void placeBaddie(byte i);
void clearBaddies();
boolean canBaddieMove(byte i, byte dir);
void setBaddieType1Pos(byte i);
void setBaddieType2Pos(byte i);
void moveBaddies();
void checkBallCollidedWithBaddie(byte i);
void makeNewBonusObject(int x, int y);
void moveBonusObject();
void clearBonusObject(int x, int y);
void drawBonusObject(int x, int y);
void getNextMovement(int &next_x, int &next_y);
void chooseNextBorder();
void setNewTrajectory(int mode);
boolean checkBatBonusCollision();
void repaintBonusBackground();
void issueBonusAction();
void centerBat(byte bat);
void playEnlargeSound();
void enlargeBat(byte x, byte y);
void drawPlayerText(byte i, byte j);
void drawVSText(byte i, byte j);
void drawWithText(byte i, byte j);
void drawCPUText(byte i, byte j);
void drawRelaxText(byte i, byte j);
void drawEasyText(byte i, byte j);
void drawWorkText(byte i, byte j);
void showOneUpImage(byte i, byte j);
void showJoyRevImage(byte i, byte j);
void drawQuotationMark(byte x, byte y);
void displayGameModeScreen();
void displayNumPlayersScreen();
void restoreBackgroundUnderBalls();
void playDrum(int freq, int duration, int attenuation);
void playNote(int freq, int duration, int attenuation);
void emitSound(byte id);
void playMelody();
void issueMelody(byte num, boolean loop);
void playInterlude(boolean erase);
void showGameOverPicture();
void loop();


// ------------------------------------------------------------------------

void setup()
{
  // Initialize serial connection
  Serial.begin(9600);

  // Initialize random number generator
  randomSeed(1000);

  // Initialize joysticks and  buttons
  pinMode(buttonL1, INPUT);     
  pinMode(buttonR1, INPUT);     
  pinMode(buttonU1, INPUT);     
  pinMode(buttonD1, INPUT);     
  pinMode(buttonFire1, INPUT);     
  pinMode(buttonL2, INPUT);     
  pinMode(buttonR2, INPUT);     
  pinMode(buttonU2, INPUT);     
  pinMode(buttonD2, INPUT);     
  pinMode(buttonFire2, INPUT);     
  pinMode(buttonReset, INPUT);     
  pinMode(buttonPause, INPUT);    

  // Activate internal pull-up resistors 
  digitalWrite(buttonL1, HIGH);
  digitalWrite(buttonR1, HIGH);
  digitalWrite(buttonU1, HIGH);
  digitalWrite(buttonD1, HIGH);
  digitalWrite(buttonFire1, HIGH);
  digitalWrite(buttonL2, HIGH);
  digitalWrite(buttonR2, HIGH);
  digitalWrite(buttonU2, HIGH);
  digitalWrite(buttonD2, HIGH);
  digitalWrite(buttonFire2, HIGH);
  digitalWrite(buttonReset, HIGH);
  digitalWrite(buttonPause, HIGH);

  // Initialize matrix and define text mode
  matrix.begin();
  matrix.setTextWrap(false);

  timer.every(110, moveBonusObject);
  timer.every(85, moveBaddies);
  timer.every(65, moveBalls);
  timer.every(35, moveBat);
  timer.every(20, animateShot);
  timer.every(200, playMelody);  
  
  // Logos
  mithotronic();
  ledMePlay();
  
  // Enter the game loop
  loop();
}

// Joystick inquiry (allows to use a classic joystick or a LEDmePlay Joypad without any configuration)
boolean joy1Up()
{
  if((digitalRead(buttonU1) == LOW && digitalRead(buttonD1) != LOW) || (digitalRead(buttonL1) == LOW && digitalRead(buttonR1) == LOW && analogRead(analogY1) > (512 + sensitivity))){ return true; }
  return false;
}
boolean joy1Down()
{
  if((digitalRead(buttonD1) == LOW && digitalRead(buttonU1) != LOW) || (digitalRead(buttonL1) == LOW && digitalRead(buttonR1) == LOW && analogRead(analogY1) < (512 - sensitivity))){ return true; }
  return false;
}
boolean joy1Left()
{
  if((digitalRead(buttonL1) == LOW && digitalRead(buttonR1) != LOW) || (digitalRead(buttonL1) == LOW && digitalRead(buttonR1) == LOW && analogRead(analogX1) > (512 + sensitivity))){ return true; }
  return false;
}
boolean joy1Right()
{
  if((digitalRead(buttonR1) == LOW && digitalRead(buttonL1) != LOW) || (digitalRead(buttonL1) == LOW && digitalRead(buttonR1) == LOW && analogRead(analogX1) < (512 - sensitivity))){ return true; }
  return false;
}
boolean joy1Fire()
{
  if(digitalRead(buttonFire1) == LOW || (digitalRead(buttonU1) == LOW && digitalRead(buttonD1) == LOW)){ return true; }
  return false;
}
boolean joy1FireA()
{
  if(digitalRead(buttonFire1) == LOW){ return true; }
  return false;
}
boolean joy1FireB()
{
  if(digitalRead(buttonU1) == LOW && digitalRead(buttonD1) == LOW){ return true; }
  return false;
}
boolean joy1IsLEDmePlayJoypad()
{
  if(digitalRead(buttonL1) == LOW && digitalRead(buttonR1) == LOW){ return true; }
  return false;
}
boolean joy2Up()
{
  if((digitalRead(buttonU2) == LOW && digitalRead(buttonD2) != LOW) || (digitalRead(buttonL2) == LOW && digitalRead(buttonR2) == LOW && analogRead(analogY2) > (512 + sensitivity))){ return true; }
  return false;
}
boolean joy2Down()
{
  if((digitalRead(buttonD2) == LOW && digitalRead(buttonU2) != LOW) || (digitalRead(buttonL2) == LOW && digitalRead(buttonR2) == LOW && analogRead(analogY2) < (512 - sensitivity))){ return true; }
  return false;
}
boolean joy2Left()
{
  if((digitalRead(buttonL2) == LOW && digitalRead(buttonR2) != LOW) || (digitalRead(buttonL2) == LOW && digitalRead(buttonR2) == LOW && analogRead(analogX2) > (512 + sensitivity))){ return true; }
  return false;
}
boolean joy2Right()
{
  if((digitalRead(buttonR2) == LOW && digitalRead(buttonL2) != LOW) || (digitalRead(buttonL2) == LOW && digitalRead(buttonR2) == LOW && analogRead(analogX2) < (512 - sensitivity))){ return true; }
  return false;
}
boolean joy2Fire()
{
  if(digitalRead(buttonFire2) == LOW || (digitalRead(buttonU2) == LOW && digitalRead(buttonD2) == LOW)){ return true; }
  return false;
}
boolean joy2FireA()
{
  if(digitalRead(buttonFire2)){ return true; }
  return false;
}
boolean joy2FireB()
{
  if(digitalRead(buttonU2) == LOW && digitalRead(buttonD2) == LOW){ return true; }
  return false;
}
boolean joy2IsLEDmePlayJoypad()
{
  if(digitalRead(buttonL2) == LOW && digitalRead(buttonR2) == LOW){ return true; }
  return false;
}

// Mithotronic Logo
// Draw the M of the Mithotronic logo
void drawM(int x, int y)
{
  matrix.fillRect(x + 2, y + 2, 6, 1, backgroundColor);
  matrix.fillRect(x, y + 3, 10, 1, backgroundColor);

  matrix.fillRect(x, y + 4, 2, 6, matrix.Color333(3, 3, 3));
  matrix.fillRect(x + 2, y + 3, 2, 2, matrix.Color333(3, 3, 3));
  matrix.fillRect(x + 4, y + 4, 2, 6, matrix.Color333(3, 3, 3));
  matrix.fillRect(x + 6, y + 3, 2, 2, matrix.Color333(3, 3, 3));
  matrix.fillRect(x + 8, y + 4, 2, 6, matrix.Color333(3, 3, 3));
}

// Draw the T of the Mithotronic logo
void drawT(int x, int y)
{
  matrix.fillRect(x, y + 5, 6, 1, backgroundColor);
  matrix.fillRect(x + 2, y + 10, 3, 1, backgroundColor);

  matrix.fillRect(x, y + 3, 6, 2, matrix.Color333(0, 0, 7));
  matrix.fillRect(x + 2, y, 2, 10, matrix.Color333(0, 0, 7));
  matrix.fillRect(x + 4, y + 8, 1, 2, matrix.Color333(0, 0, 7));
}

// Draw the animated Mithotronic logo and play jingle
void mithotronic()
{
  matrix.fillScreen(matrix.Color333(0, 0, 0));
  
  i = -10;
  do
  {
    drawM(7, i);
    drawT(19, 22 - i);
    i++;
    delay(50);
  }
  while (i <= 11);

  // Jingle on start screen
  tone(audio, NOTE_C4, 200);
  delay(400 + 20);
  tone(audio, NOTE_C4, 90);
  delay(200 - 20);
  tone(audio, NOTE_G4, 140);
  delay(400 + 20);
  tone(audio, NOTE_G4, 140);
  delay(200 - 20);
  tone(audio, NOTE_C5, 450);
  delay(600);
  tone(audio, NOTE_AS4, 140);
  delay(200 - 20);
  tone(audio, NOTE_A4, 130);
  delay(200 - 10);
  tone(audio, NOTE_F4, 120);
  delay(200);
  tone(audio, NOTE_G4, 1000);
  delay(3000);

  matrix.fillRect(0, 0, 32, 32, matrix.Color333(0, 0, 0)); // Clear LED matrix
}

// Sets color for the next character to show the LEDmePLay logo
void setLEDMePlayColor(int i)
{
  switch(i % 9)
  {
    case 0:
    matrix.setTextColor(matrix.Color333(5,0,0));
    break;
    case 1:
    matrix.setTextColor(matrix.Color333(5,2,0));
    break;
    case 2:
    matrix.setTextColor(matrix.Color333(2,5,0));
    break;
    case 3:
    matrix.setTextColor(matrix.Color333(0,5,0));
    break;
    case 4:
    matrix.setTextColor(matrix.Color333(0,5,2));
    break;
    case 5:
    matrix.setTextColor(matrix.Color333(0,2,5));
    break;
    case 6:
    matrix.setTextColor(matrix.Color333(0,0,5));
    break;
    case 7:
    matrix.setTextColor(matrix.Color333(2,0,5));
    break;
    case 8:
    matrix.setTextColor(matrix.Color333(5,0,2));
    break;
  }
}

// Draw the LEDmePlay logo
void ledMePlay()
{
  // Clear screen
  matrix.fillScreen(matrix.Color333(0, 0, 0));
  matrix.setTextSize(1);

  int i = 0;
  do
  {
    // Write 'LEDmePlay'
    setLEDMePlayColor(i++);
    matrix.setCursor(7, 5);
    matrix.println("L");
    setLEDMePlayColor(i++);
    matrix.setCursor(13, 5);
    matrix.println("E");
    setLEDMePlayColor(i++);
    matrix.setCursor(19, 5);
    matrix.println("D");

    setLEDMePlayColor(i++);
    matrix.setCursor(10, 11);
    matrix.println("m");
    setLEDMePlayColor(i++);
    matrix.setCursor(16, 11);
    matrix.println("e");

    setLEDMePlayColor(i++);
    matrix.setCursor(4, 19);
    matrix.println("P");
    setLEDMePlayColor(i++);
    matrix.setCursor(10, 19);
    matrix.println("l");
    setLEDMePlayColor(i++);
    matrix.setCursor(16, 19);
    matrix.println("a");
    setLEDMePlayColor(i++);
    matrix.setCursor(22, 19);
    matrix.println("y");
    
    i++;
    if(i > 81)
    {
      i = 0;
    }

    int j = 0;
    do
    {
      j++;
      delay(1);
    }
    while(j < 250 && !joy1Fire() && !joy2Fire());
  }
  while(!joy1Fire() && !joy2Fire());
  // SOUND: Leave logo screen
  tone(audio,1024,20);
  delay(200);
  matrix.fillRect(0, 0, 32, 32, matrix.Color333(0,0,0));
}

void setTimers()
{
  Serial.print("\nGameMode: "); Serial.print(gameMode);
  timer.every(110, moveBonusObject);
  timer.every(85, moveBaddies);
  timer.every(65, moveBalls);
  timer.every(35, moveBat);
  timer.every(20, animateShot);
  timer.every(200, playMelody);  
}

void initBalls()
{
  // Balls
  for (int i = 0; i < 5; i++)
  {
    ball_x[i] = bat_pos[LOWER_BAT];
    ball_y[i] = 30;
    ball_moveAngle[i] = 30;
    ball_vector_x[i] = getInkrement_x(ball_moveAngle[i]) * abs(calcMoveAngle_x(min(360, ball_moveAngle[i])));
    ball_vector_y[i] = getInkrement_y(ball_moveAngle[i]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[i])));
    ball_old_x[i] = ball_x[i];
    ball_old_y[i] = ball_y[i];
    ball_active[i] = false;
  }
  ball_active[0] = true;

  //Serial.print("\ninit: ball_vector_x, ball_vector_y: "); Serial.print(ball_vector_x[0]); Serial.print(", "); Serial.print(ball_vector_y[0]);
}

void clearBalls()
{
  for (int i = 0; i < 5; i++)
  {
    matrix.drawPixel(ball_x[i], ball_y[i], matrix.Color333(0, 0, 0));
  }
}

void initBats()
{
  // Bats
  bat_pos[UPPER_BAT] = 13; // x = 12
  bat_pos[LOWER_BAT] = 13; // x = 12
  bat_pos[LEFT_BAT] = 13; // y = 12
  bat_pos[RIGHT_BAT] = 13; // y = 12
  bat_pos_old[UPPER_BAT] = bat_pos[UPPER_BAT];
  bat_pos_old[LOWER_BAT] = bat_pos[LOWER_BAT];
  bat_pos_old[LEFT_BAT] = bat_pos[LEFT_BAT];
  bat_pos_old[RIGHT_BAT] = bat_pos[RIGHT_BAT];
  bat_hasBall[UPPER_BAT] = false;
  bat_hasBall[LOWER_BAT] = false;
  bat_hasBall[LEFT_BAT] = false;
  bat_hasBall[RIGHT_BAT] = false;
  bat_hasGun[UPPER_BAT] = false;
  bat_hasGun[LOWER_BAT] = false;
  bat_hasGun[LEFT_BAT] = false;
  bat_hasGun[RIGHT_BAT] = false;
}

void closeOpenBorders(boolean closeThem)
{
  int col = closeThem == true ? wall_color : backgroundColor;

  if (upperBorderOpen)
  {
    for (byte i = 0; i < 32; i++)
    {
      framebuffer[i][0] = closeThem == true ? wall_color : backgroundColor;
      playfield[i][0] = closeThem == true ? HORIZ_WALL_LOW : EMPTY;
    }
    matrix.drawLine(1, 0, 30, 0, col);
  }

  if (lowerBorderOpen)
  {
    for (byte i = 0; i < 32; i++)
    {
      framebuffer[i][31] = closeThem == true ? wall_color : backgroundColor;
      playfield[i][31] = closeThem == true ? HORIZ_WALL_LOW : EMPTY;
    }
    matrix.drawLine(1, 31, 30, 31, col);
  }

  if (leftBorderOpen)
  {
    for (byte i = 0; i < 32; i++)
    {
      framebuffer[0][i] = closeThem == true ? wall_color : backgroundColor;
      playfield[0][i] = closeThem == true ? VERT_WALL : EMPTY;
    }
    matrix.drawLine(0, 1, 0, 30, col);
  }

  if (rightBorderOpen)
  {
    for (byte i = 0; i < 32; i++)
    {
      framebuffer[31][i] = closeThem == true ? wall_color : backgroundColor;
      playfield[31][i] = closeThem == true ? VERT_WALL : EMPTY;
    }
    matrix.drawLine(31, 1, 31, 30, col);
  }
}

void blinkOpenBorders()
{
  int col;
  animToggle = !animToggle;
  if (animToggle) {
    col = wall_color;
  } else {
    col = backgroundColor;
  }

  if (upperBorderOpen) {
    matrix.drawLine(1, 0, 30, 0, col);
  }
  if (lowerBorderOpen) {
    matrix.drawLine(1, 31, 30, 31, col);
  }
  if (leftBorderOpen) {
    matrix.drawLine(0, 1, 0, 30, col);
  }
  if (rightBorderOpen) {
    matrix.drawLine(31, 1, 31, 30, col);
  }
}

void initVars()
{
  // Initialize random number generator
  randomSeed(analogRead(32) + analogRead(2));

  initBalls();
  initBats();
}

void initializePlayfield()
{
  // Initialize playfield structure
  for (byte i = 0; i < 32; i++)
  {
    for (byte j = 0; j < 32; j++)
    {
      playfield[i][j] = EMPTY;
    }
  }
  // Draw border on playfield
  for (i = 0; i < 32; i++)
  {
    playfield[i][0] = HORIZ_WALL_LOW; framebuffer[i][0] = wall_color;
    playfield[i][31] = HORIZ_WALL_LOW; framebuffer[i][31] = wall_color;
    playfield[0][i] = VERT_WALL; framebuffer[0][i] = wall_color;
    playfield[31][i] = VERT_WALL; framebuffer[31][i] = wall_color;
  }
}

void clearFramebuffer()
{
  for (byte i = 0; i < 32; i++)
  {
    for (byte j = 0; j < 32; j++)
    {
      framebuffer[i][j] = backgroundColor;
    }
  }
}

// Reads the playfield structure from Flash ROM (PROGMEM) and transfers it to data structure in RAM
// Draws the playfield
void drawPlayfield()
{
  matrix.fillRect(1, 1, 31, 31, matrix.Color333(0, 0, 0)); // Clear LED matrix

  initializePlayfield();

  // Initialize the levelData and playfield data structures
  for (byte i = 0; i < 150; i++) {
    levelData[i] = EMPTY;
  }
  // Copy the arenaData from program memory into data structure levelData
  byte k;
  for (k = 0; k < 150; k++)
  {
    levelData[k] = pgm_read_byte_near(arenaData + (arena * (150 + 8)) + k);
  }
  // Set bats active/inactive
  //Syntax used: return a>b ? a : b;
  bat_active[UPPER_BAT] = pgm_read_byte_near(arenaData + (arena * (150 + 8) + k + 0)) == 1 ? true : false;
  bat_active[LOWER_BAT] = pgm_read_byte_near(arenaData + (arena * (150 + 8) + k + 1)) == 1 ? true : false;
  bat_active[LEFT_BAT] =  pgm_read_byte_near(arenaData + (arena * (150 + 8) + k + 2)) == 1 ? true : false;
  bat_active[RIGHT_BAT] = pgm_read_byte_near(arenaData + (arena * (150 + 8) + k + 3)) == 1 ? true : false;

  // Set the playfield border flags on either "opened" or "closed"
  upperBorderOpen = pgm_read_byte_near(arenaData + (arena * (150 + 8) + k + 4)) == 1 ? true : false;
  lowerBorderOpen = pgm_read_byte_near(arenaData + (arena * (150 + 8) + k + 5)) == 1 ? true : false;
  leftBorderOpen = pgm_read_byte_near(arenaData + (arena * (150 + 8) + k + 6)) == 1 ? true : false;
  rightBorderOpen = pgm_read_byte_near(arenaData + (arena * (150 + 8) + k + 7)) == 1 ? true : false;
  if (upperBorderOpen || lowerBorderOpen || leftBorderOpen || rightBorderOpen) {
    borderOpen = true;
  } else {
    borderOpen = false;
  }
  //Serial.print("\nin drawPlayfield: lowerBorderOpen = "); if (lowerBorderOpen) { Serial.print("true");} else { Serial.print("false");};

  // Draw playfield border
  if (!upperBorderOpen) {
    matrix.drawLine(0, 0, 31, 0, wall_color);

  } // matrix.drawPixel(0, 0, matrix.Color888(40, 40, 100)); matrix.drawPixel(31, 0, matrix.Color888(40, 40, 100)); }
  if (!leftBorderOpen)  {
    matrix.drawLine(0, 0, 0, 31, wall_color);
  }
  if (!rightBorderOpen) {
    matrix.drawLine(31, 0, 31, 31, wall_color);
  }
  if (!lowerBorderOpen) {
    matrix.drawLine(0, 31, 31, 31, wall_color);
  }
  // Draw border corners
  //matrix.drawPixel(0, 0, matrix.Color888(80, 120, 160)); matrix.drawPixel(31, 0, matrix.Color888(80, 120, 160));
  //matrix.drawPixel(0, 31, matrix.Color888(80, 120, 160)); matrix.drawPixel(31, 31, matrix.Color888(80, 120, 160));

  // Draw bricks and walls, and store them in the playfield
  for (i = 0; i < 10; i++) // Wall, 10 bricks in a row, wall
  {
    for (j = 0; j < 15; j++) // Wall, 15 bricks in a column, wall
    {
      drawPlayfieldElement(i, j);
    } // FOR j
  } // FOR i

  // Set open and closed borders in playfield[][]
  if (upperBorderOpen)
  {
    for (int x = 1; x < 31; x++)
    {
      playfield[x][0] = EMPTY;
      //playfield[x][0] = EMPTY;
      framebuffer[x][0] = backgroundColor;
    }
  }

  if (lowerBorderOpen)
  {
    for (int x = 1; x < 31; x++)
    {
      playfield[x][31] = EMPTY;
      //playfield[x][31] = EMPTY;
      framebuffer[x][31] = backgroundColor;
    }
  }

  if (leftBorderOpen)
  {
    for (int y = 1; y < 31; y++)
    {
      playfield[0][y] = EMPTY;
      //playfield[0][y] = EMPTY;
      framebuffer[0][y] = backgroundColor;
    }
  }

  if (rightBorderOpen)
  {
    for (int y = 1; y < 31; y++)
    {
      playfield[31][y] = EMPTY;
      //playfield[31][y] = EMPTY;
      framebuffer[31][y] = backgroundColor;
    }
  }
  //debugShowFramebuffer(); return;

} // drawPlayfield

void setPlayfieldElement(byte i, byte j, byte element)
{
  if    ((element != HORIZ_WALL_HIGH) && (element != HORIZ_WALL_LOW) && (element != VERT_WALL) && (element != UNUSED_BRICK)
         && (element != CORNER_NE) && (element != CORNER_NW) && (element != CORNER_SE) && (element != CORNER_SW))
  {
    playfield[1 + (i * 3) + 0][(1 + j * 2) + 0] = element;
    playfield[1 + (i * 3) + 1][(1 + j * 2) + 0] = element;
    playfield[1 + (i * 3) + 2][(1 + j * 2) + 0] = element;
    playfield[1 + (i * 3) + 0][(1 + j * 2) + 1] = element;
    playfield[1 + (i * 3) + 1][(1 + j * 2) + 1] = element;
    playfield[1 + (i * 3) + 2][(1 + j * 2) + 1] = element;
  }
  else if (element == HORIZ_WALL_HIGH)
  {
    playfield[1 + (i * 3) + 0][(1 + j * 2) + 0] = element;
    playfield[1 + (i * 3) + 1][(1 + j * 2) + 0] = element;
    playfield[1 + (i * 3) + 2][(1 + j * 2) + 0] = element;
  }
  else if (element == HORIZ_WALL_LOW)
  {
    playfield[1 + (i * 3) + 0][(1 + j * 2) + 1] = element;
    playfield[1 + (i * 3) + 1][(1 + j * 2) + 1] = element;
    playfield[1 + (i * 3) + 2][(1 + j * 2) + 1] = element;
  }
  else if (element == VERT_WALL)
  {
    /*
       matrix.drawLine(i*3+2, j*2+1, i*3+2, j*2+2, wall_color);
    */
    playfield[1 + (i * 3) + 1][(1 + j * 2) + 0] = element;
    playfield[1 + (i * 3) + 1][(1 + j * 2) + 1] = element;
  }
  else if (element == CORNER_NE)
  {
    /*
      matrix.drawPixel(i*3+2, j*2+1, wall_color);
      matrix.drawPixel(i*3+2, j*2+2, wall_color);
      matrix.drawPixel(i*3+1, j*2+1, wall_color);
    */
    playfield[1 + (i * 3) + 1][(1 + j * 2) + 0] = element;
    playfield[1 + (i * 3) + 0][(1 + j * 2) + 0] = element;
    playfield[1 + (i * 3) + 1][(1 + j * 2) + 1] = element;
  }
  else if (element == CORNER_NW)
  {
    /*
      matrix.drawPixel(i*3+2, j*2+1, wall_color);
        matrix.drawPixel(i*3+3, j*2+1, wall_color);
        matrix.drawPixel(i*3+2, j*2+2, wall_color);
    */
    playfield[1 + (i * 3) + 1][(1 + j * 2) + 0] = element;
    playfield[1 + (i * 3) + 2][(1 + j * 2) + 0] = element;
    playfield[1 + (i * 3) + 1][(1 + j * 2) + 1] = element;
  }
  else if (element == CORNER_SE)
  {
    playfield[1 + (i * 3) + 1][(1 + j * 2) + 0] = element;
    playfield[1 + (i * 3) + 2][(1 + j * 2) + 1] = element;
    playfield[1 + (i * 3) + 1][(1 + j * 2) + 1] = element;
  }
  else if (element == CORNER_SW)
  {
    playfield[1 + (i * 3) + 1][(1 + j * 2) + 0] = element;
    playfield[1 + (i * 3) + 0][(1 + j * 2) + 1] = element;
    playfield[1 + (i * 3) + 1][(1 + j * 2) + 1] = element;
  }
}

void drawPlayfieldElement(byte i, byte j)
{
  if (levelData[(j * 10) + i] == EMPTY) // Passage
  {
    setPlayfieldElement(i, j, EMPTY);
  }
  else if (levelData[(j * 10) + i] == UNUSED_BRICK)
  {
    setPlayfieldElement(i, j, UNUSED_BRICK);

    matrix.drawLine(i * 3 + 2, j * 2 + 1, i * 3 + 2, j * 2 + 2, matrix.Color333(1, 0, 1));
    framebuffer[i * 3 + 2][j * 2 + 1] = matrix.Color333(1, 0, 1);
    framebuffer[i * 3 + 2][j * 2 + 2] = matrix.Color333(1, 0, 1);
    matrix.drawLine(i * 3 + 3, j * 2 + 1, i * 3 + 3, j * 2 + 2, matrix.Color333(1, 0, 0));
    framebuffer[i * 3 + 3][j * 2 + 1] = matrix.Color333(1, 0, 0);
    framebuffer[i * 3 + 3][j * 2 + 2] = matrix.Color333(1, 0, 0);

    numBricks++;
  }
  else if (levelData[(j * 10) + i] == RED_BRICK)
  {
    setPlayfieldElement(i, j, RED_BRICK);

    matrix.drawLine(i * 3 + 1, j * 2 + 1, i * 3 + 1, j * 2 + 2, matrix.Color333(1, 0, 0)); framebuffer[i * 3 + 1][j * 2 + 1] = matrix.Color333(1, 0, 0); framebuffer[i * 3 + 1][j * 2 + 2] = matrix.Color333(1, 0, 0);
    matrix.drawLine(i * 3 + 2, j * 2 + 1, i * 3 + 2, j * 2 + 2, matrix.Color333(3, 0, 0)); framebuffer[i * 3 + 2][j * 2 + 1] = matrix.Color333(1, 0, 0); framebuffer[i * 3 + 2][j * 2 + 2] = matrix.Color333(3, 0, 0);
    matrix.drawLine(i * 3 + 3, j * 2 + 1, i * 3 + 3, j * 2 + 2, matrix.Color333(5, 0, 0)); framebuffer[i * 3 + 3][j * 2 + 1] = matrix.Color333(1, 0, 0); framebuffer[i * 3 + 3][j * 2 + 2] = matrix.Color333(5, 0, 0);

    numBricks++;
  }
  else if (levelData[(j * 10) + i] == GREEN_BRICK)
  {
    setPlayfieldElement(i, j, GREEN_BRICK);

    matrix.drawLine(i * 3 + 1, j * 2 + 1, i * 3 + 1, j * 2 + 2, matrix.Color333(0, 1, 0));
    matrix.drawLine(i * 3 + 2, j * 2 + 1, i * 3 + 2, j * 2 + 2, matrix.Color333(0, 3, 0));
    matrix.drawLine(i * 3 + 3, j * 2 + 1, i * 3 + 3, j * 2 + 2, matrix.Color333(0, 5, 0));
    framebuffer[i * 3 + 1][j * 2 + 1] = matrix.Color333(0, 1, 0); framebuffer[i * 3 + 1][j * 2 + 2] = matrix.Color333(0, 1, 0);
    framebuffer[i * 3 + 2][j * 2 + 1] = matrix.Color333(0, 3, 0); framebuffer[i * 3 + 2][j * 2 + 2] = matrix.Color333(0, 3, 0);
    framebuffer[i * 3 + 3][j * 2 + 1] = matrix.Color333(0, 5, 0); framebuffer[i * 3 + 3][j * 2 + 2] = matrix.Color333(0, 5, 0);

    numBricks++;
  }
  else if (levelData[(j * 10) + i] == BLUE_BRICK)
  {
    setPlayfieldElement(i, j, BLUE_BRICK);

    matrix.drawLine(i * 3 + 1, j * 2 + 1, i * 3 + 1, j * 2 + 2, matrix.Color333(0, 0, 1));
    matrix.drawLine(i * 3 + 2, j * 2 + 1, i * 3 + 2, j * 2 + 2, matrix.Color333(0, 0, 3));
    matrix.drawLine(i * 3 + 3, j * 2 + 1, i * 3 + 3, j * 2 + 2, matrix.Color333(0, 0, 5));
    framebuffer[i * 3 + 1][j * 2 + 1] = matrix.Color333(0, 0, 1); framebuffer[i * 3 + 1][j * 2 + 2] = matrix.Color333(0, 0, 1);
    framebuffer[i * 3 + 2][j * 2 + 1] = matrix.Color333(0, 0, 3); framebuffer[i * 3 + 2][j * 2 + 2] = matrix.Color333(0, 0, 3);
    framebuffer[i * 3 + 3][j * 2 + 1] = matrix.Color333(0, 0, 5); framebuffer[i * 3 + 3][j * 2 + 2] = matrix.Color333(0, 0, 5);

    numBricks++;
  }
  else if (levelData[(j * 10) + i] == VIOLET_BRICK)
  {
    setPlayfieldElement(i, j, VIOLET_BRICK);

    matrix.drawLine(i * 3 + 1, j * 2 + 1, i * 3 + 1, j * 2 + 2, matrix.Color333(1, 0, 1));
    matrix.drawLine(i * 3 + 2, j * 2 + 1, i * 3 + 2, j * 2 + 2, matrix.Color333(3, 0, 3));
    matrix.drawLine(i * 3 + 3, j * 2 + 1, i * 3 + 3, j * 2 + 2, matrix.Color333(5, 0, 5));
    framebuffer[i * 3 + 1][j * 2 + 1] = matrix.Color333(1, 0, 1); framebuffer[i * 3 + 1][j * 2 + 2] = matrix.Color333(1, 0, 1);
    framebuffer[i * 3 + 2][j * 2 + 1] = matrix.Color333(3, 0, 3); framebuffer[i * 3 + 2][j * 2 + 2] = matrix.Color333(3, 0, 3);
    framebuffer[i * 3 + 3][j * 2 + 1] = matrix.Color333(5, 0, 5); framebuffer[i * 3 + 3][j * 2 + 2] = matrix.Color333(5, 0, 5);

    numBricks++;
  }
  else if (levelData[(j * 10) + i] == YELLOW_BRICK)
  {
    setPlayfieldElement(i, j, YELLOW_BRICK);

    matrix.drawLine(i * 3 + 1, j * 2 + 1, i * 3 + 1, j * 2 + 2, matrix.Color333(1, 1, 0));
    matrix.drawLine(i * 3 + 2, j * 2 + 1, i * 3 + 2, j * 2 + 2, matrix.Color333(3, 3, 0));
    matrix.drawLine(i * 3 + 3, j * 2 + 1, i * 3 + 3, j * 2 + 2, matrix.Color333(5, 5, 0));
    framebuffer[i * 3 + 1][j * 2 + 1] = matrix.Color333(1, 1, 0); framebuffer[i * 3 + 1][j * 2 + 2] = matrix.Color333(1, 1, 0);
    framebuffer[i * 3 + 2][j * 2 + 1] = matrix.Color333(3, 3, 0); framebuffer[i * 3 + 2][j * 2 + 2] = matrix.Color333(3, 3, 0);
    framebuffer[i * 3 + 3][j * 2 + 1] = matrix.Color333(5, 5, 0); framebuffer[i * 3 + 3][j * 2 + 2] = matrix.Color333(5, 5, 0);

    numBricks++;
  }
  else if (levelData[(j * 10) + i] == ORANGE_BRICK)
  {
    setPlayfieldElement(i, j, ORANGE_BRICK);

    matrix.drawLine(i * 3 + 1, j * 2 + 1, i * 3 + 1, j * 2 + 2, matrix.Color888(92, 26, 6));
    matrix.drawLine(i * 3 + 2, j * 2 + 1, i * 3 + 2, j * 2 + 2, matrix.Color888(96, 23, 10));
    matrix.drawLine(i * 3 + 3, j * 2 + 1, i * 3 + 3, j * 2 + 2, matrix.Color888(100, 20, 14));
    framebuffer[i * 3 + 1][j * 2 + 1] = matrix.Color888(92, 26, 6); framebuffer[i * 3 + 1][j * 2 + 2] = matrix.Color888(92, 26, 6);
    framebuffer[i * 3 + 2][j * 2 + 1] = matrix.Color888(96, 23, 10); framebuffer[i * 3 + 2][j * 2 + 2] = matrix.Color888(96, 23, 10);
    framebuffer[i * 3 + 3][j * 2 + 1] = matrix.Color888(100, 20, 14); framebuffer[i * 3 + 3][j * 2 + 2] = matrix.Color888(100, 20, 14);

    numBricks++;
  }
  else if (levelData[(j * 10) + i] == SOLID_BRICK)
  {
    setPlayfieldElement(i, j, SOLID_BRICK);

    matrix.drawRect(i * 3 + 1, j * 2 + 1, 3, 2, wall_color);
    framebuffer[i * 3 + 1][j * 2 + 1] = wall_color; framebuffer[i * 3 + 1][j * 2 + 2] = wall_color;
    framebuffer[i * 3 + 2][j * 2 + 1] = wall_color; framebuffer[i * 3 + 2][j * 2 + 2] = wall_color;
    framebuffer[i * 3 + 3][j * 2 + 1] = wall_color; framebuffer[i * 3 + 3][j * 2 + 2] = wall_color;
  }
  else if (levelData[(j * 10) + i] == 9)
  {
    setPlayfieldElement(i, j, HORIZ_WALL_HIGH);
    //matrix.drawLine(i * 3 + 1, j * 2 + 1, i * 3 + 3, j * 2 + 1, wall_color);
    matrix.drawPixel(i * 3 + 1, j * 2 + 1, wall_color);
    matrix.drawPixel(i * 3 + 2, j * 2 + 1, wall_color);
    matrix.drawPixel(i * 3 + 3, j * 2 + 1, wall_color);
    framebuffer[i * 3 + 1][j * 2 + 1] = wall_color;
    framebuffer[i * 3 + 2][j * 2 + 1] = wall_color;
    framebuffer[i * 3 + 3][j * 2 + 1] = wall_color;
  }
  else if (levelData[(j * 10) + i] == 10)
  {
    setPlayfieldElement(i, j, VERT_WALL);
    matrix.drawLine(i * 3 + 2, j * 2 + 1, i * 3 + 2, j * 2 + 2, wall_color);
    framebuffer[i * 3 + 2][j * 2 + 1] = wall_color;
    framebuffer[i * 3 + 2][j * 2 + 2] = wall_color;
  }
  else if (levelData[(j * 10) + i] == 11)
  {
    setPlayfieldElement(i, j, CORNER_NW);
    matrix.drawPixel(i * 3 + 2, j * 2 + 1, wall_color);
    matrix.drawPixel(i * 3 + 3, j * 2 + 1, wall_color);
    matrix.drawPixel(i * 3 + 2, j * 2 + 2, wall_color);
    framebuffer[i * 3 + 2][j * 2 + 1] = wall_color;
    framebuffer[i * 3 + 3][j * 2 + 1] = wall_color;
    framebuffer[i * 3 + 2][j * 2 + 2] = wall_color;
  }
  else if (levelData[(j * 10) + i] == 12)
  {
    setPlayfieldElement(i, j, CORNER_NE);
    matrix.drawPixel(i * 3 + 2, j * 2 + 1, wall_color);
    matrix.drawPixel(i * 3 + 2, j * 2 + 2, wall_color);
    matrix.drawPixel(i * 3 + 1, j * 2 + 1, wall_color);
    framebuffer[i * 3 + 2][j * 2 + 1] = wall_color;
    framebuffer[i * 3 + 2][j * 2 + 2] = wall_color;
    framebuffer[i * 3 + 1][j * 2 + 1] = wall_color;
  }
  else if (levelData[(j * 10) + i] == 13)
  {
    setPlayfieldElement(i, j, CORNER_SW);
    matrix.drawPixel(i * 3 + 2, j * 2 + 1, wall_color);
    matrix.drawPixel(i * 3 + 2, j * 2 + 2, wall_color);
    matrix.drawPixel(i * 3 + 1, j * 2 + 2, wall_color);
    framebuffer[i * 3 + 2][j * 2 + 1] = wall_color;
    framebuffer[i * 3 + 2][j * 2 + 2] = wall_color;
    framebuffer[i * 3 + 1][j * 2 + 2] = wall_color;

  }
  else if (levelData[(j * 10) + i] == 14)
  {
    setPlayfieldElement(i, j, CORNER_SE);
    matrix.drawPixel(i * 3 + 2, j * 2 + 1, wall_color);
    matrix.drawPixel(i * 3 + 2, j * 2 + 2, wall_color);
    matrix.drawPixel(i * 3 + 3, j * 2 + 2, wall_color);
    framebuffer[i * 3 + 2][j * 2 + 1] = wall_color;
    framebuffer[i * 3 + 2][j * 2 + 2] = wall_color;
    framebuffer[i * 3 + 3][j * 2 + 2] = wall_color;
  }
  else if (levelData[(j * 10) + i] == 15)
  {
    setPlayfieldElement(i, j, HORIZ_WALL_LOW);
    matrix.drawPixel(i * 3 + 1, j * 2 + 2, wall_color);
    matrix.drawPixel(i * 3 + 2, j * 2 + 2, wall_color);
    matrix.drawPixel(i * 3 + 3, j * 2 + 2, wall_color);
    framebuffer[i * 3 + 1][j * 2 + 2] = wall_color;
    framebuffer[i * 3 + 2][j * 2 + 2] = wall_color;
    framebuffer[i * 3 + 3][j * 2 + 2] = wall_color;
  }
}

// Waits until the joysticks are left alone
void consumeJoystickEvents()
{
  do
  {
  }
  while (         joy1Left()    || joy1Right()
             ||   joy1Up()      || joy1Down()
             ||   joy1Fire()    || joy2Left()
             ||   joy2Right()   || joy2Up()
             ||   joy2Down()    || joy2Fire() );

}

double calcMoveAngle_x(double angle)
{
  return (double) cos(angle * PI_FRACTION);
}

double calcMoveAngle_y(double angle)
{
  return (double) (sin(angle * PI_FRACTION));
}

double getInkrement_x(double angle)
{
  if      ((angle >= 0) && (angle < 180))    {
    return 1;
  }
  else if ((angle >= 180) && (angle <= 360))  {
    return -1;
  }
  else                                       {
    return 0;
  }
}

double getInkrement_y(double angle)
{
  if      ( ((angle >= 270) && (angle <= 360)) || ((angle >= 0) && (angle < 90)) )   {
    return -1;
  }
  else if ( (angle >= 90) && (angle < 270))                                        {
    return 1;
  }
  else                                                                            {
    return 0;
  }
}

byte baddieImpedesBat(byte which)
{
  byte offset = 3;

  for (byte i = 0; i < 4; i++)
  {
    switch (which)
    {
      case UPPER_BAT:
        if (baddie_y[i] == 2)
        {
          if (bat_isEnlarged[UPPER_BAT]) {
            offset = 5;
          } else {
            offset = 3;
          }
          if      (baddie_x[i] == bat_pos[UPPER_BAT] - 2) {
            return IS_LEFT;
          }
          else if (baddie_x[i] == bat_pos[UPPER_BAT] + offset + 2) {
            return IS_RIGHT;
          }
        }
        break;

      case LOWER_BAT:
        if (baddie_y[i] == 29)
        {
          if (bat_isEnlarged[LOWER_BAT]) {
            offset = 5;
          } else {
            offset = 3;
          }
          if      (baddie_x[i] == bat_pos[LOWER_BAT] - 2) {
            return IS_LEFT;
          }
          else if (baddie_x[i] == bat_pos[LOWER_BAT] + offset + 2) {
            return IS_RIGHT;
          }
        }
        break;

      case LEFT_BAT:
        if (baddie_x[i] == 2)
        {
          if (bat_isEnlarged[LEFT_BAT]) {
            offset = 5;
          } else {
            offset = 3;
          }
          if      (baddie_y[i] == bat_pos[LEFT_BAT] - 2) {
            return IS_OVER;
          }
          else if (baddie_y[i] == bat_pos[LEFT_BAT] + offset + 2) {
            return IS_UNDER;
          }
        }
        break;

      case RIGHT_BAT:
        if (baddie_x[i] == 29)
        {
          if (bat_isEnlarged[RIGHT_BAT]) {
            offset = 5;
          } else {
            offset = 3;
          }
          if      (baddie_y[i] == bat_pos[RIGHT_BAT] - 2) {
            return IS_OVER;
          }
          else if (baddie_y[i] == bat_pos[RIGHT_BAT] + offset + 2) {
            return IS_UNDER;
          }
        }
        break;
    }
  } // for

  return NOT_NEARBY;
}

void moveBat()
{
  if (!gameGoing) {
    return;
  }

  bat_direction[UPPER_BAT] = STILL;
  bat_direction[LOWER_BAT] = STILL;
  bat_direction[LEFT_BAT] = STILL;
  bat_direction[RIGHT_BAT] = STILL;

  byte offset;
  if (enlargedBat) {
    offset = 6;
  } else {
    offset = 4;
  }

  // Poll joystick 1 LEFT and RIGHT
  if (joy1Left() && !joy1Up() && !joy1Down()) // LEFT
  {
    if (!joystick1Reversed)
    {
      if ((bat_active[LOWER_BAT]) && (playfield[bat_pos[LOWER_BAT] - 1][30] == EMPTY) && (bat_pos[LOWER_BAT] > 1))
      {
        if (baddieImpedesBat(LOWER_BAT) != IS_LEFT) {
          bat_pos_old[LOWER_BAT]  = bat_pos[LOWER_BAT];
          bat_pos[LOWER_BAT]--; bat_direction[LOWER_BAT] = LEFT;
        }
      }

      if ((bat_active[UPPER_BAT]) && (playfield[bat_pos[UPPER_BAT] - 1][01] == EMPTY) && (bat_pos[UPPER_BAT] > 1))
      {
        if (baddieImpedesBat(UPPER_BAT) != IS_LEFT) {
          bat_pos_old[UPPER_BAT] = bat_pos[UPPER_BAT];
          bat_pos[UPPER_BAT]--; bat_direction[UPPER_BAT] = LEFT;
        }
      }
    }
    else
    {
      if ((bat_active[LOWER_BAT]) && (playfield[bat_pos[LOWER_BAT] + offset][30] == EMPTY) && (bat_pos[LOWER_BAT] < 31 - offset))
      { // 27 in 31-offset, 4 in offset, CHANGED 21.02.17
        if (baddieImpedesBat(LOWER_BAT) != IS_RIGHT)
        {
          bat_pos_old[LOWER_BAT] = bat_pos[LOWER_BAT];
          bat_pos[LOWER_BAT]++; bat_direction[LOWER_BAT] = RIGHT;
        }
      }
      if ((bat_active[UPPER_BAT]) && (playfield[bat_pos[UPPER_BAT] + offset][01] == EMPTY) && (bat_pos[UPPER_BAT] < 31 - offset))
      {
        if (baddieImpedesBat(UPPER_BAT) != IS_RIGHT)
        {
          bat_pos_old[UPPER_BAT] = bat_pos[UPPER_BAT];
          bat_pos[UPPER_BAT]++; bat_direction[UPPER_BAT] = RIGHT;
        }
      }
    }
    drawBats();
  }
  else if (joy1Right() && !joy1Up() && !joy1Down()) // RIGHT
  {
    if (!joystick1Reversed)
    {
      if ((bat_active[LOWER_BAT]) && (playfield[bat_pos[LOWER_BAT] + offset][30] == EMPTY) && (bat_pos[LOWER_BAT] < 31 - offset))
      {
        if (baddieImpedesBat(LOWER_BAT) != IS_RIGHT) {
          bat_pos_old[LOWER_BAT] = bat_pos[LOWER_BAT];
          bat_pos[LOWER_BAT]++; bat_direction[LOWER_BAT] = RIGHT;
        }
      }
      if ((bat_active[UPPER_BAT]) && (playfield[bat_pos[UPPER_BAT] + offset][01] == EMPTY) && (bat_pos[UPPER_BAT] < 31 - offset))
      {
        if (baddieImpedesBat(UPPER_BAT) != IS_RIGHT) {
          bat_pos_old[UPPER_BAT] = bat_pos[UPPER_BAT];
          bat_pos[UPPER_BAT]++; bat_direction[UPPER_BAT] = RIGHT;
        }
      }
    }
    else
    {
      if ((bat_active[LOWER_BAT]) && (playfield[bat_pos[LOWER_BAT] - 1][30] == EMPTY) && (bat_pos[LOWER_BAT] > 1))
      {
        if (baddieImpedesBat(LOWER_BAT) != IS_LEFT) {
          bat_pos_old[LOWER_BAT] = bat_pos[LOWER_BAT];
          bat_pos[LOWER_BAT]--; bat_direction[LOWER_BAT] = LEFT;
        }
      }
      if ((bat_active[UPPER_BAT]) && (playfield[bat_pos[UPPER_BAT] - 1][01] == EMPTY) && (bat_pos[UPPER_BAT] > 1))
      {
        if (baddieImpedesBat(UPPER_BAT) != IS_LEFT) {
          bat_pos_old[UPPER_BAT] = bat_pos[UPPER_BAT];
          bat_pos[UPPER_BAT]--; bat_direction[UPPER_BAT] = LEFT;
        }
      }
    }
    drawBats();
  }

  // Poll joystick 1 and joystick 2 UP and DOWN
  if (onePlayerMode)
  {
    if (joy1Up() && !joy1Left() && !joy1Right()) // UP
    {
      if (!joystick1Reversed)
      {
        if ((bat_active[LEFT_BAT]) && (playfield[01][bat_pos[LEFT_BAT] - 1] == EMPTY) && (bat_pos[LEFT_BAT] > 1))
        {
          if (baddieImpedesBat(LEFT_BAT) != IS_OVER) {
            bat_pos_old[LEFT_BAT] = bat_pos[LEFT_BAT];
            bat_pos[LEFT_BAT]--; bat_direction[LEFT_BAT] = UP;
          }
        }
        if ((bat_active[RIGHT_BAT]) && (playfield[30][bat_pos[RIGHT_BAT] - 1] == EMPTY) && (bat_pos[RIGHT_BAT] > 1))
        {
          if (baddieImpedesBat(RIGHT_BAT) != IS_OVER) {
            bat_pos_old[RIGHT_BAT] = bat_pos[RIGHT_BAT];
            bat_pos[RIGHT_BAT]--; bat_direction[RIGHT_BAT] = UP;
          }
        }
      }
      else // CHANGED
      {
        if ((bat_active[LEFT_BAT]) && (playfield[01][bat_pos[LEFT_BAT] + offset] == EMPTY) && (bat_pos[LEFT_BAT] < 31 - offset))
        {
          if (baddieImpedesBat(LEFT_BAT) != IS_UNDER) {
            bat_pos_old[LEFT_BAT] = bat_pos[LEFT_BAT];
            bat_pos[LEFT_BAT]++; bat_direction[LEFT_BAT] = DOWN;
          }
        }
        if ((bat_active[RIGHT_BAT]) && (playfield[30][bat_pos[RIGHT_BAT] + offset] == EMPTY) && (bat_pos[RIGHT_BAT] < 31 - offset))
        {
          if (baddieImpedesBat(RIGHT_BAT) != IS_UNDER) {
            bat_pos_old[RIGHT_BAT] = bat_pos[RIGHT_BAT];
            bat_pos[RIGHT_BAT]++; bat_direction[RIGHT_BAT] = DOWN;
          }
        }
      }
      drawBats();
    }
    else if (joy1Down() && !joy1Left() && !joy1Right()) // DOWN
    {
      if (!joystick1Reversed)
      {
        if ((bat_active[LEFT_BAT]) && (playfield[01][bat_pos[LEFT_BAT] + offset] == EMPTY) && (bat_pos[LEFT_BAT] < 31 - offset))
        {
          if (baddieImpedesBat(LEFT_BAT) != IS_UNDER) {
            bat_pos_old[LEFT_BAT] = bat_pos[LEFT_BAT];
            bat_pos[LEFT_BAT]++; bat_direction[LEFT_BAT] = DOWN;
          }
        }
        if ((bat_active[RIGHT_BAT]) && (playfield[30][bat_pos[RIGHT_BAT] + offset] == EMPTY) && (bat_pos[RIGHT_BAT] < 31 - offset))
        {
          if (baddieImpedesBat(RIGHT_BAT) != IS_UNDER) {
            bat_pos_old[RIGHT_BAT] = bat_pos[RIGHT_BAT];
            bat_pos[RIGHT_BAT]++; bat_direction[RIGHT_BAT] = DOWN;
          }
        }
      }
      else
      {
        if ((bat_active[LEFT_BAT]) && (playfield[01][bat_pos[LEFT_BAT] - 1] == EMPTY) && (bat_pos[LEFT_BAT] > 1))
        {
          if (baddieImpedesBat(LEFT_BAT) != IS_OVER) {
            bat_pos_old[LEFT_BAT] = bat_pos[LEFT_BAT];
            bat_pos[LEFT_BAT]--; bat_direction[LEFT_BAT] = UP;
          }
        }
        if ((bat_active[RIGHT_BAT]) && (playfield[30][bat_pos[RIGHT_BAT] - 1] == EMPTY) && (bat_pos[RIGHT_BAT] > 1))
        {
          if (baddieImpedesBat(RIGHT_BAT) != IS_OVER)
          {
            bat_pos_old[RIGHT_BAT] = bat_pos[RIGHT_BAT];
            bat_pos[RIGHT_BAT]--; bat_direction[RIGHT_BAT] = UP;
          }
        }
      }
      drawBats();
    }
  }
  else // Two-player mode
  {
    if (joy2Up() && !joy2Left() && !joy2Right()) // UP
    {
      if (!joystick2Reversed)
      {
        if ((bat_active[LEFT_BAT]) && (playfield[01][bat_pos[LEFT_BAT] - 1] == EMPTY) && (bat_pos[LEFT_BAT] > 1))
        {
          if (baddieImpedesBat(LEFT_BAT) != IS_OVER) {
            bat_pos_old[LEFT_BAT] = bat_pos[LEFT_BAT];
            bat_pos[LEFT_BAT]--; bat_direction[LEFT_BAT] = UP;
          }
        }
        if ((bat_active[RIGHT_BAT]) && (playfield[01][bat_pos[RIGHT_BAT] - 1] == EMPTY) && (bat_pos[RIGHT_BAT] > 1))
        {
          if (baddieImpedesBat(RIGHT_BAT) != IS_OVER) {
            bat_pos_old[RIGHT_BAT] = bat_pos[RIGHT_BAT];
            bat_pos[RIGHT_BAT]--; bat_direction[RIGHT_BAT] = UP;
          }
        }
      }
      else
      {
        if ((bat_active[LEFT_BAT]) && (playfield[01][bat_pos[LEFT_BAT] + offset] == EMPTY) && (bat_pos[LEFT_BAT] < 31 - offset))
        {
          if (baddieImpedesBat(LEFT_BAT) != IS_UNDER) {
            bat_pos_old[LEFT_BAT] = bat_pos[LEFT_BAT];
            bat_pos[LEFT_BAT]++; bat_direction[LEFT_BAT] = DOWN;
          }
        }
        if ((bat_active[RIGHT_BAT]) && (playfield[01][bat_pos[RIGHT_BAT] + offset] == EMPTY) && (bat_pos[RIGHT_BAT] < 31 - offset))
        {
          if (baddieImpedesBat(RIGHT_BAT) != IS_UNDER) {
            bat_pos_old[RIGHT_BAT] = bat_pos[RIGHT_BAT];
            bat_pos[RIGHT_BAT]++; bat_direction[RIGHT_BAT] = DOWN;
          }
        }
      }
      drawBats();
    }
    else if (joy2Down() && !joy2Left() && !joy2Right()) // DOWN
    {
      if (!joystick2Reversed)
      {
        if ((bat_active[LEFT_BAT]) && (playfield[01][bat_pos[LEFT_BAT] + offset] == EMPTY) && (bat_pos[LEFT_BAT] < 31 - offset))
        {
          if (baddieImpedesBat(LEFT_BAT) != IS_UNDER) {
            bat_pos_old[LEFT_BAT] = bat_pos[LEFT_BAT];
            bat_pos[LEFT_BAT]++; bat_direction[LEFT_BAT] = DOWN;
          }
        }
        if ((bat_active[RIGHT_BAT]) && (playfield[01][bat_pos[RIGHT_BAT] + offset] == EMPTY) && (bat_pos[RIGHT_BAT] < 31 - offset))
        {
          if (baddieImpedesBat(RIGHT_BAT) != IS_UNDER) {
            bat_pos_old[RIGHT_BAT] = bat_pos[RIGHT_BAT];
            bat_pos[RIGHT_BAT]++; bat_direction[RIGHT_BAT] = DOWN;
          }
        }
      }
      else
      {
        if ((bat_active[LEFT_BAT]) && (playfield[01][bat_pos[LEFT_BAT] - 1] == EMPTY) && (bat_pos[LEFT_BAT] > 1))
        {
          if (baddieImpedesBat(LEFT_BAT) != IS_OVER) {
            bat_pos_old[LEFT_BAT] = bat_pos[LEFT_BAT];
            bat_pos[LEFT_BAT]--; bat_direction[LEFT_BAT] = UP;
          }
        }
        if ((bat_active[RIGHT_BAT]) && (playfield[01][bat_pos[RIGHT_BAT] - 1] == EMPTY) && (bat_pos[RIGHT_BAT] > 1))
        {
          if (baddieImpedesBat(RIGHT_BAT) != IS_OVER) {
            bat_pos_old[RIGHT_BAT] = bat_pos[RIGHT_BAT];
            bat_pos[RIGHT_BAT]--; bat_direction[RIGHT_BAT] = UP;
          }
        }
      }
      drawBats();
    }
  }

  if (joy1Fire() || joy2Fire())
  {
    // At the beginning of a new stage, the then only ball randomly appears at one of the four bats.
    // The program waits for the players to press a button. After that the ball starts moving.
    if (waitingForUserStart)
    {
      waitingForUserStart = false;
      gameGoing = true;
      ball_active[0] = true;
    }

    // Player collected bonus item that endowed bat with five shots
    if ((batCanShoot) && (!shotInArena))
    {
      if ((((!onePlayerMode) && (((bat_hasGun[UPPER_BAT] || (bat_hasGun[LOWER_BAT])) && joy1Fire()) ||
                                 ((bat_hasGun[LEFT_BAT] || (bat_hasGun[RIGHT_BAT])) && joy2Fire()) )))
          || (onePlayerMode && joy1Fire()))
      {
        if (shotsRemaining > 0)
        {
          emitSound(SHOT);
          shotsRemaining--;
          shotInArena = true;

          if      (bat_hasGun[LOWER_BAT]) {
            shot_x = bat_pos[LOWER_BAT] + 1;
            shot_y = 29;
          }
          else if (bat_hasGun[UPPER_BAT]) {
            shot_x = bat_pos[UPPER_BAT] + 1;
            shot_y = 2;
          }
          else if (bat_hasGun[LEFT_BAT])  {
            shot_x = 2;
            shot_y = bat_pos[LEFT_BAT] + 1;
          }
          else if (bat_hasGun[RIGHT_BAT]) {
            shot_x = 29;
            shot_y = bat_pos[RIGHT_BAT] + 1;
          }
        }
      }
    }
  }


  // Placed here for a better visual synchronization between ball and bat movement
  if (waitingForUserStart)  // Ball is at the bat. Users have not yet pressed a fire button
  {
    matrix.drawPixel(ball_x[0], ball_y[0], framebuffer[(int) ball_x[0]][(int) ball_y[0]]);
    //matrix.drawPixel(ball_x[0], ball_y[0], matrix.Color333(0, 0, 0));

    if      (bat_hasBall[UPPER_BAT])
    {
      ball_x[0] = bat_pos[UPPER_BAT] + 1;
      ball_y[0] = 2;
    }
    else if (bat_hasBall[LOWER_BAT])
    {
      ball_x[0] = bat_pos[LOWER_BAT] + 1;
      ball_y[0] = 29;
    }
    else if (bat_hasBall[LEFT_BAT])
    {
      ball_x[0] = 2;
      ball_y[0] = bat_pos[LEFT_BAT] + 1;
    }
    else if (bat_hasBall[RIGHT_BAT])
    {
      ball_x[0] = 29;
      ball_y[0] = bat_pos[RIGHT_BAT] + 1;
    }

    // Paint ball right at the bat
    matrix.drawPixel(ball_x[0], ball_y[0], ball_color);
  }


  //Serial.print("\ndirection of LOWER_BAT: "); Serial.print(bat_direction[LOWER_BAT]);

} // moveBat

boolean reflectAtUpperSurface(byte b, byte surface)
{
  if (surface == IS_BRICK)
  {
    if  ((ball_moveAngle[b] > 270) && (ball_moveAngle[b] < 360))
    {
      ball_moveAngle[b] = max(30, min(329, 180 + (360 - ball_moveAngle[b] + random(0, 6) - 10)));
      ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
      return true;
    }
    else if ((ball_moveAngle[b] >= 0) && (ball_moveAngle[b] < 90))
    {
      ball_moveAngle[b] = max(30, min(329, 180 - ball_moveAngle[b] + random(0, 6) - 10));
      ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
      return true;
    }
  }
  else if (surface == IS_BORDER)
  {
    if  ((ball_moveAngle[b] > 270) && (ball_moveAngle[b] < 360))
    {
      ball_moveAngle[b] = max(20, min(339, 180 + (360 - ball_moveAngle[b] + random(0, 6) - 10)));
      ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
      return true;
    }
    else if ((ball_moveAngle[b] >= 0) && (ball_moveAngle[b] < 90))
    {
      ball_moveAngle[b] = max(20, min(339, 180 - ball_moveAngle[b] + random(0, 6) - 10));
      ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
      return true;
    }
  }
  else if (surface == IS_BAT)
  {
    if  ((ball_moveAngle[b] > 270) && (ball_moveAngle[b] < 360))
    {
      ball_moveAngle[b] = max(30, min(329, 180 + (360 - ball_moveAngle[b] + random(0, 6) - 10)));
      ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
      return true;
    }
    else if ((ball_moveAngle[b] >= 0) && (ball_moveAngle[b] < 90))
    {
      ball_moveAngle[b] = max(30, min(329, 180 - ball_moveAngle[b] + random(0, 6) - 10));
      ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
      return true;
    }
  }

  return false;
}

boolean reflectAtLowerSurface(byte b, byte surface)
{
  if (surface == IS_BRICK)
  {
    if       ((ball_moveAngle[b] > 90) && (ball_moveAngle[b] <= 180))
    {
      ball_moveAngle[b] = max(30, min(329, 180 - ball_moveAngle[b] + random(0, 6) - 10));
      ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
      return true;
    }
    else if  ((ball_moveAngle[b] > 180) && (ball_moveAngle[b] < 270))
    {
      ball_moveAngle[b] = max(30, min(329, 360 - (ball_moveAngle[b] - 180 + random(0, 6) - 10)));
      ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
      return true;
    }
  }
  else if (surface == IS_BORDER)
  {
    if       ((ball_moveAngle[b] > 90) && (ball_moveAngle[b] <= 180))
    {
      ball_moveAngle[b] = max(20, min(339, 180 - ball_moveAngle[b] + random(0, 6) - 10));
      ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
      return true;
    }
    else if  ((ball_moveAngle[b] > 180) && (ball_moveAngle[b] < 270))
    {
      ball_moveAngle[b] = max(20, min(339, 360 - (ball_moveAngle[b] - 180 + random(0, 6) - 10)));
      ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
      return true;
    }
  }
  else if (surface == IS_BAT)
  {
    if       ((ball_moveAngle[b] > 90) && (ball_moveAngle[b] <= 180))
    {
      ball_moveAngle[b] = max(30, min(329, 180 - ball_moveAngle[b] + random(0, 6) - 10));
      ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
      return true;
    }
    else if  ((ball_moveAngle[b] > 180) && (ball_moveAngle[b] < 270))
    {
      ball_moveAngle[b] = max(30, min(329, 360 - (ball_moveAngle[b] - 180 + random(0, 6) - 10)));
      ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
      return true;
    }
  }

  return false;
}

boolean reflectAtLeftSurface(byte b, byte surface)
{
  if (surface == IS_BRICK)
  {
    if ((ball_moveAngle[b] > 180) && (ball_moveAngle[b] < 360))
    {
      ball_moveAngle[b] = max(30, min(329, 360 - ball_moveAngle[b] + random(0, 6) - 10));
      ball_vector_x[b] = getInkrement_x(ball_moveAngle[b]); // * abs(calcMoveAngle_x(min(360, ball_moveAngle[b])));
      return true;
    }
  }
  else if (surface == IS_BORDER)
  {
    if ((ball_moveAngle[b] > 180) && (ball_moveAngle[b] < 360))
    {
      ball_moveAngle[b] = max(15, min(344, 360 - ball_moveAngle[b] + random(0, 6) - 10));
      ball_vector_x[b] = getInkrement_x(ball_moveAngle[b]); // * abs(calcMoveAngle_x(min(360, ball_moveAngle[b])));
      return true;
    }
  }
  else if (surface == IS_BAT)
  {
    if ((ball_moveAngle[b] > 180) && (ball_moveAngle[b] < 360))
    {
      ball_moveAngle[b] = max(30, min(329, 360 - ball_moveAngle[b] + random(0, 6) - 10));
      ball_vector_x[b] = getInkrement_x(ball_moveAngle[b]); // * abs(calcMoveAngle_x(min(360, ball_moveAngle[b])));
      return true;
    }
  }

  return false;
}

boolean reflectAtRightSurface(byte b, byte surface)
{
  if (surface == IS_BRICK)
  {
    if ((ball_moveAngle[b] > 0) && (ball_moveAngle[b] < 180))
    {
      ball_moveAngle[b] = max(10, min(349, 360 - ball_moveAngle[b] + random(0, 6) - 10));
      ball_vector_x[b] = getInkrement_x(ball_moveAngle[b]); // * abs(calcMoveAngle_x(min(360, ball_moveAngle[b])));
      return true;
    }
  }
  else if (surface == IS_BAT)
  {
    if ((ball_moveAngle[b] > 0) && (ball_moveAngle[b] < 180))
    {
      ball_moveAngle[b] = max(30, min(329, 360 - ball_moveAngle[b] + random(0, 6) - 10));
      ball_vector_x[b] = getInkrement_x(ball_moveAngle[b]); // * abs(calcMoveAngle_x(min(360, ball_moveAngle[b])));
      return true;
    }
  }
  else if (surface == IS_BORDER)
  {
    if ((ball_moveAngle[b] > 0) && (ball_moveAngle[b] < 180))
    {
      ball_moveAngle[b] = max(23, min(336, 360 - ball_moveAngle[b] + random(0, 15) - 30));
      ball_vector_x[b] = getInkrement_x(ball_moveAngle[b]); // * abs(calcMoveAngle_x(min(360, ball_moveAngle[b])));
      return true;
    }
  }

  return false;
}

boolean reflectDiagonally(byte b, byte surface)
{

  if (surface == IS_BRICK)
  {
    if       ((ball_moveAngle[b] >= 0) && (ball_moveAngle[b] < 180))
    {
      ball_moveAngle[b] = max(20, min(339, 180 + ball_moveAngle[b] + random(0, 6) - 10));
    }
    else if  ((ball_moveAngle[b] >= 180) && (ball_moveAngle[b] <= 360))
    {
      ball_moveAngle[b] = max(20, min(339, ball_moveAngle[b] - 180 + random(0, 6) - 10));
    }

    ball_vector_x[b] = getInkrement_x(ball_moveAngle[b]) * abs(calcMoveAngle_x(min(360, ball_moveAngle[b])));
    ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
    return true;
  }
  else if (surface == IS_BORDER)
  {
    if       ((ball_moveAngle[b] >= 0) && (ball_moveAngle[b] < 180))
    {
      ball_moveAngle[b] = max(20, min(339, 180 + ball_moveAngle[b] + random(0, 6) - 10));
    }
    else if  ((ball_moveAngle[b] >= 180) && (ball_moveAngle[b] <= 360))
    {
      ball_moveAngle[b] = max(20, min(339, ball_moveAngle[b] - 180 + random(0, 6) - 10));
    }

    ball_vector_x[b] = getInkrement_x(ball_moveAngle[b]) * abs(calcMoveAngle_x(min(360, ball_moveAngle[b])));
    ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
    return true;
  }
  else if (surface == IS_BAT)
  {
    if       ((ball_moveAngle[b] >= 0) && (ball_moveAngle[b] < 180))
    {
      ball_moveAngle[b] = max(20, min(339, 180 + ball_moveAngle[b] + random(0, 6) - 10));
    }
    else if  ((ball_moveAngle[b] >= 180) && (ball_moveAngle[b] <= 360))
    {
      ball_moveAngle[b] = max(20, min(339, ball_moveAngle[b] - 180 + random(0, 6) - 10));
    }

    ball_vector_x[b] = getInkrement_x(ball_moveAngle[b]) * abs(calcMoveAngle_x(min(360, ball_moveAngle[b])));
    ball_vector_y[b] = getInkrement_y(ball_moveAngle[b]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[b])));
    return true;
  }

  return false;
}

void checkBallReflectedAtBat(byte i, double ball_x, double ball_y) // DID THE BALL HIT ONE OF THE ACTIVE BATS?
{
  if (!gameGoing) {
    return;
  }

  int x = (int) ball_x;
  int y = (int) ball_y;

  byte offset;
  if (enlargedBat) {
    offset = 5;
  } else {
    offset = 3;
  }

  // ----- LOWER_BAT -----


  if (bat_active[LOWER_BAT])
  {
    if (y + 1 == LOWER_BAT_HEIGHT) // Ball is right over the bat (can potentially be reflected)
    {
      if ((x >= bat_pos[LOWER_BAT]) && (x <= bat_pos[LOWER_BAT] + offset))
      {
        ballReflected[i] = reflectAtLowerSurface(i, IS_BAT);
        emitSound(BAT_REBOUND);
      }
    }
  }


  // ----- UPPER BAT -----


  if (bat_active[UPPER_BAT])
  {
    if (y - 1 == UPPER_BAT_HEIGHT) // Ball is right under the bat (can potentially be reflected)
    {
      if ((x >= bat_pos[UPPER_BAT]) && (x <= bat_pos[UPPER_BAT] + offset))
      {
        ballReflected[i] = reflectAtUpperSurface(i, IS_BAT); emitSound(BAT_REBOUND);
      }
    }
  }


  // ----- LEFT BAT -----

  // hit pad upmost...usw ist problematisch, da die Reflexion von der Richtung des Balls abhÃ¤ngt
  // bessermachen

  // CHECK LEFT BAT
  if (bat_active[LEFT_BAT])
  {
    if (x - 1 == LEFT_BAT_HEIGHT) // Ball is slightly right from the bat (can potentially be reflected)
    {
      if ((y >= bat_pos[LEFT_BAT]) && (y <= bat_pos[LEFT_BAT] + offset))
      {
        ballReflected[i] = reflectAtLeftSurface(i, IS_BAT); emitSound(BAT_REBOUND);
      }
    }
  }


  // ------ RIGHT BAT -----

  // CHECK RIGHT BAT
  if (bat_active[RIGHT_BAT])
  {
    if (x + 1 == RIGHT_BAT_HEIGHT) // Ball is slightly left from the bat (can potentially be reflected)
    {
      if ((y >= bat_pos[RIGHT_BAT]) && (y <= bat_pos[RIGHT_BAT] + offset))
      {
        ballReflected[i] = reflectAtRightSurface(i, IS_BAT); emitSound(BAT_REBOUND);
      }
    }
  } // RIGHT_BAT
} // checkBallReflectedAtBat

// (ball_x, ball_y) is the current position of the ball. Check whether the ball gets reflected at a brick
void checkBallReflectedAtBrick(byte i, double ball_x, double ball_y)
{
  if (!gameGoing)
  {
    return;
  }

  int x = (int) ball_x; // Here, we need to compare pixel locations on-screen that differ by 1
  int y = (int) ball_y; // 2.0 < ball_y < 3.0 means that ball_y = screen coordinate 2


  // ------------------ Direction between 0Â° and 90Â° ----------------------------


  if      ((ball_moveAngle[i] > 0) && (ball_moveAngle[i] < 90))
  {
    if ((playfield[x][y - 1] != EMPTY) && (playfield[x + 1][y] != EMPTY)) // 1
    {
      ballReflected[i] = reflectDiagonally(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x][y - 1], playfield[x + 1][y], x, y - 1, x + 1, y); // Object1, Object2, ball_x, ball_y
    }
    else if ((playfield[x][y - 1] != EMPTY) && (playfield[x + 1][y] == EMPTY)) // 2, muss evtl. erweitert werden
    {
      ballReflected[i] = reflectAtUpperSurface(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x][y - 1], 0, x, y - 1, 0, 0);
    }
    else if ((playfield[x + 1][y - 1] != EMPTY) && (playfield[x - 1][y - 1] == EMPTY) && (playfield[x + 1][y] == EMPTY)) // 3
    {
      ballReflected[i] = reflectDiagonally(i, IS_BRICK); // Reflektieren mit hohem Zufallsanteilen in x- und y-Richtung
      deleteObjAndThrowBonus(playfield[x + 1][y - 1], 0, x + 1, y - 1, 0, 0);
    }
    else if ((playfield[x][y - 1] == EMPTY) && (playfield[x + 1][y] != EMPTY)) // 4, muss evtl. erweitert werden
    {
      ballReflected[i] = reflectAtRightSurface(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x + 1][y], 0, x + 1, y, 0, 0); // Object1, Object2, ball_x, ball_y
    }
  }


  // ------------------ Direction between 90Â° and 180Â° ----------------------------


  else if ((ball_moveAngle[i] > 90) && (ball_moveAngle[i] < 180))
  {
    if ((playfield[x + 1][y] != EMPTY) && (playfield[x][y + 1] != EMPTY)) // 1
    {
      ballReflected[i] = reflectDiagonally(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x + 1][y], playfield[x][y + 1], x + 1, y, x, y + 1); // Object1, Object2, ball_x, ball_y
    }
    else if ((playfield[x][y + 1] != EMPTY) && (playfield[x + 1][y] == EMPTY)) // 2, muss evtl. erweitert werden
    {
      ballReflected[i] = reflectAtLowerSurface(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x][y + 1], 0, x, y + 1, 0, 0); // Object1, Object2, ball_x, ball_y
    }
    else if ((playfield[x + 1][y + 1] != EMPTY) && (playfield[x + 1][y] == EMPTY) && (playfield[x][y + 1] == EMPTY)) // 3
    {
      ballReflected[i] = reflectDiagonally(i, IS_BRICK); // Reflektieren mit hohem Zufallsanteilen in x- und y-Richtung
      deleteObjAndThrowBonus(playfield[x + 1][y + 1], 0, x + 1, y + 1, 0, 0); // Object1, Object2, ball_x, ball_y
    }
    else if ((playfield[x + 1][y] != EMPTY) && (playfield[x][y + 1] == EMPTY)) // 4, muss evtl. erweitert werden
    {
      ballReflected[i] = reflectAtRightSurface(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x + 1][y], 0, x + 1, y, 0, 0); // Object1, Object2, ball_x, ball_y
    }
  }


  // ------------------ Direction between 180Â° and 270Â° ----------------------------


  else if ((ball_moveAngle[i] > 180) && (ball_moveAngle[i] < 270))
  {
    if ((playfield[x - 1][y] != EMPTY) && (playfield[x][y + 1] != EMPTY)) // 1
    {
      ballReflected[i] = reflectDiagonally(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x - 1][y], playfield[x][y + 1], x - 1, y, x, y + 1); // Object1, Object2, ball_x, ball_y
    }
    else if ((playfield[x - 1][y] != EMPTY) && (playfield[x][y + 1] == EMPTY)) // 2, muss evtl. erweitert werden
    {
      ballReflected[i] = reflectAtLeftSurface(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x - 1][y], 0, x - 1, y, 0, 0); // Object1, Object2, ball_x, ball_y
    }
    else if ((playfield[x - 1][y + 1] != EMPTY) && (playfield[x - 1][y] == EMPTY) && (playfield[x][y + 1] == EMPTY)) // 3
    {
      ballReflected[i] = reflectDiagonally(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x - 1][y + 1], 0, x - 1, y + 1, 0, 0); // Object1, Object2, ball_x, ball_y
    }
    else if ((playfield[x][y + 1] != EMPTY) && (playfield[x - 1][y] == EMPTY)) // 4, muss evtl. erweitert werden
    {
      ballReflected[i] = reflectAtLowerSurface(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x][y + 1], 0, x, y + 1, 0, 0); // Object1, Object2, ball_x, ball_y
    }
  }


  // ------------------ Direction between 270Â° and 360Â° ----------------------------


  else if ((ball_moveAngle[i] > 270) && (ball_moveAngle[i] < 360))
  {
    if ((playfield[x - 1][y] != EMPTY) && (playfield[x][y - 1] != EMPTY)) // 1
    {
      ballReflected[i] = reflectDiagonally(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x - 1][y], playfield[x][y - 1], x - 1, y, x, y - 1); // Object1, Object2, ball_x, ball_y
    }
    else if ((playfield[x - 1][y] != EMPTY) && (playfield[x][y - 1] == EMPTY)) // 2, muss evtl. erweitert werden
    {
      ballReflected[i] = reflectAtLeftSurface(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x - 1][y], 0, x - 1, y, 0, 0); // Object1, Object2, ball_x, ball_y
    }
    else if ((playfield[x - 1][y - 1] != EMPTY) && (playfield[x][y - 1] == EMPTY) && (playfield[x - 1][y] == EMPTY)) // 3
    {
      ballReflected[i] = reflectDiagonally(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x - 1][y - 1], 0, x - 1, y - 1, 0, 0); // Object1, Object2, ball_x, ball_y
    }
    else if ((playfield[x][y - 1] != EMPTY) && (playfield[x - 1][y] == EMPTY)) // 4, muss evtl. erweitert werden
    {
      ballReflected[i] = reflectAtUpperSurface(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x][y - 1], 0, x, y - 1, 0, 0); // Object1, Object2, ball_x, ball_y
    }
  }


  // ------------------ Special cases: 90Â°, 180Â°, 270Â°, 360Â° ----------------------------


  else if (ball_moveAngle[i] == 90)
  {
    if (playfield[x + 1][y] != EMPTY)
    {
      ballReflected[i] = reflectAtRightSurface(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x + 1][y], 0, x + 1, y, 0, 0);
    }
  }
  else if (ball_moveAngle[i] == 180)
  {
    if (playfield[x][y + 1] != EMPTY)
    {
      ballReflected[i] = reflectAtLowerSurface(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x][y + 1], 0, x, y + 1, 0, 0);
    }
  }
  else if (ball_moveAngle[i] == 270)
  {
    if (playfield[x - 1][y] != EMPTY)
    {
      ballReflected[i] = reflectAtLeftSurface(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x - 1][y], 0, x - 1, y, 0, 0);
    }
  }
  else if (ball_moveAngle[i] == 360)
  {
    if (playfield[x][y - 1] != EMPTY)
    {
      ballReflected[i] = reflectAtUpperSurface(i, IS_BRICK);
      deleteObjAndThrowBonus(playfield[x][y - 1], 0, x, y - 1, 0, 0);
    }
  }
} // checkBallReflectedAtBrick

void checkBallOutsidePlayingArea(byte i)
{
  if (!gameGoing)
  {
    return;
  }

  int x = (int) ball_x[i];
  int y = (int) ball_y[i];

  // If ball i is the last ball in the arena and is outside the playing area, the player loses a life
  // This aborts the collision detection
  if ( (((x <= 0) || (x >= 31) || (y <= 0) || (y >= 31))) &&
       (framebuffer[x][y] == EMPTY) )
  {
    matrix.drawPixel(x, y, matrix.Color333(0, 0, 0));

    if (ball_active[i])
    {
      if (i != 0) {
        ball_active[i] = false;  // condition introduced, CHANGED 17:28 16.02.17
      }
      ball_x[i] = 35; ball_y[i] = 35;
      numActiveBalls--;
      if (numActiveBalls == 0)
      {
        // Make a suitable sound here
        emitSound(OUTOFARENA);
        lostLife = true;
      }
    }
  }
}

void checkShotCollidedWithBrick()
{
  byte ex = 1 + 3 * ((shot_x - 1) / 3);
  byte ey = 1 + 2 * ((shot_y - 1) / 2);
  byte o = playfield[shot_x][shot_y];

  if ((o == RED_BRICK)   || (o == GREEN_BRICK) || (o == YELLOW_BRICK) ||
      (o == BLUE_BRICK)  || (o == VIOLET_BRICK) || (o == ORANGE_BRICK) || (o == UNUSED_BRICK))
  {
    matrix.drawPixel(shot_x, shot_y, framebuffer[shot_x][shot_y]);
    for (byte k = 0; k < 5; k++)
    {
      matrix.drawPixel(ex + random(3), ey + random(2), backgroundColor);
      delay(20);
    }
    deleteBrick(ex, ey);
    shotInArena = false;
    shot_x = -1; shot_y = -1;
  }
  else if ( (o == SOLID_BRICK) || (o == HORIZ_WALL_HIGH) || (o == HORIZ_WALL_LOW) || (o == VERT_WALL) ||
            (o == CORNER_SE) || (o == CORNER_SW) || (o == CORNER_NE) || (o == CORNER_NW))
  {
    matrix.drawPixel(shot_x, shot_y, framebuffer[shot_x][shot_y]);
    shotInArena = false;
    shot_x = -1; shot_y = -1;
  }
}

void checkShotCollidedWithBaddie()
{
  for (byte i = 0; i < 4; i++)
  {
    if ((baddie_active[i]) && (!baddieExplode[i]) && (!baddieAppear[i]) && (!baddieDisappear[i]))
    {
      if ((abs(baddie_x[i] - shot_x) < 2) && (abs(baddie_y[i] - shot_y) < 2))
      {
        //Serial.print("\nPlayer shot baddie");
        matrix.drawPixel(shot_x, shot_y, framebuffer[shot_x][shot_y]);
        shotInArena = false;
        shot_x = -1; shot_y = -1;

        baddieExplodeAnimFrame[i] = 0;
        baddieExplode[i] = true;
        if (baddie_type[i] == DISTURBER)
        {
          baddieType2InGame = false;
        }
        //emitSound(BADDIE_EXPLODE);
        break;
      }
    }
  }
  //return false;
}

void deleteBrick(byte ex, byte ey)
{
  numBricks--;
  matrix.fillRect(ex, ey, 3, 2, matrix.Color333(0, 0, 0));
  // Delete element from playfield
  playfield[ex][ey] = EMPTY; playfield[ex + 1][ey] = EMPTY; playfield[ex + 2][ey] = EMPTY;
  playfield[ex][ey + 1] = EMPTY; playfield[ex + 1][ey + 1] = EMPTY; playfield[ex + 2][ey + 1] = EMPTY;
  framebuffer[ex][ey] = matrix.Color333(0, 0, 0);
  framebuffer[ex + 1][ey] = matrix.Color333(0, 0, 0);
  framebuffer[ex + 2][ey] = matrix.Color333(0, 0, 0);
  framebuffer[ex][ey + 1] = matrix.Color333(0, 0, 0);
  framebuffer[ex + 1][ey + 1] = matrix.Color333(0, 0, 0);
  framebuffer[ex + 2][ey + 1] = matrix.Color333(0, 0, 0);
}

void setNextHavocBallPosition(byte i, double x, double y)
{
  double newX = 0;
  double newY = 0;

  do //hier sollte eine feste, aber variable folge von koordinaten auf einer kurve genommen werden
  {
    newX = x + sin(random(0, 46)) * ball_vector_x[i];
    newY = y + cos(random(0, 46)) * ball_vector_y[i];
  }
  while (framebuffer[(int) newX][(int) newY] != backgroundColor);
  ball_x[i] = newX;
  ball_y[i] = newY;
}

// Deletes Object1 and/or Object2, ball_x, ball_y
// Throws a bonus item with a random probability
void deleteObjAndThrowBonus(byte o1, byte o2, int x1, int y1, int x2, int y2)
{
  // Which object has the ball touched?
  byte ex1 = 1 + 3 * ((x1 - 1) / 3);
  byte ey1 = 1 + 2 * ((y1 - 1) / 2);

  if ((o1 == RED_BRICK)   || (o1 == GREEN_BRICK) || (o1 == YELLOW_BRICK) ||
      (o1 == BLUE_BRICK)  || (o1 == VIOLET_BRICK) || (o1 == ORANGE_BRICK))
  {
    deleteBrick(ex1, ey1);
    emitSound(DEMOLISH);

    // Release a bonus item with a 1:30 probability: CHANGED 16:46 16.02.17
    if ((random(0, 8-gameMode) == 5) && (gameGoing) && (!ongoingBonusAction) && (!bonusObjectFlying))
    {
      makeNewBonusObject(ex1, ey1);
    }
  }
  else
  {
    emitSound(REBOUND);
  }

  byte ex2 = 1 + 3 * ((x2 - 1) / 3);
  byte ey2 = 1 + 2 * ((y2 - 1) / 2);

  if ((o2 == RED_BRICK)   || (o2 == GREEN_BRICK) || (o2 == YELLOW_BRICK) ||
      (o2 == BLUE_BRICK)  || (o2 == VIOLET_BRICK) || (o2 == ORANGE_BRICK))
  {
    deleteBrick(ex2, ey2);
    emitSound(DEMOLISH);

    // Release a bonus item with a 1:6 probability: CHANGED 16:46 16.02.17
    if ((random(0, 8-gameMode) == 5) && (gameGoing) && (!ongoingBonusAction) && (!bonusObjectFlying))
    {
      makeNewBonusObject(ex2, ey2);
    }
  }
  else
  {
    emitSound(REBOUND);
  }
}

// Ball movement:
// First the ball is cleared at its current position
// For the current position of the ball it is checked whether it will collide with an object in the next movement.
// This will change the ball's direction
// After that the ball is moved to the new position
void moveBalls()
{
  if (!gameGoing)
  {
    return;
  }

  if (!waitingForUserStart)
  {
    for (byte i = 0; i < 5; i++)
    {
      if (ball_active[i])
      {
        // Clear ball at old position
        if ((((int) ball_x[i]) >= 0) && ((int) ball_y[i] >= 0)) {
          matrix.drawPixel(ball_x[i], ball_y[i], framebuffer[(int) ball_x[i]][(int) ball_y[i]]);
        }
        //matrix.drawPixel(ball_x[i], ball_y[i], matrix.Color333(0, 0, 0));
        ball_old_x[i] = ball_x[i];
        ball_old_y[i] = ball_y[i];

        // (ball_x, ball_y) is the current position of the ball
        // It has a direction determined by (ball_vector_x, ball_vector_y)
        // If it is going to hit one of the walls in the next movement, change its direction
        // If it is going to hit a bat in the next movement, reflect it
        // If it is going to hit a brick in the next movement, destroy the brick and reflect the ball
        // If it is outside the playing area, remove it from the game
        // All incidences change the direction vector of the ball
        ballReflected[i] = false;
        checkBallReflectedAtBat(i, ball_x[i], ball_y[i]);
        checkBallReflectedAtBrick(i, ball_x[i], ball_y[i]);
        if (!ballReflected[i]) {
          checkBallCollidedWithBaddie(i);
        }
        checkBallOutsidePlayingArea(i);

        //if (!ballTurnedHavoc)
        {
          // For certain angles, the ball moves in a stairway fashion.
          // We prevent this by looking at the next two positions of the ball
          // If both are within the 8-neighborhood of the current position, we skip the next position
          // and directly go to the next after the skipped one.
          // We can do this only if the new position will lead the ball onto an empty position
          if (bothInMooreNeighborhood(ball_x[i], ball_y[i], ball_vector_x[i], ball_vector_y[i]))
          {
            ball_x[i] = ball_x[i] + 2 * ball_vector_x[i];
            ball_y[i] = ball_y[i] + 2 * ball_vector_y[i];
          }
          else
          {
            ball_x[i] = ball_x[i] + ball_vector_x[i];
            ball_y[i] = ball_y[i] + ball_vector_y[i];
          }
        }
        /*
          else
          {
          setNextHavocBallPosition(i, ball_x[i], ball_y[i]);
          }
        */

        // Paint ball at new position:
        if ((((int) ball_x[i]) >= 0) && ((int) ball_y[i] >= 0)) {
          matrix.drawPixel(ball_x[i], ball_y[i], ball_color);
        }

      } // ball_active[i]
    } // for
  }

  drawBats(); // Draw bats
}

// At the beginning of a round, or after the player lost a life, there is only one ball present.
// Places it randomly at one of the active bats
// Halts the game until a player presses a joystick button
void assignBallToBat()
{
  randomSeed(analogRead(4));

  boolean assigned = false;

  do
  {
    byte bat = random(4);

    if ((bat_active[UPPER_BAT]) && (bat == UPPER_BAT))
    {
      bat_hasBall[UPPER_BAT] = true;
      assigned = true;

      // Endue the only ball with a direction that leads into the arena
      if (ball_active[0])
      {
        //ball_moveAngle[0] = 250; // OK
      }
    }
    else if ((bat_active[LOWER_BAT]) && (bat == LOWER_BAT))
    {
      bat_hasBall[LOWER_BAT] = true;
      assigned = true;

      if (ball_active[0])
      {
        // Endue the ball with a direction that leads into the arena
        //ball_moveAngle[0] = 40; // war 30
      }
    }
    else if ((bat_active[LEFT_BAT]) && (bat == LEFT_BAT))
    {
      bat_hasBall[LEFT_BAT] = true;
      assigned = true;

      if (ball_active[0])
      {
        // Endue the ball with a direction that leads into the arena
        //ball_moveAngle[0] = 35; // 25 enspricht Bewegung exakt nach rechts
      }
    }
    else if ((bat_active[RIGHT_BAT]) && (bat == RIGHT_BAT))
    {
      bat_hasBall[RIGHT_BAT] = true;
      assigned = true;

      if (ball_active[0])
      {
        // Endue the ball with a direction that leads into the arena
        //ball_moveAngle[0] = 210; // OK, 180 ist genau horizontal
      }
    }
  }
  while (!assigned);

  //ball_vector_x[0] = getInkrement_x(ball_moveAngle[0]) * abs(calcMoveAngle_x(min(360, ball_moveAngle[0])));
  //ball_vector_y[0] = getInkrement_y(ball_moveAngle[0]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[0])));
  //Serial.print("\nball_vector_x, ball_vector_y: "); Serial.print(ball_vector_x[0]); Serial.print(", "); Serial.print(ball_vector_y[0]);
}

boolean bothInMooreNeighborhood(double x, double y, double vx, double vy)
{
  double x2 = x + vx;
  double y2 = y + vy;
  double x3 = x + 2 * vx;
  double y3 = y + 2 * vy;

  if ((abs(byte(x3) - byte(x)) == 1) && (abs(byte(y3) - byte(y)) == 1)) {
    return true;
  }
  return false;
}

void animateShot()
{
  if (!gameGoing) {
    return;
  }

  //if (!batCanShoot) { return; }

  if ((shot_x <= 0) || (shot_x >= 31) || (shot_y <= 0) || (shot_y >= 31)) {
    shotInArena = false;
    return;
  }

  matrix.drawPixel(shot_x, shot_y, framebuffer[shot_x][shot_y]); // Delete shot at former position

  if (bat_hasGun[UPPER_BAT])
  {
    shot_y++;
    matrix.drawPixel(shot_x, shot_y, matrix.Color444(13, 15, 0));
  }
  else if (bat_hasGun[LOWER_BAT])
  {
    shot_y--;
    matrix.drawPixel(shot_x, shot_y, matrix.Color444(13, 15, 0));
  }
  else if (bat_hasGun[LEFT_BAT])
  {
    shot_x++;
    matrix.drawPixel(shot_x, shot_y, matrix.Color444(13, 15, 0));
  }
  else if (bat_hasGun[RIGHT_BAT])
  {
    shot_x--;
    matrix.drawPixel(shot_x, shot_y, matrix.Color444(13, 15, 0));
  }

  checkShotCollidedWithBrick();
  checkShotCollidedWithBaddie();
}

void drawBats()
{
  int col1;
  int col2;
  if (animCounter % 2 == 0) {
    col1 = matrix.Color444(8, 13, 0);
    col2 = matrix.Color444(13, 8, 0);
  }
  else {
    col2 = matrix.Color444(8, 13, 0);
    col1 = matrix.Color444(13, 8, 0);
  }

  // Bat 0: upper bat, 1: lower bat, 2: left bat, 3: right bat
  if (bat_active[UPPER_BAT])
  {
    if (bat_hasGun[UPPER_BAT])
    {
      matrix.drawLine(bat_pos_old[UPPER_BAT], UPPER_BAT_HEIGHT, bat_pos_old[UPPER_BAT] + 3 , UPPER_BAT_HEIGHT, matrix.Color333(0, 0, 0));
      matrix.drawPixel(bat_pos[UPPER_BAT] + 0, UPPER_BAT_HEIGHT, bat_color);
      matrix.drawPixel(bat_pos[UPPER_BAT] + 1, UPPER_BAT_HEIGHT, col1);
      matrix.drawPixel(bat_pos[UPPER_BAT] + 2, UPPER_BAT_HEIGHT, col2);
      matrix.drawPixel(bat_pos[UPPER_BAT] + 3, UPPER_BAT_HEIGHT, bat_color);
    }
    else if (bat_isEnlarged[UPPER_BAT])
    {
      matrix.drawLine(bat_pos_old[UPPER_BAT], UPPER_BAT_HEIGHT, bat_pos_old[UPPER_BAT] + 5 , UPPER_BAT_HEIGHT, matrix.Color333(0, 0, 0));
      matrix.drawLine(bat_pos[UPPER_BAT], UPPER_BAT_HEIGHT, bat_pos[UPPER_BAT] + 5 , UPPER_BAT_HEIGHT, bat_color);

      matrix.drawPixel(bat_pos[UPPER_BAT] + 0, UPPER_BAT_HEIGHT, bat_color2);
      matrix.drawPixel(bat_pos[UPPER_BAT] + 5, UPPER_BAT_HEIGHT, bat_color2);
    }
    else
    {
      matrix.drawLine(bat_pos_old[UPPER_BAT], UPPER_BAT_HEIGHT, bat_pos_old[UPPER_BAT] + 3 , UPPER_BAT_HEIGHT, matrix.Color333(0, 0, 0));
      matrix.drawLine(bat_pos[UPPER_BAT], UPPER_BAT_HEIGHT, bat_pos[UPPER_BAT] + 3 , UPPER_BAT_HEIGHT, bat_color);

      matrix.drawPixel(bat_pos[UPPER_BAT] + 0, UPPER_BAT_HEIGHT, bat_color2);
      matrix.drawPixel(bat_pos[UPPER_BAT] + 3, UPPER_BAT_HEIGHT, bat_color2);
    }
  }

  if (bat_active[LOWER_BAT])
  {
    if (bat_hasGun[LOWER_BAT])
    {
      matrix.drawLine(bat_pos_old[LOWER_BAT], LOWER_BAT_HEIGHT, bat_pos_old[LOWER_BAT] + 3 , LOWER_BAT_HEIGHT, matrix.Color333(0, 0, 0));
      matrix.drawPixel(bat_pos[LOWER_BAT] + 0, LOWER_BAT_HEIGHT, bat_color);
      matrix.drawPixel(bat_pos[LOWER_BAT] + 1, LOWER_BAT_HEIGHT, col1);
      matrix.drawPixel(bat_pos[LOWER_BAT] + 2, LOWER_BAT_HEIGHT, col2);
      matrix.drawPixel(bat_pos[LOWER_BAT] + 3, LOWER_BAT_HEIGHT, bat_color);
    }
    else if (bat_isEnlarged[LOWER_BAT])
    {
      matrix.drawLine(bat_pos_old[LOWER_BAT], LOWER_BAT_HEIGHT, bat_pos_old[LOWER_BAT] + 5 , LOWER_BAT_HEIGHT, matrix.Color333(0, 0, 0));
      matrix.drawLine(bat_pos[LOWER_BAT], LOWER_BAT_HEIGHT, bat_pos[LOWER_BAT] + 5 , LOWER_BAT_HEIGHT, bat_color);

      matrix.drawPixel(bat_pos[LOWER_BAT] + 0, LOWER_BAT_HEIGHT, bat_color2);
      matrix.drawPixel(bat_pos[LOWER_BAT] + 5, LOWER_BAT_HEIGHT, bat_color2);
    }
    else
    {
      matrix.drawLine(bat_pos_old[LOWER_BAT], LOWER_BAT_HEIGHT, bat_pos_old[LOWER_BAT] + 3 , LOWER_BAT_HEIGHT, matrix.Color333(0, 0, 0));
      matrix.drawLine(bat_pos[LOWER_BAT], LOWER_BAT_HEIGHT, bat_pos[LOWER_BAT] + 3 , LOWER_BAT_HEIGHT, bat_color);

      matrix.drawPixel(bat_pos[LOWER_BAT] + 0, LOWER_BAT_HEIGHT, bat_color2);
      matrix.drawPixel(bat_pos[LOWER_BAT] + 3, LOWER_BAT_HEIGHT, bat_color2);
    }
  }

  if (bat_active[LEFT_BAT])
  {
    if (bat_hasGun[LEFT_BAT])
    {
      matrix.drawLine(LEFT_BAT_HEIGHT, bat_pos_old[LEFT_BAT], LEFT_BAT_HEIGHT, bat_pos_old[LEFT_BAT] + 3, matrix.Color333(0, 0, 0));
      matrix.drawPixel(LEFT_BAT_HEIGHT, bat_pos[LEFT_BAT] + 0, bat_color);
      matrix.drawPixel(LEFT_BAT_HEIGHT, bat_pos[LEFT_BAT] + 1, col1);
      matrix.drawPixel(LEFT_BAT_HEIGHT, bat_pos[LEFT_BAT] + 2, col2);
      matrix.drawPixel(LEFT_BAT_HEIGHT, bat_pos[LEFT_BAT] + 3, bat_color);
    }
    else if (bat_isEnlarged[LEFT_BAT])
    {
      matrix.drawLine(LEFT_BAT_HEIGHT, bat_pos_old[LEFT_BAT], LEFT_BAT_HEIGHT, bat_pos_old[LEFT_BAT] + 5, matrix.Color333(0, 0, 0));
      matrix.drawLine(LEFT_BAT_HEIGHT, bat_pos[LEFT_BAT], LEFT_BAT_HEIGHT, bat_pos[LEFT_BAT] + 5 , bat_color);

      matrix.drawPixel(LEFT_BAT_HEIGHT, bat_pos[LEFT_BAT] + 0, bat_color2);
      matrix.drawPixel(LEFT_BAT_HEIGHT, bat_pos[LEFT_BAT] + 5, bat_color2);
    }
    else
    {
      matrix.drawLine(LEFT_BAT_HEIGHT, bat_pos_old[LEFT_BAT], LEFT_BAT_HEIGHT, bat_pos_old[LEFT_BAT] + 3, matrix.Color333(0, 0, 0));
      matrix.drawLine(LEFT_BAT_HEIGHT, bat_pos[LEFT_BAT], LEFT_BAT_HEIGHT, bat_pos[LEFT_BAT] + 3 , bat_color);

      matrix.drawPixel(LEFT_BAT_HEIGHT, bat_pos[LEFT_BAT] + 0, bat_color2);
      matrix.drawPixel(LEFT_BAT_HEIGHT, bat_pos[LEFT_BAT] + 3, bat_color2);
    }
  }

  if (bat_active[RIGHT_BAT])
  {
    if (bat_hasGun[RIGHT_BAT])
    {
      matrix.drawLine(RIGHT_BAT_HEIGHT, bat_pos_old[RIGHT_BAT], RIGHT_BAT_HEIGHT, bat_pos_old[RIGHT_BAT] + 3, matrix.Color333(0, 0, 0));
      matrix.drawPixel(RIGHT_BAT_HEIGHT, bat_pos[RIGHT_BAT] + 0, bat_color);
      matrix.drawPixel(RIGHT_BAT_HEIGHT, bat_pos[RIGHT_BAT] + 1, col1);
      matrix.drawPixel(RIGHT_BAT_HEIGHT, bat_pos[RIGHT_BAT] + 2, col2);
      matrix.drawPixel(RIGHT_BAT_HEIGHT, bat_pos[RIGHT_BAT] + 3, bat_color);
    }
    else if (bat_isEnlarged[RIGHT_BAT])
    {
      matrix.drawLine(RIGHT_BAT_HEIGHT, bat_pos_old[RIGHT_BAT], RIGHT_BAT_HEIGHT, bat_pos_old[RIGHT_BAT] + 5, matrix.Color333(0, 0, 0));
      matrix.drawLine(RIGHT_BAT_HEIGHT, bat_pos[RIGHT_BAT], RIGHT_BAT_HEIGHT, bat_pos[RIGHT_BAT] + 5 , bat_color);

      matrix.drawPixel(RIGHT_BAT_HEIGHT, bat_pos[RIGHT_BAT] + 0, bat_color2);
      matrix.drawPixel(RIGHT_BAT_HEIGHT, bat_pos[RIGHT_BAT] + 5, bat_color2);
    }
    else
    {
      matrix.drawLine(RIGHT_BAT_HEIGHT, bat_pos_old[RIGHT_BAT], RIGHT_BAT_HEIGHT, bat_pos_old[RIGHT_BAT] + 3, matrix.Color333(0, 0, 0));
      matrix.drawLine(RIGHT_BAT_HEIGHT, bat_pos[RIGHT_BAT], RIGHT_BAT_HEIGHT, bat_pos[RIGHT_BAT] + 3 , bat_color);

      matrix.drawPixel(RIGHT_BAT_HEIGHT, bat_pos[RIGHT_BAT] + 0, bat_color2);
      matrix.drawPixel(RIGHT_BAT_HEIGHT, bat_pos[RIGHT_BAT] + 3, bat_color2);
    }
  }
}

void clearBats()
{
  byte l;

  if (bat_active[UPPER_BAT])
  {
    if (bat_isEnlarged[UPPER_BAT]) {
      l = 5;
    } else {
      l = 3;
    }
    matrix.drawLine(bat_pos[UPPER_BAT], UPPER_BAT_HEIGHT, bat_pos[UPPER_BAT] + l , UPPER_BAT_HEIGHT, matrix.Color333(0, 0, 0));
  }

  if (bat_active[LOWER_BAT])
  {
    if (bat_isEnlarged[LOWER_BAT]) {
      l = 5;
    } else {
      l = 3;
    }
    matrix.drawLine(bat_pos[LOWER_BAT], LOWER_BAT_HEIGHT, bat_pos[LOWER_BAT] + l , LOWER_BAT_HEIGHT, matrix.Color333(0, 0, 0));
  }

  if (bat_active[LEFT_BAT])
  {
    if (bat_isEnlarged[LEFT_BAT]) {
      l = 5;
    } else {
      l = 3;
    }
    matrix.drawLine(LEFT_BAT_HEIGHT, bat_pos[LEFT_BAT], LEFT_BAT_HEIGHT, bat_pos[LEFT_BAT] + l, matrix.Color333(0, 0, 0));
  }

  if (bat_active[RIGHT_BAT])
  {
    if (bat_isEnlarged[RIGHT_BAT]) {
      l = 5;
    } else {
      l = 3;
    }
    matrix.drawLine(RIGHT_BAT_HEIGHT, bat_pos[RIGHT_BAT], RIGHT_BAT_HEIGHT, bat_pos[RIGHT_BAT] + l, matrix.Color333(0, 0, 0));
  }
}

void showTitleScreen()
{
  // Show logo
  int col;
  byte p;

  matrix.fillScreen(backgroundColor); // Clear screen

  for (byte x = 0; x < 32; x++)
  {
    for (byte y = 0; y < 32; y++)
    {
      p = pgm_read_byte_near(titleImg + y * 32 + x);

      switch (p)
      {
        case 0:
          col = matrix.Color444(0, 0, 0);
          break;

        case 1:
          col = matrix.Color444(15, 0, 0);
          break;

        case 2:
          col = matrix.Color444(0, 15, 6);
          break;

        case 3:
          col = matrix.Color444(15, 9, 0);
          break;

        case 4:
          col = matrix.Color444(11, 12, 15);
          break;

        case 5:
          col = matrix.Color444(12, 12, 13);
          break;

        case 6:
          col = matrix.Color444(15, 15, 0);
          break;

        case 7:
          col = matrix.Color444(15, 0, 15);
          break;

        case 8:
          col = matrix.Color444(15, 15, 9);
          break;

        case 9:
          col = matrix.Color444(0, 15, 0);
          break;

      }
      matrix.drawPixel(x, y, col);
    }
  }

  // Go on as soon as one of the joysticks has been operated
  while ( !joy1Fire()  && !joy2Fire()  &&
          !joy1Left()  && !joy2Left()  &&
          !joy1Right() && !joy2Right() &&
          !joy1Up()    && !joy2Up()    &&
          !joy1Down()  && !joy2Down() )
  {
    //timer.update();
  } // Wait until the player presses the joystick button
}

static inline int8_t sgn(int val)
{
  if (val < 0) return -1;
  else if (val == 0) return 0;
  else return 1;
}

void debug(byte i)
{
  //Serial.print("\n\nball_x, ball_y: "); Serial.print(ball_x[i]); Serial.print(", "); Serial.print(ball_y[i]);
  //Serial.print("\nvector_x, vector_y: "); Serial.print(ball_vector_x[i]); Serial.print(", "); Serial.print(ball_vector_y[i]);
}


// ------------------------------ Baddies ---------------------------------------


boolean checkBaddieCollision(byte i, byte type)
{
  //Serial.print("\ncheckBaddieCollision");

  if (!baddie_active[i]) {
    return 0;
  }

  switch (type)
  {
    case KAMIKAZE:  if  ( (baddie_y[i] < -3) || (baddie_y[i] > 33) || (baddie_x[i] < -3) || (baddie_x[i] > 33) )
      {
        clearBaddie(i);
        baddie_active[i] = false;
        return true;
      }

      if (checkBaddie0CollidedWithBat(i) && (!baddieHasCollided[i]))
      {
        //Serial.print("\ncollision between baddie and bat");
        baddieHasCollided[i] = true;
        baddieExplodeAnimFrame[i] = 0;
        baddieExplode[i] = true;
        //emitSound(BADDIE_EXPLODE);
        return true;
      }
      break;

    case RANDOM_WALK: if (checkBaddieCollidedWithBat(i) && (!baddieHasCollided[i]))
      {
        //Serial.print("\ncollision between baddie and bat");
        //baddieHasCollided[i] = true;
        //baddieExplodeAnimFrame[i] = 0;
        //baddieExplode[i] = true;
        //emitSound(BADDIE_EXPLODE);
        //return true;
      }
      break;

    case DISTURBER:   if (checkBaddieCollidedWithBat(i) && (!baddieHasCollided[i]))
      {
        //Serial.print("\ncollision between baddie and bat");
        //baddieHasCollided[i] = true;
        //baddieExplodeAnimFrame[i] = 0;
        //baddieExplode[i] = true;
        //baddieType2InGame = false;
        //emitSound(BADDIE_EXPLODE);
        //return true;
      }
      break;
  }
  return false;
}

boolean checkBaddie0CollidedWithBat(byte i)
{
  //Serial.print("\ncheckBaddie0CollidedWithBat");
  if (baddie_active[i])
  {
    int ox = baddie_x[i];
    int oy = baddie_y[i];
    int bx;
    int by;

    // Check lower bat
    if (bat_active[LOWER_BAT])
    {
      bx = bat_pos[LOWER_BAT];
      by = LOWER_BAT_HEIGHT;
      if ((bx + 3 >= ox) && (bx <= ox - 1) && (by >= oy) && (by <= oy + 3))
      {
        return true;
      }
    }

    if (bat_active[UPPER_BAT])
    {
      bx = bat_pos[UPPER_BAT];
      by = UPPER_BAT_HEIGHT;
      if ((bx + 3 >= ox) && (bx <= ox - 1) && (by >= oy) && (by <= oy + 3))
      {
        return true;
      }
    }

    if (bat_active[LEFT_BAT])
    {
      bx = LEFT_BAT_HEIGHT;
      by = bat_pos[LEFT_BAT];
      if ((by + 3 >= oy) && (by <= oy + 2) && (bx >= ox) && (bx <= ox + 3))
      {
        return true;
      }
    }

    if (bat_active[RIGHT_BAT])
    {
      bx = RIGHT_BAT_HEIGHT;
      by = bat_pos[RIGHT_BAT];
      if ((by + 3 >= oy) && (by <= oy + 2) && (bx >= ox) && (bx <= ox + 3))
      {
        return true;
      }
    }
  }

  return false;
}

boolean checkBaddieCollidedWithBat(byte i)
{
  if (!baddie_active[i]) {
    return 0;
  }

  int offset = 3;
  if (baddie_type[i] == KAMIKAZE) {
    return 0;  // This type is treated in checkBaddie0CollidedWithBat()
  }

  if (baddie_active[i])
  {
    // Check lower bat
    if (bat_active[LOWER_BAT])
    {
      if (bat_isEnlarged[LOWER_BAT]) {
        offset = 5;
      } else {
        offset = 3;
      }
      if ( ((baddie_x[i] + 2 == bat_pos[LOWER_BAT]) || (bat_pos[LOWER_BAT] + offset == baddie_x[i] - 2)) &&
           (LOWER_BAT_HEIGHT == baddie_y[i] + 1) )
      {
        return true;
      }
    }

    if (bat_active[UPPER_BAT])
    {
      if (bat_isEnlarged[UPPER_BAT]) {
        offset = 5;
      } else {
        offset = 3;
      }
      if ( ((baddie_x[i] + 2 == bat_pos[UPPER_BAT]) || (bat_pos[UPPER_BAT] + offset == baddie_x[i] - 2)) &&
           (UPPER_BAT_HEIGHT == baddie_y[i] - 1) )
      {
        return true;
      }
    }

    if (bat_active[LEFT_BAT])
    {
      if (bat_isEnlarged[LEFT_BAT]) {
        offset = 5;
      } else {
        offset = 3;
      }
      if ( ((baddie_y[i] + 2 == bat_pos[LEFT_BAT]) || (bat_pos[LEFT_BAT] + offset == baddie_y[i] - 2)) &&
           (LEFT_BAT_HEIGHT == baddie_x[i] - 1) )
      {
        return true;
      }
    }

    if (bat_active[RIGHT_BAT])
    {
      if (bat_isEnlarged[RIGHT_BAT]) {
        offset = 5;
      } else {
        offset = 3;
      }
      if ( ((baddie_y[i] + 2 == bat_pos[RIGHT_BAT]) || (bat_pos[RIGHT_BAT] + offset == baddie_y[i] - 2)) &&
           (RIGHT_BAT_HEIGHT == baddie_x[i] + 1) )
      {
        return true;
      }
    }
  }

  return false;
}

void drawBaddie(byte i)
{
  //Serial.print("\ndrawBaddie");

  if (!baddie_active[i]) {
    return;
  }

  int x = baddie_x[i];
  int y = baddie_y[i];

  if (baddieAppear[i])
  {
    switch (baddieAppearAnimFrame[i])
    {
      case 0: matrix.drawPixel(x, y, matrix.Color444(15, 15, 10)); break;
      case 1: matrix.drawPixel(x + 1, y + 1, matrix.Color444(3, 3, 8)); break;
      case 2: matrix.drawPixel(x + 2, y, matrix.Color444(15, 15, 10)); break;
      case 3: matrix.drawPixel(x + 1, y + 1, matrix.Color444(3, 3, 8)); break;
      case 4: matrix.drawPixel(x + 2, y + 2, matrix.Color444(15, 15, 10)); break;
      case 5: matrix.drawPixel(x + 1, y + 1, matrix.Color444(3, 3, 8)); break;
      case 6: matrix.drawPixel(x, y + 2, matrix.Color444(15, 15, 10)); break;
      case 7: matrix.drawPixel(x + 1, y + 1, matrix.Color444(3, 3, 8)); break;
      case 8: baddieAppear[i] = false; baddieAppearAnimFrame[i] = 0; break;
    }
    baddieAppearAnimFrame[i]++;
  }
  else if (baddieExplode[i])
  {
    switch (baddieExplodeAnimFrame[i])
    {
      case 0: matrix.drawPixel(x, y + 2, matrix.Color444(15, 4, 2)); tone(audio, random(100, 600) - 50, 5); break;
      case 1: matrix.drawPixel(x+1, y+1, matrix.Color444(14, 11, 2));  matrix.drawPixel(x+2, y+2, matrix.Color444(11, 2, 2)); tone(audio, random(100, 600) - 50, 5); break;
      case 2: matrix.drawPixel(x, y, matrix.Color444(14, 11, 2)); matrix.drawPixel(x+2, y+1, matrix.Color444(11, 4, 3)); matrix.drawPixel(x+1, y+2, matrix.Color444(14, 2, 2)); tone(audio, random(100, 600) - 50, 5); break;
      case 3: matrix.drawPixel(x+1, y, matrix.Color444(11, 3, 7)); matrix.drawPixel(x, y+1, matrix.Color444(11, 11, 3)); matrix.drawPixel(x, y+2, matrix.Color444(11, 3, 9)); matrix.drawPixel(x+2, y+2, matrix.Color444(11, 3, 3)); tone(audio, random(100, 600) - 50, 5); break;
      case 4: matrix.drawPixel(x+1, y, matrix.Color444(15, 4, 10)); matrix.drawPixel(x, y+2, matrix.Color444(11, 3, 3)); matrix.drawPixel(x+1, y+2, matrix.Color444(11, 3, 8)); tone(audio, random(100, 600) - 50, 5); break;
      case 5: matrix.drawPixel(x+2, y+2, matrix.Color444(11, 3, 8)); matrix.drawPixel(x, y+1, matrix.Color444(11, 3, 3)); tone(audio, random(100, 600) - 50, 5); break;
      case 6: matrix.drawPixel(x, y+2, matrix.Color444(15, 13, 2));  matrix.drawPixel(x+2, y+1, matrix.Color444(14, 3, 3)); tone(audio, random(100, 600) - 50, 5); break;
      case 7: matrix.drawPixel(x+1, y+2, matrix.Color444(11, 3, 8)); tone(audio, random(100, 600) - 50, 5); break;
      case 8: baddieExplode[i] = false;
      
        tone(audio, random(100, 600) - 50, 5);
        baddieExplodeAnimFrame[i] = 0;
        baddieHasCollided[i] = false;
        clearBaddie(i);
        baddie_x[i] = -5; baddie_y[i] = -5;
        baddie_active[i] = false;
        break;
    }
    baddieExplodeAnimFrame[i]++;
  }
  else if (baddieDisappear[i])
  {
    switch (baddieAnimFrame[i])
    {
      case 0: matrix.drawPixel(x, y, matrix.Color444(15, 15, 10)); break;
      case 1: matrix.drawPixel(x + 1, y + 1, matrix.Color444(3, 3, 8)); break;
      case 2: matrix.drawPixel(x + 2, y, matrix.Color444(15, 15, 10)); break;
      case 3: matrix.drawPixel(x + 1, y + 1, matrix.Color444(3, 3, 8)); break;
      case 4: matrix.drawPixel(x + 2, y + 2, matrix.Color444(15, 15, 10)); break;
      case 5: matrix.drawPixel(x + 1, y + 1, matrix.Color444(3, 3, 8)); break;
      case 6: matrix.drawPixel(x, y + 2, matrix.Color444(15, 15, 10)); break;
      case 7: matrix.drawPixel(x + 1, y + 1, matrix.Color444(3, 3, 8)); break;
      case 8: baddieDisappear[i] = false;
        baddie_active[i] = false;
        clearBaddie(i);
        baddie_x[i] = -5; baddie_y[i] = -5;

        baddieAnimFrame[i] = 0;
        break;
    }
    baddieAnimFrame[i]++;
  }
  else // Baddie is walking around
  {
    switch (baddie_appearance[i])
    {
      case KAMIKAZE: if (baddieDir[i] == DOWN)
        {
          switch (baddieAnimFrame[i])
          {
            case 0: matrix.drawPixel(x, y - 1, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              matrix.drawPixel(x, y + 1, baddie_color);
              break;

            case 1: matrix.drawPixel(x, y - 1, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              matrix.drawPixel(x, y + 1, baddie_color);
              matrix.drawPixel(x + 1, y - 1, baddie_color);
              matrix.drawPixel(x + 1, y, baddie_color);
              break;

            case 2: matrix.drawPixel(x, y - 1, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              matrix.drawPixel(x, y + 1, baddie_color);
              break;

            case 3: matrix.drawPixel(x - 1, y - 1, baddie_color);
              matrix.drawPixel(x - 1, y, baddie_color);
              matrix.drawPixel(x, y + 1, baddie_color);
              matrix.drawPixel(x, y - 1, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              break;
          } // switch baddieAnimFrame
        } // baddieDir = DOWN
        else if (baddieDir[i] == UP)
        {
          switch (baddieAnimFrame[i])
          {
            case 0: matrix.drawPixel(x, y - 1, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              matrix.drawPixel(x, y + 1, baddie_color);
              break;

            case 1: matrix.drawPixel(x, y - 1, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              matrix.drawPixel(x, y + 1, baddie_color);
              matrix.drawPixel(x + 1, y, baddie_color);
              matrix.drawPixel(x + 1, y + 1, baddie_color);
              break;

            case 2: matrix.drawPixel(x, y - 1, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              matrix.drawPixel(x, y + 1, baddie_color);
              break;

            case 3: matrix.drawPixel(x - 1, y, baddie_color);
              matrix.drawPixel(x - 1, y + 1, baddie_color);
              matrix.drawPixel(x, y + 1, baddie_color);
              matrix.drawPixel(x, y - 1, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              break;


          } // switch
        } // baddieDir = UP
        else if (baddieDir[i] == LEFT)
        {
          switch (baddieAnimFrame[i])
          {
            case 0:    matrix.drawPixel(x - 1, y, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              matrix.drawPixel(x + 1, y, baddie_color);
              break;

            case 1:    matrix.drawPixel(x, y - 1, baddie_color);
              matrix.drawPixel(x + 1, y - 1, baddie_color);

              matrix.drawPixel(x - 1, y, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              matrix.drawPixel(x + 1, y, baddie_color);
              break;

            case 2:    matrix.drawPixel(x - 1, y, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              matrix.drawPixel(x + 1, y, baddie_color);
              break;

            case 3:    matrix.drawPixel(x - 1, y, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              matrix.drawPixel(x + 1, y, baddie_color);

              matrix.drawPixel(x, y + 1, baddie_color);
              matrix.drawPixel(x + 1, y + 1, baddie_color);
              break;
          } // switch
        } // baddieDir = LEFT
        else if (baddieDir[i] == RIGHT)
        {
          switch (baddieAnimFrame[i])
          {
            case 0:    matrix.drawPixel(x - 1, y, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              matrix.drawPixel(x + 1, y, baddie_color);
              break;

            case 1:    matrix.drawPixel(x - 1, y - 1, baddie_color);
              matrix.drawPixel(x, y - 1, baddie_color);
              matrix.drawPixel(x - 1, y, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              matrix.drawPixel(x + 1, y, baddie_color);
              break;

            case 2:    matrix.drawPixel(x - 1, y, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              matrix.drawPixel(x + 1, y, baddie_color);
              break;

            case 3:    matrix.drawPixel(x - 1, y, baddie_color);
              matrix.drawPixel(x, y, baddie_color);
              matrix.drawPixel(x + 1, y, baddie_color);
              matrix.drawPixel(x - 1, y + 1, baddie_color);
              matrix.drawPixel(x, y + 1, baddie_color);
              break;
          } // switch
          break;
        } // baddieDir = RIGHT
        break;

      case RANDOM_WALK: switch (baddieAnimFrame[i])
        {
          case 0:  matrix.drawPixel(x, y - 1, baddie_color);
            matrix.drawPixel(x, y + 0, baddie_color);
            matrix.drawPixel(x, y + 1, baddie_color);
            matrix.drawPixel(x - 1, y, baddie_color);
            matrix.drawPixel(x + 1, y, baddie_color);
            break;

          case 1:  matrix.drawPixel(x, y - 1, baddie_color);
            matrix.drawPixel(x, y, baddie_color);
            matrix.drawPixel(x, y + 1, baddie_color);
            matrix.drawPixel(x - 1, y, baddie_color);
            matrix.drawPixel(x + 1, y, baddie_color);
            break;

          case 2:  matrix.drawRect(x - 1, y - 1, 3, 3, baddie_color);
            break;

          case 3:  matrix.drawRect(x - 1, y - 1, 3, 3, baddie_color);
            break;
        }
        break;

      case DISTURBER:   switch (disturberAnimFrame[i])
        {
          // East
          case 0:   matrix.drawPixel( x + 0, y - 1, matrix.Color444(1, 2, 2));
            matrix.drawPixel( x + 0, y + 0, baddie_color2);
            matrix.drawPixel( x - 1, y + 1, baddie_color2);
            matrix.drawPixel( x + 1, y + 0, baddie_color2);
            break;
          case 1:   matrix.drawPixel( x + 0, y - 1, matrix.Color444(1, 2, 2));
            matrix.drawPixel( x + 0, y + 0, baddie_color2);
            matrix.drawPixel( x - 1, y + 1, baddie_color2);
            matrix.drawPixel( x + 1, y + 0, baddie_color2);
            break;
          case 2:   matrix.drawPixel( x + 0, y - 1, matrix.Color444(1, 2, 2));
            matrix.drawPixel( x + 0, y + 0, baddie_color2);
            matrix.drawPixel( x + 1, y + 1, baddie_color2);
            break;
          case 3:   matrix.drawPixel( x + 0, y - 1, matrix.Color444(1, 2, 2));
            matrix.drawPixel( x + 0, y + 0, baddie_color2);
            matrix.drawPixel( x + 1, y + 1, baddie_color2);
            break;
          case 4:   matrix.drawPixel( x + 0, y - 1, matrix.Color444(1, 2, 2));
            matrix.drawPixel( x + 0, y + 0, baddie_color2);
            matrix.drawPixel( x - 1, y + 1, baddie_color2);
            matrix.drawPixel( x + 1, y + 1, baddie_color2);
            break;
          case 5:   matrix.drawPixel( x + 0, y - 1, matrix.Color444(1, 2, 2));
            matrix.drawPixel( x + 0, y + 0, baddie_color2);
            matrix.drawPixel( x - 1, y + 1, baddie_color2);
            matrix.drawPixel( x + 1, y + 1, baddie_color2);
            break;
        }
        break;

    } // switch baddieAppearance
    if (baddieAnimFrame[i] == 4) {
      baddieAnimFrame[i] = 0;
    } else {
      baddieAnimFrame[i]++;
    }
    if (disturberAnimFrame[i] == 6) {
      disturberAnimFrame[i] = 0;
    } else {
      disturberAnimFrame[i]++;
    }
  }
}

void clearBaddie(byte i)
{
  for (int x = baddie_x[i] - 1; x < baddie_x[i] + 3; x++)
  {
    for (int y = baddie_y[i] - 1; y < baddie_y[i] + 3; y++)
    {
      matrix.drawPixel(x, y, framebuffer[x][y]);
    }
  }

  for (int x = baddie_old_x[i] - 1; x < baddie_old_x[i] + 3; x++)
  {
    for (int y = baddie_old_y[i] - 1; y < baddie_old_y[i] + 3; y++)
    {
      matrix.drawPixel(x, y, framebuffer[x][y]);
    }
  }
}

void setBaddieType0DirAndPos(byte i)
{
  if (!baddie_active[i]) {
    return;
  }
  //Serial.print("\nsetBaddieType0DirAndPos");

  // Determine direction
  boolean dirFound = false;
  byte dir = 0;
  do
  {
    dir = random(1, 5);
    if      ((dir == UP) && (bat_active[UPPER_BAT])) {
      dirFound = true;
    }
    else if ((dir == DOWN) && (bat_active[LOWER_BAT])) {
      dirFound = true;
    }
    else if ((dir == LEFT) && (bat_active[LEFT_BAT]))  {
      dirFound = true;
    }
    else if ((dir == RIGHT) && (bat_active[RIGHT_BAT])) {
      dirFound = true;
    }
  }
  while (!dirFound);
  baddieDir[i] = dir;

  // Find a suitable position
  // Preferred positions first
  boolean found = false;
  if (dir == UP)
  {
    byte y = 29;
    do
    {
      if (isBrick(bat_pos[UPPER_BAT], y)) {
        baddie_x[i] = max(4, min(27, bat_pos[UPPER_BAT] + 1));
        baddie_y[i] = y;
        found = true;
      };
      y--;
    }
    while ((!found) && (y > 10));

    if (!found) {
      setAlternatePosition();  // We need to find another position
    }
  } // dir = UP
  else if (dir == DOWN)
  {
    byte y = 2;
    do
    {
      if (isBrick(bat_pos[LOWER_BAT], y)) {
        baddie_x[i] = max(4, min(27, bat_pos[LOWER_BAT] + 1));
        baddie_y[i] = y;
        found = true;
      };
      y++;
    }
    while ((!found) && (y < 21));
    if (!found) {
      setAlternatePosition();  // We need to find another position
    }
  } // dir = UP
  else if (dir == LEFT)
  {
    byte x = 29;
    do
    {
      if (isBrick(x, bat_pos[LEFT_BAT])) {
        baddie_y[i] = max(4, min(27, bat_pos[LEFT_BAT] + 1));
        baddie_x[i] = x;
        found = true;
      };
      x--;
    }
    while ((!found) && (x > 10));
    if (!found) {
      setAlternatePosition();  // We need to find another position
    }
  } // dir = LEFT
  else if (dir == RIGHT)
  {
    byte x = 2;
    do
    {
      if (isBrick(x, bat_pos[RIGHT_BAT])) {
        baddie_y[i] = max(4, min(27, bat_pos[RIGHT_BAT] + 1));
        bat_pos[RIGHT_BAT] + 1;
        baddie_x[i] = x;
        found = true;
      };
      x++;
    }
    while ((!found) && (x < 21));
    if (!found) {
      setAlternatePosition();  // We need to find another position
    }
  } // dir = RIGHT
}

void setAlternatePosition()
{
  if (!baddie_active[i]) {
    return;
  }

  byte i = 0;
  byte j = 0;
  boolean found = false;
  do
  {
    if (i < 10) {
      i++;
    }
    else {
      i = 0;
      if (j < 15) {
        j++;
      }
    }

    if (playfield[i * 3 + 1][j * 2 + 1] == EMPTY)
    {
      baddie_x[i] = max(4, min(27, i * 3 + 2));
      baddie_y[i] = max(4, min(27, j * 2 + 2));
      found = true;
    }
  }
  while ((!found) && (j < 15));

  // Last resort if a suitable position for the baddie could not be found
  if (!found) {
    baddie_x[i] = 15;
    baddie_y[i] = 15;
  }
}

boolean isBrick(int x, int y)
{
  int e = playfield[x][y];
  if (    (e == UNUSED_BRICK) || (e == RED_BRICK) || (e == BLUE_BRICK) || (e == GREEN_BRICK) ||
          (e == YELLOW_BRICK) ||  (e == VIOLET_BRICK) || (e == ORANGE_BRICK)  ) {
    return true;
  }
  return false;
}

// Creates a new baddie of random appearance and type.
// The baddie requires a space of max. 3x3 pixels.
void makeBaddie(byte i)
{
  do
  {
    baddie_type[i] = random(0, 3);
  }
  while ( (baddie_type[i] == lastBaddieTypeMade) ||
          ( (waitingForUserStart || baddieType2InGame ) && (baddie_type[i] == DISTURBER)) );

  lastBaddieTypeMade = baddie_type[i];
  baddieAnimFrame[i] = 0;
  baddieAppearAnimFrame[i] = 0;
  baddieExplodeAnimFrame[i] = 0;

  switch (baddie_type[i])
  {
    case KAMIKAZE:
      setBaddieType0DirAndPos(i);
      baddie_appearance[i] = KAMIKAZE;
      baddieTimer[i] = millis();
      emitSound(BADDIE_APPEAR);
      break;

    case RANDOM_WALK:
      placeBaddie(i);
      baddie_appearance[i] = RANDOM_WALK;
      baddieDir[i] = random(4);
      baddie_nextWaypointX[i] = baddie_x[i];
      baddie_nextWaypointY[i] = baddie_y[i];
      baddieTimer[i] = millis();
      emitSound(BADDIE_APPEAR);
      break;

    case DISTURBER:
      placeBaddie(i);
      baddie_appearance[i] = DISTURBER;
      baddie_nextWaypointX[i] = baddie_x[i];
      baddie_nextWaypointY[i] = baddie_y[i];
      baddieType2InGame = true;
      baddieTimer[i] = millis();
      emitSound(BADDIE_APPEAR);
      break;
  }
}

void placeBaddie(byte i)
{
  boolean destinationEmpty;
  boolean placeUsed;
  byte x = 0;
  byte y = 0;
  do
  {
    x = random(5, 24);
    y = random(5, 24);
    destinationEmpty =  (playfield[x][y] == EMPTY) && (playfield[x - 1][y - 1] == EMPTY) && (playfield[x + 1][y - 1] == EMPTY) &&
                        (playfield[x - 1][y + 1] == EMPTY) && (playfield[x + 1][y + 1] == EMPTY);

    placeUsed = ( ( (baddie_active[0]) && (abs(baddie_x[0] - x) < 3) && (abs(baddie_y[0] - y) < 3)) ||
                  ( (baddie_active[1]) && (abs(baddie_x[1] - x) < 3) && (abs(baddie_y[1] - y) < 3)) ||
                  ( (baddie_active[2]) && (abs(baddie_x[2] - x) < 3) && (abs(baddie_y[2] - y) < 3)) ||
                  ( (baddie_active[3]) && (abs(baddie_x[3] - x) < 3) && (abs(baddie_y[3] - y) < 3)) );

  }
  while ((!destinationEmpty) || placeUsed);

  baddie_x[i] = x;
  baddie_y[i] = y;
  baddie_old_x[i] = baddie_x[i];
  baddie_old_y[i] = baddie_y[i];
}

void clearBaddies()
{
  for (byte i = 0; i < 4; i++) {
    if (baddie_active[i]) {
      clearBaddie(i);
    }
  }
}

boolean canBaddieMove(byte i, byte dir)
{
  if (!baddie_active[i]) {
    return 0;
  }

  // i: this baddie
  // j other baddies
  switch (dir)
  {
    case LEFT:     for (byte j = 0; j < 4; j++)
      {
        if ((j != i) && (baddie_active[j]))
        {
          if ((baddie_x[j] == baddie_x[i] - 4) && (abs(baddie_y[j] - baddie_y[i]) < 4)) {
            return false;
          }
        }
      }
      break;

    case RIGHT:   for (byte j = 0; j < 4; j++)
      {
        if ((j != i) && (baddie_active[j]))
        {
          if ((baddie_x[j] == baddie_x[i] + 4) && (abs(baddie_y[j] - baddie_y[i]) < 4)) {
            return false;
          }
        }
      }
      break;

    case UP:      for (byte j = 0; j < 4; j++)
      {
        if ((j != i) && (baddie_active[j]))
        {
          if ((abs(baddie_x[j] - baddie_x[i]) < 4) && (baddie_y[j] == baddie_y[i] - 4)) {
            return false;
          }
        }
      }
      break;

    case DOWN:    for (byte j = 0; j < 4; j++)
      {
        if ((j != i) && (baddie_active[j]))
        {
          if ((abs(baddie_x[j] - baddie_x[i]) < 4) && (baddie_y[j] == baddie_y[i] + 4)) {
            return false;
          }
        }
      }
      break;
  }
  return true;
}

void setBaddieType1Pos(byte i)
{
  if (!baddie_active[i]) {
    return;
  }

  if (baddie_x[i] >= baddie_nextWaypointX[i])
  {
    if ((playfield[baddie_x[i] - 2][baddie_y[i]] == EMPTY) && (canBaddieMove(i, LEFT)) ) {
      baddie_x[i]--;
      baddieCouldMoveX = true;
    }
  }
  else
  {
    if ((playfield[baddie_x[i] + 2][baddie_y[i]] == EMPTY) && (canBaddieMove(i, RIGHT))) {
      baddie_x[i]++;
      baddieCouldMoveX = true;
    }
  }

  if (baddie_y[i] >= baddie_nextWaypointY[i])
  {
    if ((playfield[baddie_x[i]][baddie_y[i] - 2] == EMPTY) && (canBaddieMove(i, UP))) {
      baddie_y[i]--;
      baddieCouldMoveY = true;
    }
  }
  else
  {
    if ((playfield[baddie_x[i]][baddie_y[i] + 2] == EMPTY) && (canBaddieMove(i, DOWN))) {
      baddie_y[i]++;
      baddieCouldMoveY = true;
    }
  }
}

void setBaddieType2Pos(byte i)
{
  if (!baddie_active[i]) {
    return;
  }

  if (baddie_x[i] >= ball_x[0])
  {
    if ((playfield[baddie_x[i] - 2][baddie_y[i]] == EMPTY) && (canBaddieMove(i, LEFT)) )
    {
      baddieDir[i] = LEFT;
      baddie_x[i]--;
      baddieCouldMoveX = true;
    }
    else if ((playfield[baddie_x[i] + 2][baddie_y[i]] == EMPTY) && (canBaddieMove(i, RIGHT)))
    {
      baddieDir[i] = RIGHT;
      baddie_x[i]++;
      baddieCouldMoveX = true;
    }
    else
    {
      baddieCouldMoveX = false;
    }
  }
  if (baddie_y[i] >= ball_y[0])
  {
    if ((playfield[baddie_x[i]][baddie_y[i] - 2] == EMPTY) && (canBaddieMove(i, UP)))
    {
      baddie_y[i]--;
      baddieCouldMoveY = true;
    }
    else if ((playfield[baddie_x[i]][baddie_y[i] + 2] == EMPTY) && (canBaddieMove(i, DOWN)))
    {
      baddie_y[i]++;
      baddieCouldMoveY = true;
    }
    else
    {
      baddieCouldMoveY = false;
    }
  }
}

void moveBaddies()
{
  if (!gameGoing)
  {
    return;
  }

  baddieCouldMoveX = false;
  baddieCouldMoveY = false;

  baddieTimeInkrement++;
  if (baddieTimeInkrement == 12) {
    baddieTimeInkrement = 0;
  }

  for (byte i = 0; i < 4; i++)
  {
    if (baddie_active[i])
    {
      clearBaddie(i);

      if ((!baddieAppear[i]) && (!baddieExplode[i]) && (!baddieDisappear[i])) // Do not move baddie while it is appearing
      {
        switch (baddie_type[i])
        {
          case KAMIKAZE:
            if      (baddieDir[i] == UP) {
              baddie_y[i]--;
            }
            else if (baddieDir[i] == DOWN) {
              baddie_y[i]++;
            }
            else if (baddieDir[i] == LEFT) {
              baddie_x[i]--;
            }
            else if (baddieDir[i] == RIGHT) {
              baddie_x[i]++;
            }
            checkBaddieCollision(i, baddie_type[i]);
            break;

          case RANDOM_WALK:

            // Moves from waypoint to waypoint. If it encounters an obstacle, selects a new waypoint
            // If near a bat, it moves onto it with medium probability
            baddieCouldMoveX = false;
            baddieCouldMoveY = false;

            if (baddieTimeInkrement % 5 == 0) // For time delay only
            {
              if ((baddie_x[i] != baddie_nextWaypointX[i]) && (baddie_y[i] != baddie_nextWaypointY[i]))
              {
                setBaddieType1Pos(i);
              } // baddie has not yet reached the intended waypoint

              if (((baddie_x[i] == baddie_nextWaypointX[i]) && (baddie_y[i] == baddie_nextWaypointY[i])) // Waypoint arrived - select a new waypoint
                  || ((!baddieCouldMoveY) && (!baddieCouldMoveX)) )
              {
                byte r = random(0, 3);
                // If baddie is near a bat, move towards it with medium probability
                if      ((r == 0) && (abs(baddie_x[i] - bat_pos[UPPER_BAT]) < 8) && (baddie_y[i] - 2 < 8)) {
                  baddie_nextWaypointX[i] = bat_pos[UPPER_BAT];
                  baddie_nextWaypointY[i] = 2;
                }
                else if ((r == 0) && (abs(baddie_x[i] - bat_pos[LOWER_BAT]) < 8) && (30 - baddie_y[i] < 8)) {
                  baddie_nextWaypointX[i] = bat_pos[LOWER_BAT];
                  baddie_nextWaypointY[i] = 29;
                }
                else if ((r == 0) && (abs(baddie_y[i] - bat_pos[LEFT_BAT]) < 8) && (baddie_x[i] - 2 < 8)) {
                  baddie_nextWaypointX[i] = 2;
                  baddie_nextWaypointY[i] = bat_pos[LEFT_BAT];
                }
                else if ((r == 0) && (abs(baddie_y[i] - bat_pos[RIGHT_BAT]) < 8) && (30 - baddie_x[i] < 8)) {
                  baddie_nextWaypointX[i] = 29;
                  baddie_nextWaypointY[i] = bat_pos[RIGHT_BAT];
                }
                else // ...otherwise, select a random waypoint
                {
                  if (random(0, 2) == 0) {
                    baddie_nextWaypointX[i] = baddie_x[i];
                  }
                  else {
                    baddie_nextWaypointX[i] = random(3, 29);
                  }
                  if (random(0, 2) == 0) {
                    baddie_nextWaypointY[i] = baddie_y[i];
                  }
                  else {
                    baddie_nextWaypointY[i] = random(3, 29);
                  }
                }
              }
            }
            break;

          case DISTURBER: // Walks towards ball zero

            // Moves from waypoint to waypoint. If it encounters an obstacle, selects a new waypoint
            // If near a bat, it moves onto it with medium probability
            baddieCouldMoveX = false;
            baddieCouldMoveY = false;

            if (baddieTimeInkrement % 3 == 0) // For time delay only
            {
              if ((baddie_x[i] != baddie_nextWaypointX[i]) && (baddie_y[i] != baddie_nextWaypointY[i]))
              {
                setBaddieType1Pos(i);
              } // baddie has not yet reached the intended waypoint

              if (((baddie_x[i] == baddie_nextWaypointX[i]) && (baddie_y[i] == baddie_nextWaypointY[i])) // Waypoint arrived - select a new waypoint
                  || ((!baddieCouldMoveY) && (!baddieCouldMoveX)) )
              {
                // If baddie is near the ball, move towards it
                if      ( ((abs(baddie_x[i] - ball_x[0]) < 24) && (baddie_y[i] - ball_y[0] < 24)) )
                {
                  baddie_nextWaypointX[i] = ball_x[0];
                  baddie_nextWaypointY[i] = ball_y[0];
                }
                else // select a random waypoint
                {
                  baddie_nextWaypointX[i] = random(3, 29);
                  baddie_nextWaypointY[i] = random(3, 29);
                }
              }
            }
            break;
        }
      }

      if (baddie_active[i]) {
        drawBaddie(i);
      }
    }
    else // Baddie i is inactive and may be recycled
    {
      if (random(0, max(100, (gameMode+1)*(400 - 1.5*arena))) == 10)
      {
        baddie_active[i] = true;
        makeBaddie(i);
        baddieAppear[i] = true;
        baddieExplode[i] = false;
        baddieDisappear[i] = false;
      }
    }
  } // for
}

void checkBallCollidedWithBaddie(byte i)
{
  if (!ball_active[i]) {
    return;
  }

  // i - index of ball
  // j - index of one of the baddies
  byte j = 0;
  do
  {
    if ((baddie_active[j]) && (!baddieAppear[j]) && (!baddieDisappear[j]) && (!baddieExplode[j]))
    {
      if  ((abs((int) ball_x[i] - baddie_x[j]) < 2) && (abs((int) ball_y[i] - baddie_y[j]) < 2))
      {
        emitSound(BADDIE_REBOUND);

        int r = random(0, 8);
        if (r == 0)       {
          ball_moveAngle[i] = 30;
        }
        else if (r == 1)  {
          ball_moveAngle[i] = 60;
        }
        else if (r == 2)  {
          ball_moveAngle[i] = 120;
        }
        else if (r == 3)  {
          ball_moveAngle[i] = 150;
        }
        else if (r == 4)  {
          ball_moveAngle[i] = 210;
        }
        else if (r == 5)  {
          ball_moveAngle[i] = 240;
        }
        else if (r == 6)  {
          ball_moveAngle[i] = 300;
        }
        else if (r == 7)  {
          ball_moveAngle[i] = 330;
        }

        if       ((ball_moveAngle[i] >= 0) && (ball_moveAngle[i] < 180))
        {
          ball_moveAngle[i] = max(20, min(339, 180 + ball_moveAngle[i] + random(0, 6) - 10));
        }
        else if  ((ball_moveAngle[i] >= 180) && (ball_moveAngle[i] <= 360))
        {
          ball_moveAngle[i] = max(20, min(339, ball_moveAngle[i] - 180 + random(0, 6) - 10));
        }

        ball_vector_x[i] = getInkrement_x(ball_moveAngle[i]) * abs(calcMoveAngle_x(min(360, ball_moveAngle[i])));
        ball_vector_y[i] = getInkrement_y(ball_moveAngle[i]) * abs(calcMoveAngle_y(min(360, ball_moveAngle[i])));
      }
    }
    j++;
  }
  while ((!ballReflected[i]) && (j < 4));
}



// ----------------------------- Bonus Items ------------------------------------


void makeNewBonusObject(int x, int y)
{
  if ((x <= 3) || (y <= 3) || (x > 28) || (y > 28))  {
    return;
  }

  bonus_x = x;
  bonus_y = y;
  bonus_pathIndex = 0;
  bonus_currentBorder = -1;
  bonus_nextBorder = -1;
  bonusObjectFlying = true;
  bonusDisappear = false;
  bonus_mode = BONUS_FRESH;
  bonusAppearance = random(0, 4);
  bonusTimer = millis();
  bonusAnimFrame = 0;

  emitSound(THROWBONUS);
}

void moveBonusObject()
{
  if (!gameGoing) {
    return;
  }

  if (bonusObjectFlying)
  {
    if (millis() - bonusTimer >= 15000)
    {
      clearBonusObject(bonus_x, bonus_y);
      bonusDisappear = true;
      drawBonusObject(bonus_x + next_move_x, bonus_y + next_move_y);
    }
    else
    {
      clearBonusObject(bonus_x, bonus_y);
      getNextMovement(next_move_x, next_move_y);
      drawBonusObject(bonus_x + next_move_x, bonus_y + next_move_y);

      bonus_x += next_move_x;
      bonus_y += next_move_y;
    }
  }
}

void clearBonusObject(int x, int y)
{
  for (int i = x - 1; i < x + 4; i++)
  {
    for (int j = y - 1; j < y + 4; j++)
    {
      matrix.drawPixel(i, j, framebuffer[i][j]);
    }
  }
}

void drawBonusObject(int x, int y)
{
  if (!bonusObjectFlying) { return; }
  
  int col1;
  int col2;
  int col3;

  if (!bonusDisappear)
  {
    switch (bonusAppearance)
    {
      case GRAPE:     if (animCounter % 5 == 0) {
          col1 = matrix.Color444(10, 10, 10);
          col2 = matrix.Color444(10, 10, 10);
          col3 = matrix.Color444(10, 10, 10);
        }
        else {
          col1 = matrix.Color444(11, 0, 10);
          col2 = matrix.Color444(9, 0, 8);
          col3 = matrix.Color444(0, 10, 0);
        };
        matrix.fillRect(x, y, 2, 2, col1);
        matrix.drawPixel(x, y + 1, col2);
        matrix.drawPixel(x + 1, y - 1, col3);
        break;

      case BANANA:    if (animCounter % 5 == 0) {
          col1 = matrix.Color444(10, 10, 10);
          col2 = matrix.Color444(10, 10, 10);
          col3 = matrix.Color444(10, 10, 10);
        }
        else {
          col1 = matrix.Color444(11, 12, 2);
          col2 = matrix.Color444(11, 12, 1);
          col3 = matrix.Color444(11, 12, 0);
        };
        matrix.drawPixel(x, y, col1);
        matrix.drawPixel(x + 1, y + 1, col2);
        matrix.drawPixel(x + 1, y + 2, col3);
        break;

      case CHERRY:    if (animCounter % 5 == 0) {
          col1 = matrix.Color444(10, 10, 10);
          col2 = matrix.Color444(10, 10, 10);
          col3 = matrix.Color444(10, 10, 10);
        }
        else {
          col1 = matrix.Color444(2, 7, 0);
          col2 = matrix.Color444(13, 0, 0);
          col3 = matrix.Color444(15, 0, 0);
        };
        matrix.drawPixel(x + 2, y, col1);
        matrix.drawPixel(x + 1, y + 1, col1);
        matrix.drawPixel(x, y + 2, col2);
        matrix.drawPixel(x + 1, y + 2, col3);
        break;

      case APPLE:     if (animCounter % 5 == 0) {
          col1 = matrix.Color444(10, 10, 10);
          col2 = matrix.Color444(10, 10, 10);
          col3 = matrix.Color444(10, 10, 10);
        }
        else {
          col1 = matrix.Color444(2, 7, 0);
          col2 = matrix.Color444(11, 0, 11);
          col3 = matrix.Color444(4, 0, 2);
        };
        matrix.drawPixel(x + 1, y, col1);
        matrix.drawPixel(x, y + 1, col2);
        matrix.drawPixel(x + 1, y + 1, col2);
        matrix.drawPixel(x + 2, y + 1, col2);
        matrix.drawPixel(x, y + 2, col3);
        matrix.drawPixel(x + 1, y + 2, col2);
        matrix.drawPixel(x + 2, y + 2, col3);
        break;
    }
  }
  else // Show object vanishing animation
  {
    switch (bonusAnimFrame)
    {
      case 0: matrix.drawPixel(x, y, matrix.Color444(15, 15, 10)); break;
      case 1: matrix.drawPixel(x + 1, y + 1, matrix.Color444(3, 3, 8)); break;
      case 2: matrix.drawPixel(x + 2, y, matrix.Color444(15, 15, 10)); break;
      case 3: matrix.drawPixel(x + 1, y + 1, matrix.Color444(3, 3, 8)); break;
      case 4: matrix.drawPixel(x + 2, y + 2, matrix.Color444(15, 15, 10)); break;
      case 5: matrix.drawPixel(x + 1, y + 1, matrix.Color444(3, 3, 8)); break;
      case 6: matrix.drawPixel(x, y + 2, matrix.Color444(15, 15, 10)); break;
      case 7: matrix.drawPixel(x + 1, y + 1, matrix.Color444(3, 3, 8)); break;
      case 8: bonusObjectFlying = false; bonus_x = 35; bonus_y = 35; break;
    }
    bonusAnimFrame++;
  }
}

// Fills variables next_x and next_y with the next movement steps
void getNextMovement(int &next_x, int &next_y)
{
  switch (bonus_mode)
  {
    case BONUS_FRESH:             setNewTrajectory(BONUS_EMERGE);
      break;

    case BONUS_EMERGE:            if (bonus_pathIndex == bonus_lastIndex + 1) {
        setNewTrajectory(BONUS_MOVING_TO_MIDDLE);
      };
      break;

    case BONUS_MOVING_TO_MIDDLE:  if ((abs(bonus_x - 15) <= 3) && (abs(bonus_y - 15) <= 3))
      {
        //Serial.print("\nIN MIDDLE");

        bonus_nextBorder = random(0, 4);
        switch (bonus_nextBorder)
        {
          case 0: setNewTrajectory(BONUS_MOVING_LEFT); bonus_currentBorder = GO_LEFT; break;
          case 1: setNewTrajectory(BONUS_MOVING_RIGHT); bonus_currentBorder = GO_RIGHT; break;
          case 2: setNewTrajectory(BONUS_MOVING_UP); bonus_currentBorder = GO_UP; break;
          case 3: setNewTrajectory(BONUS_MOVING_DOWN); bonus_currentBorder = GO_DOWN; break;
        };
      }
      else
      {
        byte c = random(0, 2);
        switch (c)
        {
          case 0: if (bonus_x >= 15) {
              //Serial.print("\nnach links");
              bonus_trajectory_x = bonusOneLeft_x;
              bonus_trajectory_y = bonusOneLeft_y;
              bonus_pathIndex = 0;
            }
            else {
              //Serial.print("\nnach rechts");
              bonus_trajectory_x = bonusOneRight_x;
              bonus_trajectory_y = bonusOneRight_y;
              bonus_pathIndex = 0;
            }
            break;
          case 1: if (bonus_y >= 15) {
              //Serial.print("\nnach oben");
              bonus_trajectory_x = bonusOneUp_x;
              bonus_trajectory_y = bonusOneUp_y;
              bonus_pathIndex = 0;
            }
            else {
              //Serial.print("\nnach unten");
              bonus_trajectory_x = bonusOneDown_x;
              bonus_trajectory_y = bonusOneDown_y;
              bonus_pathIndex = 0;
            }
            break;
        };
      }
      break;

    case BONUS_MOVING_LEFT:       if (bonus_x <= bonus_leftBoundary)
      {
        chooseNextBorder();
      }
      else if (bonus_pathIndex == bonus_lastIndex + 1) {
        setNewTrajectory(BONUS_MOVING_LEFT);
      };
      break;

    case BONUS_MOVING_RIGHT:      if (bonus_x >= bonus_rightBoundary)
      {
        chooseNextBorder();
      }
      else if (bonus_pathIndex == bonus_lastIndex + 1) {
        setNewTrajectory(BONUS_MOVING_RIGHT);
      };

      break;
    case BONUS_MOVING_UP:         if (bonus_y <= bonus_upperBoundary)
      {
        chooseNextBorder();
      }
      else if (bonus_pathIndex == bonus_lastIndex + 1) {
        setNewTrajectory(BONUS_MOVING_UP);
      };
      break;

    case BONUS_MOVING_DOWN:       if (bonus_y >= bonus_lowerBoundary)
      {
        chooseNextBorder();
      }
      else if (bonus_pathIndex == bonus_lastIndex + 1) {
        setNewTrajectory(BONUS_MOVING_DOWN);
      };
      break;

    case BONUS_MOVING_NE:         if ((bonus_x >= bonus_rightBoundary) || (bonus_y <= bonus_upperBoundary)) {
        chooseNextBorder();
      }
      else if (bonus_pathIndex == bonus_lastIndex + 1) {
        setNewTrajectory(BONUS_MOVING_NE);
      };
      break;

    case BONUS_MOVING_NW:         if ((bonus_x <= bonus_leftBoundary) || (bonus_y <= bonus_upperBoundary)) {
        chooseNextBorder();
      }
      else if (bonus_pathIndex == bonus_lastIndex + 1) {
        setNewTrajectory(BONUS_MOVING_NW);
      };
      break;

    case BONUS_MOVING_SE:         if ((bonus_y >= bonus_lowerBoundary) || (bonus_x >= bonus_rightBoundary)) {
        chooseNextBorder();
      }
      else if (bonus_pathIndex == bonus_lastIndex + 1) {
        setNewTrajectory(BONUS_MOVING_SE);
      };
      break;

    case BONUS_MOVING_SW:         if ((bonus_y >= bonus_lowerBoundary) || (bonus_x <= bonus_leftBoundary)) {
        chooseNextBorder();
      }
      else if (bonus_pathIndex == bonus_lastIndex + 1) {
        setNewTrajectory(BONUS_MOVING_SW);
      };
      break;

  } // switch bonus movement mode

  // Read next relative movement. Get it from the current trajectory
  next_x = *(bonus_trajectory_x + bonus_pathIndex);
  next_y = *(bonus_trajectory_y + bonus_pathIndex);

  bonus_pathIndex++;
}

void chooseNextBorder()
{
  byte d = random(0, 2);

  // In case the bonus item has passed one of the borders, make this border the current one
  if (bonus_y <= bonus_upperBoundary) {
    bonus_currentBorder = GO_UP;
  }
  else if (bonus_y >= bonus_lowerBoundary) {
    bonus_currentBorder = GO_DOWN;
  }
  else if (bonus_x <= bonus_leftBoundary) {
    bonus_currentBorder = GO_LEFT;
  }
  else if (bonus_x >= bonus_rightBoundary) {
    bonus_currentBorder = GO_RIGHT;
  }

  switch (bonus_currentBorder)
  {
    case UP: if (d == 0) {
        bonus_nextBorder = GO_LEFT;
      } else {
        bonus_nextBorder = GO_RIGHT;
      }; break;
    case DOWN: if (d == 0) {
        bonus_nextBorder = GO_LEFT;
      } else {
        bonus_nextBorder = GO_RIGHT;
      }; break;
    case LEFT: if (d == 0) {
        bonus_nextBorder = GO_UP;
      } else {
        bonus_nextBorder = GO_DOWN;
      }; break;
    case RIGHT: if (d == 0) {
        bonus_nextBorder = GO_UP;
      } else {
        bonus_nextBorder = GO_DOWN;
      }; break;
  }

  if      ((bonus_currentBorder == GO_LEFT) && (bonus_nextBorder == GO_UP)) {
    setNewTrajectory(BONUS_MOVING_NE);
  }
  else if ((bonus_currentBorder == GO_DOWN) && (bonus_nextBorder == GO_RIGHT)) {
    setNewTrajectory(BONUS_MOVING_NE);
  }
  else if ((bonus_currentBorder == GO_UP) && (bonus_nextBorder == GO_LEFT)) {
    setNewTrajectory(BONUS_MOVING_SW);
  }
  else if ((bonus_currentBorder == GO_RIGHT) && (bonus_nextBorder == GO_DOWN)) {
    setNewTrajectory(BONUS_MOVING_SW);
  }
  else if ((bonus_currentBorder == GO_LEFT) && (bonus_nextBorder == GO_DOWN)) {
    setNewTrajectory(BONUS_MOVING_SE);
  }
  else if ((bonus_currentBorder == GO_UP) && (bonus_nextBorder == GO_RIGHT)) {
    setNewTrajectory(BONUS_MOVING_SE);
  }
  else if ((bonus_currentBorder == GO_DOWN) && (bonus_nextBorder == GO_LEFT)) {
    setNewTrajectory(BONUS_MOVING_NW);
  }
  else if ((bonus_currentBorder == GO_RIGHT) && (bonus_nextBorder == GO_UP)) {
    setNewTrajectory(BONUS_MOVING_NW);
  }
}

void setNewTrajectory(int mode)
{
  byte r;
  //byte c;

  bonus_mode = mode;
  bonus_pathIndex = 0;

  switch (mode)
  {
    case BONUS_EMERGE:            r = random(0, 2);
      //Serial.print("\nEMERGE");
      switch (r)
      {
        case 0: bonus_trajectory_x = spiral1_x; bonus_trajectory_y = spiral1_y; bonus_lastIndex = 23; break;
        case 1: bonus_trajectory_x = spiral2_x; bonus_trajectory_y = spiral2_y; bonus_lastIndex = 27; break;
      }
      break;

    case BONUS_MOVING_TO_MIDDLE:      //Serial.print("\nMOVING TO MIDDLE");


      break;

    case BONUS_MOVING_LEFT:     r = random(0, 2);
      //Serial.print("\nBONUS_MOVING_LEFT");
      switch (r)
      {
        case 0: bonus_trajectory_x = sineL3_x; bonus_trajectory_y = sineL3_y; bonus_lastIndex = 7; break;
        case 1: bonus_trajectory_x = sineL2_x; bonus_trajectory_y = sineL2_y; bonus_lastIndex = 6; break;
      }
      break;
    case BONUS_MOVING_RIGHT:    r = random(0, 4);
      //Serial.print("\nBONUS_MOVING_RIGHT");
      switch (r)
      {
        case 0: bonus_trajectory_x = sineR1_x; bonus_trajectory_y = sineR1_y; bonus_lastIndex = 12; break; // 0up
        case 1: bonus_trajectory_x = sineR2_x; bonus_trajectory_y = sineR2_y; bonus_lastIndex = 11; break; // 4up
        case 2: bonus_trajectory_x = sineR3_x; bonus_trajectory_y = sineR3_y; bonus_lastIndex = 5; break;  // 3up
        case 3: bonus_trajectory_x = sineR4_x; bonus_trajectory_y = sineR4_y; bonus_lastIndex = 19; break; // 0up
      }
      break;

    case BONUS_MOVING_UP:          bonus_trajectory_x = sineU1_x; bonus_trajectory_y = sineU1_y; bonus_lastIndex = 8; break;


    case BONUS_MOVING_DOWN:        bonus_trajectory_x = sineD1_x; bonus_trajectory_y = sineD1_y; bonus_lastIndex = 7; break;

    case BONUS_MOVING_NE:          bonus_trajectory_x = sineNE_x; bonus_trajectory_y = sineNE_y; bonus_lastIndex = 12; break;
    case BONUS_MOVING_NW:          bonus_trajectory_x = sineNW_x; bonus_trajectory_y = sineNW_y; bonus_lastIndex = 15; break;
    case BONUS_MOVING_SE:          bonus_trajectory_x = sineSE_x; bonus_trajectory_y = sineSE_y; bonus_lastIndex = 14; break;
    case BONUS_MOVING_SW:          bonus_trajectory_x = sineSW_x; bonus_trajectory_y = sineSW_y; bonus_lastIndex = 13; break;
  }
}

// Checks whether one of the bats has collided with the active bonus item
boolean checkBatBonusCollision()
{
  if (!gameGoing)
  {
    collidedBat = NONE;
    return false;
  }

  int ox = bonus_x;
  int oy = bonus_y;
  int bx = 0;
  int by = 0;

  // Check lower bat
  if (bat_active[LOWER_BAT])
  {
    bx = bat_pos[LOWER_BAT];
    by = LOWER_BAT_HEIGHT;
    if ((bx + 3 >= ox) && (bx <= ox - 1) && (by >= oy) && (by <= oy + 3)) {
      collidedBat = LOWER_BAT;
      return true;
    }
  }

  if (bat_active[UPPER_BAT])
  {
    bx = bat_pos[UPPER_BAT];
    by = UPPER_BAT_HEIGHT;
    if ((bx + 3 >= ox) && (bx <= ox - 1) && (by >= oy) && (by <= oy + 3)) {
      collidedBat = UPPER_BAT;
      return true;
    }
  }

  if (bat_active[LEFT_BAT])
  {
    bx = LEFT_BAT_HEIGHT;
    by = bat_pos[LEFT_BAT];
    if ((by + 3 >= oy) && (by <= oy + 2) && (bx >= ox) && (bx <= ox + 3)) {
      collidedBat = LEFT_BAT;
      return true;
    }
  }

  if (bat_active[RIGHT_BAT])
  {
    bx = RIGHT_BAT_HEIGHT;
    by = bat_pos[RIGHT_BAT];
    if ((by + 3 >= oy) && (by <= oy + 2) && (bx >= ox) && (bx <= ox + 3)) {
      collidedBat = RIGHT_BAT;
      return true;
    }
  }

  return false;
}

void repaintBonusBackground()
{
  // Repaint the background behind the image
  for (byte i = 2; i < 31; i++)
  {
    for (byte j = 2; j < 31; j++)
    {
      matrix.drawPixel(i, j, framebuffer[i][j]);
    }
  }
}

void issueBonusAction()
{
  byte d = 60;

  // Returns the bat that has collected the bonus item (UPPER_BAT, LOWER_BAT, LEFT_BAT, RIGHT_BAT)
  // Issue one of the actions, respects the player who grabbed the bonus item
  // 0. Additional life
  // 1. Five balls
  // 2. Empty arena -> next arena
  // 3. Reverse joysticks for five seconds
  // 4. Bat can shoot five shots
  // 5. enlarge bats
  // 6. Ball turns havoc (not yet implemented)

  // Choose one among the eight actions. Prefer pleasant ones.
  // Make sure that the new action is not the old one
  byte newAction;

  do
  {
    int r = random(1, 101);
    if ((r > 0) && (r < 34)) {
      newAction = 1;
    }
    if ((r >= 34) && (r < 58)) {
      newAction = 4;
    }
    if ((r >= 58) && (r < 75)) {
      newAction = 2;
    }
    if ((r >= 75) && (r < 88)) {
      newAction = 5;
    }
    if ((r >= 88) && ( r < 95)) {
      newAction = 0;
    }
    if ((r >= 95+gameMode) && (r <= 100)) {
      newAction = 3;
    }
  }
  while (formerAction == newAction);
  formerAction = newAction;
  ongoingBonusAction = true;
  //newAction = 5;
  emitSound(BONUS_APPEAR);

  switch (newAction)
  {
    case 0:   // Additional life
      lives++;
      matrix.fillRect(2, 2, 29, 29, backgroundColor); // 2 2 29 29
      showOneUpImage(8, 10);

      // Play a nice jingle
      tone(audio, NOTE_C5, 70); delay(170);
      tone(audio, NOTE_G4, 50); delay(75);
      tone(audio, NOTE_G4, 50); delay(75);
      tone(audio, NOTE_GS4, 70); delay(170);
      tone(audio, NOTE_G4, 50); delay(370);
      tone(audio, NOTE_B4, 70); delay(185);
      tone(audio, NOTE_C5, 80); delay(215);

      repaintBonusBackground();

      // We need to be fair: the ball must not go off the arena after the image was displayed.
      // Close the open border(s) for some seconds:
      if (gameGoing && borderOpen)
      {
        borderTemporarilyOpen = true;
        closeOpenBorders(true);
        borderOpenTimer = millis();
      }

      break;

    case 1:   // Game with five balls
      for (byte i = 1; i < 5; i++)
      {
        ball_active[i] = true;
        ball_x[i] = ball_x[0];
        ball_y[i] = ball_y[0];
      }
      numActiveBalls = 5;

      // 1  1   2 1   1  2  1  1  2  2  2  1  1  2  1  1 2 1 1 2  2  4
      // D  D   D D   D  D  D  D  G  A  B  D  D  D  D  D D G B A Fis D

      tone(audio, NOTE_D4, 70); delay(80);
      tone(audio, NOTE_D4, 70); delay(80);
      tone(audio, NOTE_D4, 50); delay(160);
      tone(audio, NOTE_D4, 70);  delay(80);
      tone(audio, NOTE_D4, 70); delay(80);
      tone(audio, NOTE_D4, 50); delay(160);
      tone(audio, NOTE_D4, 70); delay(80);
      tone(audio, NOTE_D4, 70); delay(80);
      tone(audio, NOTE_G4, 50); delay(160);
      tone(audio, NOTE_A4, 50);  delay(160);
      tone(audio, NOTE_B4, 70);  delay(160);
      tone(audio, NOTE_D4, 70);  delay(80);
      tone(audio, NOTE_D4, 70); delay(80);
      tone(audio, NOTE_D4, 50);  delay(160);
      tone(audio, NOTE_D4, 70); ; delay(80);
      tone(audio, NOTE_D4, 70); delay(80);
      tone(audio, NOTE_D4, 50); delay(160);
      tone(audio, NOTE_G4, 70); delay(80);
      tone(audio, NOTE_B4, 70);  delay(80);
      tone(audio, NOTE_A4, 70);  delay(160);
      tone(audio, NOTE_FS4, 70); delay(160);
      tone(audio, NOTE_D4, 70); delay(160);

      multipleBallsActive = true;
      bonusActionTimer = millis();

      break;

    case 2:   // Empty the arena
      clearBalls();
      clearBats();
      clearBaddies();

      for (j = 0; j < 15; j++)
      {
        for (i = 0; i < 10; i++)
        {
          if ((playfield[i * 3 + 1][j * 2 + 1] != EMPTY) && (playfield[i * 3 + 1][j * 2 + 1] != SOLID_BRICK))
          {
            for (byte k = 0; k < 5; k++)
            {
              matrix.drawPixel(i * 3 + 1 + random(3), j * 2 + 1 + random(2), backgroundColor);

              for (byte k = 0; k < 10; k++)
              {
                tone(audio, 200 + random(0, 101), 15);
                //tone(audio2, 200+random(0, 101), 15);
              }
            }
            matrix.drawRect(i * 3 + 1, j * 2 + 1, 3, 2, backgroundColor);
            delay(70);
          }
        }
      }

      numBricks = 0;
      ongoingBonusAction = false;
      nextArena = true;

      break;

    case 3:   // Reverse the joystick that caught the bonus item for ten seconds
      matrix.fillRect(2, 2, 29, 29, backgroundColor);
      showJoyRevImage(8, 9);

      // Play a nice jingle
      tone(audio, NOTE_G3, 140); delay(250);
      tone(audio, NOTE_FS2, 140); delay(250);
      tone(audio, NOTE_F2, 140); delay(250);
      tone(audio, NOTE_E2, 140); delay(250);
      tone(audio, NOTE_DS2, 200); delay(400);

      repaintBonusBackground();

      // Close the open border(s) for some seconds:
      if (gameGoing && borderOpen)
      {
        borderTemporarilyOpen = true;
        closeOpenBorders(true);
        borderOpenTimer = millis();
      }

      if ((collidedBat == UPPER_BAT) || (collidedBat == LOWER_BAT))
      {
        joystick1Reversed = true;
      }
      else if ((collidedBat == LEFT_BAT) || (collidedBat == RIGHT_BAT))
      {
        if (onePlayerMode) {
          joystick1Reversed = true;
        } else {
          joystick2Reversed = true;
        }
      }
      bonusActionTimer = millis();
      break;

    case 4:   // The player's bat gets five shots, shoot with fire button
      if      (collidedBat == UPPER_BAT) {
        bat_hasGun[UPPER_BAT] = true;
      }
      else if (collidedBat == LOWER_BAT) {
        bat_hasGun[LOWER_BAT] = true;
      }
      else if (collidedBat == LEFT_BAT)  {
        bat_hasGun[LEFT_BAT] = true;
      }
      else if (collidedBat == RIGHT_BAT) {
        bat_hasGun[RIGHT_BAT] = true;
      }
      batCanShoot = true;
      shotsRemaining = 5;

      tone(audio, NOTE_C4, 4 * d - 40); delay(5 * d);
      tone(audio, NOTE_C4, 2 * d - 65); delay(2 * d - 5);
      tone(audio, NOTE_C4, 2 * d - 65); delay(2 * d - 3);
      tone(audio, NOTE_G4, 5 * d - 50); delay(6 * d);
      tone(audio, NOTE_C4, 2 * d - 60); delay(2 * d);
      tone(audio, NOTE_G4, 2 * d - 68); delay(2 * d - 8);
      tone(audio, NOTE_C5, 2 * d - 66); delay(2 * d - 6);
      tone(audio, NOTE_G4, 2 * d - 64); delay(2 * d - 4);
      tone(audio, NOTE_C4, 2 * d - 62); delay(2 * d - 2);
      tone(audio, NOTE_G4, 2 * d - 60); delay(2 * d - 0);
      tone(audio, NOTE_C5, 2 * d - 58); delay(2 * d + 2);
      tone(audio, NOTE_G4, 2 * d - 56); delay(2 * d + 4);
      tone(audio, NOTE_C4, 2 * d - 54); delay(2 * d + 6);
      tone(audio, NOTE_G4, 2 * d - 52); delay(2 * d + 8);
      tone(audio, NOTE_C5, 2 * d - 50); delay(2 * d + 10);
      tone(audio, NOTE_G4, 8 * d - 48); delay(8 * d + 12);
      
      //animateShot.continue();
      
      break;

    case 5:   // Larger bat
      if      (collidedBat == UPPER_BAT) {
        bat_isEnlarged[UPPER_BAT] = true;
        centerBat(UPPER_BAT);
      }
      else if (collidedBat == LOWER_BAT) {
        bat_isEnlarged[LOWER_BAT] = true;
        centerBat(LOWER_BAT);
      }
      else if (collidedBat == LEFT_BAT)  {
        bat_isEnlarged[LEFT_BAT] = true;
        centerBat(LEFT_BAT);
      }
      else if (collidedBat == RIGHT_BAT) {
        bat_isEnlarged[RIGHT_BAT] = true;
        centerBat(RIGHT_BAT);
      }
      enlargedBat = true;
      bonusActionTimer = millis();
      break;

    case 6:   // Ball turns havoc
      ballTurnedHavoc = true;
      bonusActionTimer = millis();
      break;
  }
}



// --------------- Larger bat -----------------------------------


// Center the enlarged bat at its old location
// Add the two new elements to the left and right with a kaboom
void centerBat(byte bat)
{
  switch (bat)
  {
    case UPPER_BAT:   bat_pos_old[UPPER_BAT] = bat_pos[UPPER_BAT];
      bat_pos[UPPER_BAT] = max(1, min(bat_pos_old[UPPER_BAT] - 1, 25));
      matrix.drawLine(bat_pos[UPPER_BAT] + 1, 1, bat_pos[UPPER_BAT] + 4, 1, bat_color);
      enlargeBat(bat_pos[UPPER_BAT], 1); enlargeBat(bat_pos[UPPER_BAT] + 5, 1);
      break;

    case LOWER_BAT:   bat_pos_old[LOWER_BAT] = bat_pos[LOWER_BAT];
      bat_pos[LOWER_BAT] = max(1, min(bat_pos_old[LOWER_BAT] - 1, 25));
      matrix.drawLine(bat_pos[LOWER_BAT] + 1, 30, bat_pos[LOWER_BAT] + 4, 30, bat_color);
      enlargeBat(bat_pos[LOWER_BAT], 30); enlargeBat(bat_pos[LOWER_BAT] + 5, 30);
      break;
    case LEFT_BAT:    bat_pos_old[LEFT_BAT] = bat_pos[LEFT_BAT];
      bat_pos[LEFT_BAT] = max(1, min(bat_pos_old[LEFT_BAT] - 1, 25));
      matrix.drawLine(1, bat_pos[LEFT_BAT] + 1, 1, bat_pos[LEFT_BAT] + 4, bat_color);
      enlargeBat(1, bat_pos[LEFT_BAT]); enlargeBat(1, bat_pos[LEFT_BAT] + 5);
      break;
    case RIGHT_BAT:   bat_pos_old[RIGHT_BAT] = bat_pos[RIGHT_BAT];
      bat_pos[RIGHT_BAT] = max(1, min(bat_pos_old[RIGHT_BAT] - 1, 25));
      matrix.drawLine(30, bat_pos[RIGHT_BAT] + 1, 30, bat_pos[RIGHT_BAT] + 4, bat_color);
      enlargeBat(30, bat_pos[RIGHT_BAT]); enlargeBat(30, bat_pos[RIGHT_BAT] + 5);
      break;
  }
}

void playEnlargeSound()
{
  tone(audio, NOTE_C1, 30); delay(50);
  tone(audio, NOTE_C2, 20); delay(30);
  tone(audio, NOTE_C3, 20); delay(30);
  tone(audio, NOTE_C4, 20); delay(30);
  tone(audio, NOTE_C5, 20); delay(30);
  tone(audio, NOTE_C6, 20); delay(90);
  tone(audio, NOTE_C1, 90); delay(100);
}

void enlargeBat(byte x, byte y)
{
  int c;
  playEnlargeSound();

  for (byte i = 0; i < 100; i++)
  {
    if (i % 2 == 0) {
      c = matrix.Color444(13, 10, 2);
    } else {
      c = matrix.Color444(10, 3, 2);
    }
    matrix.drawPixel(x, y, c);
  }
  matrix.drawPixel(x, y, bat_color);
  delay(250);
}


// -------------- Player Selection Screens -----------------------


void drawPlayerText(byte i, byte j)
{
  // PLAYER
  int col;
  byte p;

  for (byte x = 0; x < 32; x++)
  {
    for (byte y = 0; y < 8; y++)
    {
      p = pgm_read_byte_near(playerImg + y * 32 + x);

      switch (p)
      {
        case 0:
          col = matrix.Color444(0, 0, 0);
          break;

        case 1:
          col = matrix.Color444(0, 0, 15);
          break;

        case 2:
          col = matrix.Color444(2, 2, 15);
          break;

        case 3:
          //col = matrix.Color444(3, 4, 12);
          col = matrix.Color444(2, 3, 10);
          break;

        case 4:
          col = matrix.Color444(3, 4, 15);
          break;

        case 5:
          col = matrix.Color444(3, 7, 15);
          break;

      }
      matrix.drawPixel(x + i, y + j, col);
    }
  }
}

void drawVSText(byte i, byte j)
{
  int col;
  byte p;

  // VS
  for (byte x = 0; x < 11; x++)
  {
    for (byte y = 0; y < 5; y++)
    {
      p = pgm_read_byte_near(versusImg + y * 11 + x);

      switch (p)
      {
        case 0:
          col = matrix.Color444(0, 0, 0);
          break;

        case 1:
          col = matrix.Color444(0, 0, 15);
          break;

        case 2:
          col = matrix.Color444(2, 2, 15);
          break;

        case 3:
          col = matrix.Color444(3, 7, 12);
          break;

        case 4:
          col = matrix.Color444(3, 4, 15);
          break;

        case 5:
          col = matrix.Color444(3, 7, 15);
          break;

      }
      matrix.drawPixel(x + i, y + j, col);
    }
  }
}

void drawWithText(byte i, byte j)
{
  int col;
  byte p;

  // with
  for (byte x = 0; x < 15; x++)
  {
    for (byte y = 0; y < 6; y++)
    {
      p = pgm_read_byte_near(withImg + y * 15 + x);

      switch (p)
      {
        case 0:
          col = matrix.Color444(0, 0, 0);
          break;

        case 1:
          col = matrix.Color444(0, 0, 15);
          break;

        case 2:
          col = matrix.Color444(2, 2, 15);
          break;

        case 3:
          col = matrix.Color444(3, 10, 15);
          break;

        case 4:
          col = matrix.Color444(1, 0, 13);
          break;

        case 5:
          col = matrix.Color444(1, 2, 12);
          break;

        case 6:
          col = matrix.Color444(1, 6, 13);
          break;

        case 7:
          col = matrix.Color444(0, 0, 7);
          break;
      }
      matrix.drawPixel(x + i, y + j, col);
    }
  }
}

void drawCPUText(byte i, byte j)
{
  int col;
  byte p;

  // CPU
  matrix.fillRect(0, 22, 31, 9, backgroundColor);

  for (byte x = 0; x < 15; x++)
  {
    for (byte y = 0; y < 7; y++)
    {
      p = pgm_read_byte_near(CPUImg + y * 15 + x);

      switch (p)
      {
        case 0:
          col = matrix.Color444(0, 0, 0);
          break;

        case 1:
          col = matrix.Color444(0, 0, 15);
          break;

        case 2:
          col = matrix.Color444(2, 2, 15);
          break;

        case 3:
          //col = matrix.Color444(3, 4, 12);
          col = matrix.Color444(2, 3, 10);
          break;

        case 4:
          col = matrix.Color444(3, 4, 15);
          break;

        case 5:
          col = matrix.Color444(3, 7, 15);
          break;

      }
      matrix.drawPixel(x + i, y + j, col);
    }
  }
}

void drawRelaxText(byte i, byte j)
{
  int col;
  byte p;

  // Relax
  for (byte x = 0; x < 31; x++)
  {
    for (byte y = 0; y < 7; y++)
    {
      p = pgm_read_byte_near(relaxImg + y * 31 + x);

      switch (p)
      {
        case 0:
          col = matrix.Color444(0, 0, 0);
          break;

        case 1:
          col = matrix.Color444(0, 0, 10);
          break;
      }
      matrix.drawPixel(i+x, j+y, col);
    }
  }
}

void drawEasyText(byte i, byte j)
{
  int col;
  byte p;

  // Relax
  for (byte x = 0; x < 25; x++)
  {
    for (byte y = 0; y < 7; y++)
    {
      p = pgm_read_byte_near(easyImg + y * 25 + x);

      switch (p)
      {
        case 0:
          col = matrix.Color444(0, 0, 0);
          break;

        case 1:
          col = matrix.Color444(0, 0, 10);
          break;
      }
      matrix.drawPixel(i+x, j+y, col);
    }
  }
}

void drawWorkText(byte i, byte j)
{
  int col;
  byte p;

  // Relax
  for (byte x = 0; x < 25; x++)
  {
    for (byte y = 0; y < 7; y++)
    {
      p = pgm_read_byte_near(workImg + y * 25 + x);

      switch (p)
      {
        case 0:
          col = matrix.Color444(0, 0, 0);
          break;

        case 1:
          col = matrix.Color444(0, 0, 10);
          break;
      }
      matrix.drawPixel(i+x, j+y, col);
    }
  }
}

void showOneUpImage(byte i, byte j)
{
  int col;
  byte p;

  // OneUp
  for (byte x = 0; x < 16; x++)
  {
    for (byte y = 0; y < 5; y++)
    {
      p = pgm_read_byte_near(oneUpImg + y * 16 + x);
      switch (p)
      {
        case 0:
          col = matrix.Color444(0, 0, 0);
          break;

        case 1:
          col = matrix.Color444(0, 0, 15);
          break;

        case 2:
          col = matrix.Color444(2, 2, 15);
          break;

        case 3:
          col = matrix.Color444(7, 0, 3);
          break;

        case 4:
          col = matrix.Color444(11, 0, 3);
          break;

        case 5:
          col = matrix.Color444(8, 0, 3);
          break;

        case 6:
          col = matrix.Color444(9, 0, 3);
          break;

        case 7:
          col = matrix.Color444(10, 0, 3);
          break;

        case 8:
          col = matrix.Color444(3, 4, 15);
          break;

        case 9:
          col = matrix.Color444(3, 6, 15);
          break;

        case 10:
          col = matrix.Color444(5, 6, 15);
          break;

      }
      matrix.drawPixel(x + i, y + j, col);
    }
  }
}

void showJoyRevImage(byte i, byte j)
{
  int col;
  byte p;

  for (byte x = 0; x < 15; x++)
  {
    for (byte y = 0; y < 7; y++)
    {
      p = pgm_read_byte_near(joyRevImg + y * 15 + x);
      switch (p)
      {
        case 0:
          col = matrix.Color444(0, 0, 0);
          break;

        case 1:
          col = matrix.Color444(0, 0, 15);
          break;

        case 2:
          col = matrix.Color444(2, 2, 15);
          break;

        case 3:
          col = matrix.Color444(8, 0, 3);
          break;

        case 4:
          col = matrix.Color444(10, 0, 3);
          break;

        case 5:
          col = matrix.Color444(3, 4, 15);
          break;

        case 6:
          col = matrix.Color444(3, 6, 15);
          break;

        case 7:
          col = matrix.Color444(5, 6, 15);
          break;

        case 8:
          col = matrix.Color444(11, 10, 12);
          break;

        case 9:
          col = matrix.Color444(7, 0, 3);
          break;

        case 10:
          col = matrix.Color444(11, 0, 3);
          break;

        case 11:
          col = matrix.Color444(9, 0, 3);
          break;

        case 12:
          col = matrix.Color444(12, 12, 4);
          break;

      }
      matrix.drawPixel(x + i, y + j, col);
    }
  }
}

void drawQuotationMark(byte x, byte y)
{
  for (byte s = 0; s < 10; s++) { matrix.drawLine(13, 14+s, 15, 14+s, matrix.Color444(s, s, 10)); }
  matrix.fillRect(13, 26, 3, 3, matrix.Color444(0, 0, 10));
}

void displayGameModeScreen()
{
  matrix.fillScreen(backgroundColor);
  if (gameMode == RELAXED)
  {
    drawRelaxText(0, 4);
  }
  else if (gameMode == EASY)
  {
    drawEasyText(3, 4);
  }
  else if (gameMode == WORK)// Challenging mode: at least one wall of the border missing
  {
    drawWorkText(3, 4);
  }
  drawQuotationMark(7, 15);
  consumeJoystickEvents();
  delay(500);
  consumeJoystickEvents();

  do
  {
    if ( joy1Left() || joy1Right() ||
         joy2Left() || joy2Right() )
    {
      tone(audio, 800, 5); delay(8);
      tone(audio, 1200, 10); delay(13);
      
      if (gameMode == 3) { gameMode = 0; } else { gameMode++; }
      if (gameMode == RELAXED)
      {
        matrix.fillRect(0, 0, 31, 12, backgroundColor);
        drawRelaxText(0, 4);
        delay(300);
      }
      else if (gameMode == EASY)
      {
        matrix.fillRect(0, 0, 31, 12, backgroundColor);
        drawEasyText(3, 4);
        delay(300);
      }
      else if (gameMode == WORK)// Challenging mode: at least one wall of the border missing
      {
        matrix.fillRect(0, 0, 31, 12, backgroundColor);
        drawWorkText(3, 4);
        delay(300);
      }
      consumeJoystickEvents();
    }
  }
  while (!joy1Fire() && !joy2Fire());
}

// Player selection
void displayNumPlayersScreen()
{
  matrix.fillScreen(backgroundColor);
  drawPlayerText(1, 1);
  drawVSText(10, 13);
  drawCPUText(8, 22);
  
  consumeJoystickEvents();
  delay(500);
  consumeJoystickEvents();

  do
  {
    if ( joy1Left() || joy1Right() ||
         joy2Left() || joy2Right())
    {
      tone(audio, 800, 5); delay(8);
      tone(audio, 1200, 10); delay(13);
      
      onePlayerMode = !onePlayerMode;
      if (onePlayerMode)
      {
        matrix.fillRect(0, 13, 31, 18, backgroundColor);
        drawVSText(10, 13);
        drawCPUText(8, 22);
        delay(300);
      }
      else // Two player mode
      {
        matrix.fillRect(0, 13, 31, 18, backgroundColor);
        drawWithText(8, 13);
        drawPlayerText(1, 21);
        delay(300);
      }
      consumeJoystickEvents();
    }
  }
  while (!joy1Fire() && !joy2Fire());
}

void restoreBackgroundUnderBalls()
{
  // Restore the background beneath balls 1 - 4
  for (int i = 1; i < 5; i++)
  {
    for (byte a = 0; a < 3; a++)
    {
      for (byte b = 0; b < 3; b++)
      {
        matrix.drawPixel((int)ball_old_x[i] + a, (int)ball_old_y[i] + b, framebuffer[(int)ball_old_x[i] + a][(int)ball_old_y[i] + b]);
        matrix.drawPixel((int)ball_x[i] + a, (int)ball_y[i] + b, framebuffer[(int)ball_x[i] + a][(int)ball_y[i] + b]);
      }
    }
  }
}

// ----------------- Sounds --------------------------

void playDrum(int freq, int duration, int attenuation)
{
  int offset = 0;
  if      (attenuation == NORMAL)   {
    offset = -15;
  }
  else if (attenuation == STACCATO) {
    offset = -40;
  }
  else if (attenuation == ACCENT) {
    offset = 15;
  }

  for (int d = 0; d < duration + offset; d++)
  {
    tone(audio, freq + random(40) - 5, 2);
    tone(audio, 400 + random(40) - 5, 2);
    //delay(2);
  }
}

void playNote(int freq, int duration, int attenuation)
{
  int offset = 0;
  if      (attenuation == NORMAL)   {
    offset = -20;
  }
  else if (attenuation == STACCATO) {
    offset = -45;
  }
  else if (attenuation == ACCENT) {
    offset = 20;
  }

  for (int d = 0; d < duration + offset; d++)
  {
    tone(audio, freq + random(2) - 1, 2);
  }
  delay(35 - offset);
}

void emitSound(byte id)
{
  int freq1 = 0;
  int freq2 = 0;
  int freq3 = 0;
  int freq4 = 0;
  int freq5 = 0;

  switch (id)
  {
    case REBOUND:     tone(audio, 200 + random(10) - 20, 20); tone(audio, 800 + random(10) - 20, 4); tone(audio, 1200 + random(10) - 20, 4);
      break;

    case DEMOLISH:    break; //tone(audio, 150, 20); for (byte k = 0; k < 25; k++) { tone(audio, 200 + random(0, 121), 11); }; break;


    case BAT_REBOUND: tone(audio, 200 + random(10) - 20, 20); tone(audio, 600 + random(10) - 20, 4); tone(audio, 700 + random(10) - 20, 4); break;

    case OUTOFARENA:  for (byte t = 0; t < 35; t++) {
        tone (audio, random(800, 1000), 2);
        delay(2);
      }
      for (byte t = 0; t < 35; t++) {
        tone (audio, random(300, 400), 2);
        delay(2);
      }
      break;

    case GAMEOVER:      freq1 = 466;
      freq2 = 440;
      freq3 = 415;
      freq4 = 392;
      freq5 = 370;

      for (int f = freq1; f > freq2; f--) {
        tone(audio, f, 5);
      }
      for (int f = freq2; f < freq1; f++) {
        tone(audio, f, 5);
      }
      for (int f = freq2; f > freq3; f--) {
        tone(audio, f, 5);
      }
      for (int f = freq3; f < freq2; f++) {
        tone(audio, f, 5);
      }
      for (int f = freq3; f > freq4; f--) {
        tone(audio, f, 5);
      }
      for (int f = freq4; f < freq3; f++) {
        tone(audio, f, 5);
      }
      for (int f = freq4; f > freq5; f--) {
        tone(audio, f, 5);
      }
      for (int f = freq5; f < freq4; f++) {
        tone(audio, f, 5);
      }
      tone(audio, freq5, 100);
      delay(2000);
      break;

    case SHOT:         for (int g = 500; g > 150; g = g - 50)
      {
        for (byte i = 0; i < 5; i++)
        {
          tone(audio, g + random(51) - 50, 2);
          delay(1);
        }
        delay(2);
      }
      break;

    case BADDIE_REBOUND:   tone(audio, 200 + random(10) - 20, 4);
      tone(audio, 800 + random(10) - 20, 20);
      tone(audio, 1200 + random(10) - 20, 4);
      tone(audio, 1190 + random(10) - 20, 4);
      tone(audio, 1180 + random(10) - 20, 4);
      tone(audio, 1170 + random(10) - 20, 4);
      break;

    case BADDIE_EXPLODE:

      for (int g = 300; g > 100; g = g - 25)
      {
        for (byte i = 0; i < 20; i++)
        {
          tone(audio, g + random(51) - 50, 2); delay(4);
        }
      }
      break;

    case BADDIE_APPEAR:  tone(audio, NOTE_C7, 15); delay(20);
      tone(audio, NOTE_G6, 5); delay(10);
      tone(audio, NOTE_G7, 5); delay(10);
      tone(audio, NOTE_E7, 5); delay(10);
      break;

    case BONUS_APPEAR:   tone(audio, NOTE_C6, 15); delay(20);
      tone(audio, NOTE_D6, 5); delay(10);
      tone(audio, NOTE_E6, 5); delay(10);
      tone(audio, NOTE_F6, 5); delay(10);
      tone(audio, NOTE_G6, 5); delay(10);
      tone(audio, NOTE_A6, 5); delay(10);
      tone(audio, NOTE_B6, 5); delay(10);
      tone(audio, NOTE_C7, 5); delay(50);
      tone(audio, NOTE_E7, 5); delay(40);
      tone(audio, NOTE_C7, 5); delay(50);

      break;
  }
}


void playMelody()
{
  if (audioIsProduced)
  {
    int note = *(melodyPointer + melodyPosition);
    if (note == -1) // Snare
    {
      //playDrum(250, 40, NORMAL);
      for (int i = 0; i < 55; i++)
      {
        tone(audio, 350 + random(75) - 150, 3);
        //delay(2);
        //if ((i / 10) == 0) { tone(audio, 2000+random(50)-100, 2); }
      }
    }
    else
    {
      tone(audio, note, 60);
    }

    if (playMelodyInLoop)
    {
      if (melodyPosition < melodyLength) {
        melodyPosition++;
      } else {
        melodyPosition = 0;
      }
    }
    else
    {
      if (melodyPosition < melodyLength) {
        melodyPosition++;
      } else {
        melodyPosition = 0;
        audioIsProduced = false;
      }
    }
  }
  return;
}


void issueMelody(byte num, boolean loop)
{
  if (loop) {
    playMelodyInLoop = true;
  }
  else {
    playMelodyInLoop = false;
  }

  if (!audioIsProduced)
  {
    switch (num)
    {
      case NEXT_ARENA_MELODY:        melodyPointer = nextArenaMelody; melodyPosition = 0; melodyLength = 63; audioIsProduced = true; break;
      default:                       melodyLength = 0; melodyPosition = 0; audioIsProduced = false; break;
    }
  }
  return;
}


// ----------------- Interlude -----------------------


void playInterlude(boolean erase)
{
  gameGoing = false;
  int col;

  // Draw a spiral
  byte v = 0;
  byte i = 1;
  byte j = 1;
  byte ox = 1; // Upper left starting point of the spiral
  byte oy = 1;

  if (erase) {
    col = backgroundColor;
  } else {
    col = wall_color;
  }
  matrix.drawRect(0, 0, 32, 32, col); // Remove the border

  do
  {
    // From upper left to upper right
    do
    {
      matrix.fillRect(i, j, 3, 3, col);
      delay(10);
      i = i + 3;
    }
    while (i < 28 - v);
    // From upper right to lower right
    do
    {
      matrix.fillRect(i, j, 3, 3, col);
      delay(10);
      j = j + 3;
    }
    while (j < 28 - v);
    // From lower right to lower left
    do
    {
      matrix.fillRect(i, j, 3, 3, col);
      delay(10);
      i = i - 3;
    }
    while (i > ox + v);
    // From lower left to upper left
    do
    {
      matrix.fillRect(i, j, 3, 3, col);
      delay(10);
      j = j - 3;
    }
    while (j > oy + v + 3);
    v = v + 3;
  }
  while (v < 18);
  delay(200);

  // Jump through a black hole
  // The scroll routine was modified from an Adafruit Demo
  // The Z-Plane Starfield routine was modified from one in the book "AMOS Programming"
  char arenaChar[5];
  char livesChar[5];
  itoa(arena + 1, arenaChar, 10 );
  itoa(lives, livesChar, 10);
  String arenaStr = arenaChar;
  String livesStr = livesChar;
  String str1 = "Arena " + arenaStr;
  if (lives > 0) {
    str1 += " Lives " + livesStr;
  }
  else {
    str1 += " Life 1";
  }
  int  textX   = matrix.width();
  int  textMin = sizeof(str1) * -31;
  int  hue     = 0;
  byte num = 15;
  byte x[num], y[num], xs[num], ys[num];
  byte xrange = 9;
  byte yrange = 9;
  matrix.fillRect(0, 0, 32, 32, backgroundColor); // Remove the border

  for (byte a = 0; a < num; a++)
  {
    x[a] = 15;
    y[a] = 15;
    xs[a] = random(xrange) + 1 - (xrange / 2);
    ys[a] = random(yrange) + 1 - (yrange / 2);
  }

  //boolean stop = false;
  consumeJoystickEvents();
  delay(300);
  consumeJoystickEvents();
  matrix.setTextSize(2);
  long t = millis();

  issueMelody(NEXT_ARENA_MELODY, true);

  do
  {
    if (millis() - t > 50)
    {
      t = millis();
      randomSeed(analogRead(20));

      // Draw Starfield
      for (byte a = 0; a < num; a++)
      {
        //if ((y[a] < 9) || (y[a] > 23)) // Omit the screen section with the scroll text
        if ((x[a] != 15) && (y[a] != 15))
        {
          matrix.drawPixel(x[a], y[a], backgroundColor);
        }

        x[a] += xs[a];
        y[a] += ys[a];

        if ((x[a] < 0) || (x[a] > 31) || (y[a] < 0) || (y[a] > 31))
        {
          x[a] = 15;
          y[a] = 15;
          xs[a] = random(xrange) + 1 - (xrange / 2);
          ys[a] = random(yrange) + 1 - (yrange / 2);
        }
        //if ((y[a] < 9) || (y[a] > 23)) // Omit the screen section with the scroll text
        if ((x[a] != 15) && (y[a] != 15))
        {
          matrix.drawPixel(x[a], y[a], wall_color);
        }
      } // for

      // Erase scroll text
      matrix.setTextColor(matrix.Color333(0, 0, 0));
      matrix.setCursor(textX, 16);
      matrix.print(str1);

      // Move text left (w/wrap), increase hue
      if ((--textX) < textMin) {
        textX = matrix.width();
      }
      // Draw scroll text
      matrix.setTextColor(matrix.ColorHSV(hue, 255, 255, true));
      matrix.setCursor(textX, 16);
      matrix.print(str1);
      hue += 7;
      if (hue >= 1536) hue -= 1536;

    } // millis()

    timer.update();
  }
  while ( !joy1Fire()  && !joy2Fire()  &&
          !joy1Left()  && !joy2Left()  &&
          !joy1Right() && !joy2Right() &&
          !joy1Up()    && !joy2Up()    &&
          !joy1Down()  && !joy2Down() );

  audioIsProduced = false;
  playMelodyInLoop = false;
  gameGoing = true;

  matrix.fillRect(0, 0, 32, 32, matrix.Color333(0, 0, 0));
}

void showGameOverPicture()
{
  // Draw a spiral
  byte v = 0;
  byte i = 1;
  byte j = 1;
  byte ox = 1; // Upper left starting point of the spiral
  byte oy = 1;

  matrix.drawRect(0, 0, 32, 32, backgroundColor);
  int col = wall_color;

  // Dissolve screen content in a spiral
  do
  {
    // From upper left to upper right
    do
    {
      matrix.fillRect(i, j, 3, 3, col);
      delay(10);
      i = i + 3;
    }
    while (i < 28 - v);
    // From upper right to lower right
    do
    {
      matrix.fillRect(i, j, 3, 3, col);
      delay(10);
      j = j + 3;
    }
    while (j < 28 - v);
    // From lower right to lower left
    do
    {
      matrix.fillRect(i, j, 3, 3, col);
      delay(10);
      i = i - 3;
    }
    while (i > ox + v);
    // From lower left to upper left
    do
    {
      matrix.fillRect(i, j, 3, 3, col);
      delay(10);
      j = j - 3;
    }
    while (j > oy + v + 3);
    v = v + 3;
  }
  while (v < 18);
  delay(200);

  byte p;
  matrix.fillScreen(matrix.Color444(0, 0, 0));

  for (byte x = 0; x < 32; x++)
  {
    for (byte y = 0; y < 32; y++)
    {
      p = pgm_read_byte_near(gameOverImg + y * 32 + x);

      switch (p)
      {
        case 0:
          col = matrix.Color444(0, 0, 0);
          break;

        case 1:
          col = matrix.Color444(8, 5, 0);
          break;

        case 2:
          col = matrix.Color444(1, 1, 4);
          break;

        case 3:
          col = matrix.Color444(0, 0, 2);
          break;

        case 4:
          col = matrix.Color444(1, 0, 5);
          break;

        case 5: // Red
          col = matrix.Color444(13, 5, 0);
          break;

        case 6: // Yellow
          col = matrix.Color444(13, 13, 0);
          break;

        case 7:
          col = matrix.Color444(0, 0, 15);
          break;

        case 8:
          col = matrix.Color444(0, 0, 15);
          break;
      }
      matrix.drawPixel(x, y, col);
    }
  }

  do
  {
  }
  while ( !joy1Fire()  && !joy2Fire()  &&
          !joy1Left()  && !joy2Left()  &&
          !joy1Right() && !joy2Right() &&
          !joy1Up()    && !joy2Up()    &&
          !joy1Down()  && !joy2Down() );

  consumeJoystickEvents();
}


// ----------------- Main loop -----------------------

// Main loop of the game
void loop()
{
  if (showWelcomeScreen) {
    showTitleScreen();
  }
  onePlayerMode = true;
  displayNumPlayersScreen();

  gameMode = EASY;
  displayGameModeScreen();
  //setTimers();
  if (gameMode == RELAXED) 
  {
    if (RELAX_START_ARENA == 0) { arena = 0; }
    else { arena = RELAX_START_ARENA; } 
  } 
  else if (gameMode == EASY)
  {
    if (EASY_START_ARENA == 26) { arena = 26; }
    else { arena = EASY_START_ARENA; }
  }
  else if (gameMode == WORK)
  { 
    if (WORK_START_ARENA == 38) { arena = 38; }
    else { arena = WORK_START_ARENA; } 
  }
  
  initVars(); // Initialize data structures
  numActiveBalls = 1;
  gameOver = false;
  reset = false;
  nextArena = false;
  baddieTimeInkrement = 0;
  for (byte i = 0; i < 4; i++)
  {
    baddie_active[i] = false;
    baddieHasCollided[i] = false;
  }
  playInterlude(true);

  // Initialize random number generator
  randomSeed(analogRead(31));

  do // The game is ongoing
  {
    //audioIsProduced = false;
    clearFramebuffer();
    drawPlayfield(); // Draw current arena on-screen
    initVars(); // Initialize data structures
    ball_active[0] = false;
    consumeJoystickEvents();
    waitingForUserStart = true;
    assignBallToBat();
    multipleBallsActive = false;
    ongoingBonusAction = false;
    bonusObjectFlying = false;
    ballTurnedHavoc = false;
    enlargedBat = false;
    batCanShoot = false; shot_x = -1; shot_y = -1;
    borderTemporarilyOpen = false;
    collidedBat = NONE;
    lastBaddieTypeMade = 100; // Dummy value
    baddieType2InGame = false;
    for (byte i = 0; i < 4; i++) {
      baddie_active[i] = false;

      //animateShot.stop();
    }


    do // We are playing the current stage
    {
      timer.update();
      animCounter++; animCounter = animCounter % 100000;

      // Consequence of bonus action 0 (Additional Life)
      if (borderTemporarilyOpen)
      {
        if (gameGoing)
        {
          int diff = millis() - borderOpenTimer;
          if (diff >= 5000)
          {
            // Open border(s) again
            closeOpenBorders(false);
            borderTemporarilyOpen = false;
            ongoingBonusAction = false;
          }
          else
          {
            if ((diff >= 1000) && (diff < 2000))
            {
              if (animCounter % 500 == 0) {
                blinkOpenBorders();
              }
            }
            else if ((diff >= 2000) && (diff < 3000))
            {
              if (animCounter % 300 == 0) {
                blinkOpenBorders();
              }
            }
            else if ((diff >= 3000) && (diff < 4000))
            {
              if (animCounter % 200 == 0) {
                blinkOpenBorders();
              }
            }
            else if ((diff >= 4000) && (diff < 5000))
            {
              if (animCounter % 150 == 0) {
                blinkOpenBorders();
              }
            }
          }
        }
      }

      // Consequence of bonus action 1 (Five Balls)
      if (gameGoing && (!borderOpen) && multipleBallsActive)
      {
        int dur = millis() - bonusActionTimer;
        if (dur > 15000)
        {
          clearBalls();
          ball_active[1] = false;
          ball_active[2] = false;
          ball_active[3] = false;
          ball_active[4] = false;
          multipleBallsActive = false;
          ball_active[0] = true;

          // Restore the background beneath balls 1 - 4
          restoreBackgroundUnderBalls();

          ongoingBonusAction = false;
        }
        else if ((dur > 14000) && (dur <= 15000)) // Vanishing animation for balls 1 - 4
        {
          restoreBackgroundUnderBalls();

          if (dur < 14125 )
          {
            for (byte i = 1; i < 5; i++) {
              matrix.drawPixel(ball_x[i], ball_y[i], matrix.Color444(15, 15, 10));
            }
          }
          else if ((dur >= 14125) && (dur < 14250))
          {
            for (byte i = 1; i < 5; i++) {
              matrix.drawPixel(ball_x[i] + 1, ball_y[i] + 1, matrix.Color444(3, 3, 8));
            }
          }
          else if ((dur >= 14250) && (dur < 14375))
          {
            for (byte i = 1; i < 5; i++) {
              matrix.drawPixel(ball_x[i] + 2, ball_y[i], matrix.Color444(15, 15, 10));
            }
          }
          else if ((dur >= 14375) && (dur < 14500))
          {
            for (byte i = 1; i < 5; i++) {
              matrix.drawPixel(ball_x[i] + 1, ball_y[i] + 1, matrix.Color444(3, 3, 8));
            }
          }
          else if ((dur >= 14625) && (dur < 14750))
          {
            for (byte i = 1; i < 5; i++) {
              matrix.drawPixel(ball_x[i] + 2, ball_y[i] + 2, matrix.Color444(15, 15, 10));
            }
          }
          else if ((dur >= 14750) && (dur < 14875))
          {
            for (byte i = 1; i < 5; i++) {
              matrix.drawPixel(ball_x[i] + 1, ball_y[i] + 1, matrix.Color444(3, 3, 8));
            }
          }
          else if ((dur >= 14875) && (dur < 15000))
          {
            for (byte i = 1; i < 5; i++) {
              matrix.drawPixel(ball_x[i], ball_y[i] + 2, matrix.Color444(15, 15, 10));
            }
          }
        }
      }

      // Consequence of bonus action 3 (Joystick(s) Reversed)
      if (gameGoing && (joystick1Reversed || joystick2Reversed))
      {
        if (millis() - bonusActionTimer >= 10000)
        {
          joystick1Reversed = false;
          joystick2Reversed = false;

          ongoingBonusAction = false;
        }
      }

      // Consequence of bonus action 4 (Bat Has Gun)
      if (gameGoing && batCanShoot)
      {
        if ((shotsRemaining <= 0) && (!shotInArena))
        {
          //animateShot.stop();
          bat_hasGun[UPPER_BAT] = false; bat_hasGun[LOWER_BAT] = false; bat_hasGun[LEFT_BAT] = false; bat_hasGun[RIGHT_BAT] = false;
          batCanShoot = false;

          ongoingBonusAction = false;
        }
      }

      // Consequence of bonus action 5 (Enlarged Bat)
      if (gameGoing && enlargedBat)
      {
        if (millis() - bonusActionTimer >= 20000)
        {
          playEnlargeSound(); delay(300);
          clearBats();
          if (bat_isEnlarged[UPPER_BAT]) {
            bat_pos_old[UPPER_BAT] = bat_pos[UPPER_BAT];
            bat_pos[UPPER_BAT] = max(1, min(bat_pos_old[UPPER_BAT] + 1, 25));
            bat_isEnlarged[UPPER_BAT]  = false;
          }
          if (bat_isEnlarged[LOWER_BAT]) {
            bat_pos_old[LOWER_BAT] = bat_pos[LOWER_BAT];
            bat_pos[LOWER_BAT] = max(1, min(bat_pos_old[LOWER_BAT] + 1, 25));
            bat_isEnlarged[LOWER_BAT]  = false;
          }
          if (bat_isEnlarged[LEFT_BAT]) {
            bat_pos_old[LEFT_BAT] = bat_pos[LEFT_BAT];
            bat_pos[LEFT_BAT] = max(1, min(bat_pos_old[LEFT_BAT] + 1, 25));
            bat_isEnlarged[LEFT_BAT] = false;
          }
          if (bat_isEnlarged[RIGHT_BAT]) {
            bat_pos_old[RIGHT_BAT] = bat_pos[RIGHT_BAT];
            bat_pos[RIGHT_BAT] = max(1, min(bat_pos_old[RIGHT_BAT] + 1, 25));
            bat_isEnlarged[RIGHT_BAT]  = false;
          }
          enlargedBat = false;
          drawBats();
          ongoingBonusAction = false;
        }
      }

      // Consequence of bonus action 6 (Ball Turned Havoc) - not implemented
      if (gameGoing && ballTurnedHavoc)
      {
        if (millis() - bonusActionTimer >= 7000)
        {
          ballTurnedHavoc = false;
          ongoingBonusAction = false;
        }
      }

      // Check whether player has caught bonus item: if so, fires one of the bonus actions
      if (gameGoing)
      {
        if (checkBatBonusCollision())
        {
          {
            bonusObjectFlying = false;
            clearBonusObject(bonus_x, bonus_y);
            bonus_x = -4; bonus_y = -4;
            issueBonusAction();  // Ensure that no new action is issued while an old one is ongoing
            collidedBat = NONE;
          }
        }
      }

      //if (millis() - audioTimer > 500)
      //{
      //  audioIsProduced = false;
      //}

      if (numBricks <= 0)
      {
        nextArena = true;  // Player demolished all bricks
      }

      if (digitalRead(buttonReset) == LOW) // Reset game
      {
        reset = true;
      }

      if (digitalRead(buttonPause) == LOW) // Next arena
      {
        nextArena = true;
      }

      // Ensure that a baddie of type 1 or 2 is not longer than 15 seconds on-screen
      for (byte i = 1; i < 4; i++) // Baddie Type 0 crashes at a bat or leaves the arena
      {
        if ((baddie_active[i]) && (!baddieDisappear[i]) && (!baddieExplode[i]) && (!baddieAppear[i]))
        {
          if (millis() - baddieTimer[i] >= 15000)
          {
            baddieDisappear[i] = true;
            if (baddie_type[i] == DISTURBER) {
              baddieType2InGame = false;
            }
          }
        }
      }

      if (gameGoing && lostLife)
      {
        clearBalls();
        baddieTimeInkrement = 0;
        multipleBallsActive = false;
        ballTurnedHavoc = false;
        enlargedBat = false;
        bat_isEnlarged[UPPER_BAT] = false; bat_isEnlarged[LOWER_BAT] = false; bat_isEnlarged[LEFT_BAT] = false; bat_isEnlarged[RIGHT_BAT] = false;
        batCanShoot = false; shotsRemaining = 0; shot_x = -1; shot_y = -1;
        clearBats();
        joystick1Reversed = false; joystick2Reversed = false;
        numActiveBalls = 1;
        ball_active[0] = true; ball_active[1] = false; ball_active[2] = false; ball_active[3] = false; ball_active[4] = false;
        bonusObjectFlying = false;
        clearBonusObject(bonus_x, bonus_y);

        // Something nice, such as a jingle and a picture, belongs here
        delay(1000);
        if (lives == 0)
        {
          gameOver = true;
          emitSound(GAMEOVER);
        }
        else
        {
          lives--;
          
          initBalls(); clearBats(); initBats();
        }

        lostLife = false;
        drawBats();
        assignBallToBat();
        waitingForUserStart = true;
      }
    }
    while ( (!nextArena) && (!gameOver) && (!reset) );

    numBricks = 0;
    bonusObjectFlying = false;
    joystick1Reversed = false; joystick2Reversed = false;
    multipleBallsActive = false;
    ballTurnedHavoc = false;
    enlargedBat = false;
    batCanShoot = false; shot_x = -1; shot_y = -1; shotInArena = false;
    bat_isEnlarged[UPPER_BAT] = false; bat_isEnlarged[LOWER_BAT] = false; bat_isEnlarged[LEFT_BAT] = false; bat_isEnlarged[RIGHT_BAT] = false;
    clearFramebuffer();

    clearBaddies();
    for (byte i = 0; i < 4; i++)
    {
      baddie_active[i] = false;
      baddie_x[i] = 35; // Some arbitrary position outside the display
      baddie_y[i] = 35;
      baddie_old_x[i] = baddie_x[i];
      baddie_old_y[i] = baddie_y[i];
      baddieAppear[i] = false;
      baddieDisappear[i] = false;
      baddieExplode[i] = false;
      baddieAnimFrame[i] = 0;
      baddieAppearAnimFrame[i] = 0;
      baddieExplodeAnimFrame[i] = 0;
      baddieHasCollided[i] = false;
      baddieTimer[i] = 0;
      baddie_nextWaypointX[i] = 0;
      baddie_nextWaypointY[i] = 0;
    }
    baddieTimeInkrement = 0;
    baddieCouldMoveX = false;
    baddieCouldMoveY = false;

    clearBalls();
    for (byte i = 0; i < 4; i++)
    {
      ball_x[i] = 40;
      ball_y[i] = 40;
      ball_old_x[i] = ball_x[i];
      ball_old_y[i] = ball_y[i];
      ball_active[i] = false;
    }
    ball_active[0] = true;

    ongoingBonusAction = false;

    // Enter the next arena
    if (nextArena)
    {
      gameGoing = false;

      if (gameMode == RELAXED)
      {
        if (arena == 25)
        {
          arena = 0;
        }
        else
        {
          arena++;
        }
      }
      else if (gameMode == EASY)
      {
        if (arena == 37)
        {
          arena = 26;
        }
        else
        {
          arena++;
        }
      }
      else if (gameMode == WORK)//  game mode
      {
        if (arena == 48)
        {
          arena = 38;
        }
        else
        {
          arena++;
        } 
      }
      //animateShot.stop();
      nextArena = false;
      clearBalls();
      clearBats();
      clearBonusObject(bonus_x, bonus_y);
      bonusObjectFlying = false;
      delay(1000);
      playInterlude(false);
    }
  }
  while ((!gameOver) && (!reset));

  gameGoing = false;
  
  lives = NUM_LIVES;
  if (gameMode == RELAXED) { arena = RELAX_START_ARENA; }
  else if (gameMode == EASY) { arena = EASY_START_ARENA; } 
  else if (gameMode == WORK) { arena = WORK_START_ARENA; }
  nextArena = false;
  reset = false;
  bonusObjectFlying = false;
  bonus_x = 35; bonus_y = 35;
  clearBalls();
  clearBats();
  clearFramebuffer();

  if (gameOver)
  {
    showGameOverPicture();
  }

} // loop
