/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.SwingUtilities;
import processing.core.PApplet;
import processing.core.PFont;

public class WallNBallEdit
extends PApplet {
    final int red_brick = 0;
    final int green_brick = 1;
    final int blue_brick = 2;
    final int yellow_brick = 3;
    final int violet_brick = 4;
    final int orange_brick = 5;
    final int solid_brick = 6;
    final int empty_brick = 7;
    final int horiz_wall_low = 8;
    final int horiz_wall_high = 9;
    final int vert_wall = 10;
    final int corner_nw = 11;
    final int corner_ne = 12;
    final int corner_sw = 13;
    final int corner_se = 14;
    final int UPPER_BAT = 0;
    final int LOWER_BAT = 1;
    final int LEFT_BAT = 2;
    final int RIGHT_BAT = 3;
    final int UPPER_GAP = 0;
    final int LOWER_GAP = 1;
    final int LEFT_GAP = 2;
    final int RIGHT_GAP = 3;
    final int RED_BRICK = 0;
    final int GREEN_BRICK = 1;
    final int BLUE_BRICK = 2;
    final int YELLOW_BRICK = 3;
    final int VIOLET_BRICK = 4;
    final int ORANGE_BRICK = 5;
    final int SOLID_BRICK = 6;
    final int EMPTY_BRICK = 7;
    final int HORIZ_WALL_LOW = 8;
    final int HORIZ_WALL_HIGH = 9;
    final int VERT_WALL = 10;
    final int CORNER_NW = 11;
    final int CORNER_NE = 12;
    final int CORNER_SW = 13;
    final int CORNER_SE = 14;
    final int ledOffIndex = 4864;
    boolean upperBorder = true;
    boolean lowerBorder = true;
    boolean leftBorder = true;
    boolean rightBorder = true;
    boolean upperBatActive = false;
    boolean lowerBatActive = true;
    boolean leftBatActive = false;
    boolean rightBatActive = false;
    boolean leftLEDMatrixPanel = false;
    int selectedBrick;
    ToolGroup toolGroup = new ToolGroup();
    ElementSelector redBrick;
    ElementSelector greenBrick;
    ElementSelector blueBrick;
    ElementSelector violetBrick;
    ElementSelector yellowBrick;
    ElementSelector orangeBrick;
    ElementSelector solidBrick;
    ElementSelector emptyBrick;
    ElementSelector horizWallHigh;
    ElementSelector horizWallLow;
    ElementSelector vertWall;
    ElementSelector cornerNW;
    ElementSelector cornerNE;
    ElementSelector cornerSW;
    ElementSelector cornerSE;
    ExportButton exportButton;
    ClearButton clearButton;
    LoadButton loadButton;
    BatSelectButton upperBatActiveSel;
    BatSelectButton lowerBatActiveSel;
    BatSelectButton leftBatActiveSel;
    BatSelectButton rightBatActiveSel;
    GapSelectButton upperGap;
    GapSelectButton lowerGap;
    GapSelectButton leftGap;
    GapSelectButton rightGap;
    public int[] indexColor = new int[4929];
    public PFont f;
    public int currentLED_x;
    public int currentLED_y;
    public int formerLED_x;
    public int formerLED_y;
    public int[][] frameBuffer = new int[32][32];
    public int foregroundCol;
    public int backgroundCol;
    public int contourCol;
    public int batColor;
    public int black;
    public int white;
    public int grey;
    public int darkGrey;
    public int red;
    public int green;
    public int blue;
    public int violet;
    public int yellow;
    public int orange;
    public int solid;
    public int empty;
    public boolean useColor1 = true;
    public boolean useColor2 = false;
    public int dotDiameter = 13;
    public int indexColor1 = 255;
    public int indexColor2 = 4864;
    public boolean diskOperationPending = false;
    public boolean dragging;
    public boolean fileLoaded = false;

    public void setup() {
        this.colorMode(1, 16.0f, 16.0f, 16.0f);
        this.background(6);
        this.frameRate(50.0f);
        this.red = this.color(13, 2, 2);
        this.green = this.color(2, 13, 2);
        this.blue = this.color(2, 2, 13);
        this.violet = this.color(13, 2, 13);
        this.yellow = this.color(13, 13, 2);
        this.orange = this.color(13, 7, 2);
        this.solid = this.color(10, 10, 13);
        this.white = this.color(15, 15, 15);
        this.black = this.color(0, 0, 0);
        this.grey = this.color(9, 9, 9);
        this.darkGrey = this.color(6, 6, 6);
        this.contourCol = this.color(0, 0, 0);
        this.empty = this.color(0, 0, 0);
        this.batColor = this.color(16, 8, 8);
        this.clearLEDmePlayFrameBuffer();
        this.drawEmptyMatrix();
        this.foregroundCol = this.indexColor[this.indexColor1];
        this.backgroundCol = this.indexColor[this.indexColor2];
        this.redBrick = new ElementSelector(0, 940, 40, 75, 50);
        this.redBrick.setToolGroup(this.toolGroup);
        this.greenBrick = new ElementSelector(1, 940, 100, 75, 50);
        this.greenBrick.setToolGroup(this.toolGroup);
        this.violetBrick = new ElementSelector(4, 940, 160, 75, 50);
        this.violetBrick.setToolGroup(this.toolGroup);
        this.blueBrick = new ElementSelector(2, 940, 220, 75, 50);
        this.blueBrick.setToolGroup(this.toolGroup);
        this.yellowBrick = new ElementSelector(3, 940, 280, 75, 50);
        this.yellowBrick.setToolGroup(this.toolGroup);
        this.orangeBrick = new ElementSelector(5, 940, 340, 75, 50);
        this.orangeBrick.setToolGroup(this.toolGroup);
        this.emptyBrick = new ElementSelector(7, 940, 460, 75, 50);
        this.emptyBrick.setToolGroup(this.toolGroup);
        this.horizWallHigh = new ElementSelector(9, 1040, 40, 75, 50);
        this.horizWallHigh.setToolGroup(this.toolGroup);
        this.horizWallLow = new ElementSelector(8, 1040, 100, 75, 50);
        this.horizWallLow.setToolGroup(this.toolGroup);
        this.vertWall = new ElementSelector(10, 1040, 160, 75, 50);
        this.vertWall.setToolGroup(this.toolGroup);
        this.cornerNW = new ElementSelector(11, 1040, 220, 75, 50);
        this.cornerNW.setToolGroup(this.toolGroup);
        this.cornerNE = new ElementSelector(12, 1040, 280, 75, 50);
        this.cornerNE.setToolGroup(this.toolGroup);
        this.cornerSW = new ElementSelector(13, 1040, 340, 75, 50);
        this.cornerSW.setToolGroup(this.toolGroup);
        this.cornerSE = new ElementSelector(14, 1040, 400, 75, 50);
        this.cornerSE.setToolGroup(this.toolGroup);
        this.solidBrick = new ElementSelector(6, 1040, 460, 75, 50);
        this.solidBrick.setToolGroup(this.toolGroup);
        this.upperBatActiveSel = new BatSelectButton(0, 1140, 40, 200, 50, this.upperBatActive);
        this.lowerBatActiveSel = new BatSelectButton(1, 1140, 100, 200, 50, this.lowerBatActive);
        this.leftBatActiveSel = new BatSelectButton(2, 1140, 160, 200, 50, this.leftBatActive);
        this.rightBatActiveSel = new BatSelectButton(3, 1140, 220, 200, 50, this.rightBatActive);
        this.drawBats();
        this.upperGap = new GapSelectButton(0, 1140, 280, 200, 50, this.upperBorder);
        this.lowerGap = new GapSelectButton(1, 1140, 340, 200, 50, this.lowerBorder);
        this.leftGap = new GapSelectButton(2, 1140, 400, 200, 50, this.leftBorder);
        this.rightGap = new GapSelectButton(3, 1140, 460, 200, 50, this.rightBorder);
        this.drawArenaBorder();
        this.clearButton = new ClearButton(940, 560, 175, 50);
        this.exportButton = new ExportButton(940, 620, 105, 50);
        this.loadButton = new LoadButton(1055, 620, 85, 50);
        this.f = this.loadFont("ArialMT-30.vlw");
        if (this.f == null) {
            this.f = this.loadFont("ArialMT-30.vlw");
        }
        this.textFont(this.f, 30.0f);
        this.formerLED_x = 32;
        this.formerLED_y = 32;
        this.currentLED_x = 32;
        this.currentLED_y = 32;
    }

    public void draw() {
        this.drawFrameBuffer();
        this.drawBats();
        if (this.diskOperationPending) {
            this.fill(0);
            this.textFont(this.f, 30.0f);
            this.fill(6.0f, 6.0f, 6.0f);
            this.noStroke();
            this.rect(39.0f, 920.0f, 900.0f, 40.0f);
            this.fill(this.black);
            this.text("Please wait - disk operation pending...", 40.0f, 950.0f);
            return;
        }
        if (this.mouseX > 36 && this.mouseX < 865 && this.mouseY > 36 && this.mouseY < 845) {
            this.leftLEDMatrixPanel = false;
            this.currentLED_x = (this.mouseX - 40) / 27;
            this.currentLED_y = (this.mouseY - 40) / 27;
            this.formerLED_x = this.currentLED_x;
            this.formerLED_y = this.currentLED_y;
            if ((this.currentLED_x + 2) % 3 == 0 && (this.currentLED_y + 1) % 2 == 0 || (this.currentLED_x + 2) % 3 == 1 && (this.currentLED_y + 1) % 2 == 0 || (this.currentLED_x + 2) % 3 == 2 && (this.currentLED_y + 1) % 2 == 0 || (this.currentLED_x + 2) % 3 == 0 && (this.currentLED_y + 1) % 2 == 1 || (this.currentLED_x + 2) % 3 == 1 && (this.currentLED_y + 1) % 2 == 1 || (this.currentLED_x + 2) % 3 == 2 && (this.currentLED_y + 1) % 2 == 1) {
                int grid_x = 1 + (this.currentLED_x - 1) / 3 * 3;
                int grid_y = 1 + (this.currentLED_y - 1) / 2 * 2;
                this.drawMouseCursor(grid_x, grid_y);
            }
        } else if (!this.leftLEDMatrixPanel) {
            this.drawFrameBuffer();
            this.leftLEDMatrixPanel = true;
        }
        if (this.fileLoaded) {
            this.fileLoaded = false;
            this.drawEmptyMatrix();
            this.drawFrameBuffer();
            this.drawArenaBorder();
            this.leftBatActiveSel.repaint();
            this.rightBatActiveSel.repaint();
            this.upperBatActiveSel.repaint();
            this.lowerBatActiveSel.repaint();
            this.fill(6.0f, 6.0f, 6.0f);
            this.noStroke();
            this.rect(39.0f, 920.0f, 900.0f, 40.0f);
        }
    }

    public void drawFrameBuffer() {
        this.noStroke();
        int i = 1;
        while (i < 32) {
            int j = 1;
            while (j < 32) {
                this.restoreBrick(i, j);
                j += 2;
            }
            i += 3;
        }
    }

    public void drawBats() {
        int x;
        int y;
        if (this.upperBatActive) {
            this.fill(this.batColor);
            y = 1;
            x = 13;
            while (x < 17) {
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                ++x;
            }
        }
        if (this.lowerBatActive) {
            this.fill(this.batColor);
            y = 30;
            x = 13;
            while (x < 17) {
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                ++x;
            }
        }
        if (this.leftBatActive) {
            this.fill(this.batColor);
            x = 1;
            y = 13;
            while (y < 17) {
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                ++y;
            }
        }
        if (this.rightBatActive) {
            this.fill(this.batColor);
            x = 30;
            y = 13;
            while (y < 17) {
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                ++y;
            }
        }
    }

    public void drawArenaBorder() {
        int x;
        int y;
        if (this.upperBorder) {
            this.fill(this.solid);
            y = 0;
            x = 0;
            while (x < 32) {
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.frameBuffer[x][y] = 6;
                ++x;
            }
        } else {
            this.fill(this.empty);
            y = 0;
            x = 1;
            while (x < 32) {
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.frameBuffer[x][y] = 7;
                ++x;
            }
        }
        if (this.lowerBorder) {
            this.fill(this.solid);
            y = 31;
            x = 0;
            while (x < 32) {
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.frameBuffer[x][y] = 6;
                ++x;
            }
        } else {
            this.fill(this.empty);
            y = 31;
            x = 0;
            while (x < 32) {
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.frameBuffer[x][y] = 7;
                ++x;
            }
        }
        if (this.leftBorder) {
            this.fill(this.solid);
            x = 0;
            y = 0;
            while (y < 32) {
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.frameBuffer[x][y] = 6;
                ++y;
            }
        } else {
            this.fill(this.empty);
            x = 0;
            y = 0;
            while (y < 32) {
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.frameBuffer[x][y] = 7;
                ++y;
            }
        }
        if (this.rightBorder) {
            this.fill(this.solid);
            x = 31;
            y = 0;
            while (y < 32) {
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.frameBuffer[x][y] = 6;
                ++y;
            }
        } else {
            this.fill(this.empty);
            x = 31;
            y = 0;
            while (y < 32) {
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.frameBuffer[x][y] = 7;
                ++y;
            }
        }
    }

    public void drawEmptyMatrix() {
        this.noStroke();
        this.strokeWeight(1.0f);
        this.fill(1);
        this.rect(27.0f, 27.0f, 884.0f, 884.0f);
        this.fill(this.indexColor[4864]);
        int x = 0;
        while (x < 864) {
            int y = 0;
            while (y < 864) {
                this.ellipse(50 + x, 50 + y, this.dotDiameter, this.dotDiameter);
                y += 27;
            }
            x += 27;
        }
    }

    public void clearLEDmePlayFrameBuffer() {
        int x = 0;
        while (x < 32) {
            int y = 0;
            while (y < 32) {
                this.frameBuffer[x][y] = 7;
                ++y;
            }
            ++x;
        }
    }

    public void restoreLED(int x, int y) {
        if (x < 1 || y < 1 || x > 30 || y > 30) {
            return;
        }
        int c1 = 0;
        int c2 = 0;
        int c3 = 0;
        int c4 = 0;
        int c5 = 0;
        int c6 = 0;
        int selectedBrick = this.frameBuffer[x][y];
        switch (selectedBrick) {
            case 0: {
                c1 = this.color(13, 2, 2);
                c2 = this.color(12, 2, 2);
                c3 = this.color(11, 2, 2);
                c4 = this.color(10, 2, 2);
                c5 = this.color(9, 2, 2);
                c6 = this.color(8, 2, 2);
                break;
            }
            case 1: {
                c1 = this.color(2, 13, 2);
                c2 = this.color(2, 12, 2);
                c3 = this.color(2, 11, 2);
                c4 = this.color(2, 10, 2);
                c5 = this.color(2, 9, 2);
                c6 = this.color(2, 8, 2);
                break;
            }
            case 2: {
                c1 = this.color(2, 2, 13);
                c2 = this.color(2, 2, 12);
                c3 = this.color(2, 2, 11);
                c4 = this.color(2, 2, 10);
                c5 = this.color(2, 2, 9);
                c6 = this.color(2, 2, 8);
                break;
            }
            case 3: {
                c1 = this.color(13, 13, 2);
                c2 = this.color(12, 12, 2);
                c3 = this.color(11, 11, 2);
                c4 = this.color(10, 10, 2);
                c5 = this.color(9, 9, 2);
                c6 = this.color(8, 8, 2);
                break;
            }
            case 4: {
                c1 = this.color(13, 2, 13);
                c2 = this.color(12, 2, 12);
                c3 = this.color(11, 2, 11);
                c4 = this.color(10, 2, 10);
                c5 = this.color(9, 2, 9);
                c6 = this.color(8, 2, 8);
                break;
            }
            case 5: {
                c1 = this.color(13, 7, 2);
                c2 = this.color(12, 7, 2);
                c3 = this.color(11, 7, 2);
                c4 = this.color(10, 7, 2);
                c5 = this.color(9, 7, 2);
                c6 = this.color(8, 7, 2);
                break;
            }
            case 6: {
                c1 = this.solid;
                c2 = this.solid;
                c3 = this.solid;
                c4 = this.solid;
                c5 = this.solid;
                c6 = this.solid;
            }
        }
        if (selectedBrick == 0 || selectedBrick == 1 || selectedBrick == 2 || selectedBrick == 3 || selectedBrick == 5 || selectedBrick == 4 || selectedBrick == 7 || selectedBrick == 6) {
            if ((x + 2) % 3 == 0 && (y + 1) % 2 == 0) {
                this.fill(c1);
            } else if ((x + 2) % 3 == 1 && (y + 1) % 2 == 0) {
                this.fill(c2);
            } else if ((x + 3) % 3 == 2 && (y + 1) % 2 == 0) {
                this.fill(c3);
            } else if ((x + 3) % 3 == 0 && (y + 1) % 2 == 1) {
                this.fill(c4);
            } else if ((x + 3) % 3 == 1 && (y + 1) % 2 == 1) {
                this.fill(c5);
            } else if ((x + 3) % 3 == 2 && (y + 1) % 2 == 1) {
                this.fill(c6);
            }
            this.ellipse(50 + x * 27, 50 + y * 27, this.dotDiameter, this.dotDiameter);
        }
    }

    public void restoreBrick(int x, int y) {
        if (x < 1 || y < 1 || x > 30 || y > 30) {
            return;
        }
        int selectedBrick = this.frameBuffer[x][y];
        if (selectedBrick == 0 || selectedBrick == 1 || selectedBrick == 2 || selectedBrick == 3 || selectedBrick == 5 || selectedBrick == 4 || selectedBrick == 7 || selectedBrick == 6) {
            this.restoreLED(x, y + 0);
            this.restoreLED(x + 1, y + 0);
            this.restoreLED(x + 2, y + 0);
            this.restoreLED(x, y + 1);
            this.restoreLED(x + 1, y + 1);
            this.restoreLED(x + 2, y + 1);
        } else {
            switch (selectedBrick) {
                case 9: {
                    this.drawBrick(x, y, 9);
                    break;
                }
                case 8: {
                    this.drawBrick(x, y, 8);
                    break;
                }
                case 10: {
                    this.drawBrick(x, y, 10);
                    break;
                }
                case 12: {
                    this.drawBrick(x, y, 12);
                    break;
                }
                case 11: {
                    this.drawBrick(x, y, 11);
                    break;
                }
                case 14: {
                    this.drawBrick(x, y, 14);
                    break;
                }
                case 13: {
                    this.drawBrick(x, y, 13);
                }
            }
        }
    }

    public void drawBrick(int x, int y, int selectedBrick) {
        switch (selectedBrick) {
            case 8: {
                this.fill(this.empty);
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 1) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 2) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.fill(this.solid);
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 1) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 2) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                break;
            }
            case 9: {
                this.fill(this.solid);
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 1) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 2) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.fill(this.empty);
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 1) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 2) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                break;
            }
            case 10: {
                this.fill(this.solid);
                this.ellipse(50 + (x + 1) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 1) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.fill(this.empty);
                this.ellipse(50 + (x + 2) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 2) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                break;
            }
            case 11: {
                this.fill(this.solid);
                this.ellipse(50 + (x + 1) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 1) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 2) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.fill(this.empty);
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 2) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                break;
            }
            case 12: {
                this.fill(this.solid);
                this.ellipse(50 + (x + 1) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 1) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.fill(this.empty);
                this.ellipse(50 + (x + 2) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 2) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                break;
            }
            case 13: {
                this.fill(this.solid);
                this.ellipse(50 + (x + 1) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 1) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 2) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.fill(this.empty);
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 2) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                break;
            }
            case 14: {
                this.fill(this.solid);
                this.ellipse(50 + (x + 1) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 1) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.fill(this.empty);
                this.ellipse(50 + (x + 2) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
                this.ellipse(50 + (x + 2) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
            }
        }
    }

    public void drawMouseCursor(int x, int y) {
        int brickColor = 0;
        if (this.selectedBrick == 0 || this.selectedBrick == 1 || this.selectedBrick == 2 || this.selectedBrick == 4 || this.selectedBrick == 3 || this.selectedBrick == 5 || this.selectedBrick == 7 || this.selectedBrick == 6) {
            switch (this.selectedBrick) {
                case 0: {
                    brickColor = this.red;
                    break;
                }
                case 1: {
                    brickColor = this.green;
                    break;
                }
                case 2: {
                    brickColor = this.blue;
                    break;
                }
                case 3: {
                    brickColor = this.yellow;
                    break;
                }
                case 4: {
                    brickColor = this.violet;
                    break;
                }
                case 5: {
                    brickColor = this.orange;
                    break;
                }
                case 7: {
                    brickColor = this.empty;
                    break;
                }
                case 6: {
                    brickColor = this.solid;
                }
            }
            this.fill(brickColor);
            this.ellipse(50 + (x + 0) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
            this.ellipse(50 + (x + 1) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
            this.ellipse(50 + (x + 2) * 27, 50 + (y + 0) * 27, this.dotDiameter, this.dotDiameter);
            this.ellipse(50 + (x + 0) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
            this.ellipse(50 + (x + 1) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
            this.ellipse(50 + (x + 2) * 27, 50 + (y + 1) * 27, this.dotDiameter, this.dotDiameter);
        } else {
            switch (this.selectedBrick) {
                case 9: {
                    this.drawBrick(x, y, 9);
                    break;
                }
                case 8: {
                    this.drawBrick(x, y, 8);
                    break;
                }
                case 10: {
                    this.drawBrick(x, y, 10);
                    break;
                }
                case 12: {
                    this.drawBrick(x, y, 12);
                    break;
                }
                case 11: {
                    this.drawBrick(x, y, 11);
                    break;
                }
                case 14: {
                    this.drawBrick(x, y, 14);
                    break;
                }
                case 13: {
                    this.drawBrick(x, y, 13);
                }
            }
        }
    }

    public void mouseMoved() {
        if (this.mouseX > 36 && this.mouseX < 845 && this.mouseY > 36 && this.mouseY < 845 && !this.diskOperationPending) {
            this.fill(6.0f, 6.0f, 6.0f);
            this.noStroke();
            this.rect(39.0f, 920.0f, 900.0f, 40.0f);
        }
        if (this.exportButton != null && !this.exportButton.mouseOver(this.mouseX, this.mouseY) && this.exportButton.hasFocus) {
            this.exportButton.hasFocus = false;
            this.exportButton.pressed = false;
            this.exportButton.repaint();
        }
        if (this.clearButton != null && !this.clearButton.mouseOver(this.mouseX, this.mouseY) && this.clearButton.hasFocus) {
            this.clearButton.hasFocus = false;
            this.clearButton.pressed = false;
            this.clearButton.repaint();
        }
        if (this.loadButton != null && !this.loadButton.mouseOver(this.mouseX, this.mouseY) && this.loadButton.hasFocus) {
            this.loadButton.hasFocus = false;
            this.loadButton.pressed = false;
            this.loadButton.repaint();
        }
    }

    public void mousePressed() {
        if (this.mouseX > 36 && this.mouseX < 865 && this.mouseY > 36 && this.mouseY < 845) {
            if (this.mouseButton == 37 && ((this.currentLED_x + 2) % 3 == 0 && (this.currentLED_y + 1) % 2 == 0 || (this.currentLED_x + 2) % 3 == 1 && (this.currentLED_y + 1) % 2 == 0 || (this.currentLED_x + 2) % 3 == 2 && (this.currentLED_y + 1) % 2 == 0 || (this.currentLED_x + 2) % 3 == 0 && (this.currentLED_y + 1) % 2 == 1 || (this.currentLED_x + 2) % 3 == 1 && (this.currentLED_y + 1) % 2 == 1 || (this.currentLED_x + 2) % 3 == 2 && (this.currentLED_y + 1) % 2 == 1)) {
                int grid_x = 1 + (this.currentLED_x - 1) / 3 * 3;
                int grid_y = 1 + (this.currentLED_y - 1) / 2 * 2;
                this.noStroke();
                this.frameBuffer[grid_x + 0][grid_y + 0] = this.selectedBrick;
                this.frameBuffer[grid_x + 1][grid_y + 0] = this.selectedBrick;
                this.frameBuffer[grid_x + 2][grid_y + 0] = this.selectedBrick;
                this.frameBuffer[grid_x + 0][grid_y + 1] = this.selectedBrick;
                this.frameBuffer[grid_x + 1][grid_y + 1] = this.selectedBrick;
                this.frameBuffer[grid_x + 2][grid_y + 1] = this.selectedBrick;
            }
        } else {
            if (this.redBrick != null && this.redBrick.mouseOver(this.mouseX, this.mouseY)) {
                this.redBrick.select();
                this.selectedBrick = 0;
            }
            if (this.greenBrick != null && this.greenBrick.mouseOver(this.mouseX, this.mouseY)) {
                this.greenBrick.select();
                this.selectedBrick = 1;
            }
            if (this.blueBrick != null && this.blueBrick.mouseOver(this.mouseX, this.mouseY)) {
                this.blueBrick.select();
                this.selectedBrick = 2;
            }
            if (this.yellowBrick != null && this.yellowBrick.mouseOver(this.mouseX, this.mouseY)) {
                this.yellowBrick.select();
                this.selectedBrick = 3;
            }
            if (this.violetBrick != null && this.violetBrick.mouseOver(this.mouseX, this.mouseY)) {
                this.violetBrick.select();
                this.selectedBrick = 4;
            }
            if (this.orangeBrick != null && this.orangeBrick.mouseOver(this.mouseX, this.mouseY)) {
                this.orangeBrick.select();
                this.selectedBrick = 5;
            }
            if (this.solidBrick != null && this.solidBrick.mouseOver(this.mouseX, this.mouseY)) {
                this.solidBrick.select();
                this.selectedBrick = 6;
            }
            if (this.emptyBrick != null && this.emptyBrick.mouseOver(this.mouseX, this.mouseY)) {
                this.emptyBrick.select();
                this.selectedBrick = 7;
            }
            if (this.horizWallLow != null && this.horizWallLow.mouseOver(this.mouseX, this.mouseY)) {
                this.horizWallLow.select();
                this.selectedBrick = 8;
            }
            if (this.horizWallHigh != null && this.horizWallHigh.mouseOver(this.mouseX, this.mouseY)) {
                this.horizWallHigh.select();
                this.selectedBrick = 9;
            }
            if (this.vertWall != null && this.vertWall.mouseOver(this.mouseX, this.mouseY)) {
                this.vertWall.select();
                this.selectedBrick = 10;
            }
            if (this.cornerNW != null && this.cornerNW.mouseOver(this.mouseX, this.mouseY)) {
                this.cornerNW.select();
                this.selectedBrick = 11;
            }
            if (this.cornerNE != null && this.cornerNE.mouseOver(this.mouseX, this.mouseY)) {
                this.cornerNE.select();
                this.selectedBrick = 12;
            }
            if (this.cornerSW != null && this.cornerSW.mouseOver(this.mouseX, this.mouseY)) {
                this.cornerSW.select();
                this.selectedBrick = 13;
            }
            if (this.cornerSE != null && this.cornerSE.mouseOver(this.mouseX, this.mouseY)) {
                this.cornerSE.select();
                this.selectedBrick = 14;
            }
            if (this.exportButton != null && this.exportButton.mouseOver(this.mouseX, this.mouseY)) {
                this.exportButton.pressed = true;
                this.exportButton.repaint();
                this.diskOperationPending = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WallNBallEdit.this.selectOutput("Select output file:", "outputFileSelected");
                    }
                });
                this.fileLoaded = true;
            }
            if (this.clearButton != null && this.clearButton.mouseOver(this.mouseX, this.mouseY)) {
                this.clearButton.pressed = true;
                this.clearButton.repaint();
                this.drawEmptyMatrix();
                this.clearLEDmePlayFrameBuffer();
                this.upperBorder = true;
                this.lowerBorder = true;
                this.leftBorder = true;
                this.rightBorder = true;
                this.upperGap.pressed = false;
                this.upperGap.repaint();
                this.lowerGap.pressed = false;
                this.lowerGap.repaint();
                this.leftGap.pressed = false;
                this.leftGap.repaint();
                this.rightGap.pressed = false;
                this.rightGap.repaint();
                this.upperBatActive = false;
                this.upperBatActiveSel.pressed = false;
                this.lowerBatActive = true;
                this.lowerBatActiveSel.pressed = true;
                this.leftBatActive = false;
                this.leftBatActiveSel.pressed = false;
                this.rightBatActive = false;
                this.rightBatActiveSel.pressed = false;
                this.drawArenaBorder();
                this.drawBats();
            }
            if (this.upperBatActiveSel != null && this.upperBatActiveSel.mouseOver(this.mouseX, this.mouseY)) {
                this.upperBatActiveSel.toggle();
            }
            if (this.lowerBatActiveSel != null && this.lowerBatActiveSel.mouseOver(this.mouseX, this.mouseY)) {
                this.lowerBatActiveSel.toggle();
            }
            if (this.leftBatActiveSel != null && this.leftBatActiveSel.mouseOver(this.mouseX, this.mouseY)) {
                this.leftBatActiveSel.toggle();
            }
            if (this.rightBatActiveSel != null && this.rightBatActiveSel.mouseOver(this.mouseX, this.mouseY)) {
                this.rightBatActiveSel.toggle();
            }
            if (this.upperGap != null && this.upperGap.mouseOver(this.mouseX, this.mouseY)) {
                this.upperGap.toggle();
            }
            if (this.lowerGap != null && this.lowerGap.mouseOver(this.mouseX, this.mouseY)) {
                this.lowerGap.toggle();
            }
            if (this.leftGap != null && this.leftGap.mouseOver(this.mouseX, this.mouseY)) {
                this.leftGap.toggle();
            }
            if (this.rightGap != null && this.rightGap.mouseOver(this.mouseX, this.mouseY)) {
                this.rightGap.toggle();
            }
            if (!(this.upperBatActiveSel.pressed || this.lowerBatActiveSel.pressed || this.leftBatActiveSel.pressed || this.rightBatActiveSel.pressed)) {
                this.lowerBatActive = true;
                this.lowerBatActiveSel.pressed = true;
                this.upperBatActive = false;
                this.upperBatActiveSel.pressed = false;
                this.rightBatActiveSel.pressed = false;
                this.rightBatActiveSel.pressed = false;
                this.lowerBatActiveSel.repaint();
                this.upperBatActiveSel.repaint();
                this.leftBatActiveSel.repaint();
                this.rightBatActiveSel.repaint();
                this.drawFrameBuffer();
                this.drawBats();
            }
            if (this.loadButton != null && this.loadButton.mouseOver(this.mouseX, this.mouseY)) {
                this.loadButton.pressed = true;
                this.loadButton.repaint();
                this.diskOperationPending = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WallNBallEdit.this.selectInput("Select a file to load:", "inputFileSelected");
                    }
                });
                this.fileLoaded = true;
            }
        }
    }

    public void mouseReleased() {
        if (this.mouseX <= 36 || this.mouseX >= 845 || this.mouseY > 36) {
            // empty if block
        }
        if (this.exportButton != null && this.exportButton.mouseOver(this.mouseX, this.mouseY) && this.exportButton.pressed) {
            this.exportButton.hasFocus = false;
            this.exportButton.pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WallNBallEdit.this.exportButton.repaint();
                }
            });
        }
        if (this.clearButton != null && !this.clearButton.mouseOver(this.mouseX, this.mouseY) && this.clearButton.pressed) {
            this.clearButton.hasFocus = false;
            this.clearButton.pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WallNBallEdit.this.clearButton.repaint();
                }
            });
        }
        if (this.loadButton != null && !this.loadButton.mouseOver(this.mouseX, this.mouseY) && this.loadButton.pressed) {
            this.loadButton.hasFocus = false;
            this.loadButton.pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WallNBallEdit.this.loadButton.repaint();
                }
            });
        }
    }

    public void exportData(File path) {
        String dataMatrix = "";
        String value = "";
        int j = 1;
        while (j < 30) {
            int i = 1;
            while (i < 29) {
                switch (this.frameBuffer[i][j]) {
                    case 0: {
                        value = "2";
                        break;
                    }
                    case 1: {
                        value = "3";
                        break;
                    }
                    case 2: {
                        value = "4";
                        break;
                    }
                    case 3: {
                        value = "6";
                        break;
                    }
                    case 5: {
                        value = "8";
                        break;
                    }
                    case 4: {
                        value = "5";
                        break;
                    }
                    case 6: {
                        value = "7";
                        break;
                    }
                    case 7: {
                        value = "0";
                        break;
                    }
                    case 8: {
                        value = "15";
                        break;
                    }
                    case 9: {
                        value = "9";
                        break;
                    }
                    case 10: {
                        value = "10";
                        break;
                    }
                    case 11: {
                        value = "11";
                        break;
                    }
                    case 12: {
                        value = "12";
                        break;
                    }
                    case 13: {
                        value = "14";
                        break;
                    }
                    case 14: {
                        value = "13";
                    }
                }
                dataMatrix = String.valueOf(dataMatrix) + value + ", ";
                if (i == 28) {
                    dataMatrix = String.valueOf(dataMatrix) + "\r\n";
                }
                i += 3;
            }
            j += 2;
        }
        dataMatrix = this.upperBatActive ? String.valueOf(dataMatrix) + "1, " : String.valueOf(dataMatrix) + "0, ";
        dataMatrix = this.lowerBatActive ? String.valueOf(dataMatrix) + "1, " : String.valueOf(dataMatrix) + "0, ";
        dataMatrix = this.leftBatActive ? String.valueOf(dataMatrix) + "1, " : String.valueOf(dataMatrix) + "0, ";
        dataMatrix = this.rightBatActive ? String.valueOf(dataMatrix) + "1, " : String.valueOf(dataMatrix) + "0,";
        dataMatrix = String.valueOf(dataMatrix) + " // Upper, lower, left, right bat is 1-active/0 - inactive";
        dataMatrix = String.valueOf(dataMatrix) + "\r\n";
        dataMatrix = this.upperBorder ? String.valueOf(dataMatrix) + "0, " : String.valueOf(dataMatrix) + "1, ";
        dataMatrix = this.lowerBorder ? String.valueOf(dataMatrix) + "0, " : String.valueOf(dataMatrix) + "1, ";
        dataMatrix = this.leftBorder ? String.valueOf(dataMatrix) + "0, " : String.valueOf(dataMatrix) + "1, ";
        dataMatrix = this.rightBorder ? String.valueOf(dataMatrix) + "0, " : String.valueOf(dataMatrix) + "1,";
        dataMatrix = String.valueOf(dataMatrix) + " // Upper, lower, left, right border is 0-closed/1-open";
        dataMatrix = String.valueOf(dataMatrix) + "\r\n\n";
        System.out.print("\n" + dataMatrix);
        PrintWriter output = WallNBallEdit.createWriter((File)path);
        output.println(dataMatrix);
        output.flush();
        output.close();
        StringSelection data = new StringSelection(dataMatrix);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(data, data);
        this.diskOperationPending = false;
    }

    public void outputFileSelected(File selection) {
        if (selection == null) {
            WallNBallEdit.println((String)"File requester was closed, or user hit cancel.");
            return;
        }
        this.exportData(selection);
    }

    public void inputFileSelected(File selection) {
        if (selection == null) {
            WallNBallEdit.println((String)"File requester was either closed, or the user hit cancel.");
        } else if (!selection.exists()) {
            WallNBallEdit.println((String)"The file does not exist.");
        } else {
            WallNBallEdit.println((String)("Try to load Arena data from file " + selection.getAbsolutePath()));
            String[] lines = WallNBallEdit.loadStrings((File)selection);
            WallNBallEdit.println((String)("There are " + lines.length + " lines in the file"));
            int row = 0;
            String[] m = new String[lines.length];
            while ((m = WallNBallEdit.match((String)lines[row], (String)"(\\d+,)+")) == null && ++row < lines.length) {
            }
            if (m != null) {
                System.out.print("\nFile contains lines of the required format.");
                int i = 0;
                while (i < 15) {
                    String[] tokens = WallNBallEdit.splitTokens((String)lines[i], (String)",");
                    int j = 0;
                    while (j < 10) {
                        int brickID = Integer.parseInt(WallNBallEdit.trim((String)tokens[j]));
                        switch (brickID) {
                            case 0: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 7);
                                break;
                            }
                            case 1: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 7);
                                break;
                            }
                            case 2: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 0);
                                break;
                            }
                            case 3: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 1);
                                break;
                            }
                            case 4: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 2);
                                break;
                            }
                            case 5: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 4);
                                break;
                            }
                            case 6: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 3);
                                break;
                            }
                            case 7: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 6);
                                break;
                            }
                            case 8: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 5);
                                break;
                            }
                            case 9: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 9);
                                break;
                            }
                            case 10: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 10);
                                break;
                            }
                            case 11: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 11);
                                break;
                            }
                            case 12: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 12);
                                break;
                            }
                            case 13: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 14);
                                break;
                            }
                            case 14: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 13);
                                break;
                            }
                            case 15: {
                                this.writeFrameBuffer(1 + 3 * j, 1 + 2 * i, 8);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                row = 15;
                String[] tokens = WallNBallEdit.splitTokens((String)lines[row], (String)",");
                if (Integer.parseInt(WallNBallEdit.trim((String)tokens[0])) == 0) {
                    this.upperBatActive = false;
                    this.upperBatActiveSel.pressed = false;
                } else {
                    this.upperBatActive = true;
                    this.upperBatActiveSel.pressed = true;
                }
                if (Integer.parseInt(WallNBallEdit.trim((String)tokens[1])) == 0) {
                    this.lowerBatActive = false;
                    this.lowerBatActiveSel.pressed = false;
                } else {
                    this.lowerBatActive = true;
                    this.lowerBatActiveSel.pressed = true;
                }
                if (Integer.parseInt(WallNBallEdit.trim((String)tokens[2])) == 0) {
                    this.leftBatActive = false;
                    this.leftBatActiveSel.pressed = false;
                } else {
                    this.leftBatActive = true;
                    this.leftBatActiveSel.pressed = true;
                }
                if (Integer.parseInt(WallNBallEdit.trim((String)tokens[3])) == 0) {
                    this.rightBatActive = false;
                    this.rightBatActiveSel.pressed = false;
                } else {
                    this.rightBatActive = true;
                    this.rightBatActiveSel.pressed = true;
                }
                row = 16;
                tokens = WallNBallEdit.splitTokens((String)lines[row], (String)",");
                if (Integer.parseInt(WallNBallEdit.trim((String)tokens[0])) == 1) {
                    this.upperBorder = false;
                    this.upperGap.pressed = true;
                } else {
                    this.upperBorder = true;
                    this.upperGap.pressed = false;
                }
                if (Integer.parseInt(WallNBallEdit.trim((String)tokens[1])) == 1) {
                    this.lowerBorder = false;
                    this.lowerGap.pressed = true;
                } else {
                    this.lowerBorder = true;
                    this.lowerGap.pressed = false;
                }
                if (Integer.parseInt(WallNBallEdit.trim((String)tokens[2])) == 1) {
                    this.leftBorder = false;
                    this.leftGap.pressed = true;
                } else {
                    this.leftBorder = true;
                    this.leftGap.pressed = false;
                }
                if (Integer.parseInt(WallNBallEdit.trim((String)tokens[3])) == 1) {
                    this.rightBorder = false;
                    this.rightGap.pressed = true;
                } else {
                    this.rightBorder = true;
                    this.rightGap.pressed = false;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WallNBallEdit.this.upperBatActiveSel.repaint();
                        WallNBallEdit.this.lowerBatActiveSel.repaint();
                        WallNBallEdit.this.leftBatActiveSel.repaint();
                        WallNBallEdit.this.rightBatActiveSel.repaint();
                        WallNBallEdit.this.upperGap.repaint();
                        WallNBallEdit.this.lowerGap.repaint();
                        WallNBallEdit.this.leftGap.repaint();
                        WallNBallEdit.this.rightGap.repaint();
                        WallNBallEdit.this.drawArenaBorder();
                    }
                });
                this.fileLoaded = true;
                this.redraw();
            }
        }
        this.diskOperationPending = false;
    }

    public void writeFrameBuffer(int i, int j, int brickID) {
        this.frameBuffer[i + 0][j + 0] = brickID;
        this.frameBuffer[i + 1][j + 0] = brickID;
        this.frameBuffer[i + 2][j + 0] = brickID;
        this.frameBuffer[i + 0][j + 1] = brickID;
        this.frameBuffer[i + 1][j + 1] = brickID;
        this.frameBuffer[i + 2][j + 1] = brickID;
    }

    public void settings() {
        this.size(1371, 970);
        this.noSmooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"WallNBallEdit"};
        if (passedArgs != null) {
            PApplet.main((String[])WallNBallEdit.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    public class BatSelectButton {
        private int x;
        private int y;
        private int w;
        private int h;
        private int type;
        private String text;
        private boolean pressed;
        public boolean hasFocus;

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            return false;
        }

        public BatSelectButton(int type, int x, int y, int w, int h, boolean usesBat) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.pressed = usesBat;
            this.type = type;
            if (type == 0) {
                this.text = "Upper Bat";
            } else if (type == 1) {
                this.text = "Lower Bat";
            } else if (type == 2) {
                this.text = "Left Bat";
            } else if (type == 3) {
                this.text = "Right Bat";
            }
            this.hasFocus = false;
            this.repaint();
            WallNBallEdit.this.redraw();
        }

        public void toggle() {
            this.pressed = !this.pressed;
            this.repaint();
            if (this.type == 0) {
                WallNBallEdit.this.upperBatActive = !WallNBallEdit.this.upperBatActive;
            } else if (this.type == 1) {
                WallNBallEdit.this.lowerBatActive = !WallNBallEdit.this.lowerBatActive;
            } else if (this.type == 2) {
                WallNBallEdit.this.leftBatActive = !WallNBallEdit.this.leftBatActive;
            } else if (this.type == 3) {
                WallNBallEdit.this.rightBatActive = !WallNBallEdit.this.rightBatActive;
            }
            WallNBallEdit.this.drawBats();
            WallNBallEdit.this.redraw();
        }

        public void repaint() {
            if (WallNBallEdit.this.f == null) {
                WallNBallEdit.this.f = WallNBallEdit.this.loadFont("ArialMT-30.vlw");
            }
            WallNBallEdit.this.textFont(WallNBallEdit.this.f, 30.0f);
            if (this.pressed) {
                WallNBallEdit.this.stroke(0);
                WallNBallEdit.this.strokeWeight(2.0f);
                WallNBallEdit.this.fill(WallNBallEdit.this.black);
                WallNBallEdit.this.rect(this.x, this.y, this.w, this.h);
                WallNBallEdit.this.strokeWeight(1.0f);
                WallNBallEdit.this.fill(7);
                WallNBallEdit.this.text(this.text, this.x + 10, this.y + 35);
            } else {
                WallNBallEdit.this.stroke(WallNBallEdit.this.contourCol);
                WallNBallEdit.this.fill(7);
                WallNBallEdit.this.strokeWeight(2.0f);
                WallNBallEdit.this.rect(this.x, this.y, this.w, this.h);
                WallNBallEdit.this.strokeWeight(1.0f);
                WallNBallEdit.this.fill(0);
                WallNBallEdit.this.text(this.text, this.x + 10, this.y + 35);
            }
        }
    }

    public class ClearButton {
        private int x;
        private int y;
        private int w;
        private int h;
        public boolean pressed;
        public boolean hasFocus;

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            return false;
        }

        public ClearButton(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.hasFocus = false;
            this.pressed = false;
            this.repaint();
        }

        public void repaint() {
            if (WallNBallEdit.this.f == null) {
                WallNBallEdit.this.f = WallNBallEdit.this.loadFont("ArialMT-30.vlw");
            }
            WallNBallEdit.this.textFont(WallNBallEdit.this.f, 30.0f);
            if (this.pressed) {
                WallNBallEdit.this.stroke(7);
                WallNBallEdit.this.strokeWeight(2.0f);
                WallNBallEdit.this.fill(WallNBallEdit.this.black);
                WallNBallEdit.this.rect(this.x, this.y, this.w, this.h);
                WallNBallEdit.this.strokeWeight(1.0f);
                WallNBallEdit.this.fill(7);
                WallNBallEdit.this.text("Clear Arena", this.x + 10, this.y + 35);
                this.pressed = false;
            } else {
                WallNBallEdit.this.stroke(WallNBallEdit.this.contourCol);
                WallNBallEdit.this.fill(7);
                WallNBallEdit.this.strokeWeight(2.0f);
                WallNBallEdit.this.rect(this.x, this.y, this.w, this.h);
                WallNBallEdit.this.strokeWeight(1.0f);
                WallNBallEdit.this.fill(WallNBallEdit.this.contourCol);
                WallNBallEdit.this.text("Clear Arena", this.x + 10, this.y + 35);
            }
        }
    }

    public class ElementSelector
    implements SelectionTool {
        private int type;
        private int x;
        private int y;
        private int w;
        private int h;
        public boolean selected;
        private ToolGroup group;

        @Override
        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.repaint();
                return true;
            }
            return false;
        }

        public ElementSelector(int type, int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.type = type;
            this.selected = false;
            this.repaint();
        }

        @Override
        public void repaint() {
            int c = WallNBallEdit.this.darkGrey;
            WallNBallEdit.this.strokeWeight(2.0f);
            if (!this.selected) {
                switch (this.type) {
                    case 0: {
                        c = WallNBallEdit.this.red;
                        break;
                    }
                    case 1: {
                        c = WallNBallEdit.this.green;
                        break;
                    }
                    case 2: {
                        c = WallNBallEdit.this.blue;
                        break;
                    }
                    case 3: {
                        c = WallNBallEdit.this.yellow;
                        break;
                    }
                    case 4: {
                        c = WallNBallEdit.this.violet;
                        break;
                    }
                    case 5: {
                        c = WallNBallEdit.this.orange;
                        break;
                    }
                    case 6: {
                        c = WallNBallEdit.this.solid;
                        break;
                    }
                    case 7: {
                        c = WallNBallEdit.this.empty;
                        break;
                    }
                    case 9: {
                        c = WallNBallEdit.this.empty;
                        break;
                    }
                    case 8: {
                        c = WallNBallEdit.this.empty;
                        break;
                    }
                    case 10: {
                        c = WallNBallEdit.this.empty;
                        break;
                    }
                    case 11: {
                        c = WallNBallEdit.this.empty;
                        break;
                    }
                    case 12: {
                        c = WallNBallEdit.this.empty;
                        break;
                    }
                    case 13: {
                        c = WallNBallEdit.this.empty;
                        break;
                    }
                    case 14: {
                        c = WallNBallEdit.this.empty;
                    }
                }
                WallNBallEdit.this.fill(2);
                WallNBallEdit.this.stroke(WallNBallEdit.this.contourCol);
                WallNBallEdit.this.strokeWeight(2.0f);
                WallNBallEdit.this.rect(this.x, this.y, 75.0f, 50.0f);
                WallNBallEdit.this.noStroke();
                WallNBallEdit.this.fill(c);
                WallNBallEdit.this.ellipse(this.x + 12, this.y + 12, 12.0f, 12.0f);
                WallNBallEdit.this.ellipse(this.x + 37, this.y + 12, 12.0f, 12.0f);
                WallNBallEdit.this.ellipse(this.x + 62, this.y + 12, 12.0f, 12.0f);
                WallNBallEdit.this.ellipse(this.x + 12, this.y + 37, 12.0f, 12.0f);
                WallNBallEdit.this.ellipse(this.x + 37, this.y + 37, 12.0f, 12.0f);
                WallNBallEdit.this.ellipse(this.x + 62, this.y + 37, 12.0f, 12.0f);
            } else {
                WallNBallEdit.this.noFill();
                WallNBallEdit.this.stroke(WallNBallEdit.this.red);
                WallNBallEdit.this.rect(this.x, this.y, 75.0f, 50.0f);
                WallNBallEdit.this.noStroke();
            }
            WallNBallEdit.this.fill(WallNBallEdit.this.solid);
            switch (this.type) {
                case 9: {
                    WallNBallEdit.this.ellipse(this.x + 12, this.y + 12, 12.0f, 12.0f);
                    WallNBallEdit.this.ellipse(this.x + 37, this.y + 12, 12.0f, 12.0f);
                    WallNBallEdit.this.ellipse(this.x + 62, this.y + 12, 12.0f, 12.0f);
                    break;
                }
                case 8: {
                    WallNBallEdit.this.ellipse(this.x + 12, this.y + 37, 12.0f, 12.0f);
                    WallNBallEdit.this.ellipse(this.x + 37, this.y + 37, 12.0f, 12.0f);
                    WallNBallEdit.this.ellipse(this.x + 62, this.y + 37, 12.0f, 12.0f);
                    break;
                }
                case 10: {
                    WallNBallEdit.this.ellipse(this.x + 37, this.y + 12, 12.0f, 12.0f);
                    WallNBallEdit.this.ellipse(this.x + 37, this.y + 37, 12.0f, 12.0f);
                    break;
                }
                case 12: {
                    WallNBallEdit.this.ellipse(this.x + 12, this.y + 12, 12.0f, 12.0f);
                    WallNBallEdit.this.ellipse(this.x + 37, this.y + 12, 12.0f, 12.0f);
                    WallNBallEdit.this.ellipse(this.x + 37, this.y + 37, 12.0f, 12.0f);
                    break;
                }
                case 11: {
                    WallNBallEdit.this.ellipse(this.x + 37, this.y + 12, 12.0f, 12.0f);
                    WallNBallEdit.this.ellipse(this.x + 62, this.y + 12, 12.0f, 12.0f);
                    WallNBallEdit.this.ellipse(this.x + 37, this.y + 37, 12.0f, 12.0f);
                    break;
                }
                case 14: {
                    WallNBallEdit.this.ellipse(this.x + 37, this.y + 12, 12.0f, 12.0f);
                    WallNBallEdit.this.ellipse(this.x + 37, this.y + 37, 12.0f, 12.0f);
                    WallNBallEdit.this.ellipse(this.x + 12, this.y + 37, 12.0f, 12.0f);
                    break;
                }
                case 13: {
                    WallNBallEdit.this.ellipse(this.x + 37, this.y + 12, 12.0f, 12.0f);
                    WallNBallEdit.this.ellipse(this.x + 37, this.y + 37, 12.0f, 12.0f);
                    WallNBallEdit.this.ellipse(this.x + 62, this.y + 37, 12.0f, 12.0f);
                }
            }
        }

        @Override
        public void select() {
            this.selected = true;
            this.group.toggle(this);
            this.repaint();
        }

        @Override
        public void unselect() {
            this.selected = false;
            this.repaint();
        }

        @Override
        public void setToolGroup(ToolGroup group) {
            this.group = group;
            group.register(this);
        }
    }

    public class ExportButton {
        private int x;
        private int y;
        private int w;
        private int h;
        public boolean pressed;
        public boolean hasFocus;

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            return false;
        }

        public ExportButton(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.hasFocus = false;
            this.pressed = false;
            this.repaint();
        }

        public void repaint() {
            if (WallNBallEdit.this.f == null) {
                WallNBallEdit.this.f = WallNBallEdit.this.loadFont("ArialMT-30.vlw");
            }
            WallNBallEdit.this.textFont(WallNBallEdit.this.f, 30.0f);
            if (this.pressed) {
                WallNBallEdit.this.stroke(7);
                WallNBallEdit.this.strokeWeight(2.0f);
                WallNBallEdit.this.fill(WallNBallEdit.this.black);
                WallNBallEdit.this.rect(this.x, this.y, this.w, this.h);
                WallNBallEdit.this.strokeWeight(1.0f);
                WallNBallEdit.this.fill(7);
                WallNBallEdit.this.text("Export", this.x + 10, this.y + 35);
                this.pressed = false;
            } else {
                WallNBallEdit.this.stroke(WallNBallEdit.this.contourCol);
                WallNBallEdit.this.fill(7);
                WallNBallEdit.this.strokeWeight(2.0f);
                WallNBallEdit.this.rect(this.x, this.y, this.w, this.h);
                WallNBallEdit.this.strokeWeight(1.0f);
                WallNBallEdit.this.fill(WallNBallEdit.this.contourCol);
                WallNBallEdit.this.text("Export", this.x + 10, this.y + 35);
            }
        }
    }

    public class GapSelectButton {
        private int x;
        private int y;
        private int w;
        private int h;
        private int type;
        private String text;
        public boolean pressed;
        public boolean hasFocus;

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            return false;
        }

        public GapSelectButton(int type, int x, int y, int w, int h, boolean isOpen) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.type = type;
            if (type == 0) {
                this.text = "Upper Border";
            } else if (type == 1) {
                this.text = "Lower Border";
            } else if (type == 2) {
                this.text = "Left Border";
            } else if (type == 3) {
                this.text = "Right Border";
            }
            this.hasFocus = false;
            this.pressed = isOpen;
            this.repaint();
            WallNBallEdit.this.redraw();
        }

        public void toggle() {
            this.pressed = !this.pressed;
            this.repaint();
            if (this.type == 0) {
                WallNBallEdit.this.upperBorder = !WallNBallEdit.this.upperBorder;
            } else if (this.type == 1) {
                WallNBallEdit.this.lowerBorder = !WallNBallEdit.this.lowerBorder;
            } else if (this.type == 2) {
                WallNBallEdit.this.leftBorder = !WallNBallEdit.this.leftBorder;
            } else if (this.type == 3) {
                WallNBallEdit.this.rightBorder = !WallNBallEdit.this.rightBorder;
            }
            WallNBallEdit.this.drawArenaBorder();
            WallNBallEdit.this.redraw();
        }

        public void repaint() {
            if (WallNBallEdit.this.f == null) {
                WallNBallEdit.this.f = WallNBallEdit.this.loadFont("ArialMT-30.vlw");
            }
            WallNBallEdit.this.textFont(WallNBallEdit.this.f, 30.0f);
            if (this.pressed) {
                WallNBallEdit.this.stroke(0);
                WallNBallEdit.this.strokeWeight(2.0f);
                WallNBallEdit.this.fill(WallNBallEdit.this.black);
                WallNBallEdit.this.rect(this.x, this.y, this.w, this.h);
                WallNBallEdit.this.strokeWeight(1.0f);
                WallNBallEdit.this.fill(7);
                WallNBallEdit.this.text(this.text, this.x + 10, this.y + 35);
            } else {
                WallNBallEdit.this.stroke(WallNBallEdit.this.contourCol);
                WallNBallEdit.this.fill(7);
                WallNBallEdit.this.strokeWeight(2.0f);
                WallNBallEdit.this.rect(this.x, this.y, this.w, this.h);
                WallNBallEdit.this.strokeWeight(1.0f);
                WallNBallEdit.this.fill(0);
                WallNBallEdit.this.text(this.text, this.x + 10, this.y + 35);
            }
        }
    }

    public class LoadButton {
        private int x;
        private int y;
        private int w;
        private int h;
        public boolean pressed;
        public boolean hasFocus;

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            return false;
        }

        public LoadButton(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.pressed = false;
            this.repaint();
        }

        public void repaint() {
            WallNBallEdit.this.textFont(WallNBallEdit.this.f, 30.0f);
            if (this.pressed) {
                WallNBallEdit.this.stroke(7);
                WallNBallEdit.this.strokeWeight(2.0f);
                WallNBallEdit.this.fill(WallNBallEdit.this.black);
                WallNBallEdit.this.rect(this.x, this.y, this.w, this.h);
                WallNBallEdit.this.strokeWeight(1.0f);
                WallNBallEdit.this.fill(7);
                WallNBallEdit.this.text("Load", this.x + 10, this.y + 35);
                this.pressed = false;
            } else {
                WallNBallEdit.this.stroke(WallNBallEdit.this.contourCol);
                WallNBallEdit.this.fill(7);
                WallNBallEdit.this.strokeWeight(2.0f);
                WallNBallEdit.this.rect(this.x, this.y, this.w, this.h);
                WallNBallEdit.this.strokeWeight(1.0f);
                WallNBallEdit.this.fill(WallNBallEdit.this.contourCol);
                WallNBallEdit.this.text("Load", this.x + 10, this.y + 35);
            }
        }
    }

    static interface Selectable {
        public static final int x = 0;
        public static final int y = 0;
        public static final int w = 0;
        public static final int h = 0;
        public static final boolean selected = false;

        public void repaint();

        public void select();

        public void unselect();

        public boolean mouseOver(int var1, int var2);

        public void setToolGroup(ToolGroup var1);
    }

    static interface SelectionTool {
        public static final int x = 0;
        public static final int y = 0;
        public static final int w = 0;
        public static final int h = 0;
        public static final boolean selected = false;

        public void repaint();

        public void select();

        public void unselect();

        public boolean mouseOver(int var1, int var2);

        public void setToolGroup(ToolGroup var1);
    }

    class ToolGroup {
        Vector<SelectionTool> group = new Vector();

        ToolGroup() {
        }

        public void register(SelectionTool tool) {
            this.group.add(tool);
        }

        public Vector<SelectionTool> getTools() {
            return this.group;
        }

        public void toggle(SelectionTool tool) {
            for (SelectionTool t : this.group) {
                tool.repaint();
                if (t == tool) continue;
                t.unselect();
                t.repaint();
            }
        }
    }
}

