/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import processing.core.PApplet;
import processing.core.PFont;

public class LEDmePlayDraw_270117
extends PApplet {
    final int mPOINT = 0;
    final int mBOX = 1;
    final int mLINE = 2;
    final int mCIRCLE = 3;
    final int mFILL = 4;
    final int RED = 0;
    final int GREEN = 1;
    final int BLUE = 2;
    final int ledOffIndex = 4864;
    final int UNDO_STEPS = 1000;
    int drawingMode;
    LineTool lineTool;
    PointTool pointTool;
    BoxTool boxTool;
    CircleTool circleTool;
    FillTool fillTool;
    ToolGroup toolGroup = new ToolGroup();
    ExportButton exportButton;
    ClearButton clearButton;
    LoadButton loadButton;
    UndoButton undoButton;
    RedoButton redoButton;
    ColorManipulator color1Manipulator;
    ColorManipulator color2Manipulator;
    ColorRGB444Palette palette;
    UndoBuffer undoHistory;
    public int[] indexColor = new int[4929];
    public PFont f;
    public int currentLED_x;
    public int currentLED_y;
    public int formerLED_x;
    public int formerLED_y;
    public int[][] frameBuffer = new int[32][32];
    public int[][] backBuffer = new int[32][32];
    public int foregroundCol;
    public int backgroundCol;
    public int contourCol;
    public int black;
    public int white;
    public int grey;
    public int red;
    public boolean useColor1 = true;
    public boolean useColor2 = false;
    public int dotDiameter = 13;
    public int indexColor1 = 255;
    public int indexColor2 = 4864;
    public int currentColor_x;
    public int currentColor_y;
    public int formerColor_x;
    public int formerColor_y;
    public int currentColorIndex;
    public boolean diskOperationPending = false;
    public int defaultBlue = 15;
    public int startX;
    public int startY;
    public int endX;
    public int endY;
    public boolean dragging;
    public boolean fileLoaded = false;

    public void setup() {
        this.colorMode(1, 16.0f, 16.0f, 16.0f);
        this.background(6);
        this.red = this.color(13, 2, 2);
        this.white = this.color(15, 15, 15);
        this.black = this.color(0, 0, 0);
        this.grey = this.color(9, 9, 9);
        this.contourCol = this.color(0, 0, 0);
        this.clearLEDmePlayFrameBuffer();
        this.palette = new ColorRGB444Palette(960, 45, 875, 629, this.indexColor, this.defaultBlue);
        this.drawEmptyMatrix();
        this.foregroundCol = this.indexColor[this.indexColor1];
        this.backgroundCol = this.indexColor[this.indexColor2];
        this.pointTool = new PointTool(1000, 840, 50, 50);
        this.pointTool.setToolGroup(this.toolGroup);
        this.pointTool.select();
        this.drawingMode = 0;
        this.lineTool = new LineTool(1140, 840, 50, 50);
        this.lineTool.setToolGroup(this.toolGroup);
        this.circleTool = new CircleTool(1210, 840, 50, 50);
        this.circleTool.setToolGroup(this.toolGroup);
        this.boxTool = new BoxTool(1070, 840, 50, 50);
        this.boxTool.setToolGroup(this.toolGroup);
        this.fillTool = new FillTool(1280, 840, 50, 50);
        this.fillTool.setToolGroup(this.toolGroup);
        this.clearButton = new ClearButton(1350, 840, 175, 50);
        this.exportButton = new ExportButton(1600, 840, 105, 50);
        this.loadButton = new LoadButton(1720, 840, 85, 50);
        this.undoButton = new UndoButton(1000, 907, 90, 50);
        this.redoButton = new RedoButton(1110, 907, 90, 50);
        this.color1Manipulator = new ColorManipulator(995, 715, this.indexColor, this.indexColor1, "Color1");
        this.color2Manipulator = new ColorManipulator(1355, 715, this.indexColor, this.indexColor2, "Color2");
        this.color2Manipulator.deactivated = true;
        this.color2Manipulator.repaint();
        this.undoHistory = new UndoBuffer(1000);
        this.f = this.loadFont("ArialMT-30.vlw");
        if (this.f == null) {
            this.f = this.loadFont("ArialMT-30.vlw");
        }
        this.textFont(this.f, 30.0f);
        this.formerLED_x = 1;
        this.formerLED_y = 1;
        this.currentLED_x = 0;
        this.currentLED_y = 0;
        this.currentColor_x = 0;
        this.currentColor_y = 0;
        this.formerColor_x = -50;
        this.formerColor_y = -50;
    }

    public void draw() {
        int colIndex = 0;
        if (this.diskOperationPending) {
            this.fill(0);
            this.textFont(this.f, 30.0f);
            this.fill(6.0f, 6.0f, 6.0f);
            this.noStroke();
            this.rect(39.0f, 920.0f, 900.0f, 40.0f);
            this.fill(this.black);
            this.text("Please wait - disk operation pending...", 40.0f, 950.0f);
            return;
        }
        if (this.mouseX > 36 && this.mouseX < 895 && this.mouseY > 36 && this.mouseY < 895) {
            if (this.drawingMode == 0) {
                if (this.mousePressed) {
                    this.backupFrameBuffer();
                    this.currentLED_x = (this.mouseX - 40) / 27;
                    this.currentLED_y = (this.mouseY - 40) / 27;
                    this.noStroke();
                    if (this.mouseButton == 37) {
                        this.fill(this.indexColor[this.indexColor1]);
                        this.frameBuffer[this.currentLED_x][this.currentLED_y] = this.indexColor1;
                    } else if (this.mouseButton == 39) {
                        this.fill(this.indexColor[this.indexColor2]);
                        this.frameBuffer[this.currentLED_x][this.currentLED_y] = this.indexColor2;
                    }
                    this.ellipse(50 + this.currentLED_x * 27, 50 + this.currentLED_y * 27, this.dotDiameter, this.dotDiameter);
                }
            } else if (this.drawingMode == 2) {
                if (this.mousePressed) {
                    this.restoreFrameBuffer();
                    colIndex = this.mouseButton == 37 ? this.indexColor1 : this.indexColor2;
                    if (!this.dragging) {
                        this.startX = this.mouseX;
                        this.startY = this.mouseY;
                        this.dragging = true;
                    } else {
                        this.backupFrameBuffer();
                        this.endX = this.mouseX;
                        this.endY = this.mouseY;
                        this.drawLEDLine(this.startX, this.startY, this.endX, this.endY, colIndex);
                    }
                }
            } else if (this.drawingMode == 1) {
                if (this.mousePressed) {
                    this.restoreFrameBuffer();
                    colIndex = this.mouseButton == 37 ? this.indexColor1 : this.indexColor2;
                    if (!this.dragging) {
                        this.startX = this.mouseX;
                        this.startY = this.mouseY;
                        this.dragging = true;
                    } else {
                        this.backupFrameBuffer();
                        this.endX = this.mouseX;
                        this.endY = this.mouseY;
                        this.stroke(this.white);
                        this.strokeWeight(1.0f);
                        this.noFill();
                        this.drawLEDBox(this.startX, this.startY, this.endX, this.endY, colIndex);
                    }
                }
            } else if (this.drawingMode == 3) {
                if (this.mousePressed) {
                    this.restoreFrameBuffer();
                    colIndex = this.mouseButton == 37 ? this.indexColor1 : this.indexColor2;
                    if (!this.dragging) {
                        this.startX = this.mouseX;
                        this.startY = this.mouseY;
                        this.dragging = true;
                    } else {
                        this.backupFrameBuffer();
                        this.endX = this.mouseX;
                        this.endY = this.mouseY;
                        this.stroke(this.white);
                        this.strokeWeight(1.0f);
                        this.noFill();
                        this.drawLEDCircle(this.startX, this.startY, this.endX, this.endY, colIndex);
                    }
                }
            } else if (this.drawingMode == 4 && this.mousePressed) {
                this.backupFrameBuffer();
                this.currentLED_x = (this.mouseX - 40) / 27;
                this.currentLED_y = (this.mouseY - 40) / 27;
                this.noStroke();
                colIndex = this.mouseButton == 37 ? this.indexColor1 : this.indexColor2;
                this.fillArea(this.currentLED_x, this.currentLED_y, colIndex);
            }
        }
        if (this.fileLoaded) {
            this.fileLoaded = false;
            this.indexColor[0] = 4864;
            if (this.color1Manipulator != null) {
                this.color1Manipulator.setNewColorIndex(this.indexColor1);
                this.color1Manipulator.repaint();
            }
            if (this.color2Manipulator != null) {
                this.color2Manipulator.setNewColorIndex(this.indexColor2);
                this.color2Manipulator.repaint();
            }
            this.palette.repaintUpperLeftColorBox = true;
            this.palette.repaintUpperRightColorBox = true;
            this.palette.repaintLowerLeftColorBox = true;
            this.palette.repaintDynamicColorBox = true;
            this.palette.repaint64ColorBox = true;
            this.palette.repaint();
            this.pointTool.select();
            this.drawingMode = 0;
            this.drawEmptyMatrix();
            this.drawFrameBuffer();
        }
    }

    public void fillArea(int x, int y, int colIndex) {
        Stack<Point> stack = new Stack<Point>();
        int bgColIndex = this.frameBuffer[x][y];
        stack.add(new Point(x, y));
        while (!stack.empty() && stack.size() < 8192) {
            Point p = (Point)stack.pop();
            if (this.frameBuffer[p.x][p.y] != bgColIndex) continue;
            this.frameBuffer[p.x][p.y] = colIndex;
            if (p.x >= 0 && p.y - 1 >= 0 && p.x < 32 && p.y - 1 < 32) {
                stack.push(new Point(p.x, p.y - 1));
            }
            if (p.x - 1 >= 0 && p.y >= 0 && p.x - 1 < 32 && p.y < 32) {
                stack.push(new Point(p.x - 1, p.y));
            }
            if (p.x + 1 >= 0 && p.y >= 0 && p.x + 1 < 32 && p.y < 32) {
                stack.push(new Point(p.x + 1, p.y));
            }
            if (p.x < 0 || p.y + 1 < 0 || p.x >= 32 || p.y + 1 >= 32) continue;
            stack.push(new Point(p.x, p.y + 1));
        }
        this.drawFrameBuffer();
    }

    public void backupFrameBuffer() {
        int x = 0;
        while (x < 32) {
            int y = 0;
            while (y < 32) {
                this.backBuffer[x][y] = this.frameBuffer[x][y];
                ++y;
            }
            ++x;
        }
    }

    public void restoreFrameBuffer() {
        this.noStroke();
        int x = 0;
        while (x < 32) {
            int y = 0;
            while (y < 32) {
                this.frameBuffer[x][y] = this.backBuffer[x][y];
                this.fill(this.indexColor[this.frameBuffer[x][y]]);
                this.ellipse(50 + x * 27, 50 + y * 27, this.dotDiameter, this.dotDiameter);
                ++y;
            }
            ++x;
        }
    }

    public void drawFrameBuffer() {
        this.noStroke();
        int x = 0;
        while (x < 32) {
            int y = 0;
            while (y < 32) {
                this.fill(0);
                this.ellipse(50 + x * 27, 50 + y * 27, this.dotDiameter + 1, this.dotDiameter + 1);
                this.fill(this.indexColor[this.frameBuffer[x][y]]);
                this.ellipse(50 + x * 27, 50 + y * 27, this.dotDiameter, this.dotDiameter);
                ++y;
            }
            ++x;
        }
    }

    public void makeRGB444Gradient(int fromIndex, int toIndex) {
        int numSteps = LEDmePlayDraw_270117.abs((int)(fromIndex - toIndex));
        int fromColor = this.indexColor[fromIndex];
        int toColor = this.indexColor[toIndex];
        float redFraction = (this.red(toColor) - this.red(fromColor)) / (float)numSteps;
        float greenFraction = (this.green(toColor) - this.green(fromColor)) / (float)numSteps;
        float blueFraction = (this.blue(toColor) - this.blue(fromColor)) / (float)numSteps;
        LEDmePlayDraw_270117.println((String)("red, green blue fraction: " + redFraction + ", " + greenFraction + ", " + blueFraction));
        int col = this.indexColor[fromIndex];
        int step = 1;
        int index = fromIndex + 1;
        while (index < toIndex) {
            this.indexColor[index] = this.color(this.red(col) + (float)step * redFraction, this.green(col) + (float)step * greenFraction, this.blue(col) + (float)step * blueFraction);
            ++step;
            ++index;
        }
    }

    public void drawLEDLine(int fromX, int fromY, int toX, int toY, int colIndex) {
        this.fill(this.indexColor[colIndex]);
        this.noStroke();
        int x0 = (fromX - 40) / 27;
        int y0 = (fromY - 40) / 27;
        int x1 = (toX - 40) / 27;
        int y1 = (toY - 40) / 27;
        int dx = LEDmePlayDraw_270117.abs((int)(x1 - x0));
        int sx = x0 < x1 ? 1 : -1;
        int dy = -LEDmePlayDraw_270117.abs((int)(y1 - y0));
        int sy = y0 < y1 ? 1 : -1;
        int err = dx + dy;
        while (true) {
            this.ellipse(50 + x0 * 27, 50 + y0 * 27, this.dotDiameter, this.dotDiameter);
            this.frameBuffer[x0][y0] = colIndex;
            if (x0 == x1 && y0 == y1) break;
            int e2 = 2 * err;
            if (e2 > dy) {
                err += dy;
                x0 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y0 += sy;
        }
    }

    public void drawLEDBox(int startX, int startY, int endX, int endY, int colIndex) {
        this.drawLEDLine(startX, startY, endX, startY, colIndex);
        this.drawLEDLine(startX, startY, startX, endY, colIndex);
        this.drawLEDLine(startX, endY, endX, endY, colIndex);
        this.drawLEDLine(endX, startY, endX, endY, colIndex);
    }

    public void drawLEDCircle(int fromX, int fromY, int toX, int toY, int colIndex) {
        this.fill(this.indexColor[colIndex]);
        this.noStroke();
        int x0 = (fromX - 40) / 27;
        int y0 = (fromY - 40) / 27;
        int x1 = (toX - 40) / 27;
        int y1 = (toY - 40) / 27;
        int radius = LEDmePlayDraw_270117.floor((float)LEDmePlayDraw_270117.sqrt((float)((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0))));
        int f = 1 - radius;
        int ddF_x = 0;
        int ddF_y = -2 * radius;
        int x = 0;
        int y = radius;
        this.setPixel(x0, y0 + radius, colIndex);
        this.setPixel(x0, y0 - radius, colIndex);
        this.setPixel(x0 + radius, y0, colIndex);
        this.setPixel(x0 - radius, y0, colIndex);
        while (x < y) {
            if (f >= 0) {
                --y;
                f += (ddF_y += 2);
            }
            f += (ddF_x += 2) + 1;
            this.setPixel(x0 + ++x, y0 + y, colIndex);
            this.setPixel(x0 - x, y0 + y, colIndex);
            this.setPixel(x0 + x, y0 - y, colIndex);
            this.setPixel(x0 - x, y0 - y, colIndex);
            this.setPixel(x0 + y, y0 + x, colIndex);
            this.setPixel(x0 - y, y0 + x, colIndex);
            this.setPixel(x0 + y, y0 - x, colIndex);
            this.setPixel(x0 - y, y0 - x, colIndex);
        }
    }

    public void setPixel(int x, int y, int colIndex) {
        if (50 + x * 27 > 29 && 50 + x * 27 < 891 && 50 + y * 27 > 29 && 50 + y * 27 < 891) {
            this.ellipse(50 + x * 27, 50 + y * 27, this.dotDiameter, this.dotDiameter);
            if (x >= 0 && x <= 31 && y >= 0 && y <= 31) {
                this.frameBuffer[x][y] = colIndex;
            }
        }
    }

    public void drawEmptyMatrix() {
        this.noStroke();
        this.strokeWeight(1.0f);
        this.fill(1);
        this.rect(27.0f, 27.0f, 884.0f, 884.0f);
        this.fill(this.indexColor[4864]);
        int x = 0;
        while (x < 864) {
            int y = 0;
            while (y < 864) {
                this.ellipse(50 + x, 50 + y, this.dotDiameter, this.dotDiameter);
                y += 27;
            }
            x += 27;
        }
    }

    public void clearLEDmePlayFrameBuffer() {
        int x = 0;
        while (x < 32) {
            int y = 0;
            while (y < 32) {
                this.frameBuffer[x][y] = 4864;
                this.backBuffer[x][y] = 4864;
                ++y;
            }
            ++x;
        }
    }

    public void clearMarkings() {
        this.fill(6.0f, 6.0f, 6.0f);
        this.noStroke();
        this.rect(39.0f, 920.0f, 900.0f, 40.0f);
        this.noStroke();
        int colIndex = this.frameBuffer[this.formerLED_x][this.formerLED_y];
        int col = this.indexColor[colIndex];
        this.fill(col);
        this.ellipse(50 + this.formerLED_x * 27, 50 + this.formerLED_y * 27, this.dotDiameter, this.dotDiameter);
        this.palette.repaint();
    }

    public void mouseMoved() {
        if (this.mouseX > 36 && this.mouseX < 895 && this.mouseY > 36 && this.mouseY < 895) {
            this.noStroke();
            this.strokeWeight(1.0f);
            int colIndex = this.frameBuffer[this.formerLED_x][this.formerLED_y];
            int col = this.indexColor[colIndex];
            this.fill(col);
            this.ellipse(50 + this.formerLED_x * 27, 50 + this.formerLED_y * 27, this.dotDiameter, this.dotDiameter);
            this.currentLED_x = (this.mouseX - 40) / 27;
            this.currentLED_y = (this.mouseY - 40) / 27;
            this.noStroke();
            this.fill(13.0f, 13.0f, 13.0f);
            this.ellipse(50 + this.currentLED_x * 27, 50 + this.currentLED_y * 27, this.dotDiameter, this.dotDiameter);
            this.formerLED_x = this.currentLED_x;
            this.formerLED_y = this.currentLED_y;
            if (!this.diskOperationPending) {
                String s;
                this.fill(0);
                this.textFont(this.f, 30.0f);
                this.fill(6.0f, 6.0f, 6.0f);
                this.noStroke();
                this.rect(39.0f, 920.0f, 900.0f, 40.0f);
                this.fill(this.black);
                if (this.frameBuffer[this.currentLED_x][this.currentLED_y] != 4864) {
                    s = "(" + this.currentLED_x + ", " + this.currentLED_y + ") = " + this.frameBuffer[this.currentLED_x][this.currentLED_y] + ": RGB444 color (";
                    int c = this.indexColor[this.frameBuffer[this.currentLED_x][this.currentLED_y]];
                    s = String.valueOf(s) + LEDmePlayDraw_270117.round((float)this.red(c)) + ", " + LEDmePlayDraw_270117.round((float)this.green(c)) + ", " + LEDmePlayDraw_270117.round((float)this.blue(c)) + ")";
                } else {
                    s = "(" + this.currentLED_x + ", " + this.currentLED_y + ") = LED off";
                }
                this.text(s, 40.0f, 950.0f);
            }
        } else {
            this.clearMarkings();
        }
        if (this.exportButton != null && !this.exportButton.mouseOver(this.mouseX, this.mouseY) && this.exportButton.hasFocus) {
            this.exportButton.hasFocus = false;
            this.exportButton.pressed = false;
            this.exportButton.repaint();
        }
        if (this.clearButton != null && !this.clearButton.mouseOver(this.mouseX, this.mouseY) && this.clearButton.hasFocus) {
            this.clearButton.hasFocus = false;
            this.clearButton.pressed = false;
            this.clearButton.repaint();
        }
        if (this.loadButton != null && !this.loadButton.mouseOver(this.mouseX, this.mouseY) && this.loadButton.hasFocus) {
            this.loadButton.hasFocus = false;
            this.loadButton.pressed = false;
            this.loadButton.repaint();
        }
        if (this.undoButton != null && !this.undoButton.mouseOver(this.mouseX, this.mouseY) && this.undoButton.hasFocus) {
            this.undoButton.hasFocus = false;
            this.undoButton.pressed = false;
            this.undoButton.repaint();
        }
        if (this.redoButton != null && !this.redoButton.mouseOver(this.mouseX, this.mouseY) && this.redoButton.hasFocus) {
            this.redoButton.hasFocus = false;
            this.redoButton.pressed = false;
            this.redoButton.repaint();
        }
        if (this.palette != null && this.palette.mouseOver(this.mouseX, this.mouseY) && !this.palette.hasFocus) {
            this.palette.hasFocus = true;
        }
    }

    public void mousePressed() {
        if (this.mouseX > 36 && this.mouseX < 895 && this.mouseY > 36 && this.mouseY < 895) {
            if (this.mouseButton == 37) {
                this.useColor1 = true;
                this.useColor2 = false;
            } else if (this.mouseButton == 39) {
                this.useColor2 = true;
                this.useColor1 = false;
            }
        } else if (this.mouseX > 956 && this.mouseX < 1900 && this.mouseY > 40 && this.mouseY < 684) {
            if (this.mouseButton == 37) {
                this.indexColor1 = this.currentColorIndex;
                this.color1Manipulator.setNewColorIndex(this.indexColor1);
                this.color1Manipulator.deactivated = this.currentColorIndex == 4864;
                this.color1Manipulator.repaint();
            } else {
                this.indexColor2 = this.currentColorIndex;
                this.color2Manipulator.setNewColorIndex(this.indexColor2);
                this.color2Manipulator.deactivated = this.currentColorIndex == 4864;
                this.color2Manipulator.repaint();
            }
        }
        if (this.pointTool != null && this.pointTool.mouseOver(this.mouseX, this.mouseY)) {
            this.pointTool.select();
            this.drawingMode = 0;
        }
        if (this.lineTool != null && this.lineTool.mouseOver(this.mouseX, this.mouseY)) {
            this.lineTool.select();
            this.drawingMode = 2;
        }
        if (this.boxTool != null && this.boxTool.mouseOver(this.mouseX, this.mouseY)) {
            this.boxTool.select();
            this.drawingMode = 1;
        }
        if (this.circleTool != null && this.circleTool.mouseOver(this.mouseX, this.mouseY)) {
            this.circleTool.select();
            this.drawingMode = 3;
        }
        if (this.fillTool != null && this.fillTool.mouseOver(this.mouseX, this.mouseY)) {
            this.fillTool.select();
            this.drawingMode = 4;
        }
        if (this.exportButton != null && this.exportButton.mouseOver(this.mouseX, this.mouseY)) {
            this.exportButton.pressed = true;
            this.exportButton.repaint();
            this.diskOperationPending = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.selectOutput("Select output file:", "outputFileSelected");
                }
            });
            this.fileLoaded = true;
        }
        if (this.clearButton != null && this.clearButton.mouseOver(this.mouseX, this.mouseY)) {
            this.clearButton.pressed = true;
            this.clearButton.repaint();
            this.drawEmptyMatrix();
            this.clearLEDmePlayFrameBuffer();
            this.undoHistory.addState();
        }
        if (this.undoButton != null && this.undoButton.mouseOver(this.mouseX, this.mouseY)) {
            this.undoButton.pressed = true;
            this.undoButton.repaint();
            this.undoHistory.goBack();
        }
        if (this.redoButton != null && this.redoButton.mouseOver(this.mouseX, this.mouseY)) {
            this.redoButton.pressed = true;
            this.redoButton.repaint();
            this.undoHistory.goForward();
        }
        if (this.color1Manipulator.getRedUp().mouseOver(this.mouseX, this.mouseY)) {
            this.color1Manipulator.getRedUp().push();
        }
        if (this.color1Manipulator.getGreenUp().mouseOver(this.mouseX, this.mouseY)) {
            this.color1Manipulator.getGreenUp().push();
        }
        if (this.color1Manipulator.getBlueUp().mouseOver(this.mouseX, this.mouseY)) {
            this.color1Manipulator.getBlueUp().push();
        }
        if (this.color1Manipulator.getRedDown().mouseOver(this.mouseX, this.mouseY)) {
            this.color1Manipulator.getRedDown().push();
        }
        if (this.color1Manipulator.getGreenDown().mouseOver(this.mouseX, this.mouseY)) {
            this.color1Manipulator.getGreenDown().push();
        }
        if (this.color1Manipulator.getBlueDown().mouseOver(this.mouseX, this.mouseY)) {
            this.color1Manipulator.getBlueDown().push();
        }
        if (this.color2Manipulator.getRedUp().mouseOver(this.mouseX, this.mouseY)) {
            this.color2Manipulator.getRedUp().push();
        }
        if (this.color2Manipulator.getGreenUp().mouseOver(this.mouseX, this.mouseY)) {
            this.color2Manipulator.getGreenUp().push();
        }
        if (this.color2Manipulator.getBlueUp().mouseOver(this.mouseX, this.mouseY)) {
            this.color2Manipulator.getBlueUp().push();
        }
        if (this.color2Manipulator.getRedDown().mouseOver(this.mouseX, this.mouseY)) {
            this.color2Manipulator.getRedDown().push();
        }
        if (this.color2Manipulator.getGreenDown().mouseOver(this.mouseX, this.mouseY)) {
            this.color2Manipulator.getGreenDown().push();
        }
        if (this.color2Manipulator.getBlueDown().mouseOver(this.mouseX, this.mouseY)) {
            this.color2Manipulator.getBlueDown().push();
        }
        if (this.palette.getManipulator().getUp().mouseOver(this.mouseX, this.mouseY)) {
            this.palette.getManipulator().getUp().push();
        }
        if (this.palette.getManipulator().getDown().mouseOver(this.mouseX, this.mouseY)) {
            this.palette.getManipulator().getDown().push();
        }
        if (this.loadButton != null && this.loadButton.mouseOver(this.mouseX, this.mouseY)) {
            this.loadButton.pressed = true;
            this.loadButton.repaint();
            this.diskOperationPending = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.selectInput("Select a file to load:", "inputFileSelected");
                }
            });
            this.fileLoaded = true;
        }
    }

    public void mouseReleased() {
        this.dragging = false;
        this.startX = this.mouseX;
        this.startY = this.mouseY;
        this.endX = this.startX;
        this.endY = this.startY;
        if (this.mouseX > 36 && this.mouseX < 895 && this.mouseY > 36 && this.mouseY < 895) {
            this.backupFrameBuffer();
            if (this.undoHistory.currentState == this.undoHistory.statesUsed) {
                this.undoHistory.addState();
            } else {
                this.undoHistory.replaceAsLast();
            }
        }
        if (this.undoButton != null && this.undoButton.mouseOver(this.mouseX, this.mouseY) && this.undoButton.pressed) {
            this.undoButton.hasFocus = false;
            this.undoButton.pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.undoButton.repaint();
                }
            });
        }
        if (this.exportButton != null && this.exportButton.mouseOver(this.mouseX, this.mouseY) && this.exportButton.pressed) {
            this.exportButton.hasFocus = false;
            this.exportButton.pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.exportButton.repaint();
                }
            });
        }
        if (this.clearButton != null && !this.clearButton.mouseOver(this.mouseX, this.mouseY) && this.clearButton.pressed) {
            this.clearButton.hasFocus = false;
            this.clearButton.pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.clearButton.repaint();
                }
            });
        }
        if (this.loadButton != null && !this.loadButton.mouseOver(this.mouseX, this.mouseY) && this.loadButton.pressed) {
            this.loadButton.hasFocus = false;
            this.loadButton.pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.loadButton.repaint();
                }
            });
        }
        if (this.redoButton != null && !this.redoButton.mouseOver(this.mouseX, this.mouseY) && this.redoButton.pressed) {
            this.redoButton.hasFocus = false;
            this.redoButton.pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.redoButton.repaint();
                }
            });
        }
        if (this.color1Manipulator.getRedUp().mouseOver(this.mouseX, this.mouseY) && this.color1Manipulator.getRedUp().pressed) {
            this.color1Manipulator.getRedUp().pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.color1Manipulator.getRedUp().repaint();
                }
            });
        }
        if (this.color1Manipulator.getGreenUp().mouseOver(this.mouseX, this.mouseY) && this.color1Manipulator.getGreenUp().pressed) {
            this.color1Manipulator.getGreenUp().pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.color1Manipulator.getGreenUp().repaint();
                }
            });
        }
        if (this.color1Manipulator.getBlueUp().mouseOver(this.mouseX, this.mouseY) && this.color1Manipulator.getBlueUp().pressed) {
            this.color1Manipulator.getBlueUp().pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.color1Manipulator.getBlueUp().repaint();
                }
            });
        }
        if (this.color1Manipulator.getRedDown().mouseOver(this.mouseX, this.mouseY) && this.color1Manipulator.getRedDown().pressed) {
            this.color1Manipulator.getRedDown().pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.color1Manipulator.getRedDown().repaint();
                }
            });
        }
        if (this.color1Manipulator.getGreenDown().mouseOver(this.mouseX, this.mouseY) && this.color1Manipulator.getGreenDown().pressed) {
            this.color1Manipulator.getGreenDown().pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.color1Manipulator.getGreenDown().repaint();
                }
            });
        }
        if (this.color1Manipulator.getBlueDown().mouseOver(this.mouseX, this.mouseY) && this.color1Manipulator.getBlueDown().pressed) {
            this.color1Manipulator.getBlueDown().pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.color1Manipulator.getBlueDown().repaint();
                }
            });
        }
        if (this.color2Manipulator.getRedUp().mouseOver(this.mouseX, this.mouseY) && this.color2Manipulator.getRedUp().pressed) {
            this.color2Manipulator.getRedUp().pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.color2Manipulator.getRedUp().repaint();
                }
            });
        }
        if (this.color2Manipulator.getGreenUp().mouseOver(this.mouseX, this.mouseY) && this.color2Manipulator.getGreenUp().pressed) {
            this.color2Manipulator.getGreenUp().pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.color2Manipulator.getGreenUp().repaint();
                }
            });
        }
        if (this.color2Manipulator.getBlueUp().mouseOver(this.mouseX, this.mouseY) && this.color2Manipulator.getBlueUp().pressed) {
            this.color2Manipulator.getBlueUp().pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.color2Manipulator.getBlueUp().repaint();
                }
            });
        }
        if (this.color2Manipulator.getRedDown().mouseOver(this.mouseX, this.mouseY) && this.color2Manipulator.getRedDown().pressed) {
            this.color2Manipulator.getRedDown().pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.color2Manipulator.getRedDown().repaint();
                }
            });
        }
        if (this.color2Manipulator.getGreenDown().mouseOver(this.mouseX, this.mouseY) && this.color2Manipulator.getGreenDown().pressed) {
            this.color2Manipulator.getGreenDown().pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.color2Manipulator.getGreenDown().repaint();
                }
            });
        }
        if (this.color2Manipulator.getBlueDown().mouseOver(this.mouseX, this.mouseY) && this.color2Manipulator.getBlueDown().pressed) {
            this.color2Manipulator.getBlueDown().pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.color2Manipulator.getBlueDown().repaint();
                }
            });
        }
        if (this.palette.getManipulator().getUp().mouseOver(this.mouseX, this.mouseY) && this.palette.getManipulator().getUp().pressed) {
            this.palette.getManipulator().getUp().pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.palette.getManipulator().getUp().repaint();
                }
            });
        }
        if (this.palette.getManipulator().getDown().mouseOver(this.mouseX, this.mouseY) && this.palette.getManipulator().getDown().pressed) {
            this.palette.getManipulator().getDown().pressed = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LEDmePlayDraw_270117.this.palette.getManipulator().getDown().repaint();
                }
            });
        }
    }

    public void exportData(File path) {
        int[][] buffer = new int[32][32];
        HashSet<Integer> usedIndices = new HashSet<Integer>();
        int[] t = new int[1024];
        int z = 0;
        int x = 0;
        while (x < 32) {
            int y = 0;
            while (y < 32) {
                t[z] = this.frameBuffer[x][y];
                buffer[x][y] = this.frameBuffer[x][y];
                usedIndices.add(this.frameBuffer[x][y]);
                ++z;
                ++y;
            }
            ++x;
        }
        LEDmePlayDraw_270117.println((String)("Anzahl unterschiedlicher Indices im Bild ist " + usedIndices.size()));
        String colorsString = new String();
        colorsString = String.valueOf(colorsString) + "Complete Indexed Color Palette:\r\n";
        int index = 0;
        while (index < 4927) {
            int col = this.indexColor[index];
            colorsString = String.valueOf(colorsString) + "444 Color " + index + ": (" + LEDmePlayDraw_270117.round((float)this.red(col)) + ", " + LEDmePlayDraw_270117.round((float)this.green(col)) + ", " + LEDmePlayDraw_270117.round((float)this.blue(col)) + "), ";
            colorsString = String.valueOf(colorsString) + "333 Color (" + (int)LEDmePlayDraw_270117.map((float)this.red(col), (float)0.0f, (float)15.0f, (float)0.0f, (float)7.0f) + ", " + (int)LEDmePlayDraw_270117.map((float)this.green(col), (float)0.0f, (float)15.0f, (float)0.0f, (float)7.0f) + ", " + (int)LEDmePlayDraw_270117.map((float)this.blue(col), (float)0.0f, (float)15.0f, (float)0.0f, (float)7.0f) + ")";
            colorsString = String.valueOf(colorsString) + "\r\n";
            ++index;
        }
        String imgData = new String();
        imgData = String.valueOf(imgData) + "/*\r\n" + colorsString;
        imgData = String.valueOf(imgData) + "*/\r\n/*\r\n";
        int y = 0;
        while (y < 32) {
            int x2 = 0;
            while (x2 < 32) {
                imgData = String.valueOf(imgData) + this.frameBuffer[x2][y] + ", ";
                ++x2;
            }
            imgData = String.valueOf(imgData) + "\r\n";
            ++y;
        }
        imgData = String.valueOf(imgData) + "*/";
        PrintWriter output = this.createWriter(path + "_reimport");
        output.println(imgData);
        output.flush();
        output.close();
        Hashtable<Integer, Integer> oldAndNewIndex = new Hashtable<Integer, Integer>();
        int newIndex = 0;
        Iterator iterator = usedIndices.iterator();
        while (iterator.hasNext()) {
            int oldIndex = (Integer)iterator.next();
            oldAndNewIndex.put(oldIndex, newIndex);
            ++newIndex;
        }
        colorsString = new String();
        colorsString = String.valueOf(colorsString) + "// Code that displays an image based on an indexed color palette\r\n";
        colorsString = String.valueOf(colorsString) + "void showImage()\r\n";
        colorsString = String.valueOf(colorsString) + "{\r\n";
        colorsString = String.valueOf(colorsString) + "  int col;\r\n";
        colorsString = String.valueOf(colorsString) + "  byte p;\r\n";
        colorsString = String.valueOf(colorsString) + "  byte img[32 * 32];\r\n";
        colorsString = String.valueOf(colorsString) + "  matrix.fillScreen(0, 0, 0);\r\n";
        colorsString = String.valueOf(colorsString) + "  for (int k = 0; k < 32 * 32; k++)\r\n";
        colorsString = String.valueOf(colorsString) + "  {\r\n";
        colorsString = String.valueOf(colorsString) + "    img[k] = pgm_read_byte_near(img + k);\r\n";
        colorsString = String.valueOf(colorsString) + "  }\r\n";
        colorsString = String.valueOf(colorsString) + "\r\n\r\n";
        colorsString = String.valueOf(colorsString) + "  for (byte x = 0; x < 32; x++)\r\n";
        colorsString = String.valueOf(colorsString) + "  {\r\n";
        colorsString = String.valueOf(colorsString) + "    for (byte y = 0; y < 32; y++)\r\n";
        colorsString = String.valueOf(colorsString) + "    {\r\n";
        colorsString = String.valueOf(colorsString) + "      p = img[y * 32 + x];\r\n";
        colorsString = String.valueOf(colorsString) + "\r\n";
        colorsString = String.valueOf(colorsString) + "      switch(p)\r\n";
        colorsString = String.valueOf(colorsString) + "      {\r\n";
        iterator = usedIndices.iterator();
        while (iterator.hasNext()) {
            int index2 = (Integer)iterator.next();
            int newInd = (Integer)oldAndNewIndex.get(index2);
            int col = index2 == 4864 ? this.color(0, 0, 0) : this.indexColor[index2];
            colorsString = String.valueOf(colorsString) + "      case " + newInd + ":" + "\r\n";
            colorsString = String.valueOf(colorsString) + "      col = matrix.Color444(" + LEDmePlayDraw_270117.round((float)this.red(col)) + ", " + LEDmePlayDraw_270117.round((float)this.green(col)) + ", " + LEDmePlayDraw_270117.round((float)this.blue(col)) + ");" + "\r\n";
            colorsString = String.valueOf(colorsString) + "      break;\r\n\r\n";
        }
        colorsString = String.valueOf(colorsString) + "      }\r\n";
        colorsString = String.valueOf(colorsString) + "    matrix.drawPixel(x, y, col);\r\n";
        colorsString = String.valueOf(colorsString) + "  }\r\n";
        colorsString = String.valueOf(colorsString) + "}\r\n";
        colorsString = String.valueOf(colorsString) + "\r\n\r\n";
        colorsString = String.valueOf(colorsString) + "// Image data\r\n";
        colorsString = String.valueOf(colorsString) + "const uint8_t titleImg[] PROGMEM =\r\n";
        colorsString = String.valueOf(colorsString) + "{\r\n";
        int x3 = 0;
        while (x3 < 32) {
            int y2 = 0;
            while (y2 < 32) {
                buffer[x3][y2] = (Integer)oldAndNewIndex.get(this.frameBuffer[x3][y2]);
                ++y2;
            }
            ++x3;
        }
        imgData = new String();
        imgData = String.valueOf(imgData) + colorsString;
        int y3 = 0;
        while (y3 < 32) {
            imgData = String.valueOf(imgData) + "  ";
            int x4 = 0;
            while (x4 < 32) {
                imgData = String.valueOf(imgData) + buffer[x4][y3] + ", ";
                ++x4;
            }
            imgData = String.valueOf(imgData) + "\r\n";
            ++y3;
        }
        imgData = String.valueOf(imgData) + "};\r\n";
        StringSelection data = new StringSelection(imgData);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(data, data);
        output = this.createWriter(path + "_Arduino");
        output.println(imgData);
        output.flush();
        output.close();
        this.diskOperationPending = false;
    }

    public void outputFileSelected(File selection) {
        if (selection == null) {
            LEDmePlayDraw_270117.println((String)"File requester was closed, or user hit cancel.");
            return;
        }
        this.exportData(selection);
    }

    public void inputFileSelected(File selection) {
        int[][] tempBuffer = new int[32][32];
        if (selection == null) {
            LEDmePlayDraw_270117.println((String)"File requester was either closed, or the user hit cancel.");
        } else {
            LEDmePlayDraw_270117.println((String)("Try to load picture and palette from file " + selection.getAbsolutePath()));
            String[] lines = LEDmePlayDraw_270117.loadStrings((File)selection);
            LEDmePlayDraw_270117.println((String)("There are " + lines.length + " lines in the file"));
            String[] m = new String[lines.length];
            String sectionTitle = "^Complete Indexed";
            int row = 0;
            while ((m = LEDmePlayDraw_270117.match((String)lines[row], (String)sectionTitle)) == null && ++row < lines.length) {
            }
            if (m != null) {
                LEDmePlayDraw_270117.println((String)("Headline: " + m[0]));
                int colIndex = 0;
                String colorField = "Color \\d+: \\(\\d+, \\d+, \\d+\\)";
                do {
                    String[] tokens;
                    if ((m = LEDmePlayDraw_270117.match((String)lines[row], (String)colorField)) == null) continue;
                    Pattern p = Pattern.compile("Color \\d+");
                    Matcher ma = p.matcher(lines[row]);
                    if (ma.find()) {
                        tokens = LEDmePlayDraw_270117.splitTokens((String)ma.group());
                        colIndex = Integer.parseInt(tokens[1]);
                    }
                    if ((ma = (p = Pattern.compile("\\d+, \\d+, \\d+")).matcher(lines[row])).find()) {
                        tokens = LEDmePlayDraw_270117.splitTokens((String)ma.group(), (String)", ");
                        float redComponent = Integer.parseInt(tokens[0]);
                        float greenComponent = Integer.parseInt(tokens[1]);
                        float blueComponent = Integer.parseInt(tokens[2]);
                        if (colIndex != 4864) {
                            this.indexColor[colIndex] = this.color(redComponent, greenComponent, blueComponent);
                        }
                    }
                    ++row;
                } while (row < lines.length && colIndex < 4926);
                LEDmePlayDraw_270117.println((String)"Search for the matrix of color indices");
                String sectionStartDivider = "\\/\\*";
                String sectionEndDivider = "\\*\\/";
                while ((m = LEDmePlayDraw_270117.match((String)lines[row], (String)sectionStartDivider)) == null && ++row < lines.length) {
                }
                if (m != null) {
                    LEDmePlayDraw_270117.println((String)"Found the '/*'");
                } else {
                    LEDmePlayDraw_270117.println((String)"The file does not contain a matrix with color indices");
                }
                int ypos = 0;
                int xpos = 0;
                do {
                    xpos = 0;
                    String[] tokens = LEDmePlayDraw_270117.splitTokens((String)lines[row], (String)", ");
                    do {
                        int index;
                        String s;
                        if (LEDmePlayDraw_270117.match((String)(s = tokens[xpos]), (String)"\\d+") == null) {
                            LEDmePlayDraw_270117.println((String)"There was an error in the color index matrix representation - abort");
                            return;
                        }
                        tempBuffer[xpos][ypos] = index = Integer.parseInt(s);
                        if (xpos >= 32) continue;
                        ++xpos;
                    } while (xpos < 32);
                    ++ypos;
                } while (LEDmePlayDraw_270117.match((String)lines[++row], (String)sectionEndDivider) == null && row < lines.length);
                int x = 0;
                while (x < 32) {
                    int y = 0;
                    while (y < 32) {
                        this.frameBuffer[x][y] = tempBuffer[x][y];
                        this.backBuffer[x][y] = this.frameBuffer[x][y];
                        ++y;
                    }
                    ++x;
                }
                LEDmePlayDraw_270117.println((String)"Copied picture data into frame buffer");
                this.fileLoaded = true;
                this.undoHistory.reset();
            } else {
                LEDmePlayDraw_270117.println((String)"The file format is not suitable for LEDmePlay Draw.");
            }
        }
        this.diskOperationPending = false;
    }

    public void settings() {
        this.size(1860, 970);
        this.noSmooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"LEDmePlayDraw_270117"};
        if (passedArgs != null) {
            PApplet.main((String[])LEDmePlayDraw_270117.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    public class BoxTool
    implements DrawingTool {
        private int x;
        private int y;
        private int w;
        private int h;
        public boolean selected;
        private ToolGroup group;

        @Override
        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.repaint();
                return true;
            }
            return false;
        }

        public BoxTool(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.selected = false;
            this.repaint();
        }

        @Override
        public void repaint() {
            if (!this.selected) {
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, 50.0f, 50.0f);
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.rect(this.x + 10, this.y + 10, 30.0f, 30.0f);
            } else {
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.stroke(7);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, 50.0f, 50.0f);
                LEDmePlayDraw_270117.this.rect(this.x + 10, this.y + 10, 30.0f, 30.0f);
            }
        }

        @Override
        public void select() {
            this.selected = true;
            this.group.toggle(this);
            this.repaint();
        }

        @Override
        public void unselect() {
            this.selected = false;
            this.repaint();
        }

        @Override
        public void setToolGroup(ToolGroup group) {
            this.group = group;
            group.register(this);
        }
    }

    public class CircleTool
    implements DrawingTool {
        private int x;
        private int y;
        private int w;
        private int h;
        public boolean selected;
        private ToolGroup group;

        @Override
        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.repaint();
                return true;
            }
            return false;
        }

        public CircleTool(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.selected = false;
            this.repaint();
        }

        @Override
        public void repaint() {
            if (!this.selected) {
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, 50.0f, 50.0f);
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.ellipse(this.x + 25, this.y + 25, 30.0f, 30.0f);
            } else {
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.stroke(7);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, 50.0f, 50.0f);
                LEDmePlayDraw_270117.this.ellipse(this.x + 25, this.y + 25, 30.0f, 30.0f);
            }
        }

        @Override
        public void select() {
            this.selected = true;
            this.group.toggle(this);
            this.repaint();
        }

        @Override
        public void unselect() {
            this.selected = false;
            this.repaint();
        }

        @Override
        public void setToolGroup(ToolGroup group) {
            this.group = group;
            group.register(this);
        }
    }

    public class ClearButton {
        private int x;
        private int y;
        private int w;
        private int h;
        public boolean pressed;
        public boolean hasFocus;

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            return false;
        }

        public ClearButton(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.hasFocus = false;
            this.pressed = false;
            this.repaint();
        }

        public void repaint() {
            if (LEDmePlayDraw_270117.this.f == null) {
                LEDmePlayDraw_270117.this.f = LEDmePlayDraw_270117.this.loadFont("ArialMT-30.vlw");
            }
            LEDmePlayDraw_270117.this.textFont(LEDmePlayDraw_270117.this.f, 30.0f);
            if (this.pressed) {
                LEDmePlayDraw_270117.this.stroke(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.black);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, this.w, this.h);
                LEDmePlayDraw_270117.this.strokeWeight(1.0f);
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.text("Clear Panel", this.x + 10, this.y + 35);
                this.pressed = false;
            } else {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, this.w, this.h);
                LEDmePlayDraw_270117.this.strokeWeight(1.0f);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.text("Clear Panel", this.x + 10, this.y + 35);
            }
        }
    }

    public class ColorManipulator {
        int x;
        int y;
        int w;
        int h;
        float red;
        float green;
        float blue;
        int colIndex;
        String text;
        int[] indexCol;
        boolean deactivated = false;
        UpButton redUp;
        UpButton greenUp;
        UpButton blueUp;
        DownButton redDown;
        DownButton greenDown;
        DownButton blueDown;

        public ColorManipulator(int x, int y, int[] indexCol, int index, String text) {
            this.x = x;
            this.y = y;
            this.indexCol = indexCol;
            int col = indexCol[index];
            this.colIndex = index;
            this.red = LEDmePlayDraw_270117.this.red(col);
            this.green = LEDmePlayDraw_270117.this.green(col);
            this.blue = LEDmePlayDraw_270117.this.blue(col);
            this.text = text;
            this.redUp = new UpButton(this, x + 180, y, 10, 10, 0);
            this.greenUp = new UpButton(this, x + 230, y, 10, 10, 1);
            this.blueUp = new UpButton(this, x + 280, y, 10, 10, 2);
            this.redDown = new DownButton(this, x + 180, y + 58, 10, 10, 0);
            this.greenDown = new DownButton(this, x + 230, y + 58, 10, 10, 1);
            this.blueDown = new DownButton(this, x + 280, y + 58, 10, 10, 2);
            this.repaint();
        }

        public void setRedComponent(int sign) {
            if (sign == 1 && LEDmePlayDraw_270117.round((float)this.red) < 15) {
                this.red += 1.0f;
            } else if (sign == -1 && LEDmePlayDraw_270117.round((float)this.red) > 0) {
                this.red -= 1.0f;
            }
            this.indexCol[this.colIndex] = LEDmePlayDraw_270117.this.color(this.red, this.green, this.blue);
            this.repaint();
            LEDmePlayDraw_270117.this.restoreFrameBuffer();
            if (this.colIndex > 0 && this.colIndex < 257) {
                LEDmePlayDraw_270117.this.palette.repaintUpperLeftColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            } else if (this.colIndex > 256 && this.colIndex < 512) {
                LEDmePlayDraw_270117.this.palette.repaintUpperRightColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            } else if (this.colIndex > 511 && this.colIndex < 769) {
                LEDmePlayDraw_270117.this.palette.repaintLowerLeftColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            } else if (this.colIndex > 768 && this.colIndex < 4864) {
                LEDmePlayDraw_270117.this.palette.repaintDynamicColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            } else if (this.colIndex > 4863) {
                LEDmePlayDraw_270117.this.palette.repaint64ColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            }
        }

        public void setGreenComponent(int sign) {
            if (sign == 1 && LEDmePlayDraw_270117.round((float)this.green) < 15) {
                this.green += 1.0f;
            } else if (sign == -1 && LEDmePlayDraw_270117.round((float)this.green) > 0) {
                this.green -= 1.0f;
            }
            this.indexCol[this.colIndex] = LEDmePlayDraw_270117.this.color(this.red, this.green, this.blue);
            this.repaint();
            LEDmePlayDraw_270117.this.restoreFrameBuffer();
            if (this.colIndex > 0 && this.colIndex < 257) {
                LEDmePlayDraw_270117.this.palette.repaintUpperLeftColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            } else if (this.colIndex > 256 && this.colIndex < 512) {
                LEDmePlayDraw_270117.this.palette.repaintUpperRightColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            } else if (this.colIndex > 511 && this.colIndex < 769) {
                LEDmePlayDraw_270117.this.palette.repaintLowerLeftColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            } else if (this.colIndex > 768 && this.colIndex < 4864) {
                LEDmePlayDraw_270117.this.palette.repaintDynamicColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            } else if (this.colIndex > 4863) {
                LEDmePlayDraw_270117.this.palette.repaint64ColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            }
        }

        public void setBlueComponent(int sign) {
            if (sign == 1 && LEDmePlayDraw_270117.round((float)this.blue) < 15) {
                this.blue += 1.0f;
            } else if (sign == -1 && LEDmePlayDraw_270117.round((float)this.blue) > 0) {
                this.blue -= 1.0f;
            }
            this.indexCol[this.colIndex] = LEDmePlayDraw_270117.this.color(this.red, this.green, this.blue);
            this.repaint();
            LEDmePlayDraw_270117.this.restoreFrameBuffer();
            if (this.colIndex > 0 && this.colIndex < 257) {
                LEDmePlayDraw_270117.this.palette.repaintUpperLeftColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            } else if (this.colIndex > 256 && this.colIndex < 512) {
                LEDmePlayDraw_270117.this.palette.repaintUpperRightColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            } else if (this.colIndex > 511 && this.colIndex < 769) {
                LEDmePlayDraw_270117.this.palette.repaintLowerLeftColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            } else if (this.colIndex > 768 && this.colIndex < 4864) {
                LEDmePlayDraw_270117.this.palette.repaintDynamicColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            } else if (this.colIndex > 4863) {
                LEDmePlayDraw_270117.this.palette.repaint64ColorBox = true;
                LEDmePlayDraw_270117.this.palette.repaint();
            }
        }

        public void repaint() {
            if (LEDmePlayDraw_270117.this.f == null) {
                LEDmePlayDraw_270117.this.f = LEDmePlayDraw_270117.this.loadFont("ArialMT-30.vlw");
            }
            LEDmePlayDraw_270117.this.textFont(LEDmePlayDraw_270117.this.f, 30.0f);
            LEDmePlayDraw_270117.this.noFill();
            LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
            LEDmePlayDraw_270117.this.strokeWeight(2.0f);
            LEDmePlayDraw_270117.this.fill(7);
            LEDmePlayDraw_270117.this.rect(this.x + 168, this.y + 22, 45.0f, 30.0f);
            LEDmePlayDraw_270117.this.rect(this.x + 218, this.y + 22, 45.0f, 30.0f);
            LEDmePlayDraw_270117.this.rect(this.x + 268, this.y + 22, 45.0f, 30.0f);
            LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.black);
            LEDmePlayDraw_270117.this.noStroke();
            LEDmePlayDraw_270117.this.text(LEDmePlayDraw_270117.round((float)this.red), this.x + 174, this.y + 48);
            LEDmePlayDraw_270117.this.text(LEDmePlayDraw_270117.round((float)this.green), this.x + 224, this.y + 48);
            LEDmePlayDraw_270117.this.text(LEDmePlayDraw_270117.round((float)this.blue), this.x + 274, this.y + 48);
            LEDmePlayDraw_270117.this.fill(6);
            LEDmePlayDraw_270117.this.rect(this.x + 168, this.y + 77, 140.0f, 35.0f);
            LEDmePlayDraw_270117.this.rect(this.x, this.y + 20, 95.0f, 30.0f);
            LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.black);
            LEDmePlayDraw_270117.this.text("R", this.x + 178, this.y + 105);
            LEDmePlayDraw_270117.this.text("G", this.x + 228, this.y + 105);
            LEDmePlayDraw_270117.this.text("B", this.x + 278, this.y + 105);
            LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.color(this.red, this.green, this.blue));
            LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
            LEDmePlayDraw_270117.this.strokeWeight(2.0f);
            LEDmePlayDraw_270117.this.rect(this.x + 108, this.y + 22, 40.0f, 30.0f);
            LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.black);
            LEDmePlayDraw_270117.this.noStroke();
            LEDmePlayDraw_270117.this.text(this.text, this.x + 6, this.y + 48);
            this.redUp.repaint();
            this.greenUp.repaint();
            this.blueUp.repaint();
            this.redDown.repaint();
            this.greenDown.repaint();
            this.blueDown.repaint();
        }

        public void setNewColorIndex(int index) {
            this.colIndex = index;
            int col = this.indexCol[index];
            this.red = LEDmePlayDraw_270117.this.red(col);
            this.green = LEDmePlayDraw_270117.this.green(col);
            this.blue = LEDmePlayDraw_270117.this.blue(col);
            this.repaint();
        }

        public UpButton getRedUp() {
            return this.redUp;
        }

        public UpButton getGreenUp() {
            return this.greenUp;
        }

        public UpButton getBlueUp() {
            return this.blueUp;
        }

        public DownButton getRedDown() {
            return this.redDown;
        }

        public DownButton getGreenDown() {
            return this.greenDown;
        }

        public DownButton getBlueDown() {
            return this.blueDown;
        }
    }

    class ColorRGB444Palette {
        int[] indexColor;
        int x;
        int y;
        int w;
        int h;
        boolean hasFocus;
        int defaultBlue;
        int dynamicIndex;
        int offsetIndex;
        int boxX;
        int boxY;
        int oldBoxX;
        int oldBoxY;
        int col64X;
        int col64Y;
        int oldCol64X;
        int oldCol64Y;
        NumberManipulator blueManipulator;
        public boolean repaintDynamicColorBox;
        public boolean repaintUpperLeftColorBox;
        public boolean repaintUpperRightColorBox;
        public boolean repaintLowerLeftColorBox;
        public boolean repaint64ColorBox;

        public ColorRGB444Palette(int x, int y, int w, int h, int[] indexColor, int blueValue) {
            this.boxX = this.x;
            this.boxY = this.y;
            this.oldBoxX = this.boxX;
            this.oldBoxY = this.boxY;
            this.col64X = this.x + 720;
            this.col64Y = this.y;
            this.oldCol64X = -20;
            this.oldCol64Y = -20;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.indexColor = indexColor;
            this.defaultBlue = blueValue;
            this.dynamicIndex = this.switchPalette(this.defaultBlue);
            this.indexColor[4864] = LEDmePlayDraw_270117.this.color(2, 2, 2);
            this.hasFocus = false;
            this.makeColorRGB444Palette();
            this.blueManipulator = new NumberManipulator(x + 479, y + 340, indexColor, this.defaultBlue, "");
            this.paintUpperLeftColorBox();
            this.paintUpperRightColorBox();
            this.paintLowerLeftColorBox();
            this.paintDynamicColorBox();
            LEDmePlayDraw_270117.this.strokeWeight(2.0f);
            LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
            LEDmePlayDraw_270117.this.noFill();
            LEDmePlayDraw_270117.this.rect(this.x - 10, this.y - 10, 650.0f, 650.0f);
            this.paint64ColorBox();
            this.repaintUpperLeftColorBox = false;
            this.repaintUpperRightColorBox = false;
            this.repaintLowerLeftColorBox = false;
            this.repaintDynamicColorBox = true;
            this.repaint64ColorBox = true;
        }

        public void makeColorRGB444Palette() {
            int g;
            int i = 0;
            int b = 0;
            int r = 0;
            while (r < 16) {
                g = 0;
                while (g < 16) {
                    this.indexColor[i] = LEDmePlayDraw_270117.this.color(r, g, b);
                    ++i;
                    ++g;
                }
                ++r;
            }
            r = 0;
            g = 0;
            while (g < 16) {
                b = 0;
                while (b < 16) {
                    this.indexColor[i] = LEDmePlayDraw_270117.this.color(r, g, b);
                    ++i;
                    ++b;
                }
                ++g;
            }
            g = 0;
            r = 0;
            while (r < 16) {
                b = 0;
                while (b < 16) {
                    this.indexColor[i] = LEDmePlayDraw_270117.this.color(r, g, b);
                    ++i;
                    ++b;
                }
                ++r;
            }
            b = 0;
            while (b < 16) {
                g = 0;
                while (g < 16) {
                    r = 0;
                    while (r < 16) {
                        this.indexColor[i] = LEDmePlayDraw_270117.this.color(r, g, b);
                        ++i;
                        ++r;
                    }
                    ++g;
                }
                ++b;
            }
            int j = i + 1;
            while (j < i + 64) {
                this.indexColor[j] = LEDmePlayDraw_270117.this.color(LEDmePlayDraw_270117.this.random(0.0f, 16.0f), LEDmePlayDraw_270117.this.random(0.0f, 16.0f), LEDmePlayDraw_270117.this.random(0.0f, 16.0f));
                ++j;
            }
        }

        public int switchPalette(int page) {
            this.dynamicIndex = 768 + page * 256;
            this.repaintDynamicColorBox = true;
            this.repaint();
            return this.dynamicIndex;
        }

        public void writeColorComponents() {
            LEDmePlayDraw_270117.this.fill(0);
            LEDmePlayDraw_270117.this.textFont(LEDmePlayDraw_270117.this.f, 30.0f);
            LEDmePlayDraw_270117.this.fill(6.0f, 6.0f, 6.0f);
            LEDmePlayDraw_270117.this.noStroke();
            LEDmePlayDraw_270117.this.rect(39.0f, 920.0f, 900.0f, 40.0f);
            LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.black);
            int col = this.indexColor[LEDmePlayDraw_270117.this.currentColorIndex];
            String s = "";
            s = LEDmePlayDraw_270117.this.currentColorIndex != 4864 ? "RGB444 Color " + LEDmePlayDraw_270117.this.currentColorIndex + ":  (" + LEDmePlayDraw_270117.round((float)LEDmePlayDraw_270117.this.red(col)) + ", " + LEDmePlayDraw_270117.round((float)LEDmePlayDraw_270117.this.green(col)) + ", " + LEDmePlayDraw_270117.round((float)LEDmePlayDraw_270117.this.blue(col)) + ")" : "LED Off Color - immutable";
            s = String.valueOf(s) + ",  Color1: " + LEDmePlayDraw_270117.this.indexColor1 + ", Color2: " + LEDmePlayDraw_270117.this.indexColor2;
            LEDmePlayDraw_270117.this.text(s, 40.0f, 950.0f);
        }

        public void paint64ColorBox() {
            int x = this.x + 730;
            int y = this.y;
            LEDmePlayDraw_270117.this.fill(10);
            LEDmePlayDraw_270117.this.noStroke();
            LEDmePlayDraw_270117.this.rect(this.x + 720, this.y - 1, 41.0f, 32.0f);
            int index = 4864;
            while (index < 4928) {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                int col = this.indexColor[index];
                LEDmePlayDraw_270117.this.fill(col);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.rect(x, y, 30.0f, 30.0f);
                if (x >= this.x + 730 + 100) {
                    x = this.x + 730;
                    y += 35;
                } else {
                    x += 35;
                }
                ++index;
            }
            LEDmePlayDraw_270117.this.noFill();
            LEDmePlayDraw_270117.this.strokeWeight(2.0f);
            LEDmePlayDraw_270117.this.rect(this.x + 720, this.y - 9, 155.0f, 574.0f);
        }

        public void paintUpperLeftColorBox() {
            int x = this.x;
            int y = this.y;
            int index = 0;
            while (index < 256) {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                int col = this.indexColor[index];
                LEDmePlayDraw_270117.this.fill(col);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.rect(x, y, 15.0f, 15.0f);
                if (x >= this.x + 280) {
                    x = this.x;
                    y += 19;
                } else {
                    x += 19;
                }
                ++index;
            }
        }

        public void paintUpperRightColorBox() {
            int x = this.x + 330;
            int y = this.y;
            int index = 256;
            while (index < 512) {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                int col = this.indexColor[index];
                LEDmePlayDraw_270117.this.fill(col);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.rect(x, y, 15.0f, 15.0f);
                if (x >= this.x + 610) {
                    x = this.x + 330;
                    y += 19;
                } else {
                    x += 19;
                }
                ++index;
            }
        }

        public void paintLowerLeftColorBox() {
            int x = this.x;
            int y = this.y + 330;
            int index = 512;
            while (index < 768) {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                int col = this.indexColor[index];
                LEDmePlayDraw_270117.this.fill(col);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.rect(x, y, 15.0f, 15.0f);
                if (x >= this.x + 270) {
                    x = this.x;
                    y += 19;
                } else {
                    x += 19;
                }
                ++index;
            }
        }

        public void paintDynamicColorBox() {
            int x = this.x + 330;
            int y = this.y + 330;
            int index = this.dynamicIndex;
            while (index < this.dynamicIndex + 256) {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                int col = this.indexColor[index];
                LEDmePlayDraw_270117.this.fill(col);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.rect(x, y, 15.0f, 15.0f);
                if (x >= this.x + 610) {
                    x = this.x + 330;
                    y += 19;
                } else {
                    x += 19;
                }
                ++index;
            }
        }

        public void repaint() {
            this.highlightColorBox();
            if (this.repaintUpperLeftColorBox) {
                this.paintUpperLeftColorBox();
                this.repaintUpperLeftColorBox = false;
            }
            if (this.repaintUpperRightColorBox) {
                this.paintUpperRightColorBox();
                this.repaintUpperRightColorBox = false;
            }
            if (this.repaintLowerLeftColorBox) {
                this.paintLowerLeftColorBox();
                this.repaintLowerLeftColorBox = false;
            }
            if (this.repaintDynamicColorBox) {
                this.paintDynamicColorBox();
                this.repaintDynamicColorBox = false;
            }
            if (this.repaint64ColorBox) {
                this.paint64ColorBox();
                this.repaint64ColorBox = false;
            }
        }

        public void highlightColorBox() {
            if (this.oldBoxX != this.boxX || this.oldBoxY != this.boxY) {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.noFill();
                LEDmePlayDraw_270117.this.rect(this.oldBoxX, this.oldBoxY, 15.0f, 15.0f);
            }
            LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.red);
            LEDmePlayDraw_270117.this.strokeWeight(2.0f);
            this.oldBoxX = this.boxX;
            this.oldBoxY = this.boxY;
            LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
            LEDmePlayDraw_270117.this.noFill();
            LEDmePlayDraw_270117.this.rect(this.x - 5 + this.oldCol64X * 35, this.y + this.oldCol64Y * 35, 30.0f, 30.0f);
            if (LEDmePlayDraw_270117.this.mouseX > this.x && LEDmePlayDraw_270117.this.mouseX < this.x + 299 && LEDmePlayDraw_270117.this.mouseY > this.y && LEDmePlayDraw_270117.this.mouseY < this.y + 299) {
                this.offsetIndex = 0;
                this.oldBoxX = this.x + this.boxX * 19;
                this.oldBoxY = this.y + this.boxY * 19;
                LEDmePlayDraw_270117.this.noFill();
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.red);
                this.boxX = (LEDmePlayDraw_270117.this.mouseX - this.x) / 19;
                this.boxY = (LEDmePlayDraw_270117.this.mouseY - this.y) / 19;
                LEDmePlayDraw_270117.this.rect(this.x + this.boxX * 19, this.y + this.boxY * 19, 15.0f, 15.0f);
                LEDmePlayDraw_270117.this.currentColorIndex = this.boxY * 16 + this.boxX;
                this.writeColorComponents();
            } else if (LEDmePlayDraw_270117.this.mouseX > this.x + 330 && LEDmePlayDraw_270117.this.mouseX < this.x + 330 + 299 && LEDmePlayDraw_270117.this.mouseY > this.y && LEDmePlayDraw_270117.this.mouseY < this.y + 299) {
                this.offsetIndex = 256;
                this.oldBoxX = this.x + this.boxX * 19 + 330;
                this.oldBoxY = this.y + this.boxY * 19;
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.red);
                LEDmePlayDraw_270117.this.noFill();
                this.boxX = (LEDmePlayDraw_270117.this.mouseX - 330 - this.x) / 19;
                this.boxY = (LEDmePlayDraw_270117.this.mouseY - this.y) / 19;
                LEDmePlayDraw_270117.this.rect(this.x + this.boxX * 19 + 330, this.y + this.boxY * 19, 15.0f, 15.0f);
                LEDmePlayDraw_270117.this.currentColorIndex = 256 + this.boxY * 16 + this.boxX;
                this.writeColorComponents();
            } else if (LEDmePlayDraw_270117.this.mouseX > this.x && LEDmePlayDraw_270117.this.mouseX < this.x + 299 && LEDmePlayDraw_270117.this.mouseY > this.y + 330 && LEDmePlayDraw_270117.this.mouseY < this.y + 330 + 299) {
                this.offsetIndex = 512;
                this.oldBoxX = this.x + this.boxX * 19;
                this.oldBoxY = this.y + this.boxY * 19 + 330;
                LEDmePlayDraw_270117.this.noFill();
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.red);
                this.boxX = (LEDmePlayDraw_270117.this.mouseX - this.x) / 19;
                this.boxY = (LEDmePlayDraw_270117.this.mouseY - 330 - this.y) / 19;
                LEDmePlayDraw_270117.this.rect(this.x + this.boxX * 19, this.y + this.boxY * 19 + 330, 15.0f, 15.0f);
                LEDmePlayDraw_270117.this.currentColorIndex = 512 + this.boxY * 16 + this.boxX;
                this.writeColorComponents();
            } else if (LEDmePlayDraw_270117.this.mouseX > this.x + 330 && LEDmePlayDraw_270117.this.mouseX < this.x + 330 + 299 && LEDmePlayDraw_270117.this.mouseY > this.y + 330 && LEDmePlayDraw_270117.this.mouseY < this.y + 330 + 299) {
                this.oldBoxX = this.x + this.boxX * 19 + 330;
                this.oldBoxY = this.y + this.boxY * 19 + 330;
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.red);
                LEDmePlayDraw_270117.this.noFill();
                this.boxX = (LEDmePlayDraw_270117.this.mouseX - 330 - this.x) / 19;
                this.boxY = (LEDmePlayDraw_270117.this.mouseY - 330 - this.y) / 19;
                LEDmePlayDraw_270117.this.rect(this.x + this.boxX * 19 + 330, this.y + this.boxY * 19 + 330, 15.0f, 15.0f);
                LEDmePlayDraw_270117.this.currentColorIndex = this.dynamicIndex + this.boxY * 16 + this.boxX;
                this.writeColorComponents();
            } else if (LEDmePlayDraw_270117.this.mouseX > this.x + 715 && LEDmePlayDraw_270117.this.mouseX < this.x + 900 && LEDmePlayDraw_270117.this.mouseY > this.y - 9 && LEDmePlayDraw_270117.this.mouseY < this.y + 560 && LEDmePlayDraw_270117.this.mouseX > this.x + 730 && LEDmePlayDraw_270117.this.mouseX < this.x + 870) {
                this.oldCol64X = this.col64X;
                this.oldCol64Y = this.col64Y;
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.red);
                LEDmePlayDraw_270117.this.noFill();
                this.col64X = (LEDmePlayDraw_270117.this.mouseX + 5 - this.x) / 35;
                this.col64Y = (LEDmePlayDraw_270117.this.mouseY - this.y) / 35;
                LEDmePlayDraw_270117.this.rect(this.x - 5 + this.col64X * 35, this.y + this.col64Y * 35, 30.0f, 30.0f);
                LEDmePlayDraw_270117.this.currentColorIndex = 4864 + (this.col64Y - 1) * 4 + this.col64X - 17;
                this.writeColorComponents();
            }
        }

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            this.hasFocus = false;
            return false;
        }

        public NumberManipulator getManipulator() {
            return this.blueManipulator;
        }

        public int getDynamicIndex() {
            return this.dynamicIndex;
        }
    }

    public class DownButton {
        private int x;
        private int y;
        private int w;
        private int h;
        private int type;
        private ColorManipulator cm;
        public boolean pressed;
        public boolean hasFocus;

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            return false;
        }

        public DownButton(ColorManipulator cm, int x, int y, int w, int h, int type) {
            this.cm = cm;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.type = type;
            this.pressed = false;
            this.repaint();
        }

        public void push() {
            if (!this.cm.deactivated) {
                switch (this.type) {
                    case 0: {
                        this.cm.setRedComponent(-1);
                        break;
                    }
                    case 1: {
                        this.cm.setGreenComponent(-1);
                        break;
                    }
                    case 2: {
                        this.cm.setBlueComponent(-1);
                    }
                }
                this.pressed = true;
                this.repaint();
                this.pressed = false;
            }
        }

        public void repaint() {
            if (LEDmePlayDraw_270117.this.f == null) {
                LEDmePlayDraw_270117.this.f = LEDmePlayDraw_270117.this.loadFont("ArialMT-30.vlw");
            }
            LEDmePlayDraw_270117.this.textFont(LEDmePlayDraw_270117.this.f, 30.0f);
            if (this.pressed) {
                LEDmePlayDraw_270117.this.stroke(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.black);
                LEDmePlayDraw_270117.this.triangle(this.x, this.y, this.x + 16, this.y, this.x + 8, this.y + 16);
                LEDmePlayDraw_270117.this.strokeWeight(1.0f);
                LEDmePlayDraw_270117.this.fill(7);
            } else if (!this.cm.deactivated) {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.triangle(this.x, this.y, this.x + 16, this.y, this.x + 8, this.y + 16);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.contourCol);
            } else {
                LEDmePlayDraw_270117.this.noStroke();
                LEDmePlayDraw_270117.this.rect(this.x - 3, this.y - 3, 22.0f, 22.0f);
                LEDmePlayDraw_270117.this.fill(6);
            }
        }
    }

    static interface DrawingTool {
        public static final int x = 0;
        public static final int y = 0;
        public static final int w = 0;
        public static final int h = 0;
        public static final boolean selected = false;

        public void repaint();

        public void select();

        public void unselect();

        public boolean mouseOver(int var1, int var2);

        public void setToolGroup(ToolGroup var1);
    }

    public class ExportButton {
        private int x;
        private int y;
        private int w;
        private int h;
        public boolean pressed;
        public boolean hasFocus;

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            return false;
        }

        public ExportButton(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.hasFocus = false;
            this.pressed = false;
            this.repaint();
        }

        public void repaint() {
            if (LEDmePlayDraw_270117.this.f == null) {
                LEDmePlayDraw_270117.this.f = LEDmePlayDraw_270117.this.loadFont("ArialMT-30.vlw");
            }
            LEDmePlayDraw_270117.this.textFont(LEDmePlayDraw_270117.this.f, 30.0f);
            if (this.pressed) {
                LEDmePlayDraw_270117.this.stroke(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.black);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, this.w, this.h);
                LEDmePlayDraw_270117.this.strokeWeight(1.0f);
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.text("Export", this.x + 10, this.y + 35);
                this.pressed = false;
            } else {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, this.w, this.h);
                LEDmePlayDraw_270117.this.strokeWeight(1.0f);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.text("Export", this.x + 10, this.y + 35);
            }
        }
    }

    public class FillTool
    implements DrawingTool {
        private int x;
        private int y;
        private int w;
        private int h;
        public boolean selected;
        private ToolGroup group;

        @Override
        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.repaint();
                return true;
            }
            return false;
        }

        public FillTool(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.selected = false;
            this.repaint();
        }

        @Override
        public void repaint() {
            if (!this.selected) {
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, 50.0f, 50.0f);
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.rect(this.x + 22, this.y + 22, 15.0f, 20.0f);
                LEDmePlayDraw_270117.this.rect(this.x + 24, this.y + 15, 5.0f, 7.0f);
                LEDmePlayDraw_270117.this.line(this.x + 7, this.y + 9, this.x + 16, this.y + 14);
                LEDmePlayDraw_270117.this.line(this.x + 7, this.y + 18, this.x + 16, this.y + 18);
                LEDmePlayDraw_270117.this.line(this.x + 7, this.y + 27, this.x + 16, this.y + 22);
            } else {
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.stroke(7);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, 50.0f, 50.0f);
                LEDmePlayDraw_270117.this.rect(this.x + 22, this.y + 22, 15.0f, 20.0f);
                LEDmePlayDraw_270117.this.rect(this.x + 24, this.y + 15, 5.0f, 7.0f);
                LEDmePlayDraw_270117.this.line(this.x + 7, this.y + 9, this.x + 16, this.y + 14);
                LEDmePlayDraw_270117.this.line(this.x + 7, this.y + 18, this.x + 16, this.y + 18);
                LEDmePlayDraw_270117.this.line(this.x + 7, this.y + 27, this.x + 16, this.y + 22);
            }
        }

        @Override
        public void select() {
            this.selected = true;
            this.group.toggle(this);
            this.repaint();
        }

        @Override
        public void unselect() {
            this.selected = false;
            this.repaint();
        }

        @Override
        public void setToolGroup(ToolGroup group) {
            this.group = group;
            group.register(this);
        }
    }

    public class LineTool
    implements DrawingTool {
        private int x;
        private int y;
        private int w;
        private int h;
        public boolean selected;
        private ToolGroup group;

        @Override
        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.repaint();
                return true;
            }
            return false;
        }

        public LineTool(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.selected = false;
            this.repaint();
        }

        @Override
        public void repaint() {
            if (!this.selected) {
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, this.w, this.h);
                LEDmePlayDraw_270117.this.line(this.x + 10, this.y + 10, this.x + 40, this.y + 40);
            } else {
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.stroke(7);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, this.w, this.h);
                LEDmePlayDraw_270117.this.line(this.x + 10, this.y + 10, this.x + 40, this.y + 40);
            }
        }

        @Override
        public void select() {
            this.selected = true;
            this.group.toggle(this);
            this.repaint();
        }

        @Override
        public void unselect() {
            this.selected = false;
            this.repaint();
        }

        @Override
        public void setToolGroup(ToolGroup group) {
            this.group = group;
            group.register(this);
        }
    }

    public class LoadButton {
        private int x;
        private int y;
        private int w;
        private int h;
        public boolean pressed;
        public boolean hasFocus;

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            return false;
        }

        public LoadButton(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.pressed = false;
            this.repaint();
        }

        public void repaint() {
            LEDmePlayDraw_270117.this.textFont(LEDmePlayDraw_270117.this.f, 30.0f);
            if (this.pressed) {
                LEDmePlayDraw_270117.this.stroke(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.black);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, this.w, this.h);
                LEDmePlayDraw_270117.this.strokeWeight(1.0f);
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.text("Load", this.x + 10, this.y + 35);
                this.pressed = false;
            } else {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, this.w, this.h);
                LEDmePlayDraw_270117.this.strokeWeight(1.0f);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.text("Load", this.x + 10, this.y + 35);
            }
        }
    }

    public class NumberManipulator {
        int x;
        int y;
        int w;
        int h;
        float red;
        float green;
        float blue;
        int colIndex;
        String text;
        int value;
        int[] indexCol;
        boolean deactivated = false;
        SimpleUpButton up;
        SimpleDownButton down;

        public NumberManipulator(int x, int y, int[] indexCol, int value, String text) {
            this.x = x;
            this.y = y;
            this.indexCol = indexCol;
            this.value = value;
            this.text = text;
            this.up = new SimpleUpButton(this, x + 180, y, 10, 10);
            this.down = new SimpleDownButton(this, x + 180, y + 58, 10, 10);
            this.repaint();
        }

        public void setValue(int sign) {
            if (sign == 1 && this.value < 15) {
                ++this.value;
            } else if (sign == -1 && this.value > 0) {
                --this.value;
            }
            this.repaint();
            LEDmePlayDraw_270117.this.palette.switchPalette(this.value);
        }

        public void repaint() {
            if (LEDmePlayDraw_270117.this.f == null) {
                LEDmePlayDraw_270117.this.f = LEDmePlayDraw_270117.this.loadFont("ArialMT-30.vlw");
            }
            LEDmePlayDraw_270117.this.textFont(LEDmePlayDraw_270117.this.f, 30.0f);
            LEDmePlayDraw_270117.this.noFill();
            LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
            LEDmePlayDraw_270117.this.strokeWeight(2.0f);
            LEDmePlayDraw_270117.this.fill(7);
            LEDmePlayDraw_270117.this.rect(this.x + 168, this.y + 22, 45.0f, 30.0f);
            LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.black);
            LEDmePlayDraw_270117.this.text(LEDmePlayDraw_270117.round((float)this.value), this.x + 174, this.y + 48);
            LEDmePlayDraw_270117.this.text("B", this.x + 179, this.y + 105);
            this.up.repaint();
            this.down.repaint();
        }

        public void setNewValue(int value) {
            this.value = value;
            this.repaint();
        }

        public SimpleUpButton getUp() {
            return this.up;
        }

        public SimpleDownButton getDown() {
            return this.down;
        }
    }

    public class PointTool
    implements DrawingTool {
        private int x;
        private int y;
        private int w;
        private int h;
        public boolean selected;
        private ToolGroup group;

        @Override
        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.repaint();
                return true;
            }
            return false;
        }

        public PointTool(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.selected = false;
            this.repaint();
        }

        @Override
        public void repaint() {
            LEDmePlayDraw_270117.this.strokeWeight(2.0f);
            if (!this.selected) {
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, 50.0f, 50.0f);
                LEDmePlayDraw_270117.this.ellipse(this.x + 25, this.y + 25, 3.0f, 3.0f);
            } else {
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.stroke(7);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, 50.0f, 50.0f);
                LEDmePlayDraw_270117.this.ellipse(this.x + 25, this.y + 25, 3.0f, 3.0f);
            }
        }

        @Override
        public void select() {
            this.selected = true;
            this.group.toggle(this);
            this.repaint();
        }

        @Override
        public void unselect() {
            this.selected = false;
            this.repaint();
        }

        @Override
        public void setToolGroup(ToolGroup group) {
            this.group = group;
            group.register(this);
        }
    }

    class RandomColorPalette {
        int[] indexColor;
        int x;
        int y;
        int w;
        int h;
        boolean hasFocus;

        public RandomColorPalette(int x, int y, int w, int h, int[] indexColor) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.indexColor = indexColor;
            this.indexColor[1] = LEDmePlayDraw_270117.this.color(15, 15, 15);
            this.indexColor[0] = LEDmePlayDraw_270117.this.color(2, 2, 2);
            this.hasFocus = false;
            this.makeRandomRGB444Palette();
            this.repaint();
        }

        public void makeRandomRGB444Palette() {
            LEDmePlayDraw_270117.this.randomSeed(45L);
            int i = 2;
            while (i < 64) {
                this.indexColor[i] = LEDmePlayDraw_270117.this.color(LEDmePlayDraw_270117.this.random(0.0f, 16.0f), LEDmePlayDraw_270117.this.random(0.0f, 16.0f), LEDmePlayDraw_270117.this.random(0.0f, 16.0f));
                ++i;
            }
        }

        public void repaint() {
            if (LEDmePlayDraw_270117.this.f == null) {
                LEDmePlayDraw_270117.this.f = LEDmePlayDraw_270117.this.loadFont("ArialMT-30.vlw");
            }
            LEDmePlayDraw_270117.this.textFont(LEDmePlayDraw_270117.this.f, 30.0f);
            int x = this.x;
            int y = this.y;
            int index = 0;
            while (index < 64) {
                LEDmePlayDraw_270117.this.noStroke();
                LEDmePlayDraw_270117.this.fill(0);
                LEDmePlayDraw_270117.this.textAlign(37);
                LEDmePlayDraw_270117.this.text("" + index, x + 3, 32 + y);
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                int col = this.indexColor[index];
                LEDmePlayDraw_270117.this.fill(col);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.rect(x, 40 + y, 45.0f, 45.0f);
                if (x >= this.x + 750) {
                    x = this.x;
                    y += 100;
                } else {
                    x += 50;
                }
                ++index;
            }
            LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
            LEDmePlayDraw_270117.this.strokeWeight(2.0f);
            LEDmePlayDraw_270117.this.noFill();
            if (this.hasFocus) {
                this.clearHighlightedFrame();
                LEDmePlayDraw_270117.this.currentColor_x = (LEDmePlayDraw_270117.this.mouseX - (this.x + 4)) / 50;
                if (LEDmePlayDraw_270117.this.mouseY > this.y + 47 && LEDmePlayDraw_270117.this.mouseY < this.y + 94) {
                    LEDmePlayDraw_270117.this.currentColor_y = this.y + 40;
                } else if (LEDmePlayDraw_270117.this.mouseY > this.y + 147 && LEDmePlayDraw_270117.this.mouseY < this.y + 194) {
                    LEDmePlayDraw_270117.this.currentColor_y = this.y + 140;
                } else if (LEDmePlayDraw_270117.this.mouseY > this.y + 247 && LEDmePlayDraw_270117.this.mouseY < this.y + 294) {
                    LEDmePlayDraw_270117.this.currentColor_y = this.y + 240;
                } else if (LEDmePlayDraw_270117.this.mouseY > this.y + 347 && LEDmePlayDraw_270117.this.mouseY < this.y + 394) {
                    LEDmePlayDraw_270117.this.currentColor_y = this.y + 340;
                }
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.red);
                if (LEDmePlayDraw_270117.this.currentColor_y >= this.y + 40 && LEDmePlayDraw_270117.this.currentColor_y <= this.y + 340) {
                    LEDmePlayDraw_270117.this.rect(this.x + LEDmePlayDraw_270117.this.currentColor_x * 50, LEDmePlayDraw_270117.this.currentColor_y, 45.0f, 45.0f);
                }
                LEDmePlayDraw_270117.this.formerColor_x = LEDmePlayDraw_270117.this.currentColor_x;
                LEDmePlayDraw_270117.this.formerColor_y = LEDmePlayDraw_270117.this.currentColor_y;
                LEDmePlayDraw_270117.this.currentColorIndex = (LEDmePlayDraw_270117.this.currentColor_y - 50) / 100 * 16 + LEDmePlayDraw_270117.this.currentColor_x;
            }
        }

        public void clearHighlightedFrame() {
            if (LEDmePlayDraw_270117.this.formerColor_y >= this.y + 40 && LEDmePlayDraw_270117.this.formerColor_y <= this.y + 340) {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.noFill();
                LEDmePlayDraw_270117.this.rect(this.x + LEDmePlayDraw_270117.this.formerColor_x * 50, LEDmePlayDraw_270117.this.formerColor_y, 45.0f, 45.0f);
            }
        }

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            this.hasFocus = false;
            return false;
        }
    }

    public class RedoButton {
        private int x;
        private int y;
        private int w;
        private int h;
        public boolean pressed;
        public boolean hasFocus;

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            return false;
        }

        public RedoButton(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.pressed = false;
            this.repaint();
        }

        public void repaint() {
            LEDmePlayDraw_270117.this.textFont(LEDmePlayDraw_270117.this.f, 30.0f);
            if (this.pressed) {
                LEDmePlayDraw_270117.this.stroke(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.black);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, this.w, this.h);
                LEDmePlayDraw_270117.this.strokeWeight(1.0f);
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.text("Redo", this.x + 10, this.y + 35);
                this.pressed = false;
            } else {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, this.w, this.h);
                LEDmePlayDraw_270117.this.strokeWeight(1.0f);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.text("Redo", this.x + 10, this.y + 35);
            }
        }
    }

    public class SimpleDownButton {
        private int x;
        private int y;
        private int w;
        private int h;
        private NumberManipulator cm;
        public boolean pressed;
        public boolean hasFocus;

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            return false;
        }

        public SimpleDownButton(NumberManipulator cm, int x, int y, int w, int h) {
            this.cm = cm;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.pressed = false;
            this.repaint();
        }

        public void push() {
            if (!this.cm.deactivated) {
                this.cm.setValue(-1);
                this.pressed = true;
                this.repaint();
                this.pressed = false;
            }
        }

        public void repaint() {
            if (LEDmePlayDraw_270117.this.f == null) {
                LEDmePlayDraw_270117.this.f = LEDmePlayDraw_270117.this.loadFont("ArialMT-30.vlw");
            }
            LEDmePlayDraw_270117.this.textFont(LEDmePlayDraw_270117.this.f, 30.0f);
            if (this.pressed) {
                LEDmePlayDraw_270117.this.stroke(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.black);
                LEDmePlayDraw_270117.this.triangle(this.x, this.y, this.x + 16, this.y, this.x + 8, this.y + 16);
                LEDmePlayDraw_270117.this.strokeWeight(1.0f);
                LEDmePlayDraw_270117.this.fill(7);
            } else if (!this.cm.deactivated) {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.triangle(this.x, this.y, this.x + 16, this.y, this.x + 8, this.y + 16);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.contourCol);
            } else {
                LEDmePlayDraw_270117.this.noStroke();
                LEDmePlayDraw_270117.this.rect(this.x - 3, this.y - 3, 22.0f, 22.0f);
                LEDmePlayDraw_270117.this.fill(6);
            }
        }
    }

    public class SimpleUpButton {
        private int x;
        private int y;
        private int w;
        private int h;
        private NumberManipulator cm;
        public boolean pressed;
        public boolean hasFocus;

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            return false;
        }

        public SimpleUpButton(NumberManipulator cm, int x, int y, int w, int h) {
            this.cm = cm;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.pressed = false;
            this.repaint();
        }

        public void push() {
            if (!this.cm.deactivated) {
                this.cm.setValue(1);
                this.pressed = true;
                this.repaint();
            }
        }

        public void repaint() {
            if (LEDmePlayDraw_270117.this.f == null) {
                LEDmePlayDraw_270117.this.f = LEDmePlayDraw_270117.this.loadFont("ArialMT-30.vlw");
            }
            LEDmePlayDraw_270117.this.textFont(LEDmePlayDraw_270117.this.f, 30.0f);
            if (this.pressed) {
                LEDmePlayDraw_270117.this.stroke(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.black);
                LEDmePlayDraw_270117.this.triangle(this.x + 8, this.y, this.x + 16, this.y + 16, this.x, this.y + 16);
                LEDmePlayDraw_270117.this.strokeWeight(1.0f);
                LEDmePlayDraw_270117.this.fill(7);
                this.pressed = false;
            } else if (!this.cm.deactivated) {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.triangle(this.x + 8, this.y, this.x + 16, this.y + 16, this.x, this.y + 16);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.contourCol);
            } else {
                LEDmePlayDraw_270117.this.noStroke();
                LEDmePlayDraw_270117.this.fill(6);
                LEDmePlayDraw_270117.this.rect(this.x - 3, this.y - 3, 22.0f, 22.0f);
            }
        }
    }

    class ToolGroup {
        Vector<DrawingTool> group = new Vector();

        ToolGroup() {
        }

        public void register(DrawingTool tool) {
            this.group.add(tool);
        }

        public Vector<DrawingTool> getTools() {
            return this.group;
        }

        public void toggle(DrawingTool tool) {
            for (DrawingTool t : this.group) {
                tool.repaint();
                if (t == tool) continue;
                t.unselect();
                t.repaint();
            }
        }
    }

    class UndoBuffer {
        int[][][] buffer;
        int currentState;
        int maxNumStates;
        int statesUsed;

        public UndoBuffer(int numStates) {
            this.buffer = new int[numStates][32][32];
            this.maxNumStates = numStates;
            this.currentState = 0;
            this.statesUsed = 0;
            this.prepareBuffer(this.currentState);
        }

        public void prepareBuffer(int state) {
            int x = 0;
            while (x < 32) {
                int y = 0;
                while (y < 32) {
                    this.buffer[state][x][y] = 4864;
                    ++y;
                }
                ++x;
            }
        }

        public void addState() {
            if (this.currentState == this.maxNumStates) {
                LEDmePlayDraw_270117.println((String)"Undo buffer full - no more undo steps possible");
            } else {
                ++this.currentState;
                LEDmePlayDraw_270117.println((String)("Added state " + this.currentState));
                ++this.statesUsed;
                int x = 0;
                while (x < 32) {
                    int y = 0;
                    while (y < 32) {
                        this.buffer[this.currentState][x][y] = LEDmePlayDraw_270117.this.frameBuffer[x][y];
                        ++y;
                    }
                    ++x;
                }
            }
        }

        public void replaceAsLast() {
            LEDmePlayDraw_270117.println((String)("Make the current, modified state the newest state" + this.currentState));
            if (this.currentState < this.maxNumStates) {
                int x = 0;
                while (x < 32) {
                    int y = 0;
                    while (y < 32) {
                        this.buffer[this.currentState + 1][x][y] = LEDmePlayDraw_270117.this.frameBuffer[x][y];
                        LEDmePlayDraw_270117.this.backBuffer[x][y] = this.buffer[this.currentState + 1][x][y];
                        ++y;
                    }
                    ++x;
                }
            }
            ++this.currentState;
            this.statesUsed = this.currentState;
        }

        public void reset() {
            LEDmePlayDraw_270117.println((String)"Emptied the undo buffer");
            this.statesUsed = 0;
            this.currentState = 0;
            int x = 0;
            while (x < 32) {
                int y = 0;
                while (y < 32) {
                    this.buffer[this.currentState][x][y] = LEDmePlayDraw_270117.this.frameBuffer[x][y];
                    ++y;
                }
                ++x;
            }
        }

        public void goBack() {
            if (this.currentState > 0) {
                --this.currentState;
                LEDmePlayDraw_270117.println((String)("Go back to state " + this.currentState));
                int x = 0;
                while (x < 32) {
                    int y = 0;
                    while (y < 32) {
                        LEDmePlayDraw_270117.this.frameBuffer[x][y] = this.buffer[this.currentState][x][y];
                        LEDmePlayDraw_270117.this.backBuffer[x][y] = this.buffer[this.currentState][x][y];
                        ++y;
                    }
                    ++x;
                }
                LEDmePlayDraw_270117.this.drawEmptyMatrix();
                LEDmePlayDraw_270117.this.drawFrameBuffer();
            } else {
                LEDmePlayDraw_270117.println((String)"No previous undo steps recorded");
            }
        }

        public void goForward() {
            if (this.currentState < this.maxNumStates && this.currentState < this.statesUsed) {
                ++this.currentState;
                LEDmePlayDraw_270117.println((String)("Go forward to state " + this.currentState));
                int x = 0;
                while (x < 32) {
                    int y = 0;
                    while (y < 32) {
                        LEDmePlayDraw_270117.this.frameBuffer[x][y] = this.buffer[this.currentState][x][y];
                        LEDmePlayDraw_270117.this.backBuffer[x][y] = this.buffer[this.currentState][x][y];
                        ++y;
                    }
                    ++x;
                }
                LEDmePlayDraw_270117.this.drawEmptyMatrix();
                LEDmePlayDraw_270117.this.drawFrameBuffer();
            } else {
                LEDmePlayDraw_270117.println((String)"Arrived at latest undo step");
            }
        }
    }

    public class UndoButton {
        private int x;
        private int y;
        private int w;
        private int h;
        public boolean pressed;
        public boolean hasFocus;

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            return false;
        }

        public UndoButton(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.pressed = false;
            this.repaint();
        }

        public void repaint() {
            LEDmePlayDraw_270117.this.textFont(LEDmePlayDraw_270117.this.f, 30.0f);
            if (this.pressed) {
                LEDmePlayDraw_270117.this.stroke(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.black);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, this.w, this.h);
                LEDmePlayDraw_270117.this.strokeWeight(1.0f);
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.text("Undo", this.x + 10, this.y + 35);
                this.pressed = false;
            } else {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.rect(this.x, this.y, this.w, this.h);
                LEDmePlayDraw_270117.this.strokeWeight(1.0f);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.text("Undo", this.x + 10, this.y + 35);
            }
        }
    }

    public class UpButton {
        private int x;
        private int y;
        private int w;
        private int h;
        private int type;
        private ColorManipulator cm;
        public boolean pressed;
        public boolean hasFocus;

        public boolean mouseOver(int mx, int my) {
            if (mx >= this.x && mx <= this.x + this.w && my >= this.y && my <= this.y + this.h) {
                this.hasFocus = true;
                this.repaint();
                return true;
            }
            return false;
        }

        public UpButton(ColorManipulator cm, int x, int y, int w, int h, int type) {
            this.cm = cm;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.type = type;
            this.pressed = false;
            this.repaint();
        }

        public void push() {
            if (!this.cm.deactivated) {
                switch (this.type) {
                    case 0: {
                        this.cm.setRedComponent(1);
                        break;
                    }
                    case 1: {
                        this.cm.setGreenComponent(1);
                        break;
                    }
                    case 2: {
                        this.cm.setBlueComponent(1);
                    }
                }
                this.pressed = true;
                this.repaint();
            }
        }

        public void repaint() {
            if (LEDmePlayDraw_270117.this.f == null) {
                LEDmePlayDraw_270117.this.f = LEDmePlayDraw_270117.this.loadFont("ArialMT-30.vlw");
            }
            LEDmePlayDraw_270117.this.textFont(LEDmePlayDraw_270117.this.f, 30.0f);
            if (this.pressed) {
                LEDmePlayDraw_270117.this.stroke(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.black);
                LEDmePlayDraw_270117.this.triangle(this.x + 8, this.y, this.x + 16, this.y + 16, this.x, this.y + 16);
                LEDmePlayDraw_270117.this.strokeWeight(1.0f);
                LEDmePlayDraw_270117.this.fill(7);
                this.pressed = false;
            } else if (!this.cm.deactivated) {
                LEDmePlayDraw_270117.this.stroke(LEDmePlayDraw_270117.this.contourCol);
                LEDmePlayDraw_270117.this.fill(7);
                LEDmePlayDraw_270117.this.strokeWeight(2.0f);
                LEDmePlayDraw_270117.this.triangle(this.x + 8, this.y, this.x + 16, this.y + 16, this.x, this.y + 16);
                LEDmePlayDraw_270117.this.fill(LEDmePlayDraw_270117.this.contourCol);
            } else {
                LEDmePlayDraw_270117.this.noStroke();
                LEDmePlayDraw_270117.this.fill(6);
                LEDmePlayDraw_270117.this.rect(this.x - 3, this.y - 3, 22.0f, 22.0f);
            }
        }
    }
}

