package utils;

import java.util.Vector;


public class ToneBank 
{
	private Vector<Tone> tones = new Vector<Tone>(); // Contains the 64 tones of a Roland aJuno 1/2 memory bank
	private static int cnt;
	
	public Tone getTone(int p)
	{
		if ((p >= 0) && ( p <= 63)) return tones.elementAt(p);
		else return null;
	}
	
	
	public void setTone(byte[] data, int p)
	{
		cnt++;
		byte[] tone = null;
		System.arraycopy(data, 0, tone, 0, data.length);
		tones.set(p, new Tone( tone ));
	}
	
	
	public boolean addTone(byte[] data)
	{
		if (cnt == 64) return false;
		if (data == null) return false;
		byte[] byteArray = new byte[64];
		System.arraycopy(data,  0, byteArray, 0, data.length);
		Tone tone = new Tone( byteArray );
		tones.add( tone );
		System.out.println(""+tone.toString());
		return true;
	}
	
	
	public int getToneCount() { return cnt; }
	
	public String[] getToneNames()
	{
		String[] names = new String[64];
		for (int i = 0; i < tones.size(); i++)
		{
			Tone tone = tones.elementAt(i);
			names[i] = tone.getName();
		}
		return names;
	}
	
	public String getToneName(int pos)
	{
		if (tones.size() < pos) return null;
		return (String) tones.elementAt(pos).getName();
	}
}
