package utils;

import java.io.Serializable;
import java.util.HashMap;

import main.Constants;



public class Tone implements Serializable, Constants
{
	private static final long serialVersionUID = 1L;
	private byte[] patchBytes = new byte[ blockLength ];
	
	private static HashMap<Integer, String> names =  new HashMap<Integer, String>(64);
	private static int TONE_NAME_1;
	private static byte VCF_KEY_FOLLOW;
	private static byte DCO_AFTER_DEPTH;
	private static byte VCA_AFTER_DEPTH;
	private static byte VCF_AFTER_DEPTH;
	private static byte DCO_BENDER_RANGE;
	private static byte ENV_KEY_FOLLOW;
	private static int b00;
	private static int DCO_ENV_MOD_DEPTH;
	private static int DCO_LFO_MOD_DEPTH;
	private static int byte3_ignored;
	private static int DCO_PULSE_PW_PWM_DEPTH;
	private static int b01;
	private static int DCO_PWM_RATE;
	private static int b02;
	private static int VCF_CUTOFF_FREQ;
	private static int b03;
	private static int VCF_RESONANCE;
	private static int b04;
	private static int VCF_ENV_MOD_DEPTH;
	private static int b05;
	private static int VCF_LFO_MOD_DEPTH;
	private static int b06;
	private static int VCA_LEVEL;
	private static int b07;
	private static int LFO_RATE;
	private static int b08;
	private static int LFO_DELAY;
	private static int b09;
	private static int ENV_T1;
	private static int b10;
	private static int ENV_L1;
	private static int b11;
	private static int ENV_T2;
	private static int b12;
	private static int ENV_L2;
	private static int b13;  
	private static int b14;  
	private static int b15;  
	private static int b16;  
	private static int b17;  
	private static int b18;  
	private static int b19;  
	private static int b20;
	private static int b21;  
	private static int b22;  
	private static int b23;
	private static int ENV_T3;
	private static int ENV_L3;
	private static int ENV_T4;
	private static int byte21_ignored;
	private static int TONE_NAME_2;
	private static int byte22_ignored;
	private static int TONE_NAME_3;
	private static int byte23_ignored;
	private static int byte24_ignored;
	private static int TONE_NAME_4;
	private static int TONE_NAME_5;
	private static int TONE_NAME_6;
	private static int byte25_ignored;
	private static int byte26_ignored;
	private static int TONE_NAME_7;
	private static int c1;
	private static int c5;
	private static int TONE_NAME_8;
	private static int c0;
	private static int c3;
	private static int c2;
	private static  int TONE_NAME_9;
	private static int c4;
	private static int TONE_NAME_10;
	private static int c7;
	private static int c6;
	private static byte dummy;
	private static int CHORUS_RATE;
	private static int CHORUS_ON_OFF;
	private static int DCO_ENV_MODE;
	private static int VCF_ENV_MODE;
	private static int VCA_ENV_MODE;
	private static int DCO_WAVEFORM_SUB;
	private static int DCO_WAVEFORM_SAWTOOTH;
	private static int DCO_WAVEFORM_PULSE;
	private static int HPF_CUTOFF_FREQ;
	private static int DCO_RANGE;
	private static int DCO_SUB_LEVEL;
	private static int DCO_NOISE_LEVEL;  
	
	private String name = null;
	
	
	public Tone( byte[] patch)
	{
		fillNameHash();
		boolean c = getParameters( patch );
		this.name = constructName();
	}
	
	public Tone( MIDIBulk dump)
	{
		fillNameHash();
		boolean c = getParameters( dump.byteArray );
		
		this.name	= constructName();
	}
	
	public byte[] getByteArray() 
	{ 
		return this.patchBytes.clone();
	}
	
	
	public static String printParameters()
	{
		String message = "";
		message += "\n\n---Roland aJuno Patch---\n";
		/*
		for (int i = 0; i < patchBytes.length; i++)
		{
			message = message + patchBytes[i]+" ";
		}
		*/
		
		message += "\nName: " 
				+ (String) names.get(TONE_NAME_1)
				+ (String) names.get(TONE_NAME_2) + (String) names.get(TONE_NAME_3) + (String) names.get(TONE_NAME_4)
				+ (String) names.get(TONE_NAME_5) + (String) names.get(TONE_NAME_6) + (String) names.get(TONE_NAME_7)
				+ (String) names.get(TONE_NAME_8) + (String) names.get(TONE_NAME_9) + (String) names.get(TONE_NAME_10);

		message += "\nVCF_KEY_FOLLOW   = "+VCF_KEY_FOLLOW;
		message += "\nVCF_AFTER_DEPTH  = "+VCF_AFTER_DEPTH;
		message += "\nVCF CUTOFF FREQ  = "+VCF_CUTOFF_FREQ;
		message += "\nVCF RESONANCE  = "+VCF_RESONANCE;
		message += "\nVCF ENV MOD DEPTH  = "+VCF_ENV_MOD_DEPTH;
		message += "\nVCF LFO MOD DEPTH  = "+VCF_LFO_MOD_DEPTH;
		message += "\nVCF_ENV_MODE = "+VCF_ENV_MODE;
		
		message += "\nVCA_AFTER_DEPTH  = "+VCA_AFTER_DEPTH;
		message += "\nVCA_ENV_MODE = "+VCA_ENV_MODE;
		message += "\nVCA LEVEL  = "+VCA_LEVEL;
		
		message += "\nDCO BENDER RANGE  = "+DCO_BENDER_RANGE;
		message += "\nDCO LFO MOD DEPTH  = "+DCO_LFO_MOD_DEPTH;
		message += "\nDCO ENV MOD DEPTH  = "+DCO_ENV_MOD_DEPTH;
		message += "\nDCO_AFTER_DEPTH  = "+DCO_AFTER_DEPTH;
		message += "\nDCO PULSE PW/PWM DEPTH  = "+DCO_PULSE_PW_PWM_DEPTH;
		message += "\nDCO_WAVEFORM_PULSE = "+DCO_WAVEFORM_PULSE;
		message += "\nDCO_WAVEFORM_SAWTOOTH = "+DCO_WAVEFORM_SAWTOOTH;
		message += "\nDCO_WAVEFORM_SUB = "+DCO_WAVEFORM_SUB;
		message += "\nDCO PWM RATE  = "+DCO_PWM_RATE;
		message += "\nDCO_NOISE_LEVEL = "+DCO_NOISE_LEVEL;
		message += "\nDCO_SUB_LEVEL = "+DCO_SUB_LEVEL;
		message += "\nDCO_RANGE = "+DCO_RANGE;
		message += "\nDCO_ENV_MODE = "+DCO_ENV_MODE;
		
		message += "\nLFO RATE  = "+LFO_RATE;
		message += "\nLFO DELAY = "+LFO_DELAY;
		
		message += "\nHPF CUTOFF FREQ = "+HPF_CUTOFF_FREQ;
		
		message += "\nENV T1  = "+ENV_T1;
		message += "\nENV L1  = "+ENV_L1;
		message += "\nENV T2  = "+ENV_T2;
		message += "\nENV L2  = "+ENV_L2;
		message += "\nENV T3  = "+ENV_T3;
		message += "\nENV L3  = "+ENV_L3;
		message += "\nENV T4  = "+ENV_T4;
		message += "\nENV KEY FOLLOW  = "+ENV_KEY_FOLLOW;
		
		message += "\nCHORUS RATE  = "+CHORUS_RATE;
		message += "\nCHORUS ON/OFF = "+CHORUS_ON_OFF;
		
		return message;
	}
	
	
	
	
	public static boolean getParameters( byte[] b)
	{
		int i = 0;
		
		VCF_KEY_FOLLOW		= b[i];
		DCO_AFTER_DEPTH		= b[i+1];
		VCA_AFTER_DEPTH		= b[i+2];
		VCF_AFTER_DEPTH 	= b[i+3];
		DCO_BENDER_RANGE 	= b[i+4];
		ENV_KEY_FOLLOW  	= b[i+5];
		
		DCO_LFO_MOD_DEPTH		= ((b[i+6] & 0xff) & 15) | (((b[i+7] & 0xFF) & 7) << 4);
		byte3_ignored			= (((b[i+7] & 0xFF) & 8) >> 3 ) ;
		
		DCO_ENV_MOD_DEPTH		= ((b[i+8] & 0xff) & 15) | (((b[i+9] & 0xFF) & 7) << 4); 
		b00						= (((b[i+9] & 0xFF) & 8) >> 3) ;
		
		DCO_PULSE_PW_PWM_DEPTH	= ((b[i+10] & 0xff) & 15) | (((b[i+11] & 0xFF) & 7) << 4); 
		b01						= (((b[i+11] & 0xFF) & 8) >> 3 ) ;
		
		DCO_PWM_RATE			= ((b[i+12] & 0xff) & 15) | (((b[i+13] & 0xFF) & 7) << 4); 
		b02						= (((b[i+13] & 0xFF) & 8) >> 3 ) ;
		
		VCF_CUTOFF_FREQ			= ((b[i+14] & 0xff) & 15) | (((b[i+15] & 0xFF) & 7) << 4); 
		b03						= (((b[i+15] & 0xFF) & 8) >> 3 ) ;
		
		VCF_RESONANCE			= ((b[i+16] & 0xff) & 15) | (((i+b[17] & 0xFF) & 7) << 4); 
		b04						= (((b[i+17] & 0xFF) & 8) >> 3 ) ;
		
		VCF_ENV_MOD_DEPTH		= ((b[i+18] & 0xff) & 15) | (((b[i+19] & 0xFF) & 7) << 4); 
		b05						= (((b[i+19] & 0xFF) & 8) >> 3 ) ;
		
		VCF_LFO_MOD_DEPTH		= ((b[i+20] & 0xff) & 15) | (((b[i+21] & 0xFF) & 7) << 4); 
		b06						= (((b[i+21] & 0xFF) & 8) >> 3 ) ;
		
		VCA_LEVEL				= ((b[i+22] & 0xff) & 15) | (((b[i+23] & 0xFF) & 7) << 4); 
		b07						= (((b[i+23] & 0xFF) & 8) >> 3 ) ;
		
		LFO_RATE				= ((b[i+24] & 0xff) & 15) | (((b[i+25] & 0xFF) & 7) << 4); 
		b08						= (((b[i+25] & 0xFF) & 8) >> 3 ) ;
		
		LFO_DELAY				= ((b[i+26] & 0xff) & 15) | (((b[i+27] & 0xFF) & 7) << 4); 
		b09						= (((b[i+27] & 0xFF) & 8) >> 3 ) ;
		
		ENV_T1					= ((b[i+28] & 0xff) & 15) | (((b[i+29] & 0xFF) & 7) << 4); 
		b10						= (((b[i+29] & 0xFF) & 8) >> 3 ) ;
		
		ENV_L1					= ((b[i+30] & 0xff) & 15) | (((b[i+31] & 0xFF) & 7) << 4); 
		b11						= (((b[i+31] & 0xFF) & 8) >> 3 ) ;
		
		ENV_T2					= ((b[i+32] & 0xff) & 15) | (((b[i+33] & 0xFF) & 7) << 4); 
		b12						= (((b[i+33] & 0xFF) & 8) >> 3 ) ;
		
		ENV_L2					= ((b[i+34] & 0xff) & 15) | (((b[i+35] & 0xFF) & 7) << 4); 
		b13						= (((b[i+35] & 0xFF) & 8) >> 3 ) ;
		
		ENV_T3					= ((b[i+36] & 0xff) & 15) | (((b[i+37] & 0xFF) & 7) << 4); 
		b14						= (((b[i+37] & 0xFF) & 8) >> 3 ) ;
		
		ENV_L3					= ((b[i+38] & 0xff) & 15) | (((b[i+39] & 0xFF) & 7) << 4); 
		b15						= (((b[i+39] & 0xFF) & 8) >> 3 ) ;
		
		ENV_T4					= ((b[i+40] & 0xff) & 15) | (((b[i+41] & 0xFF) & 7) << 4); 
		b16						= ((b[i+41] & 0xFF) & 8) >> 3 ;
		
		TONE_NAME_1				= ((b[i+42] & 0xFF) & 15) | (((b[i+43] & 0xFF) & 3) << 4); 
		b17						= ((b[i+43] & 0xFF) & 8)  >> 3 ;
		byte21_ignored			= ((b[i+43] & 0xFF) & 4)  >> 2 ;
		
		TONE_NAME_2				= ((b[i+44] & 0xFF) & 15) | (((b[i+45] & 0xFF) & 3) << 4); 
		b18						= ((b[i+45] & 0xFF) & 8) >> 3 ;
		byte22_ignored			= ((b[i+45] & 0xFF) & 4) >> 2 ;
		
		TONE_NAME_3				= ((b[i+46] & 0xFF) & 15) | (((b[i+47] & 0xFF) & 3) << 4); 
		b19						= ((b[i+47] & 0xFF) & 8) >> 3 ;
		byte23_ignored			= ((b[i+47] & 0xFF) & 4) >> 2 ;
		
		TONE_NAME_4				= ((b[i+48] & 0xFF) & 15) | (((b[i+49] & 0xFF) & 3) << 4); 
		b20						= ((b[i+49] & 0xFF) & 8) >> 3 ;
		byte24_ignored			= ((b[i+49] & 0xFF) & 4) >> 2 ;
		
		TONE_NAME_5				= ((b[i+50] & 0xFF) & 15) | (((b[i+51] & 0xFF) & 3) << 4); 
		b21						= ((b[i+51] & 0xFF) & 8) >> 3 ;
		byte25_ignored			= ((b[i+51] & 0xFF) & 4) >> 2 ;
		
		TONE_NAME_6				= ((b[i+52] & 0xFF) & 15) | (((b[i+53] & 0xFF) & 3) << 4); 
		b22						= ((b[i+53] & 0xFF) & 8) >> 3 ;
		byte26_ignored			= ((b[i+53] & 0xFF) & 4) >> 2 ;
		
		TONE_NAME_7				= ((b[i+54] & 0xFF) & 15) | (((b[i+55] & 0xFF) & 3) << 4); 
		c1						= ((b[i+55] & 0xFF) & 8) >> 3 ;
		c0						= ((b[i+55] & 0xFF) & 4) >> 2 ;
		
		TONE_NAME_8				= ((b[i+56] & 0xFF) & 15) | (((b[i+57] & 0xFF) & 3) << 4); 
		c3						= ((b[i+57] & 0xFF) & 8) >> 3 ;
		c2						= ((b[i+57] & 0xFF) & 4) >> 2 ;
		
		TONE_NAME_9				= ((b[i+58] & 0xFF) & 15) | (((b[59] & 0xFF) & 3) << 4); 
		c5						= ((b[i+59] & 0xFF) & 8) >> 3 ;
		c4						= ((b[i+59] & 0xFF) & 4) >> 2 ;
		
		TONE_NAME_10			= ((b[i+60] & 0xFF) & 15) | (((b[i+61] & 0xFF) & 3) << 4); 
		c7						= ((b[i+61] & 0xFF) & 8);
		c6						= ((b[i+61] & 0xFF) & 4) >> 2 ;
		dummy					= b[i+62];
		
		CHORUS_RATE				= (0 * 128 + c6 *64 + c5 *32 + c4 * 16 + c3 * 8 + c2 * 4 + c1 *2 + c0) & 0xFF;
		CHORUS_ON_OFF			= b00;	// 0 - OFF, 1 - ON
		
		DCO_ENV_MODE = 0;
		if 		((b01 == 0) && (b02 == 0))	DCO_ENV_MODE = 0;	// ENV normal
		else if ((b01 == 0) && (b02 == 1))	DCO_ENV_MODE = 1;	// ENV inverted
		else if ((b01 == 1) && (b02 == 0))	DCO_ENV_MODE = 2;	// ENV normal with Dynamics
		else if ((b01 == 1) && (b02 == 1))	DCO_ENV_MODE = 3;	// ENV inverted with Dynamics
		
		VCF_ENV_MODE = 0;
		if 		((b03 == 0) && (b04 == 0))	VCF_ENV_MODE = 0;	// ENV normal
		else if ((b03 == 0) && (b04 == 1))	VCF_ENV_MODE = 1;	// ENV inverted
		else if ((b03 == 1) && (b04 == 0))	VCF_ENV_MODE = 2;	// ENV normal with Dynamics
		else if ((b03 == 1) && (b04 == 1))	VCF_ENV_MODE = 3;	// dynamics
		
		VCA_ENV_MODE = 0;
		if 		((b05 == 0) && (b06 == 0))	VCF_ENV_MODE = 0;	// ENV
		else if ((b05 == 0) && (b06 == 1))	VCF_ENV_MODE = 1;	// GATE
		else if ((b05 == 1) && (b06 == 0))	VCF_ENV_MODE = 2;	// ENV with Dynamics
		else if ((b05 == 1) && (b06 == 1))	VCF_ENV_MODE = 3;	// GATE with Dynamics
		
		DCO_WAVEFORM_SUB = 0;
		if 		((b07 == 0) && (b08 == 0) && (b09 == 0))	DCO_WAVEFORM_SUB = 0;
		else if	((b07 == 0) && (b08 == 0) && (b09 == 1))	DCO_WAVEFORM_SUB = 1;
		else if	((b07 == 0) && (b08 == 1) && (b09 == 0))	DCO_WAVEFORM_SUB = 2;
		else if	((b07 == 0) && (b08 == 1) && (b09 == 1))	DCO_WAVEFORM_SUB = 3;
		else if	((b07 == 1) && (b08 == 0) && (b09 == 0))	DCO_WAVEFORM_SUB = 4;
		else if	((b07 == 1) && (b08 == 0) && (b09 == 1))	DCO_WAVEFORM_SUB = 5;
		
		DCO_WAVEFORM_SAWTOOTH = 0;
		if 		((b10 == 0) && (b11 == 0) && (b12 == 0))	DCO_WAVEFORM_SAWTOOTH = 0;
		else if	((b10 == 0) && (b11 == 0) && (b12 == 1))	DCO_WAVEFORM_SAWTOOTH = 1;
		else if	((b10 == 0) && (b11 == 1) && (b12 == 0))	DCO_WAVEFORM_SAWTOOTH = 2;
		else if	((b10 == 0) && (b11 == 1) && (b12 == 1))	DCO_WAVEFORM_SAWTOOTH = 3;
		else if	((b10 == 1) && (b11 == 0) && (b12 == 0))	DCO_WAVEFORM_SAWTOOTH = 4;
		else if	((b10 == 1) && (b11 == 0) && (b12 == 1))	DCO_WAVEFORM_SAWTOOTH = 5;
		
		DCO_WAVEFORM_PULSE = 0;
		if 		((b13 == 0) && (b14 == 0))	DCO_WAVEFORM_PULSE = 0;
		else if ((b13 == 0) && (b14 == 1))	DCO_WAVEFORM_PULSE = 1;
		else if ((b13 == 1) && (b14 == 0))	DCO_WAVEFORM_PULSE = 2;
		else if ((b13 == 1) && (b14 == 1))	DCO_WAVEFORM_PULSE = 3;
		
		HPF_CUTOFF_FREQ = 0;
		if 		((b15 == 0) && (b16 == 0))	HPF_CUTOFF_FREQ = 0;
		else if ((b15 == 0) && (b16 == 1))	HPF_CUTOFF_FREQ = 1;
		else if ((b15 == 1) && (b16 == 0))	HPF_CUTOFF_FREQ = 2;
		else if ((b15 == 1) && (b16 == 1))	HPF_CUTOFF_FREQ = 3;
		
		DCO_RANGE = 0;
		if 		((b17 == 0) && (b18 == 0))	DCO_RANGE = 0; // 4'
		else if ((b17 == 0) && (b18 == 1))	DCO_RANGE = 1; // 8'
		else if ((b17 == 1) && (b18 == 0))	DCO_RANGE = 2; // 16'
		else if ((b17 == 1) && (b18 == 1))	DCO_RANGE = 3; // 32'
		
		DCO_SUB_LEVEL = 0;
		if 		((b19 == 0) && (b20 == 0))	DCO_SUB_LEVEL = 0;
		else if ((b19 == 0) && (b20 == 1))	DCO_SUB_LEVEL = 1;
		else if ((b19 == 1) && (b20 == 0))	DCO_SUB_LEVEL = 2;
		else if ((b19 == 1) && (b20 == 1))	DCO_SUB_LEVEL = 3;
		
		DCO_NOISE_LEVEL = 0;
		if 		((b21 == 0) && (b22 == 0))	DCO_NOISE_LEVEL = 0;
		else if ((b21 == 0) && (b22 == 1))	DCO_NOISE_LEVEL = 1;
		else if ((b21 == 1) && (b22 == 0))	DCO_NOISE_LEVEL = 2;
		else if ((b21 == 1) && (b22 == 1))	DCO_NOISE_LEVEL = 3;
		
		//System.out.println(""+printParameters());
		
		
		
		return true;
	}
	
	

	
	public String getName()
	{
		/*
		byte[] b = this.getByteArray();
		
		int i = 0;
		TONE_NAME_1				= ((b[i+42] & 0xFF) & 15) | (((b[i+43] & 0xFF) & 3) << 4); 
		TONE_NAME_2				= ((b[i+44] & 0xFF) & 15) | (((b[i+45] & 0xFF) & 3) << 4); 
		TONE_NAME_3				= ((b[i+46] & 0xFF) & 15) | (((b[i+47] & 0xFF) & 3) << 4); 
		TONE_NAME_4				= ((b[i+48] & 0xFF) & 15) | (((b[i+49] & 0xFF) & 3) << 4); 
		TONE_NAME_5				= ((b[i+50] & 0xFF) & 15) | (((b[i+51] & 0xFF) & 3) << 4); 
		TONE_NAME_6				= ((b[i+52] & 0xFF) & 15) | (((b[i+53] & 0xFF) & 3) << 4); 
		TONE_NAME_7				= ((b[i+54] & 0xFF) & 15) | (((b[i+55] & 0xFF) & 3) << 4); 
		TONE_NAME_8				= ((b[i+56] & 0xFF) & 15) | (((b[i+57] & 0xFF) & 3) << 4); 
		TONE_NAME_9				= ((b[i+58] & 0xFF) & 15) | (((b[i+59] & 0xFF) & 3) << 4); 
		TONE_NAME_10			= ((b[i+60] & 0xFF) & 15) | (((b[i+61] & 0xFF) & 3) << 4); 
		
		
		System.out.println();
		System.out.print(names.get(TONE_NAME_1));
		System.out.print(names.get(TONE_NAME_2));
		System.out.print(names.get(TONE_NAME_3));
		System.out.print(names.get(TONE_NAME_4));
		System.out.print(names.get(TONE_NAME_5));
		System.out.print(names.get(TONE_NAME_6));
		System.out.print(names.get(TONE_NAME_7));
		System.out.print(names.get(TONE_NAME_8));
		System.out.print(names.get(TONE_NAME_9));
		System.out.print(names.get(TONE_NAME_10));
		
		String name 		= (String) names.get(TONE_NAME_1)
							+ (String) names.get(TONE_NAME_2) + (String) names.get(TONE_NAME_3) + (String) names.get(TONE_NAME_4)
							+ (String) names.get(TONE_NAME_5) + (String) names.get(TONE_NAME_6) + (String) names.get(TONE_NAME_7)
							+ (String) names.get(TONE_NAME_8) + (String) names.get(TONE_NAME_9) + (String) names.get(TONE_NAME_10);
							*/
		return this.name;
	}
	
	
	public String toString()
	{
		//return "Roland aJuno1/2 Tone: '" + this.getName() + "'";
		return this.getName();
	}
	
	
	public static String getName(ToneBank bank, int p) 
	{
		// Get TONE number p in TONE BANK b
		Tone patch = bank.getTone(p);
		byte[] b = patch.getByteArray();
		
		int i = 0;
		TONE_NAME_1				= ((b[i+42] & 0xFF) & 15) | (((b[i+43] & 0xFF) & 3) << 4); 
		TONE_NAME_2				= ((b[i+44] & 0xFF) & 15) | (((b[i+45] & 0xFF) & 3) << 4); 
		TONE_NAME_3				= ((b[i+46] & 0xFF) & 15) | (((b[i+47] & 0xFF) & 3) << 4); 
		TONE_NAME_4				= ((b[i+48] & 0xFF) & 15) | (((b[i+49] & 0xFF) & 3) << 4); 
		TONE_NAME_5				= ((b[i+50] & 0xFF) & 15) | (((b[i+51] & 0xFF) & 3) << 4); 
		TONE_NAME_6				= ((b[i+52] & 0xFF) & 15) | (((b[i+53] & 0xFF) & 3) << 4); 
		TONE_NAME_7				= ((b[i+54] & 0xFF) & 15) | (((b[i+55] & 0xFF) & 3) << 4); 
		TONE_NAME_8				= ((b[i+56] & 0xFF) & 15) | (((b[i+57] & 0xFF) & 3) << 4); 
		TONE_NAME_9				= ((b[i+58] & 0xFF) & 15) | (((b[i+59] & 0xFF) & 3) << 4); 
		TONE_NAME_10			= ((b[i+60] & 0xFF) & 15) | (((b[i+61] & 0xFF) & 3) << 4); 
		
		String name 		= (String) names.get(TONE_NAME_1)
							+ (String) names.get(TONE_NAME_2) + (String) names.get(TONE_NAME_3) + (String) names.get(TONE_NAME_4)
							+ (String) names.get(TONE_NAME_5) + (String) names.get(TONE_NAME_6) + (String) names.get(TONE_NAME_7)
							+ (String) names.get(TONE_NAME_8) + (String) names.get(TONE_NAME_9) + (String) names.get(TONE_NAME_10);
		return name;
	}
	
	
	private void fillNameHash()
	{
		names.put( 0, "A");
		names.put( 1, "B");
		names.put( 2, "C");
		names.put( 3, "D");
		names.put( 4, "E");
		names.put( 5, "F");
		names.put( 6, "G");
		names.put( 7, "H");
		names.put( 8, "I");
		names.put( 9, "J");
		names.put( 10, "K");
		names.put( 11, "L");
		names.put( 12, "M");
		names.put( 13, "N");
		names.put( 14, "O");
		names.put( 15, "P");
		names.put( 16, "Q");
		names.put( 17, "R");
		names.put( 18, "S");
		names.put( 19, "T");
		names.put( 20, "U");
		names.put( 21, "V");
		names.put( 22, "W");
		names.put( 23, "X");
		names.put( 24, "Y");
		names.put( 25, "Z");
		names.put( 26, "a");
		names.put( 27, "b");
		names.put( 28, "c");
		names.put( 29, "d");
		names.put( 30, "e");
		names.put( 31, "f");
		names.put( 32, "g");
		names.put( 33, "h");
		names.put( 34, "i");
		names.put( 35, "j");
		names.put( 36, "k");
		names.put( 37, "l");
		names.put( 38, "m");
		names.put( 39, "n");
		names.put( 40, "o");
		names.put( 41, "p");
		names.put( 42, "q");
		names.put( 43, "r");
		names.put( 44, "s");
		names.put( 45, "t");
		names.put( 46, "u");
		names.put( 47, "v");
		names.put( 48, "w");
		names.put( 49, "x");
		names.put( 50, "y");
		names.put( 51, "z");
		names.put( 52, "0");
		names.put( 53, "1");
		names.put( 54, "2");
		names.put( 55, "3");
		names.put( 56, "4");
		names.put( 57, "5");
		names.put( 58, "6");
		names.put( 59, "7");
		names.put( 60, "8");
		names.put( 61, "9");
		names.put( 62, " ");
		names.put( 63, "-");
	}
	
	private String constructName()
	{
		String s 	= (String) names.get(TONE_NAME_1)
					+ (String) names.get(TONE_NAME_2) + (String) names.get(TONE_NAME_3) + (String) names.get(TONE_NAME_4)
					+ (String) names.get(TONE_NAME_5) + (String) names.get(TONE_NAME_6) + (String) names.get(TONE_NAME_7)
					+ (String) names.get(TONE_NAME_8) + (String) names.get(TONE_NAME_9) + (String) names.get(TONE_NAME_10);
		return s;
	}
}