package utils;

import java.util.Iterator;
import java.util.Vector;

import main.Constants;

public class Presets implements Constants
{
	static Vector<Presets> bankP = new Vector<Presets>();
	static Vector<Presets> bankM = new Vector<Presets>();
	static String[] defaultNames_P;
	static String[] defaultNames_M;
	String name;
	String data;
	
	public Presets()
	{
		getDefaultBankNames();
		for (int i = 0; i < defaultNames_P.length; i++) 
		{
			bankP.add(new Presets(defaultNames_P[i], new String()));
		}
		for (int i = 0; i < defaultNames_M.length; i++) 
		{
			bankM.add(new Presets(defaultNames_M[i], new String()));
		}
	}
	
	public Presets(String name, String data) { this.name = name; this.data = data; }
	public String getName() { return name; }
	public void setName(String name) { this.name = name; }
	public void setdata(String data) { this.data = data; }
	public String getNameAt(int bank, int position)
	{
		if (bank == BANKP) { return bankP.elementAt(position).name; }
		if (bank == BANKM) { return bankM.elementAt(position).name; }
		return new String("");
	}
	
	public static String[] getAllNames_BankP() 
	{ 
		int i = 0;
		String[] names = new String[64];
		Iterator<Presets> it = bankP.iterator();
		while (it.hasNext()) 
		{ 
			names[i++] =  it.next().name; 
		}

		return names; 
	}
	
	public static String[] getAllNames_BankM() 
	{ 
		int i = 0;
		String[] names = new String[64];
		Iterator<Presets> it = bankM.iterator();
		while (it.hasNext()) 
		{ 
			names[i++] =  it.next().name; 
		}
		
		return names;  
	}
	
	public static String[] getAllNamesIndexed_BankP() 
	{ 
		int i = 0;
		int j = 10;
		String[] names = new String[64];
		Iterator<Presets> it = bankP.iterator();
		while (it.hasNext()) 
		{ 
			if ((j+2) % 10 == 0) j = j + 3;
			else j = j + 1;
			names[i++] =  "P"+j+"  " + it.next().name; 
		}
		
		
		return names; 
	}
	
	public static String[] getAllNamesIndexed_BankM() 
	{ 
		int i = 0;
		int j = 10;
		String[] names = new String[64];
		Iterator<Presets> it = bankM.iterator();
		while (it.hasNext()) 
		{ 
			if ((j+2) % 10 == 0) j = j + 3;
			else j = j + 1;
			names[i++] =  "M"+j+"  " + it.next().name; 
		}
		
		return names;  
	}
	
	static void getDefaultBankNames()
	{
		String[] names_M = 
		{
			"Brass 3",
			"Brass 4",
			"Fat Brass 2",
			"Trumpets",
			"Horns",
			"Brass Section",
			"Synth Brass 2",
			"Reso Sweep",
			"JUNO String 3",
			"JUNO String 4",
			"Synth Orchestra 2",
			"Tekno String",
			"Fiddle",
			"Double Basses",
			"Pad",
			"Surprise",
			"Piano 4",
			"Electric Piano 2",
			"Electric Piano 3",
			"Piano-FX",
			"Clavichord",
			"Harpsichord 2",
			"Acoustic Guitar",
			"Bass Piano",
			"Organ 3",
			"Organ 4",
			"Overdrived Organ",
			"Click Organ",
			"Pipe Organ 3",
			"Voice Pad",
			"Voices 2",
			"Harmonica",
			"Synth Koto",
			"Vibe",
			"Bells 2",
			"Bells 3",
			"Mallet",
			"Poly Pulse",
			"Echo Harp",
			"Fairy Steps",
			"Lead 4",
			"Lead 5",
			"Inv-Solo",
			"Clarinet",
			"Bassoon",
			"Synth Bass 2",
			"Synth Bass 3",
			"Uprite Bass",
			"Machines",
			"Pole Position",
			"Vidiots",
			"Jet Chord",
			"ooops",
			"Take Off",
			"Ufo",
			"Oct Jump",
			"Jet",
			"Helicopter",
			"Dogs Bark",
			"WET",
			"ooohSCARY",
			"What the",
			"Synth Toms",
			"Kick" 
		};
		defaultNames_M = names_M.clone();
		
		String[] names_P =
		{
			"Brass 1",
			"Brass 2",
			"PWM Brass",
			"Spit Valve",
			"Synth Brass",
			"Brass Swell",
			"Brass Horns",
			"Fat Brass 1",
			"JUNO String 1",
			"JUNO String 2",
			"Synth Orchestra",
			"Fast String",
			"Orchestra",
			"Cello",
			"Solo Violin",
			"Pizzicato",
			"Piano 1",
			"Piano 2",
			"Piano 3",
			"Loud-Piano",
			"Electric Piano 1",
			"Clavi",
			"Harpsichord",
			"Chorus Guitar",
			"Organ 1",
			"Organ 2",
			"Cheesy Organ",
			"Chowa Organ",
			"Pipe Organ 1",
			"Pipe Organ 2",
			"Accordion",
			"Vocoder",
			"Poly Synth 1",
			"Fat Synth",
			"Synth Sweep",
			"String Sweep",
			"Cosmo Sweep",
			"Velo-Reso",
			"Voices",
			"Sinusoidal",
			"Lead 1",
			"Lead 2",
			"Lead 3",
			"Flute",
			"Oboe",
			"Sax",
			"Electric Bass 1",
			"Synth Bass 1",
			"Chorus Pluck",
			"Bells 1",
			"Bell-Chime",
			"Xylophone",
			"Marimba",
			"Koto",
			"Steel Drum Band",
			"Harp",
			"Ominous",
			"Noise Shots",
			"Twilite Zone",
			"Echo Explosion",
			"Whistle",
			"Arpeggiator",
			"Electro Drums",
			"Timp"
		};
		defaultNames_P = names_P.clone();
	}
}
