package utils;

import java.util.Iterator;
import java.util.Vector;

import javax.sound.midi.MidiMessage;
import javax.sound.midi.SysexMessage;

import main.Constants;
import main.Librarian;



public class MIDIMessageDecoder implements Constants
{
	public static Vector<MIDIBulk> bulkDumps = new Vector<MIDIBulk>();
	private static Librarian librarian;
	
	/*
	public MIDIMessageDecoder( Librarian librarian)
	{
		this.librarian = librarian;
	}
	*/
	
	public static void addReceivedDump(Vector<MIDIMessageAndTimestamp> dump) 
	{ 
		// A Juno-2 bulk dump consists of 16 MidiMessages of type SysexMessage, 
		// each of which containing four patch definitions
		MIDIMessageAndTimestamp mat = ((MIDIMessageAndTimestamp) dump.firstElement());
		MidiMessage msg = mat.message;
		if (msg instanceof SysexMessage)
		{
			Vector<Byte> dst = new Vector<Byte>();
			Iterator<MIDIMessageAndTimestamp> it = dump.iterator();
			while (it.hasNext())
			{
				MIDIMessageAndTimestamp mat2 = (MIDIMessageAndTimestamp) it.next();
				
				msg = mat2.message;
				if (msg instanceof SysexMessage)
				{
					byte[] src = ((SysexMessage) msg).getData();
					int i;
					dst.add(byte1); // Mark begin of a Sysex message with F0 (decimal 240)
					for (i = 0; i < src.length; i++)
					{
						dst.add(src[i]);
					}
				}
			}
			byte[] dstArray = new byte[dst.size()];
			for (int i = 0; i < dst.size(); i++) dstArray[i] = dst.elementAt(i);
			//System.out.println("Received dump has byte size "+dst.size());
			MIDIBulk bulk = new MIDIBulk(dstArray);
			bulkDumps.add(bulk);
		}
	}
	
	
	public static boolean decodeLastDump() 
	{
		if (bulkDumps.isEmpty()) return false;
		MIDIBulk bulk = (MIDIBulk) bulkDumps.lastElement();
		return decodeDump(bulk);
	}
	
	
	
	// Decompose the byte stream into patches for the Roland aJuno synthesizer
	// Store the patches as the newest bank in the Librarian
	public static boolean decodeDump(MIDIBulk bulk) 
	{
		// Obtain the byte array of the MIDI SysEx bulk dump
		byte[] dump = bulk.byteArray;
		
		// Check whether the structure of the dump is in order.
		if (!checkDumpStructure( dump )) return false;
		
		// The structure of the dump is in order.
		// Separate each block of 4 TONE data sets into the separate TONE data segments and build new patches
		for (int i = 0; i < 16; i++)
		{
			byte[] preamble = new byte[10];		// Includes the F0 (Start of SysEx)
			byte[] toneData = new byte[257];	// Includes the F7 (End of SysEx)
			
			System.arraycopy( dump, 266*i, preamble, 0, 9);
			System.arraycopy( dump, 266*i+9, toneData, 0, 257);
			int program = ((preamble[8] & 0xFF) & 63);
			System.out.println("Program = "+program);
			
			byte[] set1 = new byte[65];
			byte[] set2 = new byte[65];
			byte[] set3 = new byte[65];
			byte[] set4 = new byte[65];
			
			
			System.arraycopy(toneData, 0, set1, 0, 64);
			System.arraycopy(toneData, 64, set2, 0, 64);
			System.arraycopy(toneData, 128, set3, 0, 64);
			System.arraycopy(toneData, 192, set4, 0, 64);
			
			new Tone( set1 );
			new Tone( set2 );
			new Tone( set3 );
			new Tone( set4 );
		}
		return true;
	}
	
	
	private static boolean checkDumpStructure( byte[] b)
	{
		int block = 0;		// Must be 16 blocks
		int length = 0;	// Must be 266 bytes (4 sets of TONE data), includes the surrounding F0 and F7
		// The SysEx preamble (8 bytes) comes first, then the four sets (4*64 bytes)
		int i = 0;	// Position in the bulk dump
		boolean[] wrongBlockLength = new boolean[16];
		for (int k = 0; k < 16; k++) wrongBlockLength[k] = false;
		
		do
		{
			if ( b[i] == startOfSysEx ) // Start of a SysEx message
			{
				if (!checkPreamble( b, i)) return false; // Check the SysEx preamble for this block 
				length++;
				block++;
			}
			else if ( b[i] == endOfSysEx )	// End of the block
			{
				length++;
				System.out.println("Block length = "+length);
				if (length < blockLength) wrongBlockLength[ block-1 ] = true;
				length = 0;	// A new block consisting of 4 sets of TONE data begins
			}
			else // We are within a block
			{
				length++;
			}
			i++;
		}
		while (i < b.length);
		
		// Too few TONE data blocks
		if ( block < 16 ) { System.out.println("\nThe dump contains less than 16 blocks."); return false; }
		
		// One of the 16 blocks has the wrong length
		int j = 0;
		boolean inconsistentBlockLengths = false;
		while ((j < 15) && (!inconsistentBlockLengths))
		{ 
			if (wrongBlockLength[j])
			{ 
				System.out.println("Block "+(j+2)+" has a wrong block length.");
				inconsistentBlockLengths = true;
			}
			j++;
		}
		if (inconsistentBlockLengths) return false;
		
		return true;
	}
	
	private static boolean checkPreamble(byte[] b, int p) 
	{
		/*
		byte1 = new Integer(240).byteValue(); // F0 11110000 Exclusive Status
	    byte2 = new Integer(65).byteValue();  // 41 01000001 Roland ID
	    byte3 = new Integer(54).byteValue();  // 36 00110110 Operation Code (Individual Parameter)
	    byte4 = new Integer(0).byteValue();   // 00 00000000 MIDI Channel (1-16)
	    byte5 = new Integer(35).byteValue();  // 23 00100011 Format type JU1/JU2
	    byte6 = new Integer(32).byteValue();  // 20 00100000 Level Number = 1
	    byte7 = new Integer(1).byteValue();   // 01 00000001 Group Number
	    */
		
		// The MIDI Channel can be ignored for the purpose of storing the patch bank
		// The SysEx data are suitable for the aJuno1/2, not for other modules
		// Operation code 36 is a Roland aJuno1/2 bulk dump
		// Level and group number are of no importance for this synth
		
		if  (((b[p] & 0xFF) == 0xF0) &&
			((b[p+1] & 0xFF) == 0x41) && 
			((b[p+2] & 0xFF) == 0x37) &&
			((b[p+4] & 0xFF) == 0x23)) return true;
		System.out.println("The SysEx preamble is invalid.");
		return false;
	}
	
	public static boolean decodeDump(byte[] dump)
	{
		if (decodeDump(new MIDIBulk(dump))) return true;
		return false;
	}
	
	
	
	public static void deleteLastDump() 
	{
		if (bulkDumps.isEmpty()) return;
		MIDIBulk lastDump = bulkDumps.lastElement();
		bulkDumps.remove(lastDump);
	}

	
	public static MIDIBulk getLastDump() 
	{
		if (bulkDumps.lastElement() != null) 
		{
			return bulkDumps.lastElement();
		}
		else return null;
	}
	
	
	
	public static String getHexString(byte[] aByte)
	{
		StringBuffer sbuf = new StringBuffer(aByte.length * 3 + 2);
		for (int i = 0; i < aByte.length; i++)
		{
			sbuf.append(' ');
			sbuf.append(hexDigits[(aByte[i] & 0xF0) >> 4]);
			sbuf.append(hexDigits[aByte[i] & 0x0F]);
		}
		return new String(sbuf);
	}
	
	
	private static char hexDigits[] = 
		   {'0', '1', '2', '3', 
		    '4', '5', '6', '7', 
		    '8', '9', 'A', 'B', 
		    'C', 'D', 'E', 'F'};

	
	
	public static void addLastDumpToLibrarian() 
	{
		if (!bulkDumps.isEmpty())
		{
			Librarian.addToneBank( bulkDumps.lastElement() );
		}
	}

	
	// Return the byte array for TONE p within the specified SysEx dump
	public static byte[] getToneData(MIDIBulk dump, int p) 
	{
		if (dump == null) return null;
		byte[] byteArray = dump.byteArray;
		// Find the byte at which the TONE data for TONE p begins
		int set = p % 4; 			// Set 0..3
		int block = (int) (p / 4);	// Block 0..15 
		
		//System.out.println("Block, set = "+block+" "+set);
		
		byte[] patch = new byte[64];
		int position = 266*block+9 + set*64;
		System.arraycopy(byteArray, position, patch, 0, 64);
		return patch;
	}
	
	/*
		// I added:
		for ( Long timeStamp : wholeDump.keySet() )
		{
			MidiMessage midiMessage = wholeDump.get(timeStamp);
			int length = midiMessage.getLength();
			int status = midiMessage.getStatus();
			
			System.out.print("\n");
			if (midiMessage instanceof SysexMessage)
			{
				SysexMessage sysexMessage = (SysexMessage) midiMessage;
				
				byte[] data = sysexMessage.getData();
				
				System.out.print( ""+timeStamp+": length = "+length+", status = "+status+", message: ");
				for (int i = 0; i < data.length; i++) 
				{
					//System.out.print( data[i]+" ");
					
					allBytes.add( new Byte(data[i]));
				}
			}
			else
			{
				byte[] messageContent = midiMessage.getMessage();
				//System.out.print( ""+timeStamp+": length = "+length+", status = "+status+", message: ");
				for (int i = 0; i < messageContent.length; i++) System.out.print( messageContent[i]+" ");
			}
		}
		*/
	 
}
