package utils;

import java.io.Serializable;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.SysexMessage;

// A simple wrapper for the combination of a time stamp and a SysEx message
public class MIDIMessageAndTimestamp implements Serializable
{
	private static final long serialVersionUID = -5925862562220418986L;
	public SysexMessage message;
	public long timestamp;
	
	public MIDIMessageAndTimestamp(long timestamp, MidiMessage m)
	{
		if (m instanceof SysexMessage) this.message = (SysexMessage) m;
		this.timestamp = timestamp;
		//System.out.println(MIDIMessageDecoder.getHexString(message.getData()));
	}

	
	public MIDIMessageAndTimestamp(MIDIMessageAndTimestamp mat) 
	{
		MidiMessage m = mat.message;
		if (m instanceof SysexMessage) this.message = (SysexMessage) m;
		this.timestamp = mat.timestamp;
		//System.out.println(MIDIMessageDecoder.getHexString(message.getData()));
	}
	
	
	private void displayMessage(SysexMessage message)
	{
		byte[] byteArray = message.getData();
		//System.out.println("SysexMessage: ");
		for (int i = 0; i < byteArray.length; i++) System.out.print(""+byteArray[i]+" ");
	}
	
}
