package utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;

import main.ModController;
import main.ModView;

// A MIDI OUT device has at least one transmitter and zero receivers
// A MIDI IN device has at least one receiver and zero transmitters
public class MIDIDispatcher 
{
	static ArrayList<MidiDevice> midiDevices = new ArrayList<MidiDevice>();
	static ArrayList<MidiDevice> inDevice = new ArrayList<MidiDevice>();
	static ArrayList<MidiDevice> outDevice = new ArrayList<MidiDevice>();
	static ArrayList<MidiDevice> seqDevice = new ArrayList<MidiDevice>();
	static ArrayList<MidiDevice> synDevice = new ArrayList<MidiDevice>();
	
	private static Vector<ModView> modulators = new Vector<ModView>();
	private static Vector<ModController> controllers = new Vector<ModController>();
	public static ArrayList<MidiDevice> inDevices = null;
	public static ArrayList<MidiDevice> outDevices = null;
	
	public MIDIDispatcher()
	{
		MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
		MidiDevice device = null;
	     for (int i = 0; i < infos.length; i++) 
	     {
	            try 
	            {
	            	device = MidiSystem.getMidiDevice(infos[i]);
	            	midiDevices.add(device);
	            	if (!(device instanceof Sequencer) && !(device instanceof Synthesizer)) 
		        	{
		            	if (device.getMaxReceivers() != 0) outDevice.add(device);
		            	if (device.getMaxTransmitters() != 0) inDevice.add(device);
		        	}
	            	else	// Device is either a Sequencer or a Synthesizer
	            	{
	            		if (device instanceof Sequencer) seqDevice.add(device);
	            		if (device instanceof Synthesizer) synDevice.add(device);
	            	}
				} 
	            catch (MidiUnavailableException e) 
	            {
	            	System.out.println("MIDI device " + device.getDeviceInfo().getName() + "is already reserved by another application.");
	            }
	     }
	     
	     // Show all devices separated by type
	    Iterator<MidiDevice> it;
	    System.out.println("\nMidi IN devices:");
	    it = inDevice.iterator();
	    while (it.hasNext()) 
	    {
	    	MidiDevice dev = it.next();
	    	String name = dev.getDeviceInfo().getName();
	    	int maxReceivers = dev.getMaxReceivers();
	    	int maxTransmitters = dev.getMaxTransmitters();
	    	System.out.println(name + ", receivers = " + maxReceivers + ", transmitters = " + maxTransmitters);
	    }
	    
	    System.out.println("\nMidi OUT devices:");
	    it = outDevice.iterator();
	    while (it.hasNext())
	    {
	    	MidiDevice dev = it.next();
		    String name = dev.getDeviceInfo().getName();
	    	int maxReceivers = dev.getMaxReceivers();
	    	int maxTransmitters = dev.getMaxTransmitters();
	    	System.out.println(name + ", receivers = " + maxReceivers + ", transmitters = " + maxTransmitters);
	    }
	    
	    System.out.println("\nSequencers:");
	    it = seqDevice.iterator();
	    while (it.hasNext())
	    {
	    	MidiDevice dev = it.next();
		    String name = dev.getDeviceInfo().getName();
	    	int maxReceivers = dev.getMaxReceivers();
	    	int maxTransmitters = dev.getMaxTransmitters();
	    	System.out.println(name + ", receivers = " + maxReceivers + ", transmitters = " + maxTransmitters);
	    }
	    
	    System.out.println("\nSynthesizers:");
	    it = synDevice.iterator();
	    while (it.hasNext())
	    {
	    	MidiDevice dev = it.next();
		    String name = dev.getDeviceInfo().getName();
	    	int maxReceivers = dev.getMaxReceivers();
	    	int maxTransmitters = dev.getMaxTransmitters();
	    	System.out.println(name + ", receivers = " + maxReceivers + ", transmitters = " + maxTransmitters);
	    }
	}
	
	public MidiDevice getInDevice(int index)
	{
		return inDevice.get(index);
	}
	
	public static MidiDevice getOutDevice(int index)
	{
		return outDevice.get(index);
	}
	
	public ArrayList<MidiDevice> getInDevices()
	{
		return (ArrayList<MidiDevice>) inDevice.clone();
	}
	
	public ArrayList<MidiDevice> getOutDevices()
	{
		return (ArrayList<MidiDevice>) outDevice.clone();
	}
	
	public String[] getInDevicesNames()
	{
		String[] names = new String[inDevice.size()];
		for (int i = 0; i < inDevice.size(); i++)
	    {
		   names[i] = inDevice.get(i).getDeviceInfo().getName();
	    }
	    return names;
	}
	
	public String[] getOutDevicesNames()
	{
		String[] names = new String[outDevice.size()];
		for (int i = 0; i < outDevice.size(); i++)
	    {
		   names[i] = outDevice.get(i).getDeviceInfo().getName();
	    }
	    return names;
	}
	
	public String[] getSeqDevicesNames()
	{
		String[] names = new String[seqDevice.size()];
		for (int i = 0; i < seqDevice.size(); i++)
	    {
		   names[i] = seqDevice.get(i).getDeviceInfo().getName();
	    }
	    return names;
	}
	
	public String[] getSynDevicesNames()
	{
		String[] names = new String[synDevice.size()];
		for (int i = 0; i < synDevice.size(); i++)
	    {
		   names[i] = synDevice.get(i).getDeviceInfo().getName();
	    }
	    return names;
	}
	
	public static void addModulator(ModView modulator)
	{
		modulators.add(modulator);
	}
	
	public static void addController(ModController controller)
	{
		controllers.add(controller);
	}
	
	public static Vector<ModView> getModViews() { return modulators; }

	public static Vector<ModController> getModControllers() { return controllers; }
	
	public static void setModulatorsMIDIOutPort(MidiDevice outDevice)
	{
		Iterator<ModView> it = modulators.iterator();
		while (it.hasNext())
		{
			ModView view = it.next();
			try 
			{
				view.setMIDIReceiver(outDevice.getReceiver());
			} 
			catch (MidiUnavailableException e) 
			{
			}
		}
	}
}
