package utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;

public class FileIO 
{
	
	public static int storeBulkDump(String filename, MIDIBulk bulk)
	{
		FileOutputStream outStream = null;
		try 
		{
			outStream = new FileOutputStream(filename);
			byte[] dump = bulk.byteArray;
			for (int i = 0; i < dump.length; i++)
			{
				outStream.write(dump[i]);
			}
			outStream.close();
		} 
		catch (IOException e) { return 1; }
		return 0;
	}
	
	
	/*
	public static int storeBulkDump(String filename, MIDIBulk bulk)
	{
		FileOutputStream outStream = null;
		MIDIMessageAndTimestamp mat = null;
		try 
		{
			outStream = new FileOutputStream(filename);
			
			Iterator<MIDIMessageAndTimestamp> it = bulk.iterator();
			while (it.hasNext())
			{
				mat = (MIDIMessageAndTimestamp) it.next();
				MidiMessage midiMessage = mat.message;
				byte[] message = midiMessage.getMessage();
				outStream.write(message);
			}
			outStream.close();
		} 
		catch (IOException e) { return 1; }
		return 0;
	}
	*/
	/*
	public static int storeBulkDump(String filename, MIDIBulk bulk)
	{
		FileOutputStream outStream = null;
		MIDIMessageAndTimestamp mat = null;
		try 
		{
			outStream = new FileOutputStream(filename);
			
			Iterator<MIDIMessageAndTimestamp> it = bulk.iterator();
			while (it.hasNext())
			{
				mat = (MIDIMessageAndTimestamp) it.next();
				MidiMessage midiMessage = mat.message;
				byte[] message = midiMessage.getMessage();
				outStream.write(message);
			}
			outStream.close();
		} 
		catch (IOException e) { return 1; }
		return 0;
	}
	*/
	/*
	public static int storeBulkDump(String filename, MIDIBulk bulk)
	{
		ObjectOutputStream outStream = null;
		try 
		{
			outStream = new ObjectOutputStream(new FileOutputStream(filename));
			Iterator<MIDIMessageAndTimestamp> it = bulk.iterator();
			while (it.hasNext())
			{
				MIDIMessageAndTimestamp mat = (MIDIMessageAndTimestamp) it.next();
				outStream.writeObject(mat.message);
				outStream.writeObject(mat.timestamp);
			}
			outStream.close();
		} 
		catch (IOException e) { return 1; }
		return 0;
	}
	*/
	
	
	public static byte[] loadBulkDump(File fname)
	{
		String path = fname.getPath();
		File file = new File(path);
		
		if (!file.exists()) 
		{
			System.out.println("" + file +" does not exist.");
			return null;
		}
		
		
		Vector<Byte> in = new Vector<Byte>();
		FileInputStream inStream = null;
		byte b;
		try 
		{
			inStream = new FileInputStream( file );
			while ((b = (byte) inStream.read()) != -1)
			{
				in.add(b);
			}
			inStream.close();
		} 
		catch (IOException e) { System.out.println("IO Exception"); }
		byte[] byteArray = new byte[in.size()]; // Length of a Juno's bulk dump
		for (int j = 0; j < in.size(); j++) byteArray[j] = in.elementAt(j);
		return byteArray;
	}
	
	
	
}
