package main;

import gui.ModulatorsState;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Receiver;
import javax.sound.midi.SysexMessage;




// Translates incoming value changes in MIDI control changes
// or MIDI SysEx messages and sends them to arbitrary receivers
public class Modulator128View implements ActionListener, ModView, Constants
{
	private main.Modulator128Model model;
	private int position = 0;
	private Receiver receiver;
	private Byte byte8, byte9;
	
	public Modulator128View(Byte byte8) { this.byte8 = byte8; }
	
	@Override
	public void actionPerformed(ActionEvent e) 
	{
		if (model == null) return;
		if (receiver == null) return;
		
		if (e.getActionCommand() == "currentPosition")
		{
			ModulatorsState.storeLocations();
			
			// Encapsulate the new slider position in a MIDI Message
			// and send it directly to the receiver of the specified MIDI OUT device
			position = model.getCurrentPosition();
			byte9 = new Integer(position).byteValue();
			byte[] msg = { byte1, byte2, byte3, byte4, byte5, byte6, byte7, byte8, byte9};
			SysexMessage message = new SysexMessage();
	        try 
	        {
				message.setMessage(msg, 9);
				receiver.send(message, -1);
			} 
	        catch (InvalidMidiDataException e1) { System.out.println("Wrong MIDI bytes!");}
		}
	}
	
	public void setModel(main.Modulator128Model newModel)
	{
		model =  newModel;
		
		if (model != null)
		{
			// Register the view as listener for the model
			model.addActionListener(this);
		}
	}
	
	public main.Modulator128Model getModel()
	{
		return model;
	}
	
	public void setMIDIReceiver(Receiver receiver) 
	{ 
		this.receiver = receiver; 
	}
}
