package main;

import java.awt.event.*;
import java.util.*;


public class Modulator128Model
{
	private int defaultPosition;
	private int minPosition;
	private int maxPosition;
	private int currentPosition;
	private int MIDIChannel;
	
	// Utility field used by the event firing mechanism
	private ArrayList actionListenerList;

	public Modulator128Model(int range, int position)
	{
		defaultPosition = position;
		minPosition = 0;
		maxPosition = range;
	}
	
	
	public int getDefaultPosition() { return this.defaultPosition; }
	
	public void setDefaultPosition(int pos) 
	{ 
		this.defaultPosition = pos; 
		// Notify the listener for the change on default position
		processEvent(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "defaultPosition"));
	}
	public int getMinPosition() { return this.minPosition; }
	
	public void setMinPosition(int pos) 
	{ 
		this.minPosition = pos;
		// Notify the listener for the change on minimum position
		processEvent(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "minPosition"));
	}
	
	public int getMaxPosition() { return this.maxPosition; }
	
	public void setMaxPosition(int pos) 
	{ 
		this.maxPosition = pos;
		// Notify the listener for the change on maximum position
		processEvent(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "maxPosition"));
	}
	
	public int getCurrentPosition() { return this.currentPosition; }
	
	public void setCurrentPosition(int pos) 
	{ 
		this.currentPosition = pos;
		// Notify the listener for the change on current position
		processEvent(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "currentPosition"));
	}
	
	public int getMIDIChannel() { return this.MIDIChannel; }
	
	public void setMIDIChannel(int channel) 
	{ 
		this.MIDIChannel = channel; 
		// Notify the listener for the change on MIDI channel
		processEvent(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "MIDIChannel"));
	}
	
	// Register an action event listener
	public synchronized void addActionListener(ActionListener l)
	{
		ArrayList list = actionListenerList == null ? new ArrayList(2) : (ArrayList) actionListenerList.clone();
		if (!list.contains(l))
		{
			list.add(l);
			actionListenerList = list;
		}
	}
	
	public synchronized void removeActionListener(ActionListener l)
	{
		if (actionListenerList != null && actionListenerList.contains(l))
		{
			actionListenerList.remove(l);
		}
	}
	
	// Fire TickEvent
	private void processEvent(ActionEvent e)
	{
		ArrayList list;
		synchronized (this)
		{
			list = (ArrayList) actionListenerList.clone();
		}
		
		for (int i = 0; i < list.size(); i++)
		{
			ActionListener listener = (ActionListener) list.get(i);
			listener.actionPerformed(e);
		}
	}
}
