package main;

import java.util.Vector;

import utils.MIDIBulk;
import utils.MIDIMessageDecoder;
import utils.Tone;
import utils.ToneBank;

public class Librarian {
	static Vector<ToneBank> toneBanks = new Vector<ToneBank>();

	public static void addToneBank(byte[] dump) 
	{
		addToneBank(new MIDIBulk(dump));
	}

	public static void addToneBank(MIDIBulk dump) 
	{
		System.out.println("Add bank to Librarian");
		ToneBank bank = new ToneBank();

		for (int p = 0; p < 64; p++) 
		{
			byte[] data = MIDIMessageDecoder.getToneData(dump, p);
			bank.addTone(data);
		}
		toneBanks.add(bank);

		// Print tone names
		// String[] toneNames = bank.getToneNames();
		// for (int i = 0; i < bank.getToneCount(); i++)
		// System.out.println(""+toneNames[i]);
	}

	public static void removeToneBank(int pos)
	{
		if (toneBanks.size() >= pos) 
		{
			toneBanks.remove(pos);
		}
	}

	public static void getToneName(int p, int bankNum) 
	{
		Tone.getName(toneBanks.elementAt(bankNum), p);
	}

	public static void printToneNames(int bankNum) 
	{
		ToneBank bank = toneBanks.elementAt(bankNum);
		int length = bank.getToneCount();
		for (int i = 0; i < length; i++) 
		{
			Tone tone = bank.getTone(i);
			String toneName = tone.getName();
			System.out.println("" + toneName);
		}
	}
}
