package main;

import java.awt.Color;

public interface Constants 
{
	final int DEF_HOLD_NOTE = 69;
	final int DEF_VELOCITY = 64;
	final int CTRL = 0;
	final int SYSEX = 1;
	
	final int STD_SLIDER = 0;
	final int SWITCH = 1;
	final int FOUR_VALUES = 2;
	final int SIX_VALUES = 3;
	
	// Modulator groups
	final int DCO = 0;
	final int LFO = 1;
	final int HPF = 2;
	final int VCF = 3;
	final int VCA = 4;
	final int CHORUS = 5;
	final int ENV = 6;
	final int ENTRY = 7;
	final int BEND = 9;
	final int MODLEV = 10;
	final int KEYB = 11;
	
	
	// ...and their colors
	final Color BG_COL = new Color(10, 10, 17);
	final Color MODBORDER_COL = new Color(50, 50, 65);
	
	final Color ADM_COL = new Color(140, 140, 140);
	final Color DCO_COL = new Color(100, 20, 20);
	final Color LFO_COL = new Color(20, 70, 20);
	final Color HPF_COL = new Color(0, 40, 80);
	final Color VCF_COL = new Color(40, 40, 60);
	final Color VCA_COL = new Color(100, 50, 20);
	final Color CHORUS_COL = new Color(80, 80, 20);
	final Color ENV_COL = new Color(80, 20, 80);
	final Color ENTRY_COL = new Color(20, 80, 80);
	
	final int defaultVelocity = 96;
	
	final int BANKP = 0;
	final int BANKM = 1;
	
	final int envWidgetDefX = 830; // 470, 590
	final int envWidgetDefY = 230;
	final int libWidgetDefX = 990;
	final int libWidgetDefY = 680;
	
	// Juno2 System Exclusive Header + Preamble
	static Byte byte1 = new Integer(240).byteValue(); // F0 11110000 Exclusive Status
    static Byte byte2 = new Integer(65).byteValue();  // 41 01000001 Roland ID
    static Byte byte3 = new Integer(54).byteValue();  // 36 00110110 Operation Code (Individual Parameter)
    static Byte byte4 = new Integer(0).byteValue();   // 00 00000000 MIDI Channel (1-16)
    static Byte byte5 = new Integer(35).byteValue();  // 23 00100011 Format type JU1/JU2
    static Byte byte6 = new Integer(32).byteValue();  // 20 00100000 Level Number = 1
    static Byte byte7 = new Integer(1).byteValue();   // 01 00000001 Group Number
    static byte[] sysexPreamble = { byte1, byte2, byte3, byte4, byte5, byte6, byte7};
 
    static Byte startOfSysEx = new Integer(240).byteValue();
    static Byte endOfSysEx = new Integer(247).byteValue();
    
    
    final int COMPLETED = 0;
    final int RECEIVING = 1;
    final int BORED = 2;
    
    final int blockLength = 266;
}
