package gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

import javax.swing.JSlider;
import javax.swing.JViewport;

public class TransparentSlider extends JSlider 
{
	private SignalsViewport viewport;
	private MIDIModulator modulator;

	public TransparentSlider(SignalsViewport viewport, MIDIModulator modulator)
	{
		super();
		super.setOpaque(false);
		this.viewport = viewport;
		this.modulator = modulator;
	}
	
	
	public void paint(Graphics g)
	{
		Graphics2D g2 = (Graphics2D) g.create();
		if (!viewport.showSignals)
		{
			g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 1.0f)); 
		}
		else
		{
			if ((modulator != null) && (viewport.activeMod.equals(modulator)))
			{
				g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.85f)); 
			}
		}
		super.paint(g2);
		g2.dispose();
	}
	
	
}
