package gui;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;

import javax.swing.JPanel;

public class TransparentPanel extends JPanel
{
	private SignalsViewport viewport;
	private MIDIModulator modulator;

	public TransparentPanel(SignalsViewport viewport, MIDIModulator modulator, BorderLayout borderLayout)
	{
		super();
		this.setOpaque(false);
		this.viewport = viewport;
		this.modulator = modulator;
		super.setLayout(borderLayout);
	}
	
	
	public void paintComponent(Graphics g)
	{
		Graphics2D g2 = (Graphics2D) g;
		g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.85f)); 
		
		super.paintComponent(g2);
	}
	
	
	public void paint(Graphics g)
	{
		Graphics2D g2 = (Graphics2D) g;
		if (!viewport.showSignals)
		{
			g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 1.0f)); 
		}
		else
		{
			if (viewport.activeMod.equals(modulator))
			{
				g2.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.85f)); 
			}
		}
		//super.paint(g2);
		g2.dispose();
	}
	
}
