package gui;

import java.awt.BasicStroke;
import java.awt.Color;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;

import javax.swing.JComponent;
import javax.swing.JViewport;

import main.Constants;

public class SignalsViewport extends JViewport implements Constants
{
	private static final long serialVersionUID = -2043777262526933518L;
	public boolean showSignals = false;
	public MIDIModulator activeMod = null;
	private MovingPanel movingPanel;
	private Dimension screenSize;
	private int dcoX, dcoY;
	private int vcfX, vcfY;
	private int vcaX, vcaY;
	private int hpfX, hpfY;
	private int chorusX, chorusY;
	private int outputX, outputY;
	private int lfoX, lfoY;
	private int envX, envY;
	private int bendX, bendY;
	private int bandWidth, bandHeight;
	private int modLevX, modLevY;
	private int keybX, keybY;
	
	
	
	public SignalsViewport(MovingPanel movingPanel)
	{
		this.movingPanel = movingPanel;
		Toolkit toolkit = Toolkit.getDefaultToolkit();
		screenSize = toolkit.getScreenSize();
	}
	
	public void paintChildren(Graphics g)
	{
		Graphics2D g2 = (Graphics2D) g;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);	
		super.paintChildren(g2);
		
		if (!showSignals) return;
		//if (activeMod == null) return;
		
		// Color the whole background in dark blue
		Color alphablue = new Color(10, 10, 17, 242);
		g.setColor(alphablue);
		Rectangle wRect = g.getClipBounds();
		g.fillRect(wRect.x,(int) wRect.y, wRect.width, wRect.height);
		
		// Paint the signal flow dependent on the size of the upper viewport
		paintSignalFlow(g2, activeMod );
		
		if (activeMod != null) activeMod.repaint();
		
		
		/*
		// Repaint the current modulator
		//activeMod.repaint();
		// Paint the active modulator with transparency
		BufferedImage buf = new BufferedImage(activeMod.getWidth(), activeMod.getHeight(), BufferedImage.TYPE_INT_ARGB);
		Graphics2D bg = (Graphics2D) buf.getGraphics();
		bg.setComposite(AlphaComposite.getInstance(AlphaComposite.DST_OVER, 0.85f)); 
		activeMod.paint(bg);
		g2.drawImage(buf, activeMod.getX(), activeMod.getY(), null);
		*/
		
		/*
		// Paint all components that need to be permanently visible
		// Only paint the envelope view if an envelope modulator is adjusted
		HashSet<JComponent> visibleComp = movingPanel.getAlwaysVisibleComponents();
		Iterator<JComponent> it = visibleComp.iterator();
		while (it.hasNext()) 
		{
			JComponent comp = (JComponent) it.next();
			if (comp instanceof EnvelopeWidget)
			{
				if (activeMod instanceof MIDIModulator)
				{
					if (activeMod.getParameterName().startsWith("ENV"))
					{
						comp.repaint();
					}
				}
			}
		}
		*/
		//activeMod = null;
	}
	
	
	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D) g;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);	
		g.dispose();
	}
	
	
	public void setView(JComponent view)
	{
		view.setOpaque(true);
		super.setView(view);
	}
	
	public void togglePaintSignals(MIDIModulator mod)
	{
		showSignals = !showSignals;
		if (mod != null) this.activeMod = mod;
		repaint();
	}
	
	private void paintSignalFlow(Graphics2D g2, MIDIModulator mod)
	{	
		// Find a suitable arrangement of functional tone modifying and synthesizing blocks
		// dependent on the screen resolution
		Rectangle vBounds = this.getViewRect();
		int ox = getViewPosition().x;
		int oy = getViewPosition().y;
		int borderX = 10;
		int borderY = 10;
		int gapX = Math.max(35, movingPanel.getWidth()/53);
		int gapY = Math.max(35, movingPanel.getHeight()/32);
		Point modPos = mod.getLocation();
		bandWidth =  (int) (screenSize.width/6.56);
		bandHeight = (int) (movingPanel.getHeight()/10);	
		// Row 1
		dcoX = borderX+ (int) (0.5*bandWidth)+22;
		dcoY = borderY;
		hpfX = dcoX+bandWidth;
		hpfY = dcoY;
		vcfX = hpfX+bandWidth;
		vcfY = dcoY;
		vcaX = vcfX+bandWidth;
		vcaY = dcoY;
		chorusX = vcaX+bandWidth;
		chorusY = dcoY;
		//outputX = chorusX+bandWidth;
		outputX = chorusX+196;
		outputY = dcoY;
		bendX = dcoX;
		bendY = vBounds.height-bandHeight+80;
		modLevX = lfoX;
		modLevY = vBounds.height-bandHeight+80; 
		keybX = vcfX;
		keybY = vBounds.height-bandHeight+80;
		
		// Row 2
		lfoX = borderX;
		lfoY = borderY+bandHeight+gapY;
		envX = vcaX+145;
		envY = borderY+bandHeight+gapY+gapY;
		
		// CHORUS Block
		Point p = new Point(chorusX, chorusY);
		paintBlock(g2, p, CHORUS);
		
		// LFO Block
		Point p2 = new Point (lfoX, lfoY);
		paintBlock(g2, p2, LFO);
		
		// DCO Block
		Point p3 = new Point(dcoX, dcoY);
		paintBlock(g2, p3, DCO);
		
		// HPF Block
		Point p4 = new Point(hpfX, hpfY);
		paintBlock(g2, p4, HPF);
		
		
		// VCF Block
		Point p5 = new Point(vcfX, vcfY);
		paintBlock(g2, p5, VCF);
		
		
		// VCA Block
		Point p6 = new Point(vcaX, vcaY);
		paintBlock(g2, p6, VCA);
		
		// ENV Block
		Point p7 = new Point(envX, envY);
		paintBlock(g2, p7, ENV);
		
		// MODLEV Block
		Point p8 = new Point(modLevX, modLevY);
		paintBlock(g2, p8, MODLEV);
		
		// Bend Block
		Point p9 = new Point(bendX, bendY);
		paintBlock(g2, p9, BEND);
		
		// Keyboard
		Point p10 = new Point(keybX, keybY);
		paintBlock(g2, p10, KEYB);
		
		// Loudspeaker
		Point p11 = new Point(outputX, outputY);
		paintLoudspeaker(g2, p11);
		
		paintAudioArrows(g2);
		paintControlArrows(g2);
	}


	private void paintBlock(Graphics2D g2, Point p, int block)
	{
		String name = null;
		Color col = null;
		
		switch (block)
		{
			case LFO:		{ name = "LFO BLOCK";		col = LFO_COL;		break; }
			case HPF:		{ name = "HPF BLOCK"; 		col = HPF_COL;		break; }
			case ENV:		{ name = "ENV BLOCK";		col = ENV_COL; 		break; }
			case VCF:		{ name = "VCF BLOCK"; 		col = VCF_COL; 		break; }
			case VCA:		{ name = "VCA BLOCK"; 		col = VCA_COL; 		break; }
			case CHORUS:	{ name = "CHORUS BLOCK";	col = CHORUS_COL;	break; }
			case DCO:		{ name = "DCO BLOCK";		col = DCO_COL; 		break; }
			case BEND:		{ name = ""; 									break; }
			case MODLEV:	{ name = "";									break; }
			case KEYB:		{ name = "";									break; }
		}
		
		// Determine the font and the required width of the modulator
		Font font = new Font("Arial", Font.BOLD, 22);
		FontMetrics fontMetrics = this.getFontMetrics(font);
		int width = fontMetrics.stringWidth(name);
		
		if (block == MODLEV)
		{
			g2.setColor(new Color(200, 200, 235));
			g2.drawString("Modulation", p.x+17, p.y+20 );
			g2.drawString("Lever", p.x+17, p.y+46);
			return;
		}
		else if (block == BEND)
		{
			g2.setColor(new Color(200, 200, 235));
			g2.drawString("Pitch", p.x+40, p.y+20 );
			g2.drawString("Bender", p.x+40, p.y+46);
			return;
		}
		else if (block == KEYB)
		{
			g2.setColor(new Color(200, 200, 235));
			g2.drawString("Keyboard", p.x+10, p.y+20 );
			return;
		}
		
		// Paint background
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(new Color(25, 25, 40));
		g2.fillRect(p.x+2,p.y+2, width+10, 108);
		
		
		g2.setColor(new Color(200, 200, 235));
		g2.setFont(font);
		g2.drawString(name, (int) p.x+5, p.y+29);
		g2.setColor(col);
		g2.fillRect(p.x+2, p.y+38, width+7, 43);
		g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		
		Color doublebright = new Color( Math.min(255, 2*col.getRed()), Math.min(255, 2*col.getGreen()), Math.min(255, 2*col.getBlue()));
		g2.setColor(doublebright);
		//g2.drawLine(p.x+2, p.y+38, p.x+width+8, p.y+38);
		//g2.drawLine(p.x+2, p.y+81, p.x+width+8, p.y+81);
		
		// Paint border
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(MODBORDER_COL);
		g2.drawRoundRect(p.x, p.y, width+10, 110, 5, 5);
		
	}
	
	
	private void paintAudioArrows(Graphics2D g2)
	{
		g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(new Color(200, 200, 235));
		
		// between DCO and HPF
		g2.fillRect(dcoX+148, dcoY+55, hpfX-(dcoX+148)-14, 6);
		Polygon pol = new Polygon();
		pol.addPoint(hpfX-15, dcoY+50);
		pol.addPoint(hpfX-15, dcoY+66);
		pol.addPoint(hpfX-5, dcoY+58);
		g2.fillPolygon(pol);
		
		// between HPF and VCF
		g2.fillRect(hpfX+144, hpfY+55, vcfX-(hpfX+144)-14, 6);
		pol = new Polygon();
		pol.addPoint(vcfX-15, hpfY+50);
		pol.addPoint(vcfX-15, hpfY+66);
		pol.addPoint(vcfX-5, hpfY+58);
		g2.fillPolygon(pol);
		
		// between VCF and VCA
		g2.fillRect(vcfX+145, vcfY+55, vcaX-(vcfX+145)-14, 6);
		pol = new Polygon();
		pol.addPoint(vcaX-15, vcfY+50);
		pol.addPoint(vcaX-15, vcfY+66);
		pol.addPoint(vcaX-5, vcfY+58);
		g2.fillPolygon(pol);
		
		// between VCA and CHORUS
		g2.fillRect(vcaX+145, vcaY+55, chorusX-(vcaX+145)-14, 6);
		pol = new Polygon();
		pol.addPoint(chorusX-15, vcaY+50);
		pol.addPoint(chorusX-15, vcaY+66);
		pol.addPoint(chorusX-5, vcaY+58);
		g2.fillPolygon(pol);
	}
	
	private void paintControlArrows(Graphics2D g2)
	{
		g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		g2.setColor(new Color(200, 200, 235));
		
		// from LFO to DCO
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		g2.drawArc(dcoX+17, lfoY+35, 23, 23, 0, -90);
		g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		fillMyRect(g2, dcoX+39, vcfY+135, dcoX+42, lfoY+47);
		Polygon pol = new Polygon();
		pol.addPoint(dcoX+40, dcoY+118);
		pol.addPoint(dcoX+34, dcoY+135);
		pol.addPoint(dcoX+46, dcoY+135);
		g2.fillPolygon(pol);
		
		// from LFO to VCF
		fillMyRect(g2, lfoX+143, lfoY+57, vcfX+22, lfoY+60);
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		g2.drawArc(vcfX+10, lfoY+35, 23, 23, 0, -90);
		g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		fillMyRect(g2, vcfX+32, vcfY+135, vcfX+35, lfoY+47);
		pol = new Polygon();
		pol.addPoint(vcfX+33, vcfY+118);
		pol.addPoint(vcfX+27, dcoY+135);
		pol.addPoint(vcfX+40, dcoY+135);
		g2.fillPolygon(pol);
		
		// from Modulation Lever to LFO
		fillMyRect(g2, lfoX+64, lfoY+135, lfoX+67, modLevY-5);
		pol = new Polygon();
		pol.addPoint(lfoX+65, lfoY+118);
		pol.addPoint(lfoX+59, lfoY+135);
		pol.addPoint(lfoX+72, lfoY+135);
		g2.fillPolygon(pol);
		
		// from Pitch Bender to DCO
		fillMyRect(g2, dcoX+64, dcoY+135, dcoX+67, bendY-5);
		pol = new Polygon();
		pol.addPoint(dcoX+65, dcoY+118);
		pol.addPoint(dcoX+59, dcoY+135);
		pol.addPoint(dcoX+72, dcoY+135);
		g2.fillPolygon(pol);
		
		// from ENV to DCO
		fillMyRect(g2, dcoX+102, envY+61, envX-4, envY+64);
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		g2.drawArc(dcoX+91, envY+39, 23, 23, 180, 90);
		g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		fillMyRect(g2, dcoX+90, dcoY+135, dcoX+93, envY+51);
		pol = new Polygon();
		pol.addPoint(dcoX+91, dcoY+118);
		pol.addPoint(dcoX+85, dcoY+135);
		pol.addPoint(dcoX+98, dcoY+135);
		g2.fillPolygon(pol);
		
		// from ENV to VCF
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		g2.drawArc(vcfX+61, envY+39, 23, 23, 180, 90);
		g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		fillMyRect(g2, vcfX+60, vcfY+135, vcfX+63, envY+51);
		pol = new Polygon();
		pol.addPoint(vcfX+61, vcfY+118);
		pol.addPoint(vcfX+55, vcfY+135);
		pol.addPoint(vcfX+68, vcfY+135);
		g2.fillPolygon(pol);
		
		// from ENV to VCA
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		g2.drawArc(vcaX+81, envY+39, 23, 23, 180, 90);
		g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		fillMyRect(g2, vcaX+80, vcaY+135, vcaX+83, envY+51);
		pol = new Polygon();
		pol.addPoint(vcaX+81, vcaY+118);
		pol.addPoint(vcaX+75, vcaY+135);
		pol.addPoint(vcaX+88, vcaY+135);
		g2.fillPolygon(pol);
		
		// KEYB arcs
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		g2.drawArc(keybX+61, keybY-16, 23, 23, 180, -90);
		g2.drawArc(keybX+38, keybY-16, 23, 23, -360, 90);
		// from KEYB to ENV
		// 	Horizontal bar to ENV
		g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		fillMyRect(g2, keybX+72, keybY-17, envX+60, keybY-14);
		// 	arc
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		g2.drawArc(envX+48, keybY-39, 23, 23, 0, -90);
		// 	vertical bar to ENV
		fillMyRect(g2, envX+70, envY+131, envX+73, keybY-27);
		pol = new Polygon();
		pol.addPoint(envX+71, envY+118);
		pol.addPoint(envX+65, envY+135);
		pol.addPoint(envX+78, envY+135);
		g2.fillPolygon(pol);
		
		// from KEYB to DCO
		// 	Horizontal bar to DCO
		g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		fillMyRect(g2, dcoX+128, keybY-17, keybX+50, keybY-14);
		// 	arc
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		g2.drawArc(dcoX+120, keybY-39, 23, 23, 180, 90);
		// vertical bar to DCO
		fillMyRect(g2, dcoX+119, dcoY+135, dcoX+122, keybY-27);
		pol = new Polygon();
		pol.addPoint(dcoX+120, dcoY+118);
		pol.addPoint(dcoX+114, dcoY+135);
		pol.addPoint(dcoX+127, dcoY+135);
		g2.fillPolygon(pol);
	
		// from KEYB to VCA
		//	 	arc
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		g2.drawArc(vcaX+25, keybY-39, 23, 23, 0, -90);
		// vertical bar to VCA
		fillMyRect(g2, vcaX+47, vcaY+135, vcaX+50, keybY-27);
		pol = new Polygon();
		pol.addPoint(vcaX+48, vcaY+118);
		pol.addPoint(vcaX+42, vcaY+135);
		pol.addPoint(vcaX+55, vcaY+135);
		g2.fillPolygon(pol);
		
		// from KEYB to VCF
		//	 	arc
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_BUTT, BasicStroke.JOIN_MITER));
		g2.drawArc(vcfX+70, keybY-39, 23, 23, 0, -90);
		// vertical bar to VCF
		fillMyRect(g2, vcfX+92, vcfY+135, vcfX+95, keybY-27);
		pol = new Polygon();
		pol.addPoint(vcfX+93, vcfY+118);
		pol.addPoint(vcfX+87, vcfY+135);
		pol.addPoint(vcfX+100, vcfY+135);
		g2.fillPolygon(pol);
	}
	
	private void fillMyRect(Graphics2D g2, int x1, int y1, int x2 , int y2)
	{
		int width = x2-x1;
		int height = y2-y1;
		g2.fillRect(x1, y1, width, height);
	}
	
	
	private void paintLoudspeaker(Graphics2D g2, Point p)
	{
		int w = (int) (bandWidth/2.8);
		// Determine the font and the required width of the modulator
		Font font = new Font("Arial", Font.BOLD, 22);
		
		// Paint background
		g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(new Color(200, 200, 235));
		
		// Upper arrow
		g2.fillRect(p.x, p.y+35, w, 6);
		Polygon pol = new Polygon();
		pol.addPoint(p.x+w, p.y+30);
		pol.addPoint(p.x+w, p.y+47);
		pol.addPoint(p.x+w+10, p.y+38);
		g2.fillPolygon(pol);
		g2.drawString("R", p.x+w/2-11, p.y+26);
				
		// Lower arrow
		g2.fillRect(p.x, p.y+78, w, 6);
		pol = new Polygon();
		pol.addPoint(p.x+w, p.y+73);
		pol.addPoint(p.x+w, p.y+90);
		pol.addPoint(p.x+w+10, p.y+81);
		g2.fillPolygon(pol);
		g2.drawString("L", p.x+w/2-9, p.y+111);
				
		// Loudspeaker
		pol = new Polygon();
		pol.addPoint(p.x+w+17, p.y+44);
		pol.addPoint(p.x+w+36, p.y+44);
		pol.addPoint(p.x+w+67, p.y+15);
		pol.addPoint(p.x+w+67, p.y+104);
		pol.addPoint(p.x+w+36, p.y+75);
		pol.addPoint(p.x+w+17, p.y+75);
		g2.fillPolygon(pol);
		/*
		// Upper arrow
		g2.fillRect(p.x, p.y+35, 40, 6);
		Polygon pol = new Polygon();
		pol.addPoint(p.x+40, p.y+30);
		pol.addPoint(p.x+40, p.y+47);
		pol.addPoint(p.x+50, p.y+38);
		g2.fillPolygon(pol);
		g2.drawString("R", p.x+12, p.y+26);
		
		// Lower arrow
		g2.fillRect(p.x, p.y+78, 40, 6);
		pol = new Polygon();
		pol.addPoint(p.x+40, p.y+73);
		pol.addPoint(p.x+40, p.y+90);
		pol.addPoint(p.x+50, p.y+81);
		g2.fillPolygon(pol);
		g2.drawString("L", p.x+14, p.y+111);
		
		// Loudspeaker
		pol = new Polygon();
		pol.addPoint(p.x+57, p.y+44);
		pol.addPoint(p.x+76, p.y+44);
		pol.addPoint(p.x+107, p.y+15);
		pol.addPoint(p.x+107, p.y+104);
		pol.addPoint(p.x+76, p.y+75);
		pol.addPoint(p.x+57, p.y+75);
		g2.fillPolygon(pol);
		*/
	}
	
	/*
	private void paintBlock2(Graphics2D g2, Point p, int block)
	{
		String name = null;
		Color col = null;
		
		switch (block)
		{
			case LFO:		{ name = "LFO BLOCK";		col = LFO_COL;		break; }
			case HPF:		{ name = "HPF BLOCK"; 		col = HPF_COL;		break; }
			case ENV:		{ name = "ENV BLOCK";		col = ENV_COL; 		break; }
			case VCF:		{ name = "VCF BLOCK"; 		col = VCF_COL; 		break; }
			case VCA:		{ name = "VCA BLOCK"; 		col = VCA_COL; 		break; }
			case CHORUS:	{ name = "CHORUS BLOCK";	col = CHORUS_COL;	break; }
			case DCO:		{ name = "DCO BLOCK";		col = DCO_COL; 		break; }
			case BEND:		{ name = "BEND BLOCK";		col = ENTRY_COL;	break; }
		}
		
		// Paint background
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(new Color(25, 25, 40));
		g2.fillRect(p.x+2,p.y+2, 243, 140);
		
		Font font = new Font("Arial", Font.BOLD, 24);
		FontMetrics fontMetrics = this.getFontMetrics(font);
		g2.setColor(new Color(200, 200, 235));
		g2.setFont(font);
		
		g2.drawString(name, (int) p.x+9, p.y+33);
		g2.setColor(col);
		g2.fillRect(p.x+2, p.y+48, 240, 68);
		g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		
		Color doublebright = new Color( Math.min(255, 2*col.getRed()), Math.min(255, 2*col.getGreen()), Math.min(255, 2*col.getBlue()));
		g2.setColor(doublebright);
		//g2.drawRect(p.x+4, p.y+51, 236, 61);
		g2.drawLine(p.x+4, p.y+49, p.x+240, p.y+49);
		g2.drawLine(p.x+4, p.y+114, p.x+240, p.y+114);
		
		// Paint border
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(MODBORDER_COL);
		g2.drawRoundRect(p.x, p.y, 243, 143, 5, 5);
		
	}
	*/
	/*
	private void paintChorusBlock3(Graphics2D g2, Point p)
	{
		// Paint background
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(new Color(25, 25, 40));
		g2.fillRect(p.x+2,p.y+2, 243, 140);
		
		Font font = new Font("Arial", Font.BOLD, 28);
		FontMetrics fontMetrics = this.getFontMetrics(font);
		g2.setColor(new Color(200, 200, 235));
		g2.setFont(font);
		g2.drawString("DCO BLOCK", (int) p.x+8, p.y+32);
		g2.setColor(CHORUS_COL);
		//g2.fillRect(p.x+2, p.y+48, 240, 60);
		g2.fillRect(p.x+2, p.y+72, 240, 70);
		
		g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		Color doublebright = new Color( Math.min(255, 2*CHORUS_COL.getRed()), Math.min(255, 2*CHORUS_COL.getGreen()), Math.min(255, 2*CHORUS_COL.getBlue()));
		g2.setColor(doublebright);
		g2.drawLine(p.x+6, p.y+75, p.x+237, p.y+75);
		g2.drawLine(p.x+6, p.y+138, p.x+237, p.y+138);
		
		
		// Paint border
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(MODBORDER_COL);
		g2.drawRoundRect(p.x, p.y, 243, 143, 5, 5);	
	}
	*/
	
	/*
	private void paintLFOBlock2(Graphics2D g2, Point p)
	{
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(new Color(25, 25, 40));
		g2.fillRect(p.x+2,p.y+2, 243, 140);
		
		Font font = new Font("Arial", Font.BOLD, 22);
		FontMetrics fontMetrics = this.getFontMetrics(font);
		g2.setColor(new Color(200, 200, 235));
		g2.setFont(font);
		g2.drawString("LFO BLOCK", (int) p.x+7, p.y+27);
		g2.setColor(LFO_COL);
		g2.fillRect(p.x+2, p.y+116, 240, 28);
		
		// Draw overlapping rectangles
		g2.setStroke(new BasicStroke(2.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(new Color(25, 25, 40));
		g2.fillRect(p.x+39, p.y+56, 175, 40);
		g2.setColor(MODBORDER_COL);
		g2.drawRect(p.x+39, p.y+56, 175, 40);
		
		g2.setColor(new Color(25, 25, 40));
		g2.fillRect(p.x+34, p.y+51, 175, 40);
		g2.setColor(MODBORDER_COL);
		g2.drawRect(p.x+34, p.y+51, 175, 40);
		
		g2.setColor(new Color(25, 25, 40));
		g2.fillRect(p.x+29, p.y+46, 175, 40);
		g2.setColor(MODBORDER_COL);
		g2.drawRect(p.x+29, p.y+46, 175, 40);
		
		
		g2.setStroke(new BasicStroke(4.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(new Color(155, 155, 185));
		g2.fillRect(p.x+48, p.y+65, 140, 4);
		g2.fillOval(p.x+96, p.y+61, 12, 12);
		
		//g2.setColor(new Color(25, 25, 35));
		//g2.fillRect(p.x+27, p.y+50, 195, 40);
		//g2.setColor(new Color(165, 165, 205));
		//g2.drawRect(p.x+27, p.y+50, 195, 40);
		
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(MODBORDER_COL);
		g2.drawRoundRect(p.x, p.y, 243, 143, 5, 5);
	}
	*/
	
	/*
	private void paintChorusBlock2(Graphics2D g2, Point p)
	{
		// Paint background
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(new Color(25, 25, 40));
		g2.fillRect(p.x+2,p.y+2, 243, 140);
		
		Font font = new Font("Arial", Font.BOLD, 25);
		FontMetrics fontMetrics = this.getFontMetrics(font);
		g2.setColor(new Color(200, 200, 235));
		g2.setFont(font);
		g2.drawString("CHORUS BLOCK", (int) p.x+9, p.y+33);
		g2.setColor(CHORUS_COL);
		g2.fillRect(p.x+137, p.y+48, 105, 60);
		g2.setStroke(new BasicStroke(1.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		Color doublebright = new Color( Math.min(255, 2*CHORUS_COL.getRed()), Math.min(255, 2*CHORUS_COL.getGreen()), Math.min(255, 2*CHORUS_COL.getBlue()));
		g2.setColor(doublebright);
		g2.drawLine(p.x+140, p.y+51, p.x+140, p.y+104);
		g2.drawLine(p.x+140, p.y+104, p.x+237, p.y+77);
		g2.drawLine(p.x+237, p.y+77, p.x+140, p.y+51);
		
		// Paint border
		g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
		g2.setColor(MODBORDER_COL);
		g2.drawRoundRect(p.x, p.y, 243, 143, 5, 5);
		
	}
	*/
	
}
