package gui;


// This code portion was modified from one of the Sun/Oracle Java Sound API examples
// or from jsresources.org.

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;

import javax.sound.midi.Instrument;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

import main.Constants;


/**
     * Piano renders black & white keys and plays the notes for a MIDI 
     * channel.  
     */
    public class Piano extends JPanel implements MouseListener, Constants
    {

    	public JFrame controls;
    	static int holdNote = DEF_HOLD_NOTE;
        Vector blackKeys = new Vector();
        Key prevKey;
        final int kw = 30, kh = 148;
        
        final int PROGRAM = 192;
        final int SUSTAIN = 64;
        final int REVERB = 91;
        final int ON = 0, OFF = 1;
        final int NOTEON = 144;
        final int NOTEOFF = 128;
        ChannelData channels[];
        
        final Color jfcBlue = new Color(204, 204, 255);
        final Color pink = new Color(255, 175, 175);
        
        Vector keys = new Vector();
        Vector whiteKeys = new Vector();
        JTable table;
        public boolean record;
        Track track;
        long startTime;
        //RecordFrame recordFrame;
        static boolean setHold = false;
        int transpose;
        
        private static Receiver receiver;
        
        
        public Piano() 
        {
            setLayout(new BorderLayout());
            setBackground(BG_COL);
            setPreferredSize(new Dimension(42*kw, kh+1));
            setBorder(new EmptyBorder(10, 10, 10, 10)); 
            setCursor(new Cursor(Cursor.HAND_CURSOR));
            
            this.transpose = 24;     
            int whiteIDs[] = { 0, 2, 4, 5, 7, 9, 11 }; 
          
            for (int i = 0, x = 0; i < 6; i++) {
                for (int j = 0; j < 7; j++, x += kw) {
                    int keyNum = i * 12 + whiteIDs[j] + transpose;
                    whiteKeys.add(new Key(x, 0, kw, kh, keyNum));
                }
            }
            for (int i = 0, x = 0; i < 6; i++, x += kw) {
                int keyNum = i * 12 + transpose;
                blackKeys.add(new Key((x += kw)-4, 0, kw/2, kh/2, keyNum+1));
                blackKeys.add(new Key((x += kw)-4, 0, kw/2, kh/2, keyNum+3));
                x += kw;
                blackKeys.add(new Key((x += kw)-4, 0, kw/2, kh/2, keyNum+6));
                blackKeys.add(new Key((x += kw)-4, 0, kw/2, kh/2, keyNum+8));
                blackKeys.add(new Key((x += kw)-4, 0, kw/2, kh/2, keyNum+10));
            }
            keys.addAll(blackKeys);
            keys.addAll(whiteKeys);

            addMouseMotionListener(new MouseMotionAdapter() 
            {
                public void mouseMoved(MouseEvent e) 
                {
                    //if (mouseOverCB.isSelected()) 
                    {
                        Key key = getKey(e.getPoint());
                        if (prevKey != null && prevKey != key) 
                        {
                            prevKey.off();
                        } 
                        if (key != null && prevKey != key) 
                        {
                            key.on();
                        }
                        prevKey = key;
                        repaint();
                    }
                }
            });
            addMouseListener(this);
        }

        
        public static void setMIDIOutPort(MidiDevice outDevice)
        {
        	try 
        	{
				receiver = outDevice.getReceiver();
			} 
        	catch (MidiUnavailableException e) 
        	{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
        }
        
        
        public void mousePressed(MouseEvent e) 
        { 
        	
            prevKey = getKey(e.getPoint());
            if (prevKey != null) 
            {
                prevKey.on();
                noteOn(prevKey.kNum+transpose-24, defaultVelocity);
        		repaint();
            }
        }
        public void mouseReleased(MouseEvent e) 
        { 
            if (prevKey != null) 
            {
                prevKey.off();
                noteOff(prevKey.kNum+transpose-24, defaultVelocity);
                repaint();
            }
        }
        public void mouseExited(MouseEvent e) 
        { 
            if (prevKey != null) {
                prevKey.off();
                noteOff(prevKey.kNum+transpose-24, defaultVelocity);
                repaint();
                prevKey = null;
            }
        }
        
        public void mouseClicked(MouseEvent e) 
        { 
        	/*
        	if (e.getClickCount() == 2)
        	{
	        	 prevKey = getKey(e.getPoint());
	             if (prevKey != null) 
	             {
	                 holdNote = prevKey.kNum;
	                 
	                 
	                 try 
	                 {
						controls.setHoldKey(prevKey.kNum);
					 } 
	                 catch (InvalidMidiDataException e1) {}
	                 
	                 repaint();
	             }
        	}
        	else if (e.getClickCount() == 1)
        	{
        		
        	}
        	*/
        }
        
        public void mouseEntered(MouseEvent e) {}


        public Key getKey(Point point)
        {
            for (int i = 0; i < keys.size(); i++) 
            {
                if (((Key) keys.get(i)).contains(point)) 
                {
                    return (Key) keys.get(i);
                }
            }
            return null;
        }

        public void paint(Graphics g) 
        {
            Graphics2D g2 = (Graphics2D) g;
            Dimension d = getSize();

            g2.setBackground(getBackground());
            g2.clearRect(0, 0, d.width, d.height);

            g2.setColor(new Color(190, 190, 255));
            g2.fillRect(0, 0, 42*kw, kh);

            for (int i = 0; i < whiteKeys.size(); i++) 
            {
                Key key = (Key) whiteKeys.get(i);
                if (key.isNoteOn()) 
                {
                    g2.setColor(record ? pink : jfcBlue);
                    g2.fill(key);
                    
                 // Added
                    g2.setFont(new Font("Arial", Font.PLAIN, 18));
                    g2.setColor(new Color(15, 15, 20));
                    if (key.kNum+transpose-24 == 0) g2.drawString("C0", key.x+4, key.y+140);
                    if (key.kNum+transpose-24  == 12) g2.drawString("C1", key.x+4, key.y+140);
                    if (key.kNum+transpose-24 == 24) g2.drawString("C2", key.x+4, key.y+140);
                    if (key.kNum+transpose-24 == 36) g2.drawString("C3", key.x+4, key.y+140);
                    if (key.kNum+transpose-24 == 48) g2.drawString("C4", key.x+4, key.y+140);
                    if (key.kNum+transpose-24 == 60) g2.drawString("C5", key.x+4, key.y+140);
                    if (key.kNum+transpose-24 == 72) g2.drawString("C6", key.x+4, key.y+140);
                    if (key.kNum+transpose-24 == 84) g2.drawString("C7", key.x+4, key.y+140);
                    if (key.kNum+transpose-24 == 96) g2.drawString("C8", key.x+4, key.y+140);
                    
                }
                else if (key.kNum == holdNote)
                {
                	 //g2.setColor(jfcBlue.darker());
                     //g2.fill(key);
                }
                
                g2.setColor(new Color(0, 0, 20));
                g2.draw(key);
            }
            for (int i = 0; i < blackKeys.size(); i++) 
            {
                Key key = (Key) blackKeys.get(i);
                if (key.isNoteOn()) 
                {
                    g2.setColor(record ? pink : jfcBlue);
                    g2.fill(key);
                    //g2.setColor(Color.black);
                    g2.setColor(new Color(0, 0, 20));
                    g2.draw(key);
                } 
                else if (key.kNum == holdNote)
                {
                	g2.setColor(jfcBlue.darker());
                    g2.fill(key);
                    g2.setColor(Color.black);
                    g2.draw(key);
                }
                else 
                {
                    //g2.setColor(Color.black);
                	g2.setColor(new Color(0, 0, 20));
                    g2.fill(key);
                }
            }
        }
		
   
    
    /**
     * Black and white keys or notes on the piano.
     */
    class Key extends Rectangle 
    {
        int noteState = OFF;
        int kNum;
        boolean isSelected = false;
        
        public Key(int x, int y, int width, int height, int num) 
        {
            super(x, y, width, height);
            kNum = num;
            
        }
        public boolean isNoteOn() 
        {
            return noteState == ON;
        }
        
        public void on()
        {
            setNoteState(ON);
            /*
            if (record) {
                createShortEvent(NOTEON, kNum);
            }
            */
        }
        public void off()
        {
            setNoteState(OFF);
            /*
            if (record) {
                createShortEvent(NOTEOFF, kNum);
            }
            */
        }
        public void setNoteState(int state) 
        {
            noteState = state;
        }
    } // End class Key
    
    /**
     * Stores MidiChannel information.
     */
    class ChannelData 
    {

        MidiChannel channel;
        boolean solo, mono, mute, sustain;
        int velocity, pressure, bend, reverb;
        int row, col, num;
 
        public ChannelData(MidiChannel channel, int num) 
        {
            this.channel = channel;
            this.num = num;
            velocity = pressure = bend = reverb = 64;
        }

        /*
        public void setComponentStates() 
        {
            table.setRowSelectionInterval(row, row);
            table.setColumnSelectionInterval(col, col);

            soloCB.setSelected(solo);
            monoCB.setSelected(mono);
            muteCB.setSelected(mute);
            //sustCB.setSelected(sustain);

            JSlider slider[] = { veloS, presS, bendS, revbS };
            int v[] = { velocity, pressure, bend, reverb };
            for (int i = 0; i < slider.length; i++) 
            {
                TitledBorder tb = (TitledBorder) slider[i].getBorder();
                String s = tb.getTitle();
                tb.setTitle(s.substring(0, s.indexOf('=')+1)+s.valueOf(v[i]));
                slider[i].repaint();
            }
        }
        */
    } // End class ChannelData
    
    /**
     * given 120 bpm:
     *   (120 bpm) / (60 seconds per minute) = 2 beats per second
     *   2 / 1000 beats per millisecond
     *   (2 * resolution) ticks per second
     *   (2 * resolution)/1000 ticks per millisecond, or 
     *      (resolution / 500) ticks per millisecond
     *   ticks = milliseconds * resolution / 500
     */
    public void createShortEvent(int type, int num) 
    {
    	/*
        ShortMessage message = new ShortMessage();
        try {
            long millis = System.currentTimeMillis() - startTime;
            long tick = millis * sequence.getResolution() / 500;
           // message.setMessage(type+cc.num, num, cc.velocity); 
            MidiEvent event = new MidiEvent(message, tick);
            track.add(event);
        } catch (Exception ex) { ex.printStackTrace(); }
        */
    }
    
    public void noteOn(int key, int velocity)
	{
		ShortMessage noteOn = new ShortMessage();
		try
		{
			noteOn.setMessage(ShortMessage.NOTE_ON, key, velocity);
			receiver.send(noteOn, -1);
		} 
		catch (InvalidMidiDataException e) {}
		catch (NullPointerException n) {};
	}
	
	public void noteOff(int key, int velocity)
	{
		if (setHold) return;
		ShortMessage noteOff = new ShortMessage();
		try 
		{
			noteOff.setMessage(ShortMessage.NOTE_OFF, key, velocity);
			receiver.send(noteOff, -1);
		} 
		catch (InvalidMidiDataException e) {}
		catch (NullPointerException n) {};
	}
   
	public static void setHoldNote(boolean state) { setHold = state; };
	
	public void setTransposition(int transposition)
	{
		this.transpose = transposition;
		repaint();
	}
}


