package gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;

import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;


public class MyTableCellRenderer extends JTextArea implements TableCellRenderer {
    private static final long serialVersionUID = 1L;

    public MyTableCellRenderer() 
    {
        setLineWrap(false);
        setWrapStyleWord(false);
        //setMargin(new Insets(0, 10, 0, 10));
        setBorder(null);
        setFont(new Font("Arial", Font.PLAIN, 20));
        setColumns(18);
        //LinePainter painter = new LinePainter(this);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) 
    {
        setText((String)value);
        setSize(table.getColumnModel().getColumn(column).getWidth(),getPreferredSize().height+10);
        
        
        if (isSelected)
        {
            //setBackground(new Color(40, 40, 90));
            //setForeground(new Color(180, 180, 240));
            //setBorder(new LineBorder(new Color(90, 90, 120), 1));
        }
        else
        {
            setBackground(table.getBackground());
            setForeground(table.getForeground());
            //setBorder(new LineBorder(table.getBackground(), 1));
        }
        return this;
    }
    
    public void paintComponent(Graphics g)
    {
    	Graphics2D g2 = (Graphics2D) g;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		super.paintComponent(g);
    }
}
