package gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;

import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;

import main.Constants;

public class MyDefaultTableHeaderCellRenderer extends DefaultTableCellRenderer implements Constants
{

    public MyDefaultTableHeaderCellRenderer() 
    {
        setHorizontalAlignment(LEFT);
        setHorizontalTextPosition(LEFT);
        setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) 
    {
        super.getTableCellRendererComponent(table, value,isSelected, hasFocus, row, column);
        if(table.isColumnSelected(column)) 
        {
        	
        } 
        else 
        {
        	//this.setBackground(new Color(25, 25, 40));
        }
        
        setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setFont(new Font("Arial", Font.BOLD, 22));
        this.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
        return this;
    }

}