package gui;

import java.awt.*;  
import java.awt.event.*;  
import java.awt.geom.Area;
import java.util.*;  
import javax.swing.*;  

import main.Constants;
import main.ModController;
   
public class MovingPanel extends JPanel implements MouseListener, MouseMotionListener, Constants  
{  
	HashSet<JComponent> movables = new HashSet<JComponent>(10);  
	HashSet<JComponent> components = new HashSet<JComponent>(10); 
	HashSet<JComponent> alwaysVisible = new HashSet<JComponent>(10);
	
	private Dimension dims; 
	private Point start_drag;
	private Point start_loc;
	private Point new_location;
	private Insets insets = this.getInsets();
	private boolean mouseOverMidiMod = false;
	private Object clickedComponent;  
	private boolean foundIntersection = false;
	private boolean isDragging = false;
	
	
	public MovingPanel(int width, int height)  
	{  
		this.setLayout(null);  
		this.dims = new Dimension(width, height);
	}  
	  
	public void addMovableComponent(JComponent comp, int x, int y)  
	{  
		movables.add(comp);  
		components.add(comp);
		comp.addMouseMotionListener(this);  
		comp.addMouseListener(this);  
		super.add(comp);  
		Insets insets = this.getInsets();  
		comp.setBounds(x + insets.left, y + insets.top, comp.getMinimumSize().width, comp.getMinimumSize().height);  
	}  
	  
	public void addAlwaysVisibleComponent(JComponent comp, int x, int y)  
	{  
		alwaysVisible.add(comp);
		movables.add(comp);
		components.add(comp);
		comp.addMouseMotionListener(this);  
		comp.addMouseListener(this);  
		super.add(comp);  
		Insets insets = this.getInsets();  
		comp.setBounds(x + insets.left, y + insets.top, comp.getMinimumSize().width, comp.getMinimumSize().height);  
	}  
	
	public void mouseDragged(MouseEvent me)  
	{  
		isDragging = true;
		if (mouseOverMidiMod) return;
		
		JComponent o = (JComponent) me.getSource();  
		if ((movables.contains(o)) && (clickedComponent == o))
		{
			Point current = this.getScreenLocation(me);
			Point offset = new Point((int)current.getX()-(int)start_drag.getX(), (int)current.getY()-(int)start_drag.getY());
			int x = (int)(start_loc.getX()+offset.getX());
			int y = (int)(start_loc.getY()+offset.getY());
			new_location = new Point(x, y);
			o.setLocation(new_location);
		}
	}  
	  
	
	public void mouseMoved(MouseEvent e)  
	{  
	}  
	  
	public void mousePressed(MouseEvent e)   
	{  
		if (mouseOverMidiMod) return;
		
		JPanel p = null;
		clickedComponent = e.getSource();  
		if (clickedComponent == null) return;
		if (clickedComponent instanceof JPanel)
		{
			p = (JPanel) clickedComponent;
		}
		
		this.start_drag = this.getScreenLocation(e);
		this.start_loc = p.getLocation();
	}  
	
	public void mouseReleased(MouseEvent e)   
	{  
		isDragging = false;
		
		if (mouseOverMidiMod) return;
		
		if ((new_location == null) || (e.getLocationOnScreen().equals(start_drag))) return;
		JComponent o = (JComponent) e.getSource();  
		if ((movables.contains(o)) && (clickedComponent == o))
		{
			int x = new_location.x;
			int y = new_location.y;
			if (o instanceof JPanel)
			{
				// Move component to its initial location if it now intersects with another component
				foundIntersection = false;
				Iterator<JComponent> it = components.iterator();
				while (it.hasNext())
				{
					JComponent component = (JComponent) it.next();
					Rectangle bounds = component.getBounds();
					Point newLocation = (new Point( Math.min(Math.max(insets.left, 10*(x/10)), 
							getWidth()-insets.right-o.getWidth()), Math.min(Math.max(insets.top, 10*(y/10)), getHeight()-insets.bottom-o.getHeight())));
					int width = o.getWidth();
					int height = o.getHeight();
					Rectangle destinationBounds = new Rectangle(newLocation.x, newLocation.y, width, height);
					if (bounds.intersects(destinationBounds)) // Component overlaps another component
					{
						if (!component.equals(o)) // Avoid comparing the component to itself
						{
							o.setLocation(start_loc.x, start_loc.y);
							foundIntersection = true;
						}
					}
				}	
				
				if (!foundIntersection)
				{
					// Component does not overlap another component
					o.setLocation(new Point( Math.min(Math.max(insets.left, 10*(x/10)), 
					getWidth()-insets.right-o.getWidth()), Math.min(Math.max(insets.top, 10*(y/10)), getHeight()-insets.bottom-o.getHeight())));
				}
			}
		}
		clickedComponent = null;  
	}  
	   
	public void mouseClicked(MouseEvent e) {  }  
	
	public void mouseEntered(MouseEvent e)
	{
	}  

	public void mouseExited(MouseEvent e)   
	{
	}   
	

	
	private Point getScreenLocation(MouseEvent e)
	{
		JPanel p = null;
		Point cursor = e.getPoint();
		Object o = e.getSource();
		if (o instanceof JPanel)
		{
			p = (JPanel) o;
			Point target_location = p.getLocationOnScreen();
			return new Point((int)(target_location.getX()+cursor.getX()), (int)(target_location.getY()+cursor.getY()));
		}
		return null;
	}
	
	
	public void paint(Graphics g)
	{
		Graphics2D g2 = (Graphics2D) g;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		super.paint(g2);
	}
	
	
	public boolean isMouseDragging() { return this.isDragging; }
	public HashSet<JComponent> getAlwaysVisibleComponents()	{ return this.alwaysVisible; }
}  