package gui;

import java.awt.Point;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.JPanel;


public class ModulatorsState 
{
	private static Vector<MIDIModulator> modulators;
	private static Hashtable<String, Point> defLoc = new Hashtable<String, Point>();
	
	public ModulatorsState()
	{
		readDefaultLocations();
	}
	
	public static void storeLocations()
	{
		modulators = MIDIModulator.getModulators();
		if (modulators == null) return;
		
		Iterator<MIDIModulator> it = modulators.iterator();
		while (it.hasNext())
		{
			MIDIModulator modulator = it.next();
			JPanel panel = modulator.getPanel();
			Point loc = panel.getLocation();
			String name = modulator.getParameterName();
			//System.out.println(""+name+" is "+loc);
		}
	}

	public static void setDefaultLocations()
	{
		modulators = MIDIModulator.getModulators();
		if (modulators == null) return;
		
		Iterator<MIDIModulator> it = modulators.iterator();
		while (it.hasNext())
		{
			MIDIModulator modulator = it.next();
			JPanel panel = modulator.getPanel();
			String name = modulator.getParameterName();
			panel.setLocation( defLoc.get(name));
		}
	}
	

	private static void readDefaultLocations()
	{
		defLoc.put("VCF CUTOFF", new Point(1710,20));
		defLoc.put("VCF RESO", new Point(1960,20));
		defLoc.put("VCF LFO DEPTH", new Point(1710, 170));
		defLoc.put("VCF ENV DEPTH", new Point(1960, 170));
		defLoc.put("VCF ENV MODE", new Point(1990, 470));
		defLoc.put("VCF ATOUCH SENS", new Point(1960, 320));
		defLoc.put("VCF KEY FOLLOW", new Point(1710, 320));
		defLoc.put("LFO RATE", new Point(10, 430));
		defLoc.put("LFO DELAY", new Point(10, 580));
		defLoc.put("DCO RANGE", new Point(430, 160));
		defLoc.put("DCO LFO DEPTH", new Point(430, 310));
		defLoc.put("DCO ENV DEPTH", new Point(930, 310));
		defLoc.put("DCO ENV MODE", new Point(210, 10));
		defLoc.put("DCO ATOUCH SENS", new Point(430, 460));
		defLoc.put("DCO PULSE WF", new Point(930, 10));
		defLoc.put("DCO SAW WF", new Point(680, 10));
		defLoc.put("DCO SUBOSC WF", new Point(430, 10));
		defLoc.put("DCO SUBOSC LVL", new Point(930, 160));
		defLoc.put("DCO NOISE LVL", new Point(680, 160));
		defLoc.put("DCO PWM DEPTH", new Point(680, 310));
		defLoc.put("VCA LEVEL", new Point(2430, 20));
		defLoc.put("VCA ENV MODE", new Point(2430, 320));
		defLoc.put("VCA ATOUCH SENS", new Point(2430, 170));
		defLoc.put("CHORUS", new Point(2940, 20));
		defLoc.put("CHORUS RATE", new Point(2940, 250));
		defLoc.put("HPF CUTOFF FREQ", new Point(1330, 170));
		defLoc.put("ENV T1", new Point(2920, 910));
		defLoc.put("ENV T2", new Point(3160, 910));
		defLoc.put("ENV T3", new Point(3400, 910));
		defLoc.put("ENV T4", new Point(3520, 910));
		defLoc.put("ENV L1", new Point(2800, 910));
		defLoc.put("ENV L2", new Point(3040, 910));
		defLoc.put("ENV L3", new Point(3280, 910));
		defLoc.put("ENV KEY FOLLOW", new Point(3640, 910));
		defLoc.put("BEND RANGE", new Point(1330, 910));
	}
}