package gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Hashtable;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Modulator128Controller extends JPanel implements ChangeListener, main.ModController, MouseListener, MouseMotionListener
{
	private static final long serialVersionUID = 1L;
	private main.Modulator128Model model;
	private MIDIModulator modulator, prevModulator;
	private TransparentSlider slider;
	
	// Utility field used by the event firing mechanism
	private ArrayList actionListenerList;
	private EnvelopeWidget envWidget;
	private String parameterName;
	private MovingPanel movingPanel;
	private SignalsViewport flowVisualizer;
	
	
	public Modulator128Controller(String parameterName, MIDIModulator modulator, EnvelopeWidget envWidget, MovingPanel movingPanel, SignalsViewport viewport, int orientation, int range, int position, Hashtable<Integer, JLabel> labels)
	{
		this.flowVisualizer = viewport;
		this.modulator = modulator;
		this.envWidget = envWidget;
		this.parameterName = parameterName;
		this.movingPanel = movingPanel;
		this.setLayout(new BorderLayout());
		this.setCursor(new Cursor(Cursor.HAND_CURSOR));
		
		slider = new TransparentSlider(flowVisualizer, modulator);
		slider.addMouseListener(this);
		slider.setMinimum(0);
		slider.setMaximum(range-1);
		slider.setMajorTickSpacing(range-1);
		slider.setPaintTicks(false);
		slider.setOrientation(orientation);
		slider.setPaintLabels(true);
		slider.setForeground(new Color(190, 190, 220));
		slider.setPaintTrack(true);
		slider.setFont(new Font("Arial", Font.PLAIN, 22));
		slider.addMouseMotionListener(this);
		if (labels != null) slider.setLabelTable(labels);
		slider.setValue(position);
		slider.addChangeListener(this);
		if (orientation == JSlider.VERTICAL) slider.setPreferredSize(new Dimension(150, 200));
		else if (orientation == JSlider.HORIZONTAL) slider.setMinimumSize(new Dimension(240, 150));
		this.add(slider, BorderLayout.CENTER);
		
		this.setBorder(new EmptyBorder(5, 5, 5, 5));
		this.setOpaque(false);
		//this.setBackground(new Color(255, 255, 255));
		
		// Notify envWidget as soon as a slider is moved
		this.addActionListener(envWidget);
		processEvent(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, slider.getName()));
	}

	
	@Override
	public void stateChanged(ChangeEvent e) 
	{
		if (e.getSource() == slider)
		{	
			model.setCurrentPosition( slider.getValue());
			if (modulator != null)
			{	
				modulator.setValue(slider.getValue());
				processEvent(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, slider.getName()));
			}
		}
	}
	
	public void setModel(main.Modulator128Model newModel)
	{
		model = newModel;
	}
	
	public main.Modulator128Model getTheModel()
	{
		return model;
	}
	
	public void setModulator(MIDIModulator modulator) 
	{ 
		prevModulator = this.modulator;
		this.modulator = modulator; 
	}
	
	public JSlider getSlider() { return this.slider; }
	public String getParameterName() { return this.parameterName; }
	
	// Register an action event listener
	public synchronized void addActionListener(ActionListener l)
	{
		ArrayList list = actionListenerList == null ? new ArrayList(2) : (ArrayList) actionListenerList.clone();
		if (!list.contains(l))
		{
			list.add(l);
			actionListenerList = list;
		}
	}
		
	public synchronized void removeActionListener(ActionListener l)
	{
		if (actionListenerList != null && actionListenerList.contains(l))
		{
			actionListenerList.remove(l);
		}
	}
		
	// Fire TickEvent
	private void processEvent(ActionEvent e)
	{
		ArrayList list;
		synchronized (this)
		{
			list = (ArrayList) actionListenerList.clone();
		}
		
		for (int i = 0; i < list.size(); i++)
		{
			ActionListener listener = (ActionListener) list.get(i);
			listener.actionPerformed(e);
		}
	}
	
	public void mouseEntered(MouseEvent e)
	{
		// THIS IS VERY IMPORTANT; IF WE DO NOT REQUEST THE FOCUS, 
		// THE JCOMPONENT THAT HAD THE FOCUS UNTIL NOW GETS REPAINTED
		// THIS WOULD DESTROY THE EFFECT OF THE SIGNALS VIEWPORT
		if (!flowVisualizer.showSignals) requestFocusInWindow();
		//flowVisualizer.togglePaintSignals(modulator);
	}


	@Override
	public void mouseClicked(MouseEvent e) 
	{
	}


	@Override
	public void mouseExited(MouseEvent e) 
	{
		//flowVisualizer.togglePaintSignals(modulator);
	}


	@Override
	public void mousePressed(MouseEvent e) 
	{
		if (e.isMetaDown())
		{
			flowVisualizer.togglePaintSignals(modulator);
		}
	}


	@Override
	public void mouseReleased(MouseEvent e) 
	{
		if (e.isMetaDown())
		{
			//prevSlider = slider;
			modulator.repaint();
			flowVisualizer.togglePaintSignals(modulator);
		}
	}


	@Override
	public void mouseDragged(MouseEvent e) 
	{
		if (e.isMetaDown())
		{
			//System.out.println("Mouse dragged");
			//RepaintManager.currentManager(null).markCompletelyClean(modulator);
			//RepaintManager.currentManager(null).markCompletelyClean(slider);
			//RepaintManager.currentManager(null).markCompletelyClean(modulator.getValuePanel());
			
			
			//modulator.validate();
			//modulator.repaint();
			/*
			// Paint the active modulator with transparency
			BufferedImage buf = new BufferedImage(modulator.getWidth(), modulator.getHeight(), BufferedImage.TYPE_INT_ARGB);
			Graphics2D bg = (Graphics2D) buf.getGraphics();
			bg.setComposite(AlphaComposite.getInstance(AlphaComposite.DST_OVER, 0.7f)); 
			RepaintManager.currentManager(null).markCompletelyDirty(modulator);
			modulator.paintComponent(bg);
			RepaintManager.currentManager(null).markCompletelyClean(modulator);
			viewport.getGraphics().drawImage(buf, modulator.getX(), modulator.getY(), null);
			//RepaintManager.currentManager(null).markCompletelyDirty(modulator);
			 */
			 
		}
		
	}


	@Override
	public void mouseMoved(MouseEvent arg0) 
	{
	}
}
