package gui;


import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import utils.MIDIDispatcher;


public class MIDIPlugsViewController extends JDialog implements ListSelectionListener, ActionListener
{
	private static final long serialVersionUID = 1L;
	private main.MIDIPlugsModel model;
	private MIDIDispatcher midiDispatcher;
	private JPanel buttonPanel = new JPanel();
	private JPanel selectionPanel = new JPanel();
	private JButton ok = new JButton("OK");
	private JList<String> availableMIDIIns;
	private JList<String> availableMIDIOuts;
	private JScrollPane inputsScrollPane;
	private JScrollPane outputsScrollPane;
	private JPanel leftPanel;
	private JPanel rightPanel;
	private int[] inIndices, outIndices;
	
	public MIDIPlugsViewController()
	{
		this.setModal(false);
		this.setTitle("Reserve MIDI Ports");
		this.setLayout(new BorderLayout());
		this.setResizable(false);
		this.setAlwaysOnTop(true);
		this.requestFocus();
		this.setFocusTraversalKeysEnabled(false);
		this.setCursor(new Cursor(Cursor.HAND_CURSOR));
		buttonPanel.setLayout(new FlowLayout());
		buttonPanel.add(ok);
		ok.setFont(new Font("Arial", Font.PLAIN, 18));
		ok.addActionListener(this);
		
		inputsScrollPane = new JScrollPane();
		inputsScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
		leftPanel = new JPanel();
		leftPanel.setLayout(new BorderLayout());
		JLabel inLabel = new JLabel("From Roland Juno");
		inLabel.setFont(new Font("Arial", Font.PLAIN, 18));
		leftPanel.add(inLabel, BorderLayout.NORTH);
		leftPanel.add(inputsScrollPane, BorderLayout.CENTER);
		
		outputsScrollPane = new JScrollPane();
		outputsScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
		outputsScrollPane.setCursor(new Cursor(Cursor.HAND_CURSOR));
		rightPanel = new JPanel();
		rightPanel.setLayout(new BorderLayout());
		JLabel outLabel = new JLabel("To Roland aJuno");
		outLabel.setFont(new Font("Arial", Font.PLAIN, 18));
		rightPanel.add(outLabel, BorderLayout.NORTH);
		rightPanel.add(outputsScrollPane, BorderLayout.CENTER);
		selectionPanel.setBorder(new EmptyBorder(20, 10, 10, 10));
		selectionPanel.add(leftPanel, BorderLayout.WEST);
		selectionPanel.add(rightPanel, BorderLayout.EAST);
		
		this.add(selectionPanel, BorderLayout.CENTER);
		this.add(buttonPanel, BorderLayout.SOUTH);
		this.setPreferredSize(new Dimension(600, 330));
		this.pack();
		this.setVisible(false);
	}
	
	public void setModel(main.MIDIPlugsModel newModel)
	{
		model = newModel;
		
		if (model != null)
		{
			// Register the view as listener for the model
			model.addActionListener(this);
		}
	}
	
	public main.MIDIPlugsModel getModel()
	{
		return model;
	}

	public MIDIDispatcher getMIDIDispatcher() { return midiDispatcher; }
	
	public void setMIDIDispatcher(MIDIDispatcher dispatcher)
	{
		midiDispatcher = dispatcher;
		availableMIDIIns = new JList<String>(midiDispatcher.getInDevicesNames());
		availableMIDIIns.setFont(new Font("Arial", Font.PLAIN, 18));
		inputsScrollPane.setViewportView(availableMIDIIns);
		availableMIDIIns.addListSelectionListener(this);
		availableMIDIIns.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		inputsScrollPane.doLayout();
		availableMIDIOuts = new JList<String>(midiDispatcher.getOutDevicesNames());
		availableMIDIOuts.setFont(new Font("Arial", Font.PLAIN, 18));
		outputsScrollPane.setViewportView(availableMIDIOuts);
		availableMIDIOuts.addListSelectionListener(this);
		availableMIDIOuts.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		outputsScrollPane.doLayout();
	}

	@Override
	public void valueChanged(ListSelectionEvent e) 
	{
		if (e.getSource() == availableMIDIIns)
		{
			inIndices = availableMIDIIns.getSelectedIndices();
			//model.setReservedInDevice(indices[0]);
		}
		else if (e.getSource() == availableMIDIOuts)
		{
			outIndices = availableMIDIOuts.getSelectedIndices();
			//model.setReservedOutDevice(indices[0]);
		}
	}

	@Override
	public void actionPerformed(ActionEvent e) 
	{
		// OK button was clicked
		if (e.getSource() == ok)
		{
			if ((inIndices != null) && (inIndices.length != 0)) model.setReservedInDevice(inIndices[0]);
			if ((outIndices != null) && (outIndices.length != 0)) model.setReservedOutDevice(outIndices[0]);
			this.setVisible(false);
		}
		
		// To be implemented...
		// MIDIPlugsModel acknowledged MIDIPlugsViewController of a change
		/*
		if (model == null) return;
		if (e.getActionCommand() == "reservedInDevice")
		{
			//System.out.println("Reserved another MIDI input plug: update the MIDIPlugsView...");
		}
		else if (e.getActionCommand() == "reservedOutDevice")
		{
			//System.out.println("Reserved another MIDI output plug: update the MIDIPlugsView...");
		}
		*/
	}
}