package gui;


import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.RepaintManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

import utils.MIDIDispatcher;

import main.Constants;
import main.ModController;
import main.ModModel;
import main.ModView;
import main.Modulator128View;

public class MIDIModulator extends JPanel implements Constants
{
	private MovingPanel controlPanel;
	private ModModel model;
	private ModController controller;
	private ModView view;
	private JLabel valueLabel, leftLabel;
	private JPanel valuePanel;
	private Byte byte8;
	private static Vector<MIDIModulator> modulators = new Vector<MIDIModulator>();
	private String parameterName;
	private SignalsViewport viewport;
	
	public MIDIModulator(MovingPanel panel, EnvelopeWidget envWidget, SignalsViewport viewport, String parameterName, int type, int group, 
			int range, int orientation, int position, Integer byte8Int, Hashtable<Integer, JLabel> lables)
	{
		this.parameterName = parameterName;
		this.viewport = viewport;
		String shortName = parameterName.substring(3, parameterName.length());
		
		Color groupbgColor = new Color(25, 25, 25);
		Color groupfgColor = new Color(50, 50, 50);
		
		controlPanel = panel;
		this.setLayout(new BorderLayout());
		this.setCursor(new Cursor(Cursor.MOVE_CURSOR));
		JPanel parameterPanel = new JPanel(new BorderLayout());
		JLabel parameterNameLabel = new JLabel(parameterName, JLabel.CENTER);
		parameterNameLabel.setBorder(new EmptyBorder(4, 4 ,4 , 4)); 
		Font parameterNameFont = new Font("Arial", Font.BOLD, 22);
		FontMetrics fontMetrics = panel.getFontMetrics(parameterNameFont);
		parameterNameLabel.setForeground(new Color(200, 200, 235));
		parameterNameLabel.setFont(parameterNameFont);
		parameterPanel.add(parameterNameLabel, BorderLayout.CENTER);
		parameterPanel.setBackground(new Color(25, 25, 35));
		this.add(parameterPanel, BorderLayout.NORTH);
		Border customBorder = BorderFactory.createLineBorder(MODBORDER_COL, 3, true);
		this.setBorder(customBorder);
		this.setOpaque(true);
		
		
		if (orientation == JSlider.VERTICAL)
		{
			if (!parameterName.substring(0, 3).equals("ENV")) // The ENV sliders are allowed to be smaller
			{
				this.setMinimumSize(new Dimension((int) (Math.max(216, fontMetrics.stringWidth(parameterName)+28)), 226));
				this.setPreferredSize(new Dimension((int) (Math.max(216, fontMetrics.stringWidth(parameterName)+28)), 226));
			}
			else
			{
				this.setMinimumSize(new Dimension(116, 226));
				this.setPreferredSize(new Dimension(116, 226));
			}
		}
		else
		{
			this.setMinimumSize(new Dimension((int) (Math.max(246, fontMetrics.stringWidth(parameterName)+24)), 146));
			this.setPreferredSize(new Dimension((int) (Math.max(246, fontMetrics.stringWidth(parameterName)+2)), 146));
		}
		controlPanel.addMovableComponent(this, 0, 0);
		
		
		
		if 			(type == STD_SLIDER) 
		{
			controller = (gui.Modulator128Controller) new gui.Modulator128Controller(parameterName, this, envWidget, panel, viewport, orientation, range, position, lables);
			MIDIDispatcher.addController((ModController) controller); // The MIDI dispatcher maintains a list of all MIDI controllers
			main.Modulator128Model model = new main.Modulator128Model(range, position); // Min, Max
			main.Modulator128View view = new main.Modulator128View(new Integer(byte8Int).byteValue());
			view.setModel(model);
			MIDIDispatcher.addModulator((ModView) view); // The MIDI dispatcher maintains a list of all MIDI modulators
			gui.Modulator128Controller ccontroller = (gui.Modulator128Controller) controller;
			ccontroller.setModel(model);
			ccontroller.putClientProperty("JComponent.sizeVariant", "large");
			ccontroller.setPreferredSize(new Dimension(140, 200));
			ccontroller.setBorder(new EmptyBorder(14, 14, 14, 14)); 
			ccontroller.repaint();
		}
		
		this.add((Component) controller, BorderLayout.CENTER);
		
		if 		(group == DCO) { groupbgColor = Constants.DCO_COL; }
		else if (group == HPF) { groupbgColor = Constants.HPF_COL; }
		else if (group == VCF) { groupbgColor = Constants.VCF_COL;}
		else if (group == VCA) { groupbgColor = Constants.VCA_COL;}
		else if (group == CHORUS) { groupbgColor = Constants.CHORUS_COL;}
		else if (group == ENV) { groupbgColor = Constants.ENV_COL;}
		else if (group == LFO) { groupbgColor = Constants.LFO_COL;}
		else if (group == ENTRY) { groupbgColor = Constants.ENTRY_COL; }
		
		this.setBackground(new Color(25, 25, 35));
		
		Color doublebright = new Color( Math.min(255, 2*groupbgColor.getRed()), Math.min(255, 2*groupbgColor.getGreen()), Math.min(255, 2*groupbgColor.getBlue()));
		
		// Left label
		JLabel leftLabel = new JLabel("||", JLabel.CENTER);
		leftLabel.setForeground(doublebright);
		leftLabel.setBackground(groupbgColor);
		
		// Middle label
		valueLabel = new JLabel(new Integer(position).toString(), JLabel.CENTER);
		valueLabel.setForeground(new Color(200, 200, 220));
		valueLabel.setFont(new Font("Arial", Font.PLAIN, 22));
		
		// Right panel
		JLabel rightLabel = new JLabel("||", JLabel.CENTER);
		rightLabel.setForeground(doublebright);
		rightLabel.setBackground(groupbgColor);
		
		// Panel with the three labels
		valuePanel = new JPanel(new BorderLayout());
		valuePanel.setBackground(groupbgColor);
		valuePanel.setForeground(groupfgColor);
		valuePanel.add(leftLabel, BorderLayout.WEST);
		valuePanel.add(valueLabel, BorderLayout.CENTER);
		valuePanel.add(rightLabel, BorderLayout.EAST);
		
		this.add(valuePanel, BorderLayout.SOUTH);
		modulators.add(this);
	}
	
	
	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D) g;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
	}
	
	
	
	public void setValue(int value) 
	{
		if (valueLabel == null) return;
		valueLabel.setForeground(new Color(200, 200, 220));
		valueLabel.setText(new Integer(value).toString());
	}
	
	public JPanel getPanel() { return this; }
	public String getParameterName() { return this.parameterName; }
	public ModController getController() { return this.controller; }
	public JLabel getValueLabel() { return this.valueLabel; }
	public JPanel getValuePanel() { return this.valuePanel; }
	public static Vector<MIDIModulator> getModulators() { return modulators; }
}
