package gui;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Iterator;
import java.util.Vector;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;

import utils.DumpReceiver;
import utils.FileIO;
import utils.MIDIBulk;
import utils.MIDIMessageAndTimestamp;
import utils.MIDIMessageDecoder;

import main.Constants;
import main.MIDIPlugsModel;

// Singleton class that realizes a MIDI Receive dialog
public class MIDIBulkDumpDialog extends JDialog implements ActionListener, WindowListener, Constants
{
	private static final long serialVersionUID = 1L;
	JTextArea textArea = new JTextArea();
	JButton start = new JButton("Transmit");
	Thread listener;
	Transmitter  byteTransmitter;
	Receiver receiver;
	private static MIDIPlugsModel mpModel;
	public static Vector<MIDIMessageAndTimestamp> receivedMessages = new Vector<MIDIMessageAndTimestamp>();
	//public static HashMap<Long, MidiMessage> wholeDump = new HashMap<Long, MidiMessage>();
	private static JLabel messageLabel = new JLabel("", SwingConstants.CENTER);
	private static int state = BORED;
	private static MIDIBulkDumpDialog instance = null;
	
	
	public static MIDIBulkDumpDialog getInstance() 
	{
        if (instance == null) 
        {
            instance = new MIDIBulkDumpDialog();
        }
        return instance;
    }

	
	
	public MIDIBulkDumpDialog()
	{
		//this.setModal(true); // AVOID: Otherwise, the MIDI transmission fails!
		this.setTitle("Transmit Tone Bank to aJuno");
		this.setLayout(new BorderLayout());
		this.setResizable(false);
		this.setAlwaysOnTop(true);
		this.requestFocus();
		this.addWindowListener(this);
		this.setFocusTraversalKeysEnabled(false);
		this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		this.setCursor(new Cursor(Cursor.HAND_CURSOR));
		this.setPreferredSize(new Dimension(500, 300));
		this.pack();
		this.setVisible(false);
		textArea.setText("Hold 'Data Transfer', 'Write' and 'Bulk Load' on your Juno. The display should read 'Bulk Load MIDI.o'.");
		textArea.setFont(new Font("Arial", Font.PLAIN, 22));
		textArea.setLineWrap(true);
		
		messageLabel.setFont(new Font("Arial", Font.PLAIN, 18));
		messageLabel.setPreferredSize(new Dimension(250, 30));
		
		this.add(textArea, BorderLayout.NORTH);
		this.add(messageLabel, BorderLayout.CENTER);
		start.setFont(new Font("Arial", Font.PLAIN, 18));
		start.addActionListener(this);
		
		
		JPanel lowerPanel = new JPanel();
		lowerPanel.add(start);
		
		
		this.add(lowerPanel, BorderLayout.SOUTH);
		this.setVisible(true);
	}
	
	@Override
	public void actionPerformed(ActionEvent e) 
	{
		// Start button was clicked
		if (e.getSource() == start)
		{
			Thread thread = new Thread(new Sender());
			thread.run();
		}
	}
	
	private class Sender implements Runnable
	{
		public Sender()
		{
			MidiDevice outDevice = mpModel.getReservedOutDevice();
			if ((outDevice != null) && (outDevice.isOpen()))
			{
				try 
				{
					receiver = outDevice.getReceiver();
				} 
				catch (MidiUnavailableException e) 
				{
					outDevice.close();
				}
			}
		}
		
		@Override
		public void run()
		{
			if (MIDIMessageDecoder.bulkDumps.size() > 0)
			{
				MIDIBulk bulk = MIDIMessageDecoder.bulkDumps.get(0);
				bulk.getByteArray();
				// To be implemented...
				//receiver.send(message, timeStamp);
			}
			
			// The 16 SysEx messages have been sent; close this dialog
			instance.exit();
		}
	}
	
	
	public void setMIDIPlugsModel(MIDIPlugsModel model)
	{
		this.mpModel = model;
	}
	
	
	
	
	private void exit()
	{
		this.setVisible(false);
		if (receiver != null) { receiver.close(); receiver = null; }
	}
	
	
	
	public void windowClosed(WindowEvent arg0) 
	{
		exit();
	}
	@Override
	public void windowActivated(WindowEvent arg0) {}
	@Override
	public void windowClosing(WindowEvent arg0) {}
	@Override
	public void windowDeactivated(WindowEvent arg0) {}
	@Override
	public void windowDeiconified(WindowEvent arg0) {}
	@Override
	public void windowIconified(WindowEvent arg0) {}
	@Override
	public void windowOpened(WindowEvent arg0) {}
	
	
	public static synchronized void setState(int newState) { state = newState; }

}
