package gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.QuadCurve2D;
import java.io.File;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

import utils.FileIO;
import utils.MIDIMessageDecoder;

import main.Constants;
import main.ILoveMyJuno2;
import main.Librarian;
import main.MIDIPlugsModel;
import main.ModController;

public class LibrarianWidget extends JPanel implements Constants
{
	public MIDIBulkReceiveDialog receiveDialog = null;
	public MIDIBulkDumpDialog dumpDialog = null;
	private Point position;
	private MovingPanel panel;
	private JLabel valueLabel;
	private JTable table1, table2;
	private Color groupfgColor = new Color(50, 50, 50);
	private static LibraryView libView;
	JButton receiveBank = new JButton("Receive Bank");
	JButton transmitBank = new JButton("Transmit Bank");
	JButton loadBank = new JButton("Load Bank");
	JButton saveBank = new JButton("Save Bank");
	JButton copyToneRight = new JButton("< Copy");
	JButton copyToneLeft = new JButton("Copy >");
	JButton moveToneRight = new JButton("< Move");
	JButton moveToneLeft = new JButton("Move >");
	JButton deleteLeft = new JButton("Delete");
	JButton deleteRight = new JButton("Delete");
	JButton moveUpLeft = new JButton("Move Up");
	JButton moveUpRight = new JButton("Move Up");
	JButton moveDownLeft = new JButton("Move Down");
	JButton moveDownRight = new JButton("Move Down");
	JButton editLeft = new JButton("Edit");
	JButton editRight = new JButton("Edit");
	JButton saveLeft = new JButton("Save");
	JButton saveRight = new JButton("Save");
	
	public LibrarianWidget(MovingPanel panel, Point position, int width, int height)
	{
		this.panel = panel;
		this.position = position;
		
		setLayout(new BorderLayout());
		setCursor(new Cursor(Cursor.MOVE_CURSOR));
		JPanel parameterPanel = new JPanel(new BorderLayout());
		JLabel parameterNameLabel = new JLabel("LIBRARIAN");
		parameterNameLabel.setBorder(new EmptyBorder(4, 4 ,4 , 4)); 
		Font parameterNameFont = new Font("Arial", Font.BOLD, 22);
		FontMetrics fontMetrics = panel.getFontMetrics(parameterNameFont);
		parameterNameLabel.setForeground(new Color(200, 200, 235));
		parameterNameLabel.setFont(parameterNameFont);
		parameterPanel.add(parameterNameLabel, BorderLayout.CENTER);
		add(parameterPanel, BorderLayout.NORTH);
		Border customBorder = BorderFactory.createLineBorder(MODBORDER_COL, 3, true);
		setBorder(customBorder);
		setBackground(new Color(25, 25, 33));
		
		libView = new LibraryView(width, height);
		add((JComponent) libView, BorderLayout.CENTER);
		valueLabel = new JLabel(" ", JLabel.CENTER);
		valueLabel.setFont(new Font("Arial", Font.PLAIN, 22));
		valueLabel.setForeground(new Color(200, 200, 220));
		
		// Place the valueLabel between handles
		JPanel valuePanel = new JPanel(new BorderLayout());
		Color groupbgColor = Constants.ADM_COL;
		parameterPanel.setBackground(new Color(25, 25, 35));
		setForeground(groupbgColor);
				
		Color doublebright = new Color( Math.min(255, (int) (0.5*groupbgColor.getRed())), 
		Math.min(255, (int) (0.5*groupbgColor.getGreen())), Math.min(255, (int) (0.5*groupbgColor.getBlue())));
		valuePanel.setBackground(groupbgColor);
		valuePanel.setForeground(groupfgColor);
		JLabel leftLabel = new JLabel("||");
		leftLabel.setForeground(doublebright);
		valuePanel.add(leftLabel, BorderLayout.WEST);
		valuePanel.add(valueLabel, BorderLayout.CENTER);
		JLabel rightLabel = new JLabel("||");
		rightLabel.setForeground(doublebright);
		valuePanel.add(rightLabel, BorderLayout.EAST);
		add(valuePanel, BorderLayout.SOUTH);
		
		panel.addAlwaysVisibleComponent(this, position.x, position.y);
	}
	
	private class LibraryView extends JPanel implements ActionListener
	{	
		JPanel upperPanel = new JPanel();
		JPanel lowerPanel = new JPanel(new BorderLayout());
		JScrollPane leftScrollPane = new JScrollPane();
		JScrollPane rightScrollPane = new JScrollPane();
		JSplitPane splitPane;
		
		
		public LibraryView(int width, int height)
		{
			
			String[] columnNames = { "Tone", "Key 1", "Key 2", "Key 3"};
			Object[][] rowData = new Object[64][4];
			for (int i = 0; i < 64; i++)
			{
				rowData[i][0] = "-";
				rowData[i][1] = "-";
				rowData[i][2] = "-";
				rowData[i][3] = "-";
			}
			table1 = new JTable(rowData, columnNames);
			table1.setFont(new Font("Arial", Font.PLAIN, 20));
			table1.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
			table1.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			table1.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			table1.setForeground(new Color(180, 180, 235));
			table1.setBackground(new Color(25, 25, 35));
			table1.setSelectionForeground(new Color(25, 25, 35));
			table1.setSelectionBackground(new Color(180, 180, 235));
			table1.setRowHeight(34);
			//table1.setRowMargin(10);
			table1.setShowGrid(false);
			table1.setAutoCreateRowSorter(true);
			table1.setPreferredSize(new Dimension(600, 2400));
			table1.getTableHeader().setBackground(new Color(25, 25, 35));
			table1.getTableHeader().setForeground(new Color(180, 180, 235));
			table1.getTableHeader().setFont(new Font("Arial", Font.PLAIN, 22));
			table1.getTableHeader().setReorderingAllowed(false);
			table1.getTableHeader().setDefaultRenderer(new MyDefaultTableHeaderCellRenderer());
			table1.getColumnModel().setColumnSelectionAllowed(false);
			//table1.getColumnModel().setColumnMargin(10);
			table1.setAutoCreateColumnsFromModel(false);
			DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
			renderer.setHorizontalAlignment(SwingConstants.LEFT);
			table1.getColumn("Tone").setCellRenderer(renderer);
			//table1.getColumn("Tone").setCellRenderer(new MyTableCellRenderer());
			//table1.getColumn("Key 1").setCellRenderer(new MyTableCellRenderer());
			//table1.getColumn("Key 2").setCellRenderer(new MyTableCellRenderer());
			//table1.getColumn("Key 3").setCellRenderer(new MyTableCellRenderer());
			
			JTextField editArea = new JTextField();
			editArea.setFont(new Font("Arial", Font.PLAIN, 20));
			editArea.setBackground(new Color(25, 25, 35));
			editArea.setForeground(new Color(180, 180, 225));
			
			
			TableCellEditor editor = new DefaultCellEditor(editArea);
			TableColumn column = table1.getColumnModel().getColumn(0);
			column.setCellEditor(editor);
			table1.getColumnModel().getColumn(1).setCellEditor(editor);
			table1.getColumnModel().getColumn(2).setCellEditor(editor);
			table1.getColumnModel().getColumn(3).setCellEditor(editor);
			
			
			
			table2 = new JTable(rowData, columnNames);
			table2.setFont(new Font("Arial", Font.PLAIN, 20));
			table2.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
			table2.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
			table2.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			table2.setForeground(new Color(180, 180, 235));
			table2.setBackground(new Color(25, 25, 35));
			table2.setSelectionForeground(new Color(25, 25, 35));
			table2.setSelectionBackground(new Color(180, 180, 235));
			table2.setRowHeight(34);
			//table2.setRowMargin(10);
			table1.setAutoCreateColumnsFromModel(false);
			table2.setShowGrid(false);
			table2.setAutoCreateRowSorter(true);
			table2.setPreferredSize(new Dimension(600, 2400));
			table2.getTableHeader().setBackground(new Color(25, 25, 35));
			table2.getTableHeader().setForeground(new Color(180, 180, 235));
			table2.getTableHeader().setFont(new Font("Arial", Font.PLAIN, 22));
			table2.getTableHeader().setReorderingAllowed(false);
			table2.getTableHeader().setDefaultRenderer(new MyDefaultTableHeaderCellRenderer());
			table2.getColumnModel().setColumnSelectionAllowed(false);
			//table2.getColumnModel().setColumnMargin(10);
			DefaultTableCellRenderer renderer2 = new DefaultTableCellRenderer();
			renderer2.setHorizontalAlignment(SwingConstants.LEFT);
			table2.getColumn("Tone").setCellRenderer(renderer2);
			//table2.getColumn("Tone").setCellRenderer(new MyTableCellRenderer());
			//table2.getColumn("Key 1").setCellRenderer(new MyTableCellRenderer());
			//table2.getColumn("Key 2").setCellRenderer(new MyTableCellRenderer());
			//table2.getColumn("Key 3").setCellRenderer(new MyTableCellRenderer());
			
			editArea = new JTextField();
			editArea.setFont(new Font("Arial", Font.PLAIN, 20));
			editArea.setBackground(new Color(25, 25, 35));
			editArea.setForeground(new Color(180, 180, 225));
			editor = new DefaultCellEditor(editArea);
			column = table2.getColumnModel().getColumn(0);
			column.setCellEditor(editor);
			table2.getColumnModel().getColumn(1).setCellEditor(editor);
			table2.getColumnModel().getColumn(2).setCellEditor(editor);
			table2.getColumnModel().getColumn(3).setCellEditor(editor);
			
			
			this.setLayout(new BorderLayout());
			this.setBorder(new EmptyBorder(14, 14, 14, 14));
			this.setPreferredSize(new Dimension(width, height));
			this.setMinimumSize(new Dimension(width, height));
			this.setBackground(new Color(25, 25, 35));
			this.repaint();
			
			
			// Upper panel
			upperPanel.setPreferredSize(new Dimension(width, 50));
			upperPanel.setBackground(new Color(25, 25, 35));
						
			// Lower panel
			JPanel leftPanel = new JPanel();
			JPanel rightPanel = new JPanel();
			JPanel toneMoves = new JPanel(new BorderLayout());
			toneMoves.setPreferredSize(new Dimension(width, 25));
			
			moveToneRight.setFont(new Font("Arial", Font.PLAIN, 20));
			moveToneRight.setBackground(new Color(25, 25, 35));
			moveToneRight.setForeground(new Color(180, 180, 225));
			moveToneRight.addActionListener(this);
			copyToneRight.setFont(new Font("Arial", Font.PLAIN, 20));
			copyToneRight.setBackground(new Color(25, 25, 35));
			copyToneRight.setForeground(new Color(180, 180, 225));
			copyToneRight.addActionListener(this);
			deleteLeft.setFont(new Font("Arial", Font.PLAIN, 20));
			deleteLeft.setBackground(new Color(25, 25, 35));
			deleteLeft.setForeground(new Color(180, 180, 225));
			deleteLeft.addActionListener(this);
			moveToneLeft.setFont(new Font("Arial", Font.PLAIN, 20));
			moveToneLeft.setBackground(new Color(25, 25, 35));
			moveToneLeft.setForeground(new Color(180, 180, 225));
			moveToneLeft.addActionListener(this);
			copyToneLeft.setFont(new Font("Arial", Font.PLAIN, 20));
			copyToneLeft.setBackground(new Color(25, 25, 35));
			copyToneLeft.setForeground(new Color(180, 180, 225));
			copyToneLeft.addActionListener(this);
			deleteRight.setFont(new Font("Arial", Font.PLAIN, 20));
			deleteRight.setBackground(new Color(25, 25, 35));
			deleteRight.setForeground(new Color(180, 180, 225));
			deleteRight.addActionListener(this);
			moveUpLeft.setFont(new Font("Arial", Font.PLAIN, 20));
			moveUpLeft.setBackground(new Color(25, 25, 35));
			moveUpLeft.setForeground(new Color(180, 180, 225));
			moveUpLeft.addActionListener(this);
			moveDownLeft.setFont(new Font("Arial", Font.PLAIN, 20));
			moveDownLeft.setBackground(new Color(25, 25, 35));
			moveDownLeft.setForeground(new Color(180, 180, 225));
			moveDownLeft.addActionListener(this);
			moveUpRight.setFont(new Font("Arial", Font.PLAIN, 20));
			moveUpRight.setBackground(new Color(25, 25, 35));
			moveUpRight.setForeground(new Color(180, 180, 225));
			moveUpRight.addActionListener(this);
			moveDownRight.setFont(new Font("Arial", Font.PLAIN, 20));
			moveDownRight.setBackground(new Color(25, 25, 35));
			moveDownRight.setForeground(new Color(180, 180, 225));
			moveDownRight.addActionListener(this);
			saveLeft.setFont(new Font("Arial", Font.PLAIN, 20));
			saveLeft.setBackground(new Color(25, 25, 35));
			saveLeft.setForeground(new Color(180, 180, 225));
			saveLeft.addActionListener(this);
			saveRight.setFont(new Font("Arial", Font.PLAIN, 20));
			saveRight.setBackground(new Color(25, 25, 35));
			saveRight.setForeground(new Color(180, 180, 225));
			saveRight.addActionListener(this);
			
			GridLayout leftLayout = new GridLayout(3, 4);
			leftLayout.setHgap(5);
			leftLayout.setVgap(5);
			leftPanel.setLayout(leftLayout);
			leftPanel.add(moveUpLeft);
			leftPanel.add(moveToneLeft);
			leftPanel.add(copyToneLeft);
			
			leftPanel.add(moveDownLeft);
			leftPanel.add(saveLeft);
			leftPanel.add(deleteLeft);
			leftPanel.add(editLeft);
			
			leftPanel.setBackground(new Color(25, 25, 33));
			
			GridLayout rightLayout = new GridLayout(3, 4);
			rightLayout.setHgap(5);
			rightLayout.setVgap(5);
			rightPanel.setLayout(rightLayout);
			rightPanel.add(editRight);
			rightPanel.add(deleteRight);
			rightPanel.add(moveDownRight);
			rightPanel.add(moveUpRight);
			rightPanel.add(copyToneRight);
			rightPanel.add(saveRight);
			rightPanel.add(moveToneRight);
			rightPanel.setBackground(new Color(25, 25, 33));
			toneMoves.add(leftPanel, BorderLayout.WEST);
			toneMoves.add(rightPanel, BorderLayout.EAST);
			toneMoves.setBackground(new Color(25, 25, 33));
			
			JPanel bankPanel = new JPanel();
			bankPanel.add(receiveBank);
			bankPanel.add(transmitBank);
			bankPanel.add(loadBank);
			bankPanel.add(saveBank);
			bankPanel.setBackground(new Color(25, 25, 33));
			receiveBank.setFont(new Font("Arial", Font.PLAIN, 20));
			receiveBank.setBackground(new Color(25, 25, 35));
			receiveBank.setForeground(new Color(180, 180, 225));
			receiveBank.addActionListener(this);
			transmitBank.setFont(new Font("Arial", Font.PLAIN, 20));
			transmitBank.setBackground(new Color(25, 25, 35));
			transmitBank.setForeground(new Color(180, 180, 225));
			transmitBank.addActionListener(this);
			loadBank.setFont(new Font("Arial", Font.PLAIN, 20));
			loadBank.setBackground(new Color(25, 25, 35));
			loadBank.setForeground(new Color(180, 180, 225));
			loadBank.addActionListener(this);
			saveBank.setFont(new Font("Arial", Font.PLAIN, 20));
			saveBank.setBackground(new Color(25, 25, 35));
			saveBank.setForeground(new Color(180, 180, 225));
			saveBank.addActionListener(this);
			editLeft.setFont(new Font("Arial", Font.PLAIN, 20));
			editLeft.setBackground(new Color(25, 25, 35));
			editLeft.setForeground(new Color(180, 180, 225));
			editLeft.addActionListener(this);
			editRight.setFont(new Font("Arial", Font.PLAIN, 20));
			editRight.setBackground(new Color(25, 25, 35));
			editRight.setForeground(new Color(180, 180, 225));
			editRight.addActionListener(this);
			
			lowerPanel.setPreferredSize(new Dimension(width, 180));
			lowerPanel.setBackground(new Color(25, 25, 35));
			lowerPanel.add(Box.createRigidArea(new Dimension(0,10)));
			lowerPanel.add(toneMoves, BorderLayout.CENTER);
			lowerPanel.add(bankPanel, BorderLayout.SOUTH);
			
			// Left view
			leftScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			leftScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			leftScrollPane.setPreferredSize(new Dimension( (int)(0.5*width)-50, 800));
			leftScrollPane.getViewport().add(table1);
			leftScrollPane.getViewport().setBackground(new Color(25, 25, 35));
			//leftScrollPane.getViewport().setPreferredSize(new Dimension((int) (0.5*width-50), 1600));
			leftScrollPane.setMaximumSize(new Dimension( table1.getSize() ));
			leftScrollPane.getVerticalScrollBar().setCursor(new Cursor(Cursor.HAND_CURSOR));
			leftScrollPane.setBorder(new LineBorder(MODBORDER_COL, 3));
			
			// Right view
			rightScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			rightScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			rightScrollPane.setPreferredSize(new Dimension( (int)(0.5*width)-50, 800));
			rightScrollPane.getViewport().add(table2);
			rightScrollPane.getViewport().setBackground(new Color(25, 25, 35));
			rightScrollPane.getVerticalScrollBar().setCursor(new Cursor(Cursor.HAND_CURSOR));
			rightScrollPane.setBorder(new LineBorder(MODBORDER_COL, 3));
			
			splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, leftScrollPane, rightScrollPane);
			add(splitPane, BorderLayout.CENTER);
			add(upperPanel, BorderLayout.NORTH);
			add(lowerPanel, BorderLayout.SOUTH);
		}
		
		
		public void paintComponent(Graphics g)
		{
			Graphics2D g2 = (Graphics2D) g;
			g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
			super.paintComponent(g);
		}


		@Override
		public void actionPerformed(ActionEvent e) 
		{
			String actionCommand = e.getActionCommand();
			if ("Load Bank".equals(actionCommand))
			{
				JFileChooser fileChooser = new JFileChooser();
				fileChooser.setFont(new Font("Arial", Font.PLAIN, 22));
			    FileNameExtensionFilter filter = new FileNameExtensionFilter(
			        "Roland aJuno 1/2 System Exclusive Bulk Dump File (*.syx, *.sysex)", "syx", "sysex");
			    fileChooser.setFileFilter(filter);
			    int returnVal = fileChooser.showOpenDialog(this.getParent());
			    if(returnVal == JFileChooser.APPROVE_OPTION)
			    {
			    	File file = fileChooser.getSelectedFile();
			    	byte[] dump = FileIO.loadBulkDump( file );
			    	// Check whether the dump is valid
			    	if (MIDIMessageDecoder.decodeDump( dump ))
					{
						// The dump is valid; put it as the last entry into the librarian
			    		Librarian.addToneBank( dump);
					}
			    	else
			    	{
			    		// The dump is corrupt or is not of the desired format
			    		System.out.println("The Bulk Dump is corrupt - could not save it");
			    	}
			    }
			    else if (returnVal == JFileChooser.ERROR_OPTION)
			    {
			    	
			    	System.out.println("An error occurred while opening the file.");
			    }
			}
			if ("Receive Bank".equals(actionCommand))
			{
				if (receiveDialog != null) 
				{
					receiveDialog = null;
				}
				MIDIPlugsModel mpModel = ILoveMyJuno2.getMIDIPlugsModel();
				receiveDialog = MIDIBulkReceiveDialog.getInstance();
				receiveDialog.setMIDIPlugsModel(mpModel);
				receiveDialog.listen();
				receiveDialog.setLocation(200, 200);
				receiveDialog.setVisible(true);
			}
			else if ("Transmit Bank".equals(actionCommand))
			{
				MIDIPlugsModel mpModel = ILoveMyJuno2.getMIDIPlugsModel();
				dumpDialog = MIDIBulkDumpDialog.getInstance();
				dumpDialog.setMIDIPlugsModel(mpModel);
				dumpDialog.setLocation(200, 200);
				dumpDialog.setVisible(true);
				
			}
		}
	}
}
