package gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

import main.Constants;
import main.ModController;

public class EnvelopeWidget extends JPanel implements Constants, ActionListener
{
	private Point position;
	private MovingPanel panel;
	private SignalsViewport viewport;
	private JLabel valueLabel;
	private Color groupfgColor = new Color(50, 50, 50);
	private static EnvelopeView envView;
	public int envT1, envT2, envT3, envT4, envL1, envL2, envL3;
	
	public EnvelopeWidget(MovingPanel panel, SignalsViewport viewport, Point position, int width, int height)
	{
		this.panel = panel;
		this.viewport = viewport;
		this.position = position;
		this.setName("EnvelopeView");
		
		setLayout(new BorderLayout());
		setCursor(new Cursor(Cursor.MOVE_CURSOR));
		JPanel parameterPanel = new JPanel(new BorderLayout());
		JLabel parameterNameLabel = new JLabel("ENVELOPE VIEW");
		parameterNameLabel.setBorder(new EmptyBorder(4, 4 ,4 , 4)); 
		Font parameterNameFont = new Font("Arial", Font.BOLD, 22);
		FontMetrics fontMetrics = panel.getFontMetrics(parameterNameFont);
		parameterNameLabel.setForeground(new Color(200, 200, 235));
		parameterNameLabel.setFont(parameterNameFont);
		parameterPanel.add(parameterNameLabel, BorderLayout.CENTER);
		add(parameterPanel, BorderLayout.NORTH);
		Border customBorder = BorderFactory.createLineBorder(MODBORDER_COL, 3, true);
		setBorder(customBorder);
		setBackground(new Color(25, 25, 33));
		
		envView = new EnvelopeView(width, height);
		add((JComponent) envView, BorderLayout.CENTER);
		valueLabel = new JLabel(" ", JLabel.CENTER);
		valueLabel.setFont(new Font("Arial", Font.PLAIN, 22));
		valueLabel.setForeground(new Color(200, 200, 220));
		
		// Place the valueLabel between handles
		JPanel valuePanel = new JPanel(new BorderLayout());
		Color groupbgColor = Constants.ENV_COL;
		parameterPanel.setBackground(new Color(25, 25, 35));
		setForeground(groupbgColor);
				
		Color doublebright = new Color( Math.min(255, 2*groupbgColor.getRed()), Math.min(255, 2*groupbgColor.getGreen()), Math.min(255, 2*groupbgColor.getBlue()));
		valuePanel.setBackground(groupbgColor);
		valuePanel.setForeground(groupfgColor);
		JLabel leftLabel = new JLabel("||");
		leftLabel.setForeground(doublebright);
		valuePanel.add(leftLabel, BorderLayout.WEST);
		valuePanel.add(valueLabel, BorderLayout.CENTER);
		JLabel rightLabel = new JLabel("||");
		rightLabel.setForeground(doublebright);
		valuePanel.add(rightLabel, BorderLayout.EAST);
		add(valuePanel, BorderLayout.SOUTH);
		
		panel.addAlwaysVisibleComponent(this, position.x, position.y);
	}
	
	private class EnvelopeView extends JPanel
	{	
		public EnvelopeView(int width, int height)
		{
			this.setLayout(new BorderLayout());
			this.setBorder(new EmptyBorder(14, 14, 14, 14));
			this.setPreferredSize(new Dimension(width, height));
			this.setMinimumSize(new Dimension(width, height));
			this.repaint();
		}
		
		
		public void paintComponent(Graphics g)
		{
			Graphics2D g2 = (Graphics2D) g;
			g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
			super.paintComponent(g);
			
			g.setColor(new Color(25, 25, 33));
			g.fillRect(0,  0, getWidth(), getHeight());
			g.setFont(new Font("Arial", Font.PLAIN, 20));
			float[] dashPattern = { 5, 5, 5, 5 };
		    float[] dashPattern2 = { 5, 15, 5, 15 };
			int w = this.getWidth();
			int h = this.getHeight();
			int sx = (int) (0.02*w);
			int sy = (int) (0.8*h)+7;
			
			
			// T1, T2, T3, T4
			g2.setColor(new Color(200, 200, 235));
			int maxenv_y = Math.max(envL3, Math.max(envL1, envL2));
			// T1
			g2.setStroke(new BasicStroke(2.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND, 10, dashPattern2, 0));
			//g2.drawLine(sx+120, sy, sx+120, sy-maxenv_y-40+6);
			//g2.drawLine(sx+120+envT1, sy-maxenv_y-40+6, sx+120+envT1, sy-envL1);
			g2.setStroke(new BasicStroke(2.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
			g2.drawLine(sx+120, sy-maxenv_y-40, sx+120+envT1-3, sy-maxenv_y-40); // Horizontal line
			g2.drawLine(sx+120, sy-maxenv_y-40, sx+120+5, sy-maxenv_y-45); // Left Arrow
			g2.drawLine(sx+120, sy-maxenv_y-40, sx+120+5, sy-maxenv_y-35);
			g2.drawLine(sx+120+envT1-3, sy-maxenv_y-40, sx+120+envT1-5-3, sy-maxenv_y-45); // Right Arrow
			g2.drawLine(sx+120+envT1-3, sy-maxenv_y-40, sx+120+envT1-5-3, sy-maxenv_y-35);
			g2.drawString("T1", (int) (sx+120+0.5*envT1-12), sy-maxenv_y-46);
			// T2
			g2.setStroke(new BasicStroke(2.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND, 10, dashPattern2, 0));
			// First vertical line can be omitted
			g2.setStroke(new BasicStroke(2.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
			g2.drawLine(sx+120+envT1+3, sy-maxenv_y-40, sx+120+envT1+envT2-3, sy-maxenv_y-40); // Horizontal line
			g2.drawLine(sx+120+envT1+3, sy-maxenv_y-40, sx+envT1+120+5+3, sy-maxenv_y-45); // Left Arrow
			g2.drawLine(sx+120+envT1+3, sy-maxenv_y-40, sx+envT1+120+5+3, sy-maxenv_y-35);
			g2.drawLine(sx+120+envT1+envT2-3, sy-maxenv_y-40, sx+120+envT1+envT2-5-3, sy-maxenv_y-45); // Right Arrow
			g2.drawLine(sx+120+envT1+envT2-3, sy-maxenv_y-40, sx+120+envT1+envT2-5-3, sy-maxenv_y-35);
			g2.drawString("T2", (int) (sx+120+envT1+0.5*envT2-12), sy-maxenv_y-46);
			// T3
			g2.setStroke(new BasicStroke(2.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND, 10, dashPattern2, 0));
			// First vertical line can be omitted
			g2.setStroke(new BasicStroke(2.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
			g2.drawLine(sx+120+envT1+envT2+3, sy-maxenv_y-40, sx+120+envT1+envT2+envT3, sy-maxenv_y-40); // Horizontal line
			g2.drawLine(sx+120+envT1+envT2+3, sy-maxenv_y-40, sx+envT1+envT2+120+5+3, sy-maxenv_y-45); // Left Arrow
			g2.drawLine(sx+120+envT1+envT2+3, sy-maxenv_y-40, sx+envT1+envT2+120+5+3, sy-maxenv_y-35);
			g2.drawLine(sx+120+envT1+envT2+envT3, sy-maxenv_y-40, sx+120+envT1+envT2+envT3-5, sy-maxenv_y-45); // Right Arrow
			g2.drawLine(sx+120+envT1+envT2+envT3, sy-maxenv_y-40, sx+120+envT1+envT2+envT3-5, sy-maxenv_y-35);
			g2.drawString("T3", (int) (sx+120+envT1+envT2+0.5*envT3-12), sy-maxenv_y-46);
			// T4
			g2.setStroke(new BasicStroke(2.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND, 10, dashPattern2, 0));
			g2.setStroke(new BasicStroke(2.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
			g2.drawLine(sx+247+envT1+envT2+envT3, sy-maxenv_y-40, sx+247+envT1+envT2+envT3+envT4, sy-maxenv_y-40); // Horizontal line
			g2.drawLine(sx+247+envT1+envT2+envT3, sy-maxenv_y-40, sx+247+envT1+envT2+envT3+5, sy-maxenv_y-45); // Left Arrow
			g2.drawLine(sx+247+envT1+envT2+envT3, sy-maxenv_y-40, sx+247+envT1+envT2+envT3+5, sy-maxenv_y-35);
			g2.drawLine(sx+247+envT1+envT2+envT3+envT4, sy-maxenv_y-40, sx+247+envT1+envT2+envT3+envT4-5, sy-maxenv_y-45); // Right Arrow
			g2.drawLine(sx+247+envT1+envT2+envT3+envT4, sy-maxenv_y-40, sx+247+envT1+envT2+envT3+envT4-5, sy-maxenv_y-35);
			g2.drawString("T4", (int) (sx+247+envT1+envT2+envT3+0.5*envT4-12), sy-maxenv_y-46);
			// Vertical lines
			g2.setStroke(new BasicStroke(2.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND, 10, dashPattern2, 0));
			g2.setColor(MODBORDER_COL);
			g2.drawLine(sx+120, sy, sx+120, sy-maxenv_y-40+6);
			g2.drawLine(sx+120+envT1, sy-maxenv_y-40+6, sx+120+envT1, sy-envL1);
			g2.drawLine(sx+120+envT1+envT2, sy-maxenv_y-40+6, sx+120+envT1+envT2, sy-envL2);
			g2.drawLine(sx+120+envT1+envT2+envT3, sy-maxenv_y-40+6, sx+120+envT1+envT2+envT3, sy-envL3);
			g2.drawLine(sx+247+envT1+envT2+envT3, sy-maxenv_y-40+6, sx+247+envT1+envT2+envT3, sy-envL3);
			g2.drawLine(sx+247+envT1+envT2+envT3+envT4, sy-maxenv_y-40+6, sx+247+envT1+envT2+envT3+envT4, sy);
			
			// L1, L2, L3
			g.setColor(new Color(200, 200, 235));
			g2.setStroke(new BasicStroke(2.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
			// L1
			g2.drawLine(sx, sy-4, sx, sy-envL1+4-4);
			// Lower Arrow
			g2.drawLine(sx, sy-4, sx-5, sy-5-4);
			g2.drawLine(sx, sy-4, sx+5, sy-5-4);
			// Upper Arrow
			g2.drawLine(sx, sy-envL1, sx-5, sy-envL1+5);
			g2.drawLine(sx, sy-envL1, sx+5, sy-envL1+5);
			// L2
			g2.drawLine(sx+40, sy-4, sx+40, sy-envL2+4-4);
			// Lower Arrow
			g2.drawLine(sx+40, sy-4, sx+40-5, sy-5-4);
			g2.drawLine(sx+40, sy-4, sx+40+5, sy-5-4);
			// Upper Arrow
			g2.drawLine(sx+40, sy-envL2, sx+40-5, sy-envL2+5);
			g2.drawLine(sx+40, sy-envL2, sx+40+5, sy-envL2+5);
			// L3
			g2.drawLine(sx+80, sy-4, sx+80, sy-envL3+4-4);
			// Lower Arrow
			g2.drawLine(sx+80, sy-4, sx+80-5, sy-5-4);
			g2.drawLine(sx+80, sy-4, sx+80+5, sy-5-4);
			// Upper Arrow
			g2.drawLine(sx+80, sy-envL3, sx+80-5, sy-envL3+5);
			g2.drawLine(sx+80, sy-envL3, sx+80+5, sy-envL3+5);
			// Horizontal lines
			g2.setStroke(new BasicStroke(2.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND, 10, dashPattern2, 0));
			g2.setColor(MODBORDER_COL);
			g2.drawLine(sx+5, sy-envL1, sx+120+envT1-6, sy-envL1);
			g2.drawLine(sx+40+5, sy-envL2, sx+120+envT1+envT2-6, sy-envL2);
			g2.drawLine(sx+80+5, sy-envL3, sx+120+envT1+envT2+envT3-6, sy-envL3);
			// Text
			g2.setColor(new Color(200, 200, 235));
			g2.drawString("L1", sx+4, (int) (sy-0.5*envL1+6));
			g2.drawString("L2", sx+40+4, (int) (sy-0.5*envL2+6));
			g2.drawString("L3", sx+80+4, (int) (sy-0.5*envL3+6) );
			
			// Draw Graph
			g2.setColor(new Color(130, 130, 230));
			g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
			// Horizontal line up to "key on"
			g2.drawLine( sx, (int) sy, sx+120, sy);
			// Diagonal line to P1
			g2.drawLine( sx+120, sy, sx+120+envT1, sy-envL1);
			// Diagonal line to P2
			g2.drawLine( sx+120+envT1, sy-envL1, sx+120+envT1+envT2, sy-envL2);
			// Quadratic curve to P3
			double x1 = sx+120+envT1+envT2;
			double y1 = sy-envL2;
			double x2 = sx+120+envT1+envT2+envT3;
			double y2 = sy-envL3;
			double c1 = x1+0.1*(x2-x1);
			double c2 = y1+(y2-y1)/2;
			QuadCurve2D.Double curve = new QuadCurve2D.Double(x1, y1, c1, c2, x2, y2);
			g2.draw(curve);
			// Horizontal line up to "key off"
			g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND, 5, dashPattern, 0));
			g2.drawLine( sx+120+envT1+envT2+envT3, sy-envL3, sx+247+envT1+envT2+envT3, sy-envL3);
			g2.setStroke(new BasicStroke(3.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
			// Quadratic curve to P4
			x1 = sx+245+envT1+envT2+envT3;
			y1 = sy-envL3;
			x2 = sx+245+envT1+envT2+envT3+envT4;
			y2 = sy;
			c1 = x1+0.1*(x2-x1);
			c2 = y1+(y2-y1)/2;
			curve = new QuadCurve2D.Double(x1, y1, c1, c2, x2, y2);
			g2.draw(curve);
			// Horizontal line
			g2.drawLine( sx+247+envT1+envT2+envT3+envT4, sy, sx+247+envT1+envT2+envT3+envT4+40, sy);
			
			
			// Draw bullets
			// P1
			int r = (int) (w/150);
			g2.fillOval( sx+120+envT1-r, sy-envL1-r, 2*r, 2*r);
			// P2
			g2.fillOval( sx+120+envT1+envT2-r, sy-envL2-r, 2*r, 2*r);
			// P3
			g2.fillOval( sx+120+envT1+envT2+envT3-r, sy-envL3-r, 2*r, 2*r);
		
		
			// Key On, Off
			g2.setColor(new Color(200, 200, 235));
			g2.setStroke(new BasicStroke(2.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND));
			g2.drawLine( sx+120, sy-6, sx+120, sy+6);
			g2.drawLine( sx+247+envT1+envT2+envT3, sy-6, sx+247+envT1+envT2+envT3, sy+6);
			g2.setColor(new Color(200, 200, 200));
			g2.drawString("Key On", sx+120-30, sy+30);
			g2.drawString("Key Off", sx+247+envT1+envT2+envT3-40, sy+30);
		}
	}

	public void initialize()
	{
		envView.repaint();
	}
	
	@Override
	public void actionPerformed(ActionEvent e) 
	{
		if (e.getSource() instanceof ModController)
		{
			if (e.getSource() instanceof Modulator128Controller)
			{
				Modulator128Controller controller = (Modulator128Controller) e.getSource();
				String name = controller.getParameterName();
				int newValue = controller.getSlider().getValue();
				if 		(name.equals("ENV L1")) { envL1 = newValue; }
				else if (name.equals("ENV L2")) { envL2 = newValue; }
				else if (name.equals("ENV L3")) { envL3 = newValue; }
				else if (name.equals("ENV T1")) { envT1 = newValue; }
				else if (name.equals("ENV T2")) { envT2 = newValue; }
				else if (name.equals("ENV T3")) { envT3 = newValue; }
				else if (name.equals("ENV T4")) { envT4 = newValue; }
				if ((name.startsWith("ENV")) && (viewport.showSignals == false)) { envView.repaint(); }
			}
		}	
	}
				
}
